package v50b.v50bClasesComunes;


import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.util.HSSFColor; 
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
/**
 * <p>
 * Ttulo: ClsExcel
 * </p>
 * <p>
 * Descripcin: Clase que escribe datos en un documento de excel usando POI
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Empresa: Eurohelp
 * </p>
 * 
 * @author Xabier Barba
 * @version 1.0
 */

public class V50bClsExcelGrafico {
  private static InputStream isArchivo;
  private static POIFSFileSystem fsPoi;
  private static int numColumnas=Integer.parseInt("142");

  /**
	 * 
	 * Constructor de K81aClsExcel.
	 */
  public V50bClsExcelGrafico() {
  }


  /**
  * Metodo que se conecta a un documento de Excel
  *@param strPfArchivo Nombre del documento Excel al que se va a conectar
  *@return HSSFWorkbook libro del documento de Excel
  *@throws Exception
  *				Se lanza la exception si algo va mal
  *
 **/

  public HSSFWorkbook fncConectarExcel(String strPfArchivo) throws Exception
  {
	  HSSFWorkbook libro = null;
	  try{
		  V50bClsTrazas.depura("strPfArchivo",strPfArchivo,this.getClass());
		  V50bClsExcelGrafico.isArchivo = V50bClsExcelGrafico.class.getResourceAsStream(strPfArchivo);
		  V50bClsTrazas.depura("isArchivo",V50bClsExcelGrafico.isArchivo,this.getClass());	  
		  V50bClsExcelGrafico.fsPoi = new POIFSFileSystem(V50bClsExcelGrafico.isArchivo);
		  libro = new HSSFWorkbook(V50bClsExcelGrafico.fsPoi);
	  }catch (Exception e) {
		  V50bClsTrazas.depura("Excepcion",e.toString(),this.getClass());
	  }
      return libro;
  }//Fin fncConectarExcel


  /**
  * Metodo que escribe datos en un documento de Excel

  *@param hsPfHoja hoja del documento en la que se va a escribir
  *@param arrPfPosicion ArrayList con las posiciones(fila-celda-tipoDato) en las que se va a escribir. tipo: STRING, INT
  *@param arrPfDatos ArrayList con los datos que se van a escribir
  *@throws Exception
  *          Se lanza la exception
 **/

  public void fncEscribirExcel(HSSFSheet hsPfHoja, List arrPfPosicion, List arrPfDatos) throws Exception
  {
	
    HSSFWorkbook poiPfLibro=new HSSFWorkbook();
    HSSFDataFormat formato=poiPfLibro.createDataFormat();
    HSSFCellStyle estiloNumUnDec=poiPfLibro.createCellStyle();
    estiloNumUnDec.setDataFormat(formato.getFormat("0.0"));
    
    HSSFCellStyle estiloCabecera = poiPfLibro.createCellStyle();
    estiloCabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    estiloCabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER);

     //recorre los ArrayList
     for (int i=0;i<arrPfDatos.size();i++)
     {
      
       //Coge la primera fila de los arrays

       ArrayList arrFilaPos=(ArrayList)arrPfPosicion.get(i);
    
       //coge la fila en la que se va a escribir.Esta en la 1 posicion del Array
       
       HSSFRow fila=hsPfHoja.createRow(Integer.parseInt(arrFilaPos.get(0).toString()));

       
       //Coge la celda en la que se va a escribir
       HSSFCell celda=fila.createCell(Short.parseShort(arrFilaPos.get(1).toString()));
       
       boolean isCeldaNueva=false;
       if (celda == null)
       {
         celda = fila.createCell(Short.parseShort(arrFilaPos.get(1).toString()));
         isCeldaNueva=true;
       }


         //comprueba el tipo de dato
       if(arrFilaPos.get(2).equals("STRING"))
       {

         //Escribe en la celda el dato que le corresponde en el array de datos
         HSSFCellStyle estilo = celda.getCellStyle();

         if (isCeldaNueva)
         {
           estilo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
         }
         celda.setCellStyle(estilo);
         celda.setCellValue(arrPfDatos.get(i)==null?"":arrPfDatos.get(i).toString());
         }
       else if(arrFilaPos.get(2).equals("INT"))
       {

         //Escribe en la celda el dato que le corresponde en el array de datos
         celda.setCellValue(Integer.parseInt(arrPfDatos.get(i).toString()));
         celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
       }
       else if(arrFilaPos.get(2).equals("DOUBLE"))
       {
         
         celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
         celda.setCellValue(Double.parseDouble(arrPfDatos.get(i).toString()));
         celda.setCellStyle(estiloNumUnDec);
       }
           /*else if(arrFilaPos.get(2).equals("FORMULA"))
           {
                 HSSFRow f=hsPfHoja.getRow(24);
                 HSSFCell c=f.getCell(Short.parseShort("0"));
                 celda.setCellValue("="+c.getCellFormula());
                 celda.setAsActiveCell();
           }*/
       else if (arrFilaPos.get(2).equals("CABECERA"))
       {
    	  celda.setCellValue(arrPfDatos.get(i).toString());
     	  celda.setCellStyle(estiloCabecera);
       }
      }

  }//Fin fncEscribirExcel
  
  /**
	 * Este metodo sirve para decodificar la constante de tipo de celda a la
	 * constante apropiada para HSSF
	 * 
	 * @author ilarburu
	 * @param tipo
	 *            La constante de tipo
	 * @return La decodificacion HSSF
	 */
	private int decodeTipoCelda(String tipo) {
		int resultado = HSSFCell.CELL_TYPE_STRING;

		if ("NUMERIC".equals(tipo)) {
			resultado = HSSFCell.CELL_TYPE_NUMERIC;
		}

		return (resultado);
	}
	
	/**
	 * Este metodo sirve para fijar el valor en la celda
	 * 
	 * @author ilarburu
	 * @param celda
	 *            La celda
	 * @param tipo
	 *            El tipo de dato
	 * @param valor
	 *            El valor a fijar
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	private void fijarValorCelda(HSSFCell celda, String tipo, String valor)
			throws Exception {
		if ("NUMERIC".equals(tipo)) {
			celda.setCellValue(Double.parseDouble(valor));
		} else {
			celda.setCellValue(valor);
		}
	}

  /**
	 * Este metodo sirve para escribir los libros excel respetando el formato
	 * que hay en la hoja excel de origen
	 * 
	 * @author ilarburu
	 * @param hsPfHoja
	 *            hoja del documento en la que se va a escribir
	 * @param arrPfPosicion
	 *            ArrayList con las posiciones(fila-celda-tipoDato) en las que
	 *            se va a escribir. tipo: STRING, INT
	 * @param arrPfDatos
	 *            ArrayList con los datos que se van a escribir
	 * @throws Exception
	 *             Cualquier excepcion
	 */
	public void fncEscribirExcelStyleFree(HSSFSheet hsPfHoja,List arrPfPosicion, List arrPfDatos) throws Exception 
	{
		for (int index = 0; index < arrPfDatos.size(); index++) {
			try {
				List datosPosicion = (List) arrPfPosicion.get(index);
				int indexFila = Integer.parseInt(datosPosicion.get(0).toString());
				short indexColumna = Short.parseShort(datosPosicion.get(1).toString());
				String tipoDato = datosPosicion.get(2).toString();
				String valorDato = arrPfDatos.get(index).toString();

				HSSFRow fila = hsPfHoja.getRow(indexFila);
				if (fila == null) {
					fila = hsPfHoja.createRow(indexFila);
				}
				HSSFCell celda = fila.getCell(indexColumna);
				if (celda == null) {
					celda = fila.createCell(indexColumna);
				}
				
				this.fijarValorCelda(celda, tipoDato, valorDato);
				celda.setCellType(this.decodeTipoCelda(tipoDato));
			} catch (Exception e) {
				V50bClsTrazas.depura(e.toString());
			}
		}
	} // Fin fncEscribirExcelStyleFree
  
  /**
	 * Metodo que escribe datos en un documento de Excel
	 * @param hsPflibro
	 *            libro  en el que se va a escribir
	 * @param hsPfHoja
	 *            hoja del documento en la que se va a escribir
	 * @param arrPfPosicion
	 *            ArrayList con las posiciones(fila-celda-tipoDato) en las que
	 *            se va a escribir. tipo: STRING, INT
	 * @param listPfDatos
	 *            ArrayList con los datos que se van a escribir
	 * @throws Exception
	 *             Esta excepcion se lanza cuando ocurre algun imprevisto
	 *             durante la ejecucion del metodo.
	 */
  public void fncEscribirExcel(HSSFWorkbook hsPflibro, HSSFSheet hsPfHoja, List arrPfPosicion, List listPfDatos) throws Exception
  {
	
    HSSFDataFormat formato=hsPflibro.createDataFormat();
    HSSFCellStyle estiloNumUnDec=hsPflibro.createCellStyle();
    estiloNumUnDec.setDataFormat(formato.getFormat("0.0"));
    
    HSSFCellStyle estiloCeldaCabecera = hsPflibro.createCellStyle();
    estiloCeldaCabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
    estiloCeldaCabecera.setFillForegroundColor(HSSFColor.BLUE_GREY.index);
    HSSFFont font = hsPflibro.createFont();
    font.setFontName("Arial");
    font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
    font.setColor(HSSFColor.WHITE.index);
    estiloCeldaCabecera.setFont(font);
    estiloCeldaCabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER);

     //recorre los ArrayList
     for (int i=0;i<listPfDatos.size();i++)
     {
      
       //Coge la primera fila de los arrays

       ArrayList arrFilaPos=(ArrayList)arrPfPosicion.get(i);
    
       //coge la fila en la que se va a escribir.Esta en la 1 posicion del Array
       
       HSSFRow fila=hsPfHoja.createRow(Integer.parseInt(arrFilaPos.get(0).toString()));

       
       //Coge la celda en la que se va a escribir
       HSSFCell objCelda=fila.createCell(Short.parseShort(arrFilaPos.get(1).toString()));
       
       boolean isCeldaNueva=false;
       if (objCelda == null)
       {
    	   objCelda = fila.createCell(Short.parseShort(arrFilaPos.get(1).toString()));
         isCeldaNueva=true;
       }


         //comprueba el tipo de dato
       if(arrFilaPos.get(2).equals("STRING"))
       {

         //Escribe en la celda el dato que le corresponde en el array de datos
         HSSFCellStyle estilo = objCelda.getCellStyle();

         if (isCeldaNueva)
         {
           estilo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
         }
         objCelda.setCellStyle(estilo);
         objCelda.setCellValue(listPfDatos.get(i)==null?"":listPfDatos.get(i).toString());
         }
       else if(arrFilaPos.get(2).equals("INT"))
       {

         //Escribe en la celda el dato que le corresponde en el array de datos
    	   objCelda.setCellValue(Integer.parseInt(listPfDatos.get(i).toString()));
    	   objCelda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
       }
       else if(arrFilaPos.get(2).equals("DOUBLE"))
       {
         
    	   objCelda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
    	   objCelda.setCellValue(Double.parseDouble(listPfDatos.get(i).toString()));
    	   objCelda.setCellStyle(estiloNumUnDec);
       }
           /*else if(arrFilaPos.get(2).equals("FORMULA"))
           {
                 HSSFRow f=hsPfHoja.getRow(24);
                 HSSFCell c=f.getCell(Short.parseShort("0"));
                 celda.setCellValue("="+c.getCellFormula());
                 celda.setAsActiveCell();
           }*/
       else if (arrFilaPos.get(2).equals("CABECERA"))
       {
    	   objCelda.setCellValue(listPfDatos.get(i).toString());
    	   objCelda.setCellStyle(estiloCeldaCabecera);
       }
      }

  }//Fin fncEscribirExcel




  /**
  * Metodo que escribe datos en un documento de Excel, poniendo formatos de celdas

  *@param hsPfHoja HSSFSheet hoja del documento en la que se va a escribir
  *@param arrPfPosicion ArrayList con las posiciones(fila-celda-tipoDato) en las que se va a escribir. tipo: STRING, INT
  *@param arrPfDatos ArrayList con los datos que se van a escribir
  *@param poiPfLibro HSSFWorkbook. Libro en el que se escribe
  *@throws Exception
  *			Se lanza la exception si va mal
  *
 **/

  public void fncEscribirExcel(HSSFSheet hsPfHoja, List arrPfPosicion, List arrPfDatos, HSSFWorkbook poiPfLibro) throws Exception
  {



     HSSFDataFormat formato=poiPfLibro.createDataFormat();

     //crear estilos
     HSSFCellStyle estilo=poiPfLibro.createCellStyle();
     estilo.setDataFormat(formato.getFormat("@"));
     estilo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);

     HSSFCellStyle estiloNum=poiPfLibro.createCellStyle();
     estiloNum.setDataFormat(formato.getFormat("0"));

     HSSFCellStyle estiloNumUnDec=poiPfLibro.createCellStyle();
     estiloNumUnDec.setDataFormat(formato.getFormat("0.0"));

     HSSFCellStyle estiloNumDec=poiPfLibro.createCellStyle();
     estiloNumDec.setDataFormat(formato.getFormat("0.00"));

     HSSFCellStyle estiloFecha=poiPfLibro.createCellStyle();
     estiloFecha.setDataFormat(formato.getFormat("dd/mm/yyyy"));

     //estiloFecha.setDataFormat(HSSFDataFormat.getBuiltinFormat("dd/mmm/yyyy"));
     

    //PONER CABECERAS DE TIPO TEXTO
    for (short col=0;col<V50bClsExcelGrafico.numColumnas;col++)
    {
      //coge la fila en la que se va a escribir.
       HSSFRow fila=hsPfHoja.getRow(0);
       
       //Coge la celda en la que se va a escribir
       HSSFCell celda=fila.getCell(col);
       celda.setCellStyle(estilo);

    }



    DateFormat datFormat = new SimpleDateFormat("dd/mm/yyyy");
     //recorre los ArrayList
     for (int i=0;i<arrPfDatos.size();i++)
     {
       //Coge la primera fila de los arrays
       ArrayList arrFilaPos=(ArrayList)arrPfPosicion.get(i);

       //coge la fila en la que se va a escribir.Esta en la 1 posicion del Array
       HSSFRow fila=hsPfHoja.getRow(Integer.parseInt(arrFilaPos.get(0).toString()));

       //Coge la celda en la que se va a escribir
       HSSFCell celda=fila.getCell(Short.parseShort(arrFilaPos.get(1).toString()));

       if (celda == null){
         celda = fila.createCell(Short.parseShort(arrFilaPos.get(1).toString()));
       }
         //comprueba el tipo de dato

        //STRING
       if(arrFilaPos.get(2).equals("STRING"))
       {
         celda.setCellType(HSSFCell.CELL_TYPE_STRING);

         //Escribe en la celda el dato que le corresponde en el array de datos
         celda.setCellValue(arrPfDatos.get(i).toString());
         
         celda.setCellStyle(estilo);
         celda.setAsActiveCell();
         }
        //NUMERICO DECIMALES =0
       else if(arrFilaPos.get(2).equals("INT"))
       {


         //Escribe en la celda el dato que le corresponde en el array de datos
         if (!arrPfDatos.get(i).toString().equals(""))
         {
           celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
           celda.setCellValue(Integer.parseInt(arrPfDatos.get(i).toString()));

           
           celda.setCellStyle(estiloNum);
           celda.setAsActiveCell();
         }
         else{
           celda.setCellType(HSSFCell.CELL_TYPE_ERROR);
         }
       }
       //NUMERICO DECIMALES =1
       else if(arrFilaPos.get(2).equals("UNDEC"))
       {

         
         if (!arrPfDatos.get(i).toString().equals(""))
         {
           celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
           double dblValor=Double.parseDouble(arrPfDatos.get(i).toString());
           //DecimalFormat decFormat=new DecimalFormat("#.#");
           ///decFormat.format(dblValor);
           celda.setCellValue(dblValor);


           
           celda.setCellStyle(estiloNumUnDec);
           celda.setAsActiveCell();
         }
        else{
           celda.setCellType(HSSFCell.CELL_TYPE_ERROR);
         }
        }
        //NUMERICO DECIMALES =2
       else if(arrFilaPos.get(2).equals("DOUBLE"))
       {

         
         if (!arrPfDatos.get(i).toString().equals(""))
         {
           celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
           celda.setCellValue(Double.parseDouble(arrPfDatos.get(i).toString()));
           celda.setCellStyle(estiloNumDec);
           celda.setAsActiveCell();
         }
         else{
           celda.setCellType(HSSFCell.CELL_TYPE_ERROR);
         }
        }
        //FECHA
        else if(arrFilaPos.get(2).equals("DATE"))
        {
          if (!arrPfDatos.get(i).toString().equals("")){
        	List arrFecha=V50bClsFunciones.fncSplit(arrPfDatos.get(i).toString(),"/");
            
            Calendar calFecha=Calendar.getInstance();
            calFecha.set(Integer.parseInt(arrFecha.get(2).toString()),Integer.parseInt(arrFecha.get(1).toString()),Integer.parseInt(arrFecha.get(0).toString()));

            /*
            SimpleDateFormat simDatFormat=new SimpleDateFormat("dd/mm/yyyy");
            DateFormat datFormat=simDatFormat.getDateInstance();

            datFormat.setCalendar(calFecha);
            datFormat.getDateInstance(datFormat.SHORT);
            */
            
            
            datFormat.setCalendar(calFecha);
            
            celda.setCellValue(datFormat.parse(datFormat.format(calFecha.getTime())));
            celda.setCellStyle(estiloFecha);
            celda.setAsActiveCell();
          }
        }
      }

  }//Fin fncEscribirExcel

  /**
	 * Metodo que guarda un documento de excel
	 * 
	 * @param hsPfLibro
	 *            libro de Excel que se va a guardar
	 * @return Un array de bytes.
	 * @throws Exception
	 *             Esta excepcion se lanza cuando ocurre algun imprevisto
	 *             durante la ejecucion del metodo.
	 */
  public byte[] fncGuardarExcel(HSSFWorkbook hsPfLibro) throws Exception
  {
        //OutputStream fosArchivo = new FileOutputStream(strPfArchivo);
        ByteArrayOutputStream fosArchivo = new ByteArrayOutputStream();
        hsPfLibro.write(fosArchivo);
        hsPfLibro.insertChartRecord();
        fosArchivo.flush();
        byte[] bytes = fosArchivo.toByteArray();
        fosArchivo.close();
        V50bClsExcelGrafico.isArchivo.close();
        
        return bytes;

  }//Fin fncGuardarExcel

}//Fin ClsPruebaExcel
