package v50b.v50bClasesComunes;

import java.io.ByteArrayOutputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bCeldaExcelBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bExcelBean;

/**
 * <p>Ttulo: ClsExcel</p>
 * <p>Descripcin: Clase que escribe datos en un documento de excel usando POI</p>
 * <p>Copyright: Copyright (c) 2008</p>
 * <p>Empresa: Eurohelp Consulting S.L.</p>
 * 
 * @author Iaki Cantalapiedra Bernal
 * @version 2.0 beta
 */

public class V50bClsExcel {
	
	/**
	 * Instantiates a new v50b cls excel.
	 */
	private V50bClsExcel(){}
	
	/**
	 * Metodo que genera un libro Excel en base al parametro pasados sin
	 * necesidad de plantilla.
	 * 
	 * @param excelBean Bean con los datos del libro Excel a generar.
	 * @param response the response
	 * 
	 * @throws Exception the exception
	 * 
	 * @author Iaki Cantalapiedra Bernal
	 */
	public static void fncGenerarExcel(V50bExcelBean excelBean, HttpServletResponse response) throws Exception {
	  
	/*String a = "";
	  String b = "";
	  if(a == b) {int x;}*/

	  // Generar el libro y los estilos del libro.
	  final HSSFWorkbook libro = new HSSFWorkbook();
	  
	  // Creamos las hojas necesarias.
	  for(int h=0;h<excelBean.getNombresHojas().length;h++){
		  libro.createSheet(excelBean.getNombresHojas()[h]);
	  }
	  
	  //Evita instanciar dentro del for
	  Region region = new Region();
	  
	  // Se recorre la lista con los bean de las celdas Excel.
	  for(int c=0;c<excelBean.getCeldas().size();c++){
		  
		  // Sacar el bean.
		  final V50bCeldaExcelBean celdaBean = (V50bCeldaExcelBean)excelBean.getCeldas().get(c);
		  
		  // Obtenemos la hoja necesaria para esta celda.
		  final HSSFSheet hoja = libro.getSheetAt(celdaBean.getNumeroHoja());
		  
		  // Obtenemos la fila y celda.
		  HSSFRow fila = hoja.getRow(celdaBean.getPosicionY());
		  if(fila == null){
			  fila = hoja.createRow(celdaBean.getPosicionY());
		  } 
		  HSSFCell celda = fila.getCell(celdaBean.getPosicionX());
		  if(celda == null){
			  celda = fila.createCell(celdaBean.getPosicionX());
		  }
		  
		  //Parte para combinar celdas
		  int posIniX = celdaBean.getPosicionX();
		  int posFinX = celdaBean.getPosicionXDerecha();
		  int posIniY = celdaBean.getPosicionY();
		  int posFinY = celdaBean.getPosicionYAbajo();
		  region.setRowFrom(posIniY);
		  region.setRowTo(posIniY+posFinY);
		  region.setColumnFrom((short)posIniX);
		  region.setColumnTo((short)(posIniX+posFinX));
		  hoja.addMergedRegion(region);
		  
		  //Para los anchos de las columnas
		  List lAnchoColumnas = excelBean.getAnchoColumnas();
		  for(int i=0; i<lAnchoColumnas.size(); i++){
			  String[] strCol = (String[])lAnchoColumnas.get(i);
			  int numCol = Integer.parseInt(strCol[0]);
			  int anchoCol = Integer.parseInt(strCol[1]);
			  hoja.setColumnWidth((short)numCol, (short) (anchoCol/((double)1/V50bClsConstantes.DOSCIENTOSCINCUENTAYSEIS)));
		  }
		  
		  // Ponemos el tipo de celda.
		  for (int i=0;i<excelBean.getNombresHojas().length;i++)
		  {
			  if ((celdaBean.getNumeroHoja()==1)&&(celdaBean.getPosicionX()==1)){
				   celda.setCellType(HSSFCell.CELL_TYPE_NUMERIC);
				 
  
			  }
			  else{
				  celda.setCellType(HSSFCell.CELL_TYPE_STRING);				  
			  }
			  }
		 		  
		  // Ponemos los estilos de la celda.
		  final HSSFCellStyle estilo = V50bClsExcel.fncGenerarEstiloCelda(libro,celdaBean);
		  /*final HSSFCellStyle estilo = libro.createCellStyle();
		  estilo.setAlignment(celdaBean.getAlineacionHorizontal());
		  estilo.setVerticalAlignment(celdaBean.getAlineacionVertical());
		  estilo.setBorderBottom(celdaBean.getBordeAbajo());
		  estilo.setBorderTop(celdaBean.getBordeArriba());
		  estilo.setBorderRight(celdaBean.getBordeDerecho());
		  estilo.setBorderLeft(celdaBean.getBordeIzquierdo());
		  estilo.setBottomBorderColor(celdaBean.getColorBordeAbajo());
		  estilo.setTopBorderColor(celdaBean.getColorBordeArriba());
		  estilo.setRightBorderColor(celdaBean.getColorBordeDerecho());
		  estilo.setLeftBorderColor(celdaBean.getColorBordeIzquierdo());
		  estilo.setFillForegroundColor(celdaBean.getColorFondo());
		  estilo.setDataFormat(celdaBean.getTipoDato());
		  estilo.setFillPattern(celdaBean.getPatronFondo());
		  estilo.setLocked(celdaBean.isBloqueada());*/
		  
		  // Ponemos los estilos de la fuente de la celda.
		  final HSSFFont fuente = V50bClsExcel.fncGenerarEstiloFuente(libro,celdaBean);
		  /*final HSSFFont fuente = libro.createFont();
		  fuente.setColor(celdaBean.getColorFuente());
		  fuente.setItalic(celdaBean.isFuenteItalica());
		  fuente.setBoldweight(celdaBean.getFuenteNegrita());
		  fuente.setFontHeightInPoints(celdaBean.getTamannoFuente());
		  fuente.setFontName(celdaBean.getTipoFuente());
		  fuente.setUnderline(celdaBean.getFuenteSubrayado());*/
		  estilo.setFont(fuente);
		  
		  // Insertamos el estilo.
		  celda.setCellStyle(estilo);
		  
		  // Escribimos el valor de la celda.
		  for (int i=0;i<excelBean.getNombresHojas().length;i++)
		  {
			  if ((celdaBean.getNumeroHoja()==1)&&(celdaBean.getPosicionX()==1)){
			      celda.setCellValue(celdaBean.getIntDato());
			      V50bClsTrazas.depura("dentro de clsExcel "+celda.getNumericCellValue());
				 
  
			  }
			  else{
			      celda.setCellValue(celdaBean.getDato());
			  
			  }
			  }
	         
	      // Activamos la celda
	      celda.setAsActiveCell();
	  }
	  
	  // Escribimos el Excel en la response.
      final ByteArrayOutputStream fosArchivo = new ByteArrayOutputStream();
      libro.write(fosArchivo);
      libro.insertChartRecord();
      fosArchivo.flush();
      byte[] bytes = fosArchivo.toByteArray();
      fosArchivo.close();
      
      response.setContentType("application/vnd.ms-excel");
      response.setContentLength(bytes.length);
      response.setHeader("Content-disposition", "inline;filename=" + excelBean.getNombreLibro() + ".xls");
	      
      response.getOutputStream().write(bytes);
      response.getOutputStream().flush();
	    
	  System.gc();
  }
 
	/**
	 * Metodo que genera un libro Excel en base al parametro pasados sin
	 * necesidad de plantilla.
	 * 
	 * @param excelBean Bean con los datos del libro Excel a generar.
	 * @param response the response
	 * 
	 * @throws Exception the exception
	 * 
	 * @author Iaki Cantalapiedra Bernal
	 */
	public static void fncGenerarExcelEncuestas(V50bExcelBean excelBean, HttpServletResponse response) throws Exception {
		
	  // Generar el libro y los estilos del libro.
	  final HSSFWorkbook libro = new HSSFWorkbook();
	  
	  // Creamos las hojas necesarias.
	  for(int h=0;h<excelBean.getNombresHojas().length;h++){
		  libro.createSheet(excelBean.getNombresHojas()[h]);
	  }

	  // Se recorre la lista con los bean de las celdas Excel.
	  for(int c=0;c<excelBean.getCeldas().size();c++){
		  
		  // Sacar el bean.
		  final V50bCeldaExcelBean celdaBean = (V50bCeldaExcelBean)excelBean.getCeldas().get(c);
		  
		  // Obtenemos la hoja necesaria para esta celda.
		  final HSSFSheet hoja = libro.getSheetAt(celdaBean.getNumeroHoja());
		  
		  // Obtenemos la fila y celda.
		  HSSFRow fila = hoja.getRow(celdaBean.getPosicionY());
		  if(fila == null){
			  fila = hoja.createRow(celdaBean.getPosicionY());
		  } 
		  HSSFCell celda = fila.getCell(celdaBean.getPosicionX());
		  if(celda == null){
			  celda = fila.createCell(celdaBean.getPosicionX());
		  }
		  
		  // Ponemos el tipo de celda.
		  celda.setCellType(HSSFCell.CELL_TYPE_STRING);
		  
		  // Ponemos los estilos de la celda.
		  final HSSFCellStyle estilo = V50bClsExcel.fncGenerarEstiloCelda(libro,celdaBean);
		  /*final HSSFCellStyle estilo = libro.createCellStyle();
		  estilo.setAlignment(celdaBean.getAlineacionHorizontal());
		  estilo.setVerticalAlignment(celdaBean.getAlineacionVertical());
		  estilo.setBorderBottom(celdaBean.getBordeAbajo());
		  estilo.setBorderTop(celdaBean.getBordeArriba());
		  estilo.setBorderRight(celdaBean.getBordeDerecho());
		  estilo.setBorderLeft(celdaBean.getBordeIzquierdo());
		  estilo.setBottomBorderColor(celdaBean.getColorBordeAbajo());
		  estilo.setTopBorderColor(celdaBean.getColorBordeArriba());
		  estilo.setRightBorderColor(celdaBean.getColorBordeDerecho());
		  estilo.setLeftBorderColor(celdaBean.getColorBordeIzquierdo());
		  estilo.setFillForegroundColor(celdaBean.getColorFondo());
		  estilo.setDataFormat(celdaBean.getTipoDato());
		  estilo.setFillPattern(celdaBean.getPatronFondo());
		  estilo.setLocked(celdaBean.isBloqueada());*/
		  
		  // Ponemos los estilos de la fuente de la celda.
		  final HSSFFont fuente = V50bClsExcel.fncGenerarEstiloFuente(libro,celdaBean);
		  /*final HSSFFont fuente = libro.createFont();
		  fuente.setColor(celdaBean.getColorFuente());
		  fuente.setItalic(celdaBean.isFuenteItalica());
		  fuente.setBoldweight(celdaBean.getFuenteNegrita());
		  fuente.setFontHeightInPoints(celdaBean.getTamannoFuente());
		  fuente.setFontName(celdaBean.getTipoFuente());
		  fuente.setUnderline(celdaBean.getFuenteSubrayado());*/
		  estilo.setFont(fuente);
		  
		  // Insertamos el estilo.
		  celda.setCellStyle(estilo);
		  
		  // Escribimos el valor de la celda.
	      celda.setCellValue(celdaBean.getDato());
	      
	      // Activamos la celda
	      celda.setAsActiveCell();
	  }
	  
	  // Escribimos el Excel en la response.
      final ByteArrayOutputStream fosArchivo = new ByteArrayOutputStream();
      libro.write(fosArchivo);
      libro.insertChartRecord();
      fosArchivo.flush();
      byte[] bytes = fosArchivo.toByteArray();
      fosArchivo.close();
      
      response.setContentType("application/vnd.ms-excel");
      response.setContentLength(bytes.length);
      response.setHeader("Content-disposition", "inline;filename=" + excelBean.getNombreLibro() + ".xls");
	      
      response.getOutputStream().write(bytes);
      response.getOutputStream().flush();
	    
	  System.gc();
  }
	
	/**
	 * 
	 * @param libro libro
	 * @param celdaBean celda
	 * @return HSSFCellStyle estilo celda
	 * @throws Exception ex
	 */
	private static HSSFCellStyle fncGenerarEstiloCelda(HSSFWorkbook libro,V50bCeldaExcelBean celdaBean) throws Exception{
		
		HSSFCellStyle estilo = libro.createCellStyle();
		
		  estilo.setAlignment(celdaBean.getAlineacionHorizontal());
		  estilo.setVerticalAlignment(celdaBean.getAlineacionVertical());
		  estilo.setBorderBottom(celdaBean.getBordeAbajo());
		  estilo.setBorderTop(celdaBean.getBordeArriba());
		  estilo.setBorderRight(celdaBean.getBordeDerecho());
		  estilo.setBorderLeft(celdaBean.getBordeIzquierdo());
		  estilo.setBottomBorderColor(celdaBean.getColorBordeAbajo());
		  estilo.setTopBorderColor(celdaBean.getColorBordeArriba());
		  estilo.setRightBorderColor(celdaBean.getColorBordeDerecho());
		  estilo.setLeftBorderColor(celdaBean.getColorBordeIzquierdo());
		  estilo.setFillForegroundColor(celdaBean.getColorFondo());
		  estilo.setDataFormat(celdaBean.getTipoDato());
		  estilo.setFillPattern(celdaBean.getPatronFondo());
		  estilo.setLocked(celdaBean.isBloqueada());
		
		return estilo;
	}
	
	/**
	 * fncGenerarEstiloFuente
	 * @param libro libro excel
	 * @param celdaBean bean celda
	 * @return HSSFFont fuentes
	 * @throws Exception ex
	 */
	private static HSSFFont fncGenerarEstiloFuente(HSSFWorkbook libro,V50bCeldaExcelBean celdaBean) throws Exception{

		  HSSFFont fuente = libro.createFont();
		  fuente.setColor(celdaBean.getColorFuente());
		  fuente.setItalic(celdaBean.isFuenteItalica());
		  fuente.setBoldweight(celdaBean.getFuenteNegrita());
		  fuente.setFontHeightInPoints(celdaBean.getTamannoFuente());
		  fuente.setFontName(celdaBean.getTipoFuente());
		  fuente.setUnderline(celdaBean.getFuenteSubrayado());
		  
		  return fuente;
	}
	
	//Constantes para la mascara del dato.
	public static final short formatoPorDefecto = HSSFDataFormat.getBuiltinFormat("General");
	public static final short formatoImporte = HSSFDataFormat.getBuiltinFormat("#,##0");
	public static final int formatoInteger = HSSFDataFormat.getNumberOfBuiltinBuiltinFormats();
	
	
	//CATALOGO DE ESTILOS.
	//Colores.
	public static final short BLANCO = HSSFColor.WHITE.index;
	public static final short AZUL = HSSFColor.BLUE.index;
	public static final short AZULGRISACEO = HSSFColor.BLUE_GREY.index;
	public static final short NEGRO = HSSFColor.BLACK.index;
	public static final short GRIS_CLARO = HSSFColor.GREY_40_PERCENT.index;
	public static final short GRIS_OSCURO = HSSFColor.GREY_80_PERCENT.index;
	
	//Fondos.
	public static final short FONDO_SOLIDO = HSSFCellStyle.SOLID_FOREGROUND;
	public static final short FONDO_TRANSPARENTE = HSSFCellStyle.NO_FILL;
	
	//Bordes.
	public static final short BORDE_INTERMEDIO = HSSFCellStyle.SOLID_FOREGROUND;
	
	//Alineado Horizontal
	public static final short H_CENTRADO = HSSFCellStyle.ALIGN_CENTER;
	public static final short H_DERECHA = HSSFCellStyle.ALIGN_RIGHT;
	public static final short H_IZQUIERDA = HSSFCellStyle.ALIGN_LEFT;
	//Alineado Vertical
	public static final short V_CENTRADO = HSSFCellStyle.VERTICAL_CENTER;
	public static final short V_ARRIBA = HSSFCellStyle.VERTICAL_TOP;
	public static final short V_ABAJO = HSSFCellStyle.VERTICAL_BOTTOM;
}
