package v50b.v50bClasesComunes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;



/**
 * <p>
 * Ttulo: V50bClsAccesoBD.java
 * Descipcin: Lanza bsquedas, mantenimientos, etc. contra BD
 * Copyright: Copyright (c) 2004
 * Empresa: Eurohelp
 * @author iurkidi
 * @version 1.0 06-jun-2005
 */

public class V50bClsAccesoBD implements Serializable {


	/**
	 * Constante que indica el componente al que pertenece dicha clase. Es
	 * necesario para el uso del log de trazas.
	 */
	private static final String COMPONENTE = "V50bClsAccesoBD";

	//Nombre jndi del datasource de la aplicacion v50b
	private static final String V50B_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty(V50bClsAccesoBD.COMPONENTE, null, "DATASOURCE");
	

	/**
	 * Instancia del log de trazas
	 */
	private static Q70Traza tr = Q70Traza.getSingleton();
	
	///private static 
	/**
	 * Instantiates a new v50b cls acceso bd.
	 */
	public V50bClsAccesoBD() {
	}

	
	
	
	/**
	 * Lanza una consulta que slo lleva una select y devuelve un nico dato,
	 * por ejemplo, un count o un max.
	 * 
	 * @param strPfSelect String: Sentencia SQL a lanzar
	 * 
	 * @return String: el resultado de la bsqueda, null si no encontr nada.
	 * 
	 * @throws Exception the exception
	 */

	public String fncConsultaEspecifica(String strPfSelect) throws Exception {
		
		this.logea("fncConsultaEspecifica",strPfSelect,new ArrayList());
		
		Connection conexionBD = null;
		Statement stmnt = null;
		ResultSet rs = null;
		try {
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"hace una consulta especifica");
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			}
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "hace la conexion");
			}
			stmnt = conexionBD.createStatement();
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncConsultaEspecifica - La sentencia a lanzar es: "
								+ strPfSelect);
			}
			rs = stmnt.executeQuery(strPfSelect);
			String strResult = null;
			if (rs.next()) {
				strResult = rs.getString(1);
			}
			//Devuelve null si no encuentra nada.
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "devuelve:"
						+ strResult);
			}
			return strResult;
		} catch (Exception e) {
			V50bClsTrazas.fatal("fncConsultaEspecifica", e.getMessage());
			throw e;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (stmnt != null) {
					stmnt.close();
					stmnt = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
			}
		}
	}//Fin fncConsultaEspecifica
	
	/** AADIR PARAMETRO DATASOURCE
	 * Lanza una consulta  y devuelve un nico dato.
	 * 
	 * @param strPfSelect String: Sentencia SQL a lanzar
	 * @param arrPfCampos the arr pf campos
	 * 
	 * @return String: el resultado de la bsqueda, null si no encontr nada.
	 * 
	 * @throws Exception the exception
	 */

	public String fncConsultaEspecifica(String strPfSelect,List arrPfCampos) throws Exception {
		
		this.logea("fncConsultaEspecifica2",strPfSelect,arrPfCampos);
		
		Connection conexionBD = null;
		PreparedStatement preparedStatement = null;
		ResultSet rs = null;
		try {
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"hace una consulta especifica");
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			}
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "hace la conexion");
			}			
			preparedStatement = conexionBD.prepareStatement(strPfSelect);
			if (arrPfCampos != null) {
				for (int i = 0; i < arrPfCampos.size(); i++) {
					this.fncPonerParametro(preparedStatement, i + 1, arrPfCampos
							.get(i));
				}
			}
			rs = preparedStatement.executeQuery();
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncConsultaEspecifica - La sentencia a lanzar es: "
								+ strPfSelect);
			}
			//rs = preparedStatement.executeQuery(strPfSelect);
			String strResult = null;
			if (rs.next()) {
				strResult = rs.getString(1);
			}
			//Devuelve null si no encuentra nada.
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "devuelve:"
						+ strResult);
			}
			return strResult;
		} catch (Exception e) {
			V50bClsTrazas.fatal("fncConsultaEspecifica", e.getMessage());
			throw e;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (preparedStatement != null) {
				    preparedStatement.close();
				    preparedStatement = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
			}
		}
	}//Fin fncConsultaEspecifica
	
	
	/**
	 * Lanza una consulta  y devuelve un nico dato.
	 * 
	 * @param strPfSelect String: Sentencia SQL a lanzar con dos columnas: 1 con el nombre del fichero y segundo con el blob
	 * @param arrPfCampos the arr pf campos
	 * 
	 * @return String: el resultado de la bsqueda, null si no encontr nada.
	 * 
	 * @throws Exception the exception
	 */
	public V50bClsFichero fncConsultaFichNoTemp(String strPfSelect,List arrPfCampos) throws Exception {
		
		this.logea("fncConsultaFichNoTemp",strPfSelect,arrPfCampos);
		
		Connection conexionBD = null;
		PreparedStatement preparedStatement = null;
		ResultSet rs = null;
		try {
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"hace una consulta de un fichero sin crear temporal");
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			}
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "hace la conexion");
			}			
			preparedStatement = conexionBD.prepareStatement(strPfSelect);
			if (arrPfCampos != null) {
				for (int i = 0; i < arrPfCampos.size(); i++) {
					this.fncPonerParametro(preparedStatement, i + 1, arrPfCampos
							.get(i));
				}
			}
			rs = preparedStatement.executeQuery();
			//rs = preparedStatement.executeQuery(strPfSelect);					
			V50bClsFichero fich = null;
			
			if (rs.next()) {			    
			    //fich=new HashMap();
				fich=new V50bClsFichero();
			    fich.setNombreReal(rs.getString(1));
			    fich.setOid(rs.getString(2));
			}		
			//Devuelve null si no encuentra nada.			
			if (V50bClsAccesoBD.tr.isTraceActive()) {
			    if (fich!=null){
			    	V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "devuelve:"
			                + fich.getNombreReal());			        
			    }else{
			    	V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, "No se encontro fichero");			  
			    }			    
			}
			return fich;
		} catch (Exception e) {
			V50bClsTrazas.fatal("fncConsultaFichNoTemp", e.getMessage());
			throw e;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (preparedStatement != null) {
				    preparedStatement.close();
				    preparedStatement = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
			}
//			try{
//			    inputs.close();
//			}catch (Exception e){
//			    
//			}
		}
	}//Fin fncConsultaFichNoTemp

	
	
	/**
	 * Lanza una consulta con preparedstatement y devuelve un arraylist con los
	 * datos,.
	 * 
	 * @param strPfSelect String: Sentencia SQL a lanzar
	 * @param arrPfCampos ArrayList: ArrayList con los valores a asignar a los ? de la
	 * select
	 * @param rowMapper the row mapper
	 * 
	 * @return ArrayList: el resultado de la bsqueda, arraylist vaco si no
	 * encontr nada.
	 * 
	 * @throws Exception the exception
	 */

	public List fncLanzaBusqueda(String strPfSelect,
			List arrPfCampos, V50bRowMapper rowMapper) throws Exception {
		this.logea("fncLanzaBusqueda",strPfSelect,arrPfCampos);
		
		List arrResultado = new ArrayList();
		Connection conexionBD = null;
		PreparedStatement preparedStatement = null;
		ResultSet rs = null;
		try {
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncLanzaBusqueda - La sentencia a lanzar es: "
								+ strPfSelect);
			}
			preparedStatement = conexionBD.prepareStatement(strPfSelect);
			if (arrPfCampos != null) {
				for (int i = 0; i < arrPfCampos.size(); i++) {
					this.fncPonerParametro(preparedStatement, i + 1, arrPfCampos.get(i));
				}
			}			
			long antesM = System.currentTimeMillis();
			
			rs = preparedStatement.executeQuery();
				
			long despuesM = System.currentTimeMillis();
			GregorianCalendar despues = new GregorianCalendar();
			despues.setTimeInMillis(despuesM-antesM);
			V50bClsTrazas.depura("Tiempo de BD",despues.get(Calendar.MINUTE)+":"+despues.get(Calendar.SECOND)+"."+despues.get(Calendar.MILLISECOND));
			
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG, rs.toString());
			}
			//String strResult = null;
			
			while (rs.next()) {
				/*
				final Object bean = (Object)rowMapper.mapRow(rs);
				if (bean instanceof V50bGenericoBean) {
					final V50bGenericoBean beanGen = (V50bGenericoBean) bean;
					beanGen.set_rowNum(new Integer(rs.getRow()));
					arrResultado.add(beanGen);
				}
				else{
					arrResultado.add(bean);
				}
				*/
				arrResultado.add(rowMapper.mapRow(rs));
			}
			return arrResultado;
		} catch (Exception e) {
			V50bClsTrazas.fatal("fncLanzaBusqueda", e.getMessage());
			throw e;
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
			} catch (SQLException e) {
				throw e;
			}
			try {
				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;
				}
			} catch (SQLException e) {
				throw e;
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
				throw e;
			}
		}
	}//Fin fncLanzaBusqueda
	
	
	

	/**
	 * Lanza una actualizacin con preparedstatement y devuelve un n con los
	 * registros modificados.
	 * 
	 * @param strPfSQL String: Sentencia SQL a lanzar
	 * @param arrPfCampos ArrayList: ArrayList con los valores a asignar a los ? de la
	 * select
	 * 
	 * @return int: el n de filas involucradas en la actualizacin.
	 * 
	 * @throws Exception the exception
	 */
	public int fncLanzaMovimiento(String strPfSQL, List arrPfCampos)
			throws Exception {
		
		this.logea("fncLanzaMovimiento",strPfSQL,arrPfCampos);
		
		//ArrayList arrResultado = new ArrayList();
		Connection conexionBD = null;
		PreparedStatement preparedStatement = null;
		try {
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			preparedStatement = conexionBD.prepareStatement(strPfSQL);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncLanzaMovimiento - La SQL a lanzar es: " + strPfSQL);
			}
			for (int i = 0; i < arrPfCampos.size(); i++) {
				this.fncPonerParametro(preparedStatement, i + 1, arrPfCampos.get(i));
			}			
			
			long antesM = System.currentTimeMillis();
			
			int intColumnasAfectadas = preparedStatement.executeUpdate();
			
			long despuesM = System.currentTimeMillis();
			GregorianCalendar despues = new GregorianCalendar();
			despues.setTimeInMillis(despuesM-antesM);
			V50bClsTrazas.depura("Tiempo de BD",despues.get(Calendar.MINUTE)+":"+despues.get(Calendar.SECOND)+"."+despues.get(Calendar.MILLISECOND));
			
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncLanzaMovimiento - El nmero de columnas afectadas es: "
								+ intColumnasAfectadas);
			}
			return intColumnasAfectadas;
		} catch (Exception e) {		
			V50bClsTrazas.fatal("fncLanzaMovimiento", e.getMessage());
			throw e;
		} finally {
			try {
				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
			}
		}
	}//Fin fncLanzaMovimiento
	
	
	/**
	 * Pasa parametros al PreparedStatement.
	 * 
	 * @param preparedPfStatement PreparedStatement: PreparedStatement sobre el que trabajaremos
	 * @param intPfPosicion int: n de posicin del campo a pasar
	 * @param objPfValor Object: valor a pasar como parmetro
	 * 
	 * @return boolean: true si paso el parmetro o false si el tipo no se
	 * reconoci
	 * 
	 * @throws Exception the exception
	 */
	private boolean fncPonerParametro(PreparedStatement preparedPfStatement,
			int intPfPosicion, Object objPfValor) throws Exception {
		
		if (V50bClsAccesoBD.tr.isTraceActive()) {
			V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
					"Ponemos dato en el PreparedStatement");
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_INTEGER)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.INTEGER);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO-INTEGER: ");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_DOUBLE)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.FLOAT);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO-DOUBLE: ");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_STRING)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.VARCHAR);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO-VARCHAR");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_LONG)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.NUMERIC);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO-LONG");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_FLOAT)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.FLOAT);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO-FLOAT");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_TIMESTAMP)) {
			preparedPfStatement
					.setNull(intPfPosicion, java.sql.Types.TIMESTAMP);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO_TIMESTAMP");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_DATE)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.DATE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO_DATE");
			}
			return true;
		}
		if (objPfValor.toString().equalsIgnoreCase(
				V50bClsConstantes.CONSTANTE_NULO_BLOB)) {
			preparedPfStatement.setNull(intPfPosicion, java.sql.Types.BLOB);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						" fncPonerParametro -> setObject - NULO_BLOB");
			}
			return true;
		}
		if (!objPfValor.toString().equalsIgnoreCase("")) {
			if(objPfValor instanceof byte[]){
				if (V50bClsAccesoBD.tr.isTraceActive()) {
					V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
							" fncPonerParametro -> setBinaryStream: " + objPfValor);
				}
				final InputStream blob_os = new ByteArrayInputStream((byte[])objPfValor);
				preparedPfStatement.setBinaryStream(intPfPosicion, blob_os, ((byte[])objPfValor).length);
			} else{
				if (V50bClsAccesoBD.tr.isTraceActive()) {
					V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
							" fncPonerParametro -> setObject: " + objPfValor);
				}
				preparedPfStatement.setObject(intPfPosicion, objPfValor);
			}
			return true;
		}
		if (V50bClsAccesoBD.tr.isTraceActive()) {
			V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
					" fncPonerParametro -> Tipo no definido " + intPfPosicion);
		}
		return false;
	}//Fin fncPonerParametro
	
	/**
	 * Lanza una consulta con preparedstatement y devuelve un arraylist con los
	 * datos,.
	 * 
	 * @param strPfProcedimiento strPfProcedimiento: Procedimiento a lanzar
	 * @param arrPfParametros ArrayList: ArrayList con los valores a asignar a los ? del
	 * procedimiento
	 * 
	 * @return ArrayList: ArrayList con el retorno del procedimiento almacenado
	 * 
	 * @throws Exception the exception
	 */
	public List fncLanzaProcedimiento(String strPfProcedimiento,
			List arrPfParametros) throws Exception {
		Connection conexionBD = null;
		CallableStatement callableStatement = null;
		try {			
			conexionBD = Q70ConectorJDBC.getSingleton().getConnection(
					V50bClsAccesoBD.V50B_JNDI_DATASOURCE);
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncLanzaProcedimiento - La sentencia a lanzar es: "
						+ strPfProcedimiento);
			}
			callableStatement = conexionBD.prepareCall(strPfProcedimiento);
			if (arrPfParametros != null) {
				for (int i = 0; i < arrPfParametros.size(); i++) {
					this.fncPonerParametroProcedimiento(callableStatement, i + 1,
							(V50bClsParametroSQL) arrPfParametros.get(i));
				}
			}

			callableStatement.executeUpdate();
			V50bClsParametroSQL parametroSQL;
			List arrResultado = new ArrayList();
			if (arrPfParametros != null) {
				for (int i = 0; i < arrPfParametros.size(); i++) {
					parametroSQL = (V50bClsParametroSQL) arrPfParametros.get(i);
					if (parametroSQL.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_INOUT
							|| parametroSQL.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_OUT) {
						arrResultado.add(callableStatement.getObject(i + 1));
					}
				}
			}
			return arrResultado;
		} catch (Exception e) {
			V50bClsTrazas.fatal("fncLanzaProcedimiento", e.getMessage());
			throw e;
		} finally {
			try {
				if (callableStatement != null) {
					callableStatement.close();
					callableStatement = null;
				}
			} catch (SQLException e) {
			}
			try {
				if (conexionBD != null) {
					conexionBD.close();
					conexionBD = null;
				}
			} catch (SQLException e) {
			}
		}

	}//Fin fncLanzaProcedimiento
	

	/**
	 * Pasa parametros al CallableStatement.
	 * 
	 * @param callablePfStatement CallableStatement: CallableStatement sobre el que trabajaremos
	 * @param intPfPosicion int: n de posicin del campo a pasar
	 * @param objPfParametro V50bClsParametroSQL: valor a pasar como parmetro
	 * 
	 * @return boolean
	 * 
	 * @throws Exception the exception
	 */
	private boolean fncPonerParametroProcedimiento(
			CallableStatement callablePfStatement, int intPfPosicion,
			V50bClsParametroSQL objPfParametro) throws Exception {
		if (V50bClsAccesoBD.tr.isTraceActive()) {
			V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
					"Ponemos dato en el CallableStatement");
		}		
		boolean retorno = true;
		//Si el parametro es de entrada o entrada salida registrarlo como
		// parametro de entrada
		if (objPfParametro.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_IN
				|| objPfParametro.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_INOUT) {
			retorno = retorno
					&& this.fncPonerParametro(callablePfStatement, intPfPosicion,
							objPfParametro.getValor());
		}
		//Si el parametro es de salida o entrada salida registrarlo como
		// parametro de salida
		if (objPfParametro.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_OUT
				|| objPfParametro.getTipoParametro() == V50bClsParametroSQL.TIPO_PARAMETRO_INOUT) {
			callablePfStatement.registerOutParameter(intPfPosicion,
					objPfParametro.getTipoSQL());
			if (V50bClsAccesoBD.tr.isTraceActive()) {
				String strTipo = null;	
				switch (objPfParametro.getTipoSQL()) {
				case V50bClsParametroSQL.TIPO_SQL_DATE: {
					strTipo = "DATE";
					break;
				}
				case V50bClsParametroSQL.TIPO_SQL_DOUBLE: {
					strTipo = "DOUBLE";
					break;
				}
				case V50bClsParametroSQL.TIPO_SQL_INTEGER: {
					strTipo = "INTEGER";
					break;
				}
				case V50bClsParametroSQL.TIPO_SQL_STRING: {
					strTipo = "STRING";
				}
				default: {
					strTipo = null;
				}
				}
				V50bClsAccesoBD.tr.trace(V50bClsAccesoBD.COMPONENTE, Q70TraceLevel.DEBUG,
						"fncPonerParametroSalida -> " + strTipo);
			}		

		}
		return retorno;
	}//Fin fncPonerParametroSalida
	
	
	/**
	 * Logea.
	 * 
	 * @param o0 the o0
	 * @param o1 the o1
	 * @param o2 the o2
	 */
	public void logea(Object o0, Object o1, Object o2){
		
		String trazasbd = Q70ListenerUtils.getApplicationProperty("TRAZAS_BD");
		if (trazasbd != null && trazasbd.equals("SI")){  
			if(o1!=null){
				V50bClsTrazas.depuraBD("Query",o1);
			}
			if(o2!=null){
				V50bClsTrazas.depuraBD("Campos",o2);
			}
			if (!((String)o0).equals("fncLanzarVariosMovimientos")){
				V50bClsTrazas.depura("TOAD",V50bClsTrazas.fncTrazaSQL(o1.toString(),(List)o2));
			}
			else {
				for (int i = 0; i < ((List)o1).size(); i++) {
					V50bClsTrazas.depura("TOAD",V50bClsTrazas.fncTrazaSQL(((List)o1).get(i).toString(),(List)((List)o2).get(i)));
				}
			}
		}
	}
	
}