<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"     xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java">
	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1" indent="yes"/><!--Texto latin-->

	<xsl:template match="informe">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="cuerpo" page-height="21cm" 
				        page-width="29cm"
		                  	margin-top="1cm" 
		                  	margin-bottom="1cm" 
		                  	margin-left="1cm" 
		                  	margin-right="1.5cm">
			      	<fo:region-body margin-top="3cm" margin-bottom="1.5cm"/>
		    	  	<fo:region-before extent="5cm"/>
		      		<fo:region-after extent="1.5cm"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:apply-templates/>
		</fo:root>
	</xsl:template>

	<xsl:template match="contenido">
		<fo:page-sequence master-reference="cuerpo" initial-page-number="1">
			
			<!-- PARTE ESTATICA -->
			<fo:static-content flow-name="xsl-region-before">
			<!-- El parametro idioma determina la distribucion de los literales y datos -->
	 		<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
	 		
				<fo:table table-layout="fixed">
						<fo:table-column column-width="90mm"/>
						<fo:table-column column-width="95mm"/>
						<fo:table-column column-width="80mm"/>
						<fo:table-body>
							
							<fo:table-row >
								<!-- IMAGEN DPTO SANIDAD EJ -->
					  			<fo:table-cell>
					 				<fo:block>
										<xsl:variable name="imagen" select="//parametro1"></xsl:variable>
											<fo:external-graphic src="{$imagen}"/>
									</fo:block>
								 </fo:table-cell>  
								 <!-- TITULO -->
								 <fo:table-cell>
								 	<fo:block font-family="Helvetica" font-size="14pt" line-height="80pt" text-decoration="underline" text-align="center" font-weight="bold" font-style="italic" padding-top="3pt">
			    			  			<xsl:value-of select="//parametro4"/>
		         					</fo:block>
								 </fo:table-cell>
								 
								 <!-- FECHA -->
								 <fo:table-cell>
				         			<fo:block font-family="Helvetica" text-align="right" font-size="10pt" font-weight="bold">
						      			<xsl:value-of select="//parametro2"/> 
						      		</fo:block>
								 </fo:table-cell>  
					 		</fo:table-row >			
						</fo:table-body>
					</fo:table>
			</fo:static-content>

			<!-- BODY -->
			<fo:flow flow-name="xsl-region-body">
				<fo:block font-family="Helvetica" space-after.optimum="15pt">
			 		<!-- CUADRO CABECERA -->
			 		<!-- El parametro idioma determina la distribucion de los literales y datos -->
			 		<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
			 		
			 		<fo:table table-layout="fixed" border-style="solid" padding-top="3pt">
						<fo:table-column column-width="40mm"/>
						<fo:table-column column-width="40mm"/>
						<fo:table-column column-width="60mm"/>
						<fo:table-column column-width="5mm"/>
						<fo:table-column column-width="40mm"/>
						<fo:table-column column-width="40mm"/>
						<fo:table-column column-width="5mm"/>
						<fo:table-column column-width="35mm"/>
				 		<fo:table-body>
							<fo:table-row >
					  			<fo:table-cell number-columns-spanned="3"><fo:block font-size="10pt">&#160;&#160;<xsl:value-of select="//comun.codigo"/>:&#160;&#160;<fo:inline font-weight="bold"><xsl:value-of select="//parametro5"/></fo:inline></fo:block></fo:table-cell>
					  			<fo:table-cell number-columns-spanned="2"><fo:block font-size="10pt"><xsl:value-of select="//comun.situacion"/>:&#160;&#160;<fo:inline font-weight="bold"><xsl:value-of select="//parametro6"/></fo:inline></fo:block></fo:table-cell>
					  		</fo:table-row>
							
							<fo:table-row >
					  			<fo:table-cell number-columns-spanned="8"><fo:block font-size="10pt">&#160;&#160;<xsl:value-of select="//comun.descripcion"/>:&#160;&#160;<fo:inline font-weight="bold"><xsl:value-of select="//parametro7"/></fo:inline></fo:block></fo:table-cell>
							</fo:table-row>
							
						</fo:table-body>
					</fo:table>
 				</fo:block>
 				
				<xsl:apply-templates />
			</fo:flow>
		</fo:page-sequence>
     </xsl:template>
       

	<xsl:template match="pagina">
		<fo:table table-layout="fixed" width="100%"  border-collapse="separate"  border-left-width="0.5pt" >
			        <fo:table-column column-width="10mm"/>
			        <fo:table-column column-width="5mm"/>
			        <fo:table-column column-width="65mm"/>
			        <fo:table-column column-width="5mm"/>
			        <fo:table-column column-width="15mm"/>
			        
					<fo:table-header space-after.optimum="5pt">
				       	<fo:table-row>
				        	<fo:table-cell border-bottom-style="solid" text-align="center"><fo:block font-family="Helvetica" font-size="10pt"><xsl:value-of select="//comun.codigo"/></fo:block></fo:table-cell>
				        	<fo:table-cell ><fo:block></fo:block></fo:table-cell>			        	
				        	<fo:table-cell border-bottom-style="solid" text-align="center"><fo:block font-family="Helvetica" font-size="10pt"><xsl:value-of select="//comun.descripcion"/></fo:block></fo:table-cell>
				        	<fo:table-cell ><fo:block></fo:block></fo:table-cell>
				          	<fo:table-cell border-bottom-style="solid" text-align="center"><fo:block font-family="Helvetica" font-size="10pt"><xsl:value-of select="//comun.situacion"/></fo:block></fo:table-cell>
				        </fo:table-row>
		 			</fo:table-header>	
				    <fo:table-body>
					    <xsl:apply-templates />
				    </fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="fila">
		<fo:table-row>
			<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
			<xsl:choose>
				<xsl:when test="$idioma='es'">
				<!-- Codigo -->
					<fo:table-cell text-align="center" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[2]"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell ><fo:block></fo:block></fo:table-cell>	
					<fo:table-cell text-align="left" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[4]"/> 
						</fo:block>
					</fo:table-cell>
					<fo:table-cell><fo:block></fo:block></fo:table-cell>
					<fo:table-cell text-align="center" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[6]"/> 
						</fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:when test="$idioma='eu'">
				<!-- Codigo -->
					<fo:table-cell text-align="center" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[2]"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell ><fo:block></fo:block></fo:table-cell>	
					<fo:table-cell text-align="left" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[5]"/> 
						</fo:block>
					</fo:table-cell>
					<fo:table-cell><fo:block></fo:block></fo:table-cell>
					<fo:table-cell text-align="center" padding-before="1mm">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="./celda[6]"/> 
						</fo:block>
					</fo:table-cell>
				</xsl:when>
			</xsl:choose>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>