<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java">
	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1"
		indent="yes" /><!--Texto latin-->

	<xsl:template match="informe">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="cuerpo"
					page-height="21cm" page-width="29cm" margin-top="1cm"
					margin-bottom="2cm" margin-left="2cm" margin-right="2.5cm">
					<fo:region-body margin-top="3cm"
						margin-bottom="1.5cm" />
					<fo:region-before extent="5cm" />
					<fo:region-after extent="1.5cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:apply-templates />
		</fo:root>
	</xsl:template>

	<xsl:template match="contenido">
		<fo:page-sequence master-reference="cuerpo"
			initial-page-number="1">

			<!-- PARTE ESTATICA -->
			<fo:static-content flow-name="xsl-region-before">
				<fo:table table-layout="fixed">
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="165mm" />
					<fo:table-column column-width="40mm" />
					<fo:table-body>
						<fo:table-row>

							<!-- IMAGEN IVAP -->
							<fo:table-cell text-align="left">
								<fo:block>
									<xsl:variable name="imagen"
										select="//parametro1">
									</xsl:variable>
									<fo:external-graphic
										src="{$imagen}" />
								</fo:block>
							</fo:table-cell>
							<!-- TITULO -->
							<fo:table-cell text-align="center">
								<fo:block font-family="Helvetica"
									font-size="14pt" line-height="80pt" text-decoration="underline"
									font-weight="bold" font-style="italic" text-align="center"
									padding-top="3pt">
									<xsl:value-of
										select="//comun.estadoConsultas" />
								</fo:block>
							</fo:table-cell>
							<!-- FECHA & PAGINA -->
							<fo:table-cell text-align="right">
								<fo:block font-family="Helvetica"
									font-size="10pt" font-weight="bold" space-before.optimum="15pt"
									space-after.optimum="15pt">
									<xsl:value-of
										select="//comun.pagina" />
									&#160;
									<fo:page-number />
								</fo:block>
								<fo:block font-family="Helvetica"
									font-size="10pt" font-weight="bold">
									<xsl:value-of
										select="//comun.fecha" />
									&#160;
									<xsl:value-of select="//parametro2" />
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:static-content>

			<!--  BODY -->
			<fo:flow flow-name="xsl-region-body">
				<fo:block font-family="Helvetica"
					space-after.optimum="15pt">
					<!-- CUADRO CABECERA -->
					<!-- El parametro idioma determina la distribucion de los literales y datos -->
					<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
					<fo:table table-layout="fixed" border-style="solid" padding-top="3pt">
						<fo:table-column column-width="60mm" />
						<fo:table-column column-width="32mm" />
						<fo:table-column column-width="60mm" />
						<fo:table-column column-width="63mm" />
						<fo:table-column column-width="33mm" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding-left="8pt" padding-top="2pt" number-columns-spanned="3">
									<fo:block font-size="10pt">
										<xsl:value-of select="//comun.ambito" />:&#160;&#160;
										<fo:inline font-weight="bold">
											<xsl:value-of select="//parametro6" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt" padding-top="2pt" number-columns-spanned="2">
									<fo:block font-size="10pt">
										<xsl:value-of select="//comun.estado" />:&#160;&#160;
										<fo:inline font-weight="bold">
											<xsl:value-of select="//parametro10" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="8pt" padding-top="2pt" number-columns-spanned="2">
									<fo:block font-size="10pt">
										<xsl:value-of select="//comun.dificultad" />:&#160;&#160;
										<fo:inline font-weight="bold">
											<xsl:value-of select="//parametro7" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt" padding-top="2pt" number-columns-spanned="2">
									<fo:block font-size="10pt">
										<xsl:value-of select="//comun.duracion" />:&#160;&#160;
										<fo:inline font-weight="bold">
											<xsl:value-of select="//parametro8" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="8pt" padding-top="2pt" number-columns-spanned="2">
									<fo:block font-size="10pt">
										<xsl:value-of select="//estadoConsultas.fueraPlazo" />:&#160;&#160;
										<fo:inline font-weight="bold">
											<xsl:value-of select="//parametro11" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<xsl:apply-templates />
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>

	<xsl:template match="pagina">
		<fo:table table-layout="fixed" width="100%"
			border-collapse="separate" border-left-width="0.5pt">
			<!--<fo:table-column column-width="8mm" />
			<fo:table-column column-width="4mm" />-->
			<fo:table-column column-width="7mm" />
			<fo:table-column column-width="3mm" />
			<fo:table-column column-width="12mm" />
			<fo:table-column column-width="3mm" />
			<fo:table-column column-width="32mm" />
			<fo:table-column column-width="3mm" />
			<fo:table-column column-width="27mm" />
			<fo:table-column column-width="3mm" />
			<fo:table-column column-width="15mm" />
			<fo:table-column column-width="3mm" />
			<!--<fo:table-column column-width="6mm" />
			<fo:table-column column-width="4mm" />-->
			<fo:table-column column-width="35mm" />
			<fo:table-column column-width="3mm" />
			<fo:table-column column-width="19mm" />

			<fo:table-header space-after.optimum="5pt">
				<fo:table-row>
					<!--<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//estadoConsultas.horas" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>-->
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//estadoConsultas.fPlazo" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//comun.fecha" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//comun.consulta" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//comun.ambito" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//comun.dificultad" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<!--<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//estadoConsultas.dias" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>-->
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//estadoConsultas.resolutor" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid" text-align="center">
						<fo:block font-family="Helvetica" font-size="10pt">
							<xsl:value-of select="//comun.estado" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<xsl:apply-templates />
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="fila">
		<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
		<fo:table-row>
			<!--<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:choose>
						<xsl:when test="./celda[31]/atributo[1]='S'">
							<xsl:value-of select="//comun.si" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="//comun.no" />
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>-->
			<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:choose>
						<xsl:when test="./celda[40]/atributo[1]='S'">
							<xsl:value-of select="//comun.si" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="//comun.no" />
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[24]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[11]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[2]/atributo[4]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[23]/atributo[8]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<!--<fo:table-cell text-align="right" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[23]/atributo[10]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>-->
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[47]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[46]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>