<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java">
	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1"
		indent="yes" /><!--Texto latin-->

	<xsl:template match="informe">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="cuerpo"
					page-height="29cm" page-width="21cm" margin-top="1.25cm"
					margin-bottom="0.25cm" margin-left="1.5cm" margin-right="1.5cm">
					<fo:region-body margin-top="7.5cm" />
					<fo:region-before extent="5cm" />
					<fo:region-after extent="2cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:apply-templates />
		</fo:root>
	</xsl:template>

	<xsl:template match="contenido">
		<xsl:for-each select="pagina">
			<fo:page-sequence master-reference="cuerpo">

				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="30mm" />
						<fo:table-column column-width="145mm" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block>
										<xsl:variable name="imagen"
											select="//parametro1">
										</xsl:variable>
										<fo:external-graphic
											src="{$imagen}" />
									</fo:block>
								</fo:table-cell>

								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="right">
									<fo:block
										space-before.optimum="25pt">
										<xsl:value-of
											select="./fila[1]/celda[27]">
										</xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="right">
									<fo:block>
										<xsl:value-of
											select="./fila[1]/celda[12]">
										</xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>

								<fo:table-cell text-align="right">
									<fo:block>
										<xsl:value-of
											select="./fila[1]/celda[13]">
										</xsl:value-of>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<fo:static-content flow-name="xsl-region-after">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="30mm" />
						<fo:table-column column-width="87mm" />
						<fo:table-column column-width="55mm" />
						<fo:table-body>

							<fo:table-row>
								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block>
										<xsl:variable name="imagenEJ"
											select="//parametro2">
										</xsl:variable>
										<fo:external-graphic
											src="{$imagenEJ}" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="10pt">
						<fo:table table-layout="fixed">
							<fo:table-column column-width="9cm" />
							<fo:table-column column-width="9cm" />
							<fo:table-body>

								<fo:table-row>
									<fo:table-cell
										number-columns-spanned="2" text-align="center">
										<fo:block font-size="18pt"
											font-weight="bold">
											<fo:inline
												font-style="italic">
												<xsl:value-of
													select="//aplicacion.titulo" />
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell padding-left="1cm"
										number-columns-spanned="1">
										<fo:block
											space-before.optimum="20pt" font-size="10pt">
											<xsl:value-of
												select="//suscriptores.lagunHori" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell padding-left="1cm">
										<xsl:if
											test="//parametro7!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro7" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro8!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro8" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro9!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro9" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro10!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro10" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro11!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro11" />
											</fo:block>
										</xsl:if>
									</fo:table-cell>
									<fo:table-cell padding-left="1cm">
										<xsl:if
											test="//parametro12!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro12" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro13!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro13" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro14!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro14" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro15!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro15" />
											</fo:block>
										</xsl:if>
										<xsl:if
											test="//parametro16!=''">
											<fo:block
												space-before.optimum="10pt" font-size="10pt"
												text-align="justify">
												<xsl:value-of
													select="//parametro16" />
											</fo:block>
										</xsl:if>
									</fo:table-cell>
								</fo:table-row>


								<fo:table-row>
									<fo:table-cell padding-left="7cm"
										number-columns-spanned="2" font-size="15pt">
										<fo:block
											space-before.optimum="10pt">
											<xsl:value-of
												select="//comun.usuarioCarta" />
											:
											<xsl:value-of
												select="./fila[1]/celda[36]" />
										</fo:block>
										<fo:block>
											<xsl:value-of
												select="//comun.contraseaCarta" />
											:
											<xsl:value-of
												select="./fila[1]/celda[4]" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell padding-left="1cm"
										number-columns-spanned="1">
										<fo:block
											space-before.optimum="20pt" font-size="10pt"
											text-align="left">
											<xsl:value-of
												select="//suscriptores.agurra" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell
										number-columns-spanned="2">
										<fo:block font-size="16pt">
											&#160;
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell padding-left="1cm"
										number-columns-spanned="1">
										<fo:block font-size="16pt">
											<xsl:value-of
												select="//comun.ivap" />
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell
										number-columns-spanned="2">
										<fo:block>&#160;</fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block></fo:block>
									</fo:table-cell>
								</fo:table-row>

								<fo:table-row>
									<fo:table-cell padding-left="1cm"
										number-columns-spanned="1">
										<fo:block
											space-before.optimum="10pt" font-size="10pt">
											<xsl:value-of
												select="//parametro4">
											</xsl:value-of>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>

							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>


			</fo:page-sequence>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>