<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java">

	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1"
		indent="yes" /><!--Texto latin-->



	<xsl:template match="informe">

		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

			<fo:layout-master-set>

				<fo:simple-page-master master-name="cuerpo"
					page-height="21cm" page-width="29cm" margin-top="1cm"
					margin-bottom="2cm" margin-left="2cm" margin-right="2.5cm">

					<fo:region-body margin-top="3cm"
						margin-bottom="1.5cm" />

					<fo:region-before extent="5cm" />

					<fo:region-after extent="1.5cm" />

				</fo:simple-page-master>

			</fo:layout-master-set>

			<xsl:apply-templates />

		</fo:root>

	</xsl:template>



	<xsl:template match="contenido">

		<fo:page-sequence master-reference="cuerpo"
			initial-page-number="1">



			<!-- PARTE ESTATICA -->

			<fo:static-content flow-name="xsl-region-before">

				<fo:table table-layout="fixed">

					<fo:table-column column-width="30mm" />

					<fo:table-column column-width="185mm" />

					<fo:table-column column-width="30mm" />

					<fo:table-body>

						<fo:table-row>



							<!-- IMAGEN IVAP -->

							<fo:table-cell>

								<fo:block>

									<xsl:variable name="imagen"
										select="//parametro1">
									</xsl:variable>

									<fo:external-graphic
										src="{$imagen}" />

								</fo:block>

							</fo:table-cell>



							<!-- TITULO -->

							<fo:table-cell text-align="center">

								<fo:block font-family="Helvetica"
									font-size="14pt" line-height="30pt" space-after.optimum="15pt"
									text-decoration="underline" font-weight="bold"
									font-style="italic" text-align="center" padding-top="3pt">

									<xsl:value-of
										select="//informe.tablas.calendarioLaboral.titulo" />
									&#160;
									<xsl:value-of select="//parametro4" />

								</fo:block>

							</fo:table-cell>



							<!-- FECHA & PAGINA -->

							<fo:table-cell text-align="right">

								<fo:block font-family="Helvetica"
									font-size="10pt" font-weight="bold" space-before.optimum="15pt"
									space-after.optimum="15pt">

									<xsl:value-of
										select="//comun.pagina" />
									&#160;
									<fo:page-number />

								</fo:block>

							</fo:table-cell>

						</fo:table-row>

					</fo:table-body>

				</fo:table>

			</fo:static-content>

			<!-- CUERPO -->

			<fo:flow flow-name="xsl-region-body">

				<fo:block font-size="12pt" border-style="solid"
					line-height="24pt" space-after.optimum="15pt"
					text-align="center">

					<fo:table table-layout="fixed">

						<fo:table-column column-width="120mm" />

						<fo:table-column column-width="120mm" />

						<fo:table-body>

							<fo:table-row>

								<fo:table-cell
									number-columns-spanned="2">

									<fo:block font-size="11pt"
										text-align="left" font-weight="bold">

									</fo:block>

								</fo:table-cell>

							</fo:table-row>

							<fo:table-row>
								<fo:table-cell
									number-columns-spanned="1">
									<fo:block font-size="12pt"
										text-align="left">
										<xsl:value-of
											select="//comun.fechaDesde" />
										:&#160;
										<xsl:value-of
											select="//parametro5" />
									</fo:block>
								</fo:table-cell>

								<fo:table-cell
									number-columns-spanned="1">
									<fo:block font-size="12pt"
										text-align="left">
										<xsl:value-of
											select="//comun.fechaHasta" />
										:&#160;
										<xsl:value-of
											select="//parametro6" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>

								<fo:table-cell
									number-columns-spanned="2">

									<fo:block font-size="12pt"
										text-align="left">

									</fo:block>

								</fo:table-cell>

							</fo:table-row>

						</fo:table-body>

					</fo:table>

				</fo:block>

				<xsl:apply-templates />

				<fo:table space-before.optimum="10pt"
					text-align="left">

					<fo:table-column column-width="10mm" />

					<fo:table-column column-width="40mm" />

					<fo:table-body>

						<fo:table-row>

							<fo:table-cell background-color="#008000"
								border="solid">
								<fo:block>&#160;</fo:block>
							</fo:table-cell>

							<fo:table-cell>
								<fo:block font-size="10pt">
									&#160;
									<xsl:value-of
										select="//comun.festivo" />
								</fo:block>
							</fo:table-cell>

						</fo:table-row>

						<fo:table-row>

							<fo:table-cell>
								<fo:block>&#160;</fo:block>
							</fo:table-cell>

							<fo:table-cell>
								<fo:block>&#160;</fo:block>
							</fo:table-cell>

						</fo:table-row>

						<fo:table-row>

							<fo:table-cell border="solid">
								<fo:block>&#160;</fo:block>
							</fo:table-cell>

							<fo:table-cell>
								<fo:block font-size="10pt">
									&#160;
									<xsl:value-of
										select="//comun.laborable" />
								</fo:block>
							</fo:table-cell>

						</fo:table-row>

					</fo:table-body>

				</fo:table>

			</fo:flow>

		</fo:page-sequence>

	</xsl:template>







	<xsl:template match="pagina">



		<fo:table width="100%" table-layout="fixed">

			<fo:table-column column-width="260mm" />

			<!-- DATOS TABLA -->

			<fo:table-body>

				<fo:table-row>

					<fo:table-cell>

						<fo:block>

							<xsl:apply-templates />

						</fo:block>

					</fo:table-cell>

				</fo:table-row>



			</fo:table-body>

		</fo:table>

	</xsl:template>



	<xsl:template match="mes">

		<fo:table space-after.optimum="15pt" space-before.optimum="25pt"
			width="25%" table-layout="fixed">

			<fo:table-column column-width="70mm" />

			<fo:table-column column-width="17mm" />

			<fo:table-column column-width="70mm" />

			<fo:table-column column-width="17mm" />

			<fo:table-column column-width="70mm" />

			<fo:table-header>

				<fo:table-row>

					<fo:table-cell text-align="center">
						<fo:block font-size="11pt" font-weight="bold">
							<xsl:value-of select="./nomMes[1]" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							&#160;
						</fo:block>
					</fo:table-cell>

					<fo:table-cell text-align="center">
						<fo:block font-size="11pt" font-weight="bold">
							<xsl:value-of select="./nomMes[2]" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							&#160;
						</fo:block>
					</fo:table-cell>

					<fo:table-cell text-align="center">
						<fo:block font-size="11pt" font-weight="bold">
							<xsl:value-of select="./nomMes[3]" />
						</fo:block>
					</fo:table-cell>

				</fo:table-row>

			</fo:table-header>

			<fo:table-body border-right="solid">

			</fo:table-body>

		</fo:table>

		<fo:table width="25%" table-layout="fixed"
			space-after.optimum="15pt">

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="17mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="17mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />

			<fo:table-column column-width="10mm" />



			<!-- DATOS TABLA -->

			<fo:table-body>

				<fo:table-row>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-left="solid"
						border-right="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.lunescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell border-right="solid"
						background-color="#A2A8C6" border-top="solid"
						border-bottom="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.martescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.miercolescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.juevescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.viernescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.sabadocal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.domingocal" />
						</fo:block>
					</fo:table-cell>



					<fo:table-cell border-left="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							&#160;
						</fo:block>
					</fo:table-cell>



					<fo:table-cell border-left="solid"
						background-color="#A2A8C6" border-top="solid"
						border-bottom="solid" border-right="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.lunescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.martescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.miercolescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.juevescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.viernescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.sabadocal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.domingocal" />
						</fo:block>
					</fo:table-cell>



					<fo:table-cell border-left="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							&#160;
						</fo:block>
					</fo:table-cell>



					<fo:table-cell border-left="solid"
						background-color="#A2A8C6" border-top="solid"
						border-bottom="solid" border-right="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.lunescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.martescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.miercolescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.juevescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.viernescal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" border-right="solid"
						text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.sabadocal" />
						</fo:block>
					</fo:table-cell>

					<fo:table-cell background-color="#A2A8C6"
						border-top="solid" border-bottom="solid" text-align="center">
						<fo:block font-size="10pt" font-weight="bold">
							<xsl:value-of select="//comun.domingocal" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:apply-templates />


				<fo:table-row background-color="#FFFFFF">

					<fo:table-cell border-top="solid"
						number-columns-spanned="7">
						<fo:block>&#160;</fo:block>
					</fo:table-cell>

					<fo:table-cell>
						<fo:block>&#160;</fo:block>
					</fo:table-cell>

					<fo:table-cell border-top="solid"
						number-columns-spanned="7">
						<fo:block>&#160;</fo:block>
					</fo:table-cell>

					<fo:table-cell>
						<fo:block>&#160;</fo:block>
					</fo:table-cell>

					<fo:table-cell border-top="solid"
						number-columns-spanned="7">
						<fo:block>&#160;</fo:block>
					</fo:table-cell>

				</fo:table-row>

			</fo:table-body>

		</fo:table>

	</xsl:template>





	<xsl:template match="fila">

		<fo:table-row>

			<xsl:if test="./celda[1]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[2]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[1]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[2]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[3]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[4]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[3]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[4]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[5]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[6]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[5]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[6]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[7]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[8]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[7]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[8]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[9]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[10]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[9]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[10]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>
			
			<xsl:if test="./celda[11]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[12]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[11]!='FESTIVO' and ./celda[12]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[12]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[11]!='FESTIVO' and ./celda[12]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[12]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[13]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[14]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[13]!='FESTIVO' and ./celda[14]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[14]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[13]!='FESTIVO' and ./celda[14]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[14]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			

			<fo:table-cell border-right="solid" border-left="solid"
				text-align="center">
				<fo:block font-size="10pt">&#160;</fo:block>
			</fo:table-cell>



			<xsl:if test="./celda[17]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[18]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[17]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[18]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[19]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[20]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[19]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[20]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[21]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[22]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[21]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[22]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[23]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[24]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[23]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[24]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[25]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[26]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[25]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[26]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>
			
			<xsl:if test="./celda[27]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[28]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[27]!='FESTIVO' and ./celda[28]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[28]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[27]!='FESTIVO' and ./celda[28]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[28]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[29]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[30]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[29]!='FESTIVO' and ./celda[30]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[30]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[29]!='FESTIVO' and ./celda[30]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[30]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			
			<fo:table-cell border-right="solid" border-left="solid"
				text-align="center">
				<fo:block font-size="10pt">&#160;</fo:block>
			</fo:table-cell>



			<xsl:if test="./celda[33]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[34]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[33]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[34]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[35]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[36]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[35]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[36]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[37]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[38]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[37]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[38]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[39]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[40]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[39]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[40]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[41]='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[42]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[41]!='FESTIVO'">

				<fo:table-cell border-bottom="solid"
					border-right="solid" border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[42]" />
					</fo:block>
				</fo:table-cell>

			</xsl:if>

			<xsl:if test="./celda[43]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[44]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[43]!='FESTIVO' and ./celda[44]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[44]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[43]!='FESTIVO' and ./celda[44]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[44]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[45]='FESTIVO'">
				<fo:table-cell border-bottom="solid"
					background-color="#008000" border-right="solid" border-left="solid"
					text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[46]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[45]!='FESTIVO' and ./celda[46]!=''">
				<fo:table-cell background-color="#888888" border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[46]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>
			
			<xsl:if test="./celda[45]!='FESTIVO' and ./celda[46]=''">
				<fo:table-cell border-bottom="solid" border-right="solid"
					border-left="solid" text-align="center">
					<fo:block font-size="10pt">
						<xsl:value-of select="./celda[46]" />
					</fo:block>
				</fo:table-cell>
			</xsl:if>

		</fo:table-row>

		<fo:table-row>
			<fo:table-cell background-color="#FFFFFF">
				<fo:block></fo:block>
			</fo:table-cell>
		</fo:table-row>

	</xsl:template>

</xsl:stylesheet>

