<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java">
	<xsl:output method="xml" version="1.0" encoding="ISO-8859-1"
		indent="yes" /><!--Texto latin-->

	<xsl:template match="informe">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="cuerpo"
					page-height="21cm" page-width="29cm" margin-top="1cm"
					margin-bottom="2cm" margin-left="2cm" margin-right="2.5cm">
					<fo:region-body margin-top="3cm"
						margin-bottom="1.5cm" />
					<fo:region-before extent="5cm" />
					<fo:region-after extent="1.5cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:apply-templates />
		</fo:root>
	</xsl:template>

	<xsl:template match="contenido">
		<fo:page-sequence master-reference="cuerpo"
			initial-page-number="1">

			<!-- PARTE ESTATICA -->
			<fo:static-content flow-name="xsl-region-before">
				<fo:table table-layout="fixed">
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="165mm" />
					<fo:table-column column-width="40mm" />
					<fo:table-body>
						<fo:table-row>

							<!-- IMAGEN IVAP -->
							<fo:table-cell text-align="left">
								<fo:block>
									<xsl:variable name="imagen"
										select="//parametro1">
									</xsl:variable>
									<fo:external-graphic
										src="{$imagen}" />
								</fo:block>
							</fo:table-cell>
							<!-- TITULO -->
							<fo:table-cell text-align="center">
								<fo:block font-family="Helvetica"
									font-size="14pt" line-height="80pt" text-decoration="underline"
									font-weight="bold" font-style="italic" text-align="center"
									padding-top="3pt">
									<xsl:value-of
										select="//informe.gestion.bandejaEntrada.titulo" />
								</fo:block>
							</fo:table-cell>
							<!-- FECHA & PAGINA -->
							<fo:table-cell text-align="right">
								<fo:block font-family="Helvetica"
									font-size="10pt" font-weight="bold" space-before.optimum="15pt"
									space-after.optimum="15pt">
									<xsl:value-of
										select="//comun.pagina" />
									&#160;
									<fo:page-number />
								</fo:block>
								<fo:block font-family="Helvetica"
									font-size="10pt" font-weight="bold">
									<xsl:value-of
										select="//comun.fecha" />
									&#160;
									<xsl:value-of select="//parametro2" />
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:static-content>

			<!--  BODY -->
			<fo:flow flow-name="xsl-region-body">
				<fo:block font-family="Helvetica"
					space-after.optimum="15pt">
					<!-- CUADRO CABECERA -->
					<!-- El parametro idioma determina la distribucion de los literales y datos -->
					<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
					<fo:table table-layout="fixed" border-style="solid"
						padding-top="3pt">
						<fo:table-column column-width="60mm" />
						<fo:table-column column-width="62mm" />
						<fo:table-column column-width="60mm" />
						<fo:table-column column-width="63mm" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.fConsultaDesde" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro4" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.fConsultaHasta" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro5" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.fRespuestaDesde" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro6" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.fRespuestaHasta" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro7" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.notificaciones" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro8" />
									</fo:block>
								</fo:table-cell>
<!--  								
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.abreviaturas" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro11" />
									</fo:block>
								</fo:table-cell>
-->								
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.ambito" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro9" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.estado" />
										:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro10" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding-left="8pt"
									padding-top="2pt">
									<fo:block font-size="10pt">
										<xsl:value-of
											select="//comun.consulta" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-top="2pt"
									number-columns-spanned="2">
									<fo:block font-size="10pt"
										text-align="left" font-weight="bold">
										<xsl:value-of
											select="//parametro12" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:block>
				<xsl:apply-templates />
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>

	<xsl:template match="pagina">
		<fo:table table-layout="fixed" width="100%"
			border-collapse="separate" border-left-width="0.5pt">
			<fo:table-column column-width="5mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="15mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="28mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="29mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="50mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="15mm" />
			<fo:table-column column-width="2mm" />
			<fo:table-column column-width="5mm" />

			<fo:table-header space-after.optimum="5pt">
				<fo:table-row>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.notif" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.fecha" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.ambito" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.estado" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.consulta" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.dificultad" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block></fo:block>
					</fo:table-cell>
					<fo:table-cell border-bottom-style="solid"
						text-align="center">
						<fo:block font-family="Helvetica"
							font-size="10pt">
							<xsl:value-of select="//comun.doc" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<xsl:apply-templates />
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="fila">
		<xsl:variable name="idioma" select="//parametro3"></xsl:variable>
		<fo:table-row>
			<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:choose>
						<xsl:when test="./celda[42]/atributo[1]='S'">
							<xsl:value-of select="//comun.si" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="//comun.no" />
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[24]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[2]/atributo[4]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[46]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[11]/atributo[1]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="left" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:value-of select="./celda[23]/atributo[8]" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block></fo:block>
			</fo:table-cell>
			<fo:table-cell text-align="center" padding-before="1mm">
				<fo:block font-family="Helvetica" font-size="10pt">
					<xsl:choose>
						<xsl:when test="./celda[38]/atributo[1]='S'">
							<xsl:value-of select="//comun.si" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="//comun.no" />
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

</xsl:stylesheet>