package v50bDudanetEJB;



import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bNotificacionBean;
import v50b.v50bBeans.V50bRespuestasBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bControlador.V50bControladorFactory;
import v50b.v50bControlador.V50bFachada;


/**
 * <p>Ttulo: V50bDudanetBean</p>
 * <p>Descripcin: EJB que mantiene la transaccin implementando la fachada.</p>
 * <p>Copyright: Copyright (c) 2008</p>
 * <p>Empresa: Eurohelp </p>
 *
 * @author iurkidi
 *
 * @ejb.bean name="V50bDudanet"
 *	jndi-name="v50b.v50bDudanetEJB"
 *	type="Stateless"
 *      view-type="remote"
 *      transaction-type="Container"
 *
 * @weblogic.ejb trans-timeout-seconds="60"
 *          enable-call-by-reference="True"
 */
public class V50bDudanetBean implements SessionBean, V50bFachada { 
	private static final long serialVersionUID = 1L;
	private SessionContext sessionContext; 
   
  
 
 
  //NOTA: Tras aadir un nuevo metodo a esta clase del EJB hay que coger 
  //los 5 archivos del EJB y darle a 'generar_HautaNetIntranetEJB'..
 
  //EJEMPLO!!!!!!!!!!!!!!!!!!!!!!! Hay que poner estos comentarios siempre. Si el metodo va a hacer cambio en la BD
  //se pone '@ejb.transaction type="Required"', si no los va a hacer se pone '@ejb.transaction type="Supports"'.
  //El metodo debe tener la mismo forma que el de ejemplo siempre.
	
	/**
	 * <p>Ttulo: fncVerFicheroConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 30/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @return Devuelve el lob
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
   	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public V50bClsFichero fncVerFicheroConsulta(String v50bCodigoConsulta) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncVerFicheroConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncVerFicheroConsulta(v50bCodigoConsulta);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncVerFicheroDetalleConsulta</p>
	 * <p>Descripcin: Obtiene el lob de la consulta</p>
	 * <p>Copyright: Copyright (c) 21/09/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param v50bCodigoConsulta Cdigo de la consulta
	 * @param tipo String
	 * @return Devuelve el lob
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
   	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public V50bClsFichero fncVerFicheroDetalleConsulta(String v50bCodigoConsulta, String tipo) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncVerFicheroDetalleConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncVerFicheroDetalleConsulta(v50bCodigoConsulta, tipo);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
	
 	/**
	 * 
	 * <p>Ttulo: fncBuscarConsultasBandejaEntrada</p>
	 * <p>Descripcin: Busca consultas filtrando con el formulario de Bandeja de Entrada</p>
	 * <p>Copyright: Copyright (c) 29/10/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Bandeja de Entrada
	 * @return lista de consultas que pasan el filtro
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
   	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarConsultasBandejaEntrada(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscarConsultasBandejaEntrada() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscarConsultasBandejaEntrada(form);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevaConsulta</p>
	 * <p>Descripcin: Introduce una nueva consulta en la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a insertar
	 * @return Lista con el Entero con el resultado de la operacin y String con el cdigo de la consulta
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncNuevaConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncNuevaConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncNuevaConsulta(form);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
 
	/**
	 * 
	 * <p>Ttulo: fncModificarConsulta</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncModificarConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncModificarConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncModificarConsulta(form);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultaCatalogo</p>
	 * <p>Descripcin: Modifica una consulta de la T01</p>
	 * <p>Copyright: Copyright (c) 02/04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public int fncModificarConsultaCatalogo(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncModificarConsultaCatalogo() ");
		try{  
			return V50bControladorFactory.getFachada().fncModificarConsultaCatalogo(form);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	}
	
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param ambito : ambito con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarAmbitos(v50b.v50bBeans.V50bAmbitoBean ambito) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarAmbitos(ambito);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}

  }  
  
  /**
   * Modifica las propiedades de un peticionario almacenado en la base de datos
   * 
   * @param ambito : ambito con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarAmbito(v50b.v50bBeans.V50bAmbitoBean ambito) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarAmbito(ambito);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }
  
  /**
   * Inserta un peticionario en la base de datos
   * 
   * @param ambito : ambito con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirAmbito(v50b.v50bBeans.V50bAmbitoBean ambito) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncAniadirAmbito(ambito);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }  
  
  /**
   * Inserta un peticionario en la base de datos
   * 
   * @param usuario : usuario logueado 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncObtenerPerfilUsuario(V50bUsuarioBean usuario) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncObtenerPerfilUsuario(usuario);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  } 
  	
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarTiposTrabajo(v50b.v50bBeans.V50bTipoTrabajoBean tipoTrabajo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarTiposTrabajo(tipoTrabajo);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Modifica las propiedades de un tipo de trabajo almacenado en la base de datos
   * 
   * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarTiposTrabajo(v50b.v50bBeans.V50bTipoTrabajoBean tipoTrabajo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarTiposTrabajo(tipoTrabajo);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }
  
  /**
   * Inserta un tipo de trabajo en la base de datos
   * 
   * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
   * @return int: el resultado de la insert
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirTiposTrabajo(v50b.v50bBeans.V50bTipoTrabajoBean tipoTrabajo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncAniadirTiposTrabajo(tipoTrabajo);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param motivo : motivo con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarMotivos(v50b.v50bBeans.V50bMotivosBean motivo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarMotivos(motivo);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Modifica las propiedades de un motivo de denegacion,reenvio o rechazo almacenado en la base de datos
   * 
   * @param motivo : motivo con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarMotivos(v50b.v50bBeans.V50bMotivosBean motivo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarMotivos(motivo);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }
  
  /**
   * Inserta un motivo de denegacion, reenvio o rechazo en la base de datos
   * 
   * @param motivo : motivo con los datos de busqueda 
   * @return int: el resultado de la insert
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirMotivos(v50b.v50bBeans.V50bMotivosBean motivo) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncAniadirMotivos(motivo);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }  
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param dificultad : dificultad con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarDificultad(v50b.v50bBeans.V50bDificultadBean dificultad) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarDificultad(dificultad);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Modifica las propiedades de una dificultad almacenada en la base de datos
   * 
   * @param dificultad : dificultad con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarDificultad(v50b.v50bBeans.V50bDificultadBean dificultad) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarDificultad(dificultad);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }
  
  /**
   * Inserta una dificultad en la base de datos
   * 
   * @param dificultad : dificultad con los datos de busqueda 
   * @return int: el resultado de la insert
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirDificultad(v50b.v50bBeans.V50bDificultadBean dificultad) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncAniadirDificultad(dificultad);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }  
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param dificultad : dificultad con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarAmbitosDificultad(v50b.v50bBeans.V50bDificultadBean dificultad) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarAmbitosDificultad(dificultad);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarConfiguracion(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarConfiguracion(buzon);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarConfigTextos(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarConfigTextos(buzon);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Elimina un buzon de la base de datos 
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return int: el resultado de la delete
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncEliminarConfiguracion(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncEliminarConfiguracion(buzon);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  } 
  
  /**
   * Modifica las propiedades de configuracion almacenado en la base de datos
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncGuardarConfiguracion(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncGuardarConfiguracion(buzon);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  }
  
  /**
   * Modifica las propiedades del buzon almacenado en la base de datos
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarBuzon(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarBuzon(buzon);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }
  
  /**
   * Inserta un buzon en la base de datos
   * 
   * @param buzon : buzon con los datos de busqueda 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirBuzon(v50b.v50bBeans.V50bConfiguracionBean buzon) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncAniadirBuzon(buzon);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}
  }
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param subcategorias : Subcategorias con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarSubcategorias(v50b.v50bBeans.V50bSubcategoriasBean subcategorias) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarSubcategorias(subcategorias);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}

  }  
  
  /**
   * Modifica las propiedades de una subcategora almacenada en la base de datos
   * 
   * @param subcategorias : Subcategorias con los datos a modificar 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarSubcategorias(v50b.v50bBeans.V50bSubcategoriasBean subcategorias) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarSubcategorias(subcategorias);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }
  
  /**
   * Inserta una subcategora en la base de datos
   * 
   * @param subcategorias : Subcategorias con los datos a agregar 
   * @return int: el resultado de agregar los datos
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirSubcategorias(v50b.v50bBeans.V50bSubcategoriasBean subcategorias) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncAniadirSubcategorias(subcategorias);
		}
		catch(Exception e)
		{
		    throw new RemoteException("", e);
		}

	  } 
  
  /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param subcategoria : subcategoria con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarAmbitosSubcategoria(v50b.v50bBeans.V50bSubcategoriasBean subcategoria) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarAmbitosSubcategoria(subcategoria);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}
  }

   /**
   * Lanza una consulta sencilla con statement que devuelve una lista 
   * 
   * @param profesiones : Profesiones con los datos de busqueda 
   * @return List: el resultado de la select
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Supports"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public List fncBuscarProfesiones(v50b.v50bBeans.V50bProfesionesBean profesiones) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncBuscarProfesiones(profesiones);
	}
    catch(Exception e)
    {
    	throw new RemoteException("", e);
	}

  }  
  
  /**
   * Modifica las propiedades de una profesin almacenada en la base de datos
   * 
   * @param profesiones : Profesiones con los datos a modificar 
   * @return int: el resultado de la update
   * @throws java.rmi.RemoteException eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncModificarProfesiones(v50b.v50bBeans.V50bProfesionesBean profesiones) throws RemoteException {
	try{  
		return V50bControladorFactory.getFachada().fncModificarProfesiones(profesiones);
	}
	catch(Exception e)
	{
	    throw new RemoteException("", e);
	}

  }
  
  /**
   * Inserta una profesin en la base de datos
   * 
   * @param profesiones : Profesiones con los datos a agregar 
   * @return int: el resultado de agregar los datos
   * @throws java.rmi.RemoteException Se eleva la excepcin.
   *
   * @ejb.interface-method view-type="remote"
   * @ejb.transaction type="Required"
   *
   * @weblogic.ejb.idempotent-methods
   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
   */
  public int fncAniadirProfesiones(v50b.v50bBeans.V50bProfesionesBean profesiones) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncAniadirProfesiones(profesiones);
		}
		catch(Exception e)
		{
		    throw new RemoteException("", e);
		}

	  }  

  /**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */	 
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscarUsuariosRegistrados() ");
		try {  
			return V50bControladorFactory.getFachada().fncBuscarUsuariosRegistrados(form);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */	 
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncDetalleUsuarioRegistrado() ");
		try {  
			return V50bControladorFactory.getFachada().fncDetalleUsuarioRegistrado(form);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncNuevoUsuarioRegistrado() ");
		try {  
			return V50bControladorFactory.getFachada().fncNuevoUsuarioRegistrado(form);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
		
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncModificarUsuarioRegistrado() ");
		try {  
			return V50bControladorFactory.getFachada().fncModificarUsuarioRegistrado(form);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: Elimina un suscriptor</p>
	 * <p>Copyright: Copyright (c) Abr 11, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncEliminarUsuarioRegistrado() ");
		try {  
			return V50bControladorFactory.getFachada().fncEliminarUsuarioRegistrado(usuario);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public String fncCargaEmailRemitente() throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncCargaEmailRemitente() ");
		try {  
			return V50bControladorFactory.getFachada().fncCargaEmailRemitente();
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	 /**
	   * Lanza una consulta sencilla con statement que devuelve una lista 
	   * 
	   * @param resolutores : Resolutores con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarResolutores(v50b.v50bBeans.V50bResolutoresBean resolutores) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarResolutores(resolutores);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}

	  }  
	  
	  /**
	   * Modifica las propiedades de una profesin almacenada en la base de datos
	   * 
	   * @param resolutores : Resolutores con los datos a modificar 
	   * @param usuario : usuario
	   * @return int: el resultado de la update
	   * @throws java.rmi.RemoteException eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Required"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public int fncModificarResolutores(v50b.v50bBeans.V50bResolutoresBean resolutores, String usuario) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncModificarResolutores(resolutores, usuario);
		}
		catch(Exception e)
		{
		    throw new RemoteException("", e);
		}

	  }
	  
	  /**
	   * Inserta un resolutor en la base de datos
	   * 
	   * @param resolutores : Resolutores con los datos a agregar 
	   * @return int: el resultado de agregar los datos
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Required"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public int fncAniadirResolutores(v50b.v50bBeans.V50bResolutoresBean resolutores) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncAniadirResolutores(resolutores);
		}
		catch(Exception e)
		{
		    throw new RemoteException("", e);
		}
	  }
	  
	  /**
	   * Lanza una consulta sencilla con statement que devuelve una lista 
	   * 
	   * @param resolutores : resolutor con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarAmbitosResolutor(v50b.v50bBeans.V50bResolutoresBean resolutores) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarAmbitosResolutor(resolutores);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	  } 
	  
	  /**
	   * Lanza una consulta con statement que devuelve una lista 
	   * 
	   * @param consulta : consulta con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarConsultasEstadoConsultas(v50b.v50bBeans.V50bConsultaBean consulta) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarConsultasEstadoConsultas(consulta);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}

	  }  
	  
	  /**
	   * Lanza una consulta sencilla con statement que devuelve una lista 
	   * 
	   * @param consulta : consulta con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarDificultadesAmbito(V50bConsultaBean consulta) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarDificultadesAmbito(consulta);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	  }
	  
	  /**
		* <p>Ttulo: fncObtenerTexto</p>
		* <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo</p>
		* <p>Copyright: Copyright (c) Nov 25, 2008</p>
		* <p>Empresa: Eurohelp</p>
		* 
		* @author llaparra
		* @version 1.0
		* @param codigo Cdigo del texto
		* @param idioma Idioma de la sesin
		* @return String El texto
		* @throws RemoteException Excepcin remota
		* 
		* @ejb.interface-method view-type="remote"
	    * @ejb.transaction type="Supports"
	    *
	    * @weblogic.ejb.idempotent-methods
	    * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	    */
		public String fncObtenerTexto(String codigo, String idioma) throws RemoteException {
			V50bClsTrazas.depura("V50bDudanetBean.fncObtenerTexto() ");
			try {  
				return V50bControladorFactory.getFachada().fncObtenerTexto(codigo, idioma);
			} catch(Exception e) {
		    	throw new RemoteException("", e);
			}
		}
		
		/**
		 * 
		 * <p>Ttulo: fncObtenerTextos</p>
		 * <p>Descripcin: Obtiene el texto de la tabla que corresponde con el cdigo en ambos idiomas</p>
		 * <p>Copyright: Copyright (c) Nov 25, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author llaparra
		 * @version 1.0
		 * @param codigo Cdigo del texto
		 * @return List Lista con los textos
		 * @throws Exception Cualquier excepcin
		 * 
		 * @ejb.interface-method view-type="remote"
	     * @ejb.transaction type="Supports"
	     *
	     * @weblogic.ejb.idempotent-methods
	     * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	     */
		public List fncObtenerTextos(String codigo) throws Exception{
			V50bClsTrazas.depura("V50bDudanetBean.fncObtenerTextos() ");
			try {  
				return V50bControladorFactory.getFachada().fncObtenerTextos(codigo);
			} catch(Exception e) {
		    	throw new RemoteException("", e);
			}
		}
		
		  /**
		   * Lanza una consulta con statement que devuelve una lista 
		   * 
		   * @param consulta : consulta con los datos de busqueda 
		   * @return List: el resultado de la select
		   * @throws java.rmi.RemoteException Se eleva la excepcin.
		   *
		   * @ejb.interface-method view-type="remote"
		   * @ejb.transaction type="Supports"
		   *
		   * @weblogic.ejb.idempotent-methods
		   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		   */
		  public List fncBuscarConsultasCatalogoConsultas(v50b.v50bBeans.V50bConsultaBean consulta) throws RemoteException {
			try{  
				return V50bControladorFactory.getFachada().fncBuscarConsultasCatalogoConsultas(consulta);
			}
		    catch(Exception e)
		    {
		    	throw new RemoteException("", e);
			}

		  }  
		
   /**
	* <p>Ttulo: fncDetalleConsulta</p>
	* <p>Descripcin: Busca los datos de una consulta</p>
	* <p>Copyright: Copyright (c) 29/10/2008</p>
	* <p>Empresa: Eurohelp</p>
	* 
	* @author llaparra
	* @version 1.0
	* @param form Formulario de Bandeja de Entrada
	* @return V50bConsultaBean Consulta detallada
	* @throws RemoteException Excepcin remota
	* 
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Supports"
	*
	* @weblogic.ejb.idempotent-methods
	* @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	*/
	public V50bConsultaBean fncDetalleConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncDetalleConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncDetalleConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	* <p>Ttulo: fncComboSubcategoriaDificultad</p>
	* <p>Descripcin: Busca los datos de una consulta</p>
	* <p>Copyright: Copyright (c) 29/10/2008</p>
	* <p>Empresa: Eurohelp</p>
	* 
	* @author llaparra
	* @version 1.0
	* @param codAmbito Cdigo del mbito
	* @param idioma Idioma de la sesin
	* @return List Lista con las listas de los combos subcategora y dificultades
	* @throws RemoteException Excepcin remota
	* 
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Supports"
	*
	* @weblogic.ejb.idempotent-methods
	* @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	*/
	public List fncComboSubcategoriaDificultad(String codAmbito, String idioma) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncComboSubcategoriaDificultad() ");
		try{  
			return V50bControladorFactory.getFachada().fncComboSubcategoriaDificultad(codAmbito, idioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	* <p>Ttulo: fncComboSubcategoriaResolutorDificultad</p>
	* <p>Descripcin: Busca los datos de una consulta</p>
	* <p>Copyright: Copyright (c) 29/10/2008</p>
	* <p>Empresa: Eurohelp</p>
	* 
	* @author alata
	* @version 1.0
	* @param codAmbito Cdigo del mbito
	* @param idioma Idioma de la sesin
	* @return List Lista con las listas de los combos subcategora, resolutor y dificultades
	* @throws RemoteException Excepcin remota
	* 
	* @ejb.interface-method view-type="remote"
	* @ejb.transaction type="Supports"
	*
	* @weblogic.ejb.idempotent-methods
	* @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	*/
	public List fncComboSubcategoriaResolutorDificultad(String codAmbito, String idioma) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncComboSubcategoriaResolutorDificultad() ");
		try{  
			return V50bControladorFactory.getFachada().fncComboSubcategoriaResolutorDificultad(codAmbito, idioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscSituacionResolutoresArea() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscSituacionResolutoresArea(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	   * Lanza una consulta sencilla con statement que devuelve una lista 
	   * @author acompes
	   * @param consulta : consulta con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarSubcategoriasAmbito(V50bConsultaBean consulta) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarSubcategoriasAmbito(consulta);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}
	  }
	  
	/**
	   * Lanza una consulta con statement que devuelve una lista 
	   * 
	   * @param consulta : consulta con los datos de busqueda 
	   * @return List: el resultado de la select
	   * @throws java.rmi.RemoteException Se eleva la excepcin.
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBuscarConsultasHistoricoConsultas(v50b.v50bBeans.V50bConsultaBean consulta) throws RemoteException {
		try{  
			return V50bControladorFactory.getFachada().fncBuscarConsultasHistoricoConsultas(consulta);
		}
	    catch(Exception e)
	    {
	    	throw new RemoteException("", e);
		}

	  } 
	
	/**
	 * 
	 * <p>Ttulo: fncAsignarResolutor</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para asignar un resolutor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos
	 * @return Lista con los datos de comunicacin al usuario y un entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncAsignarResolutor(V50bConsultaBean form) throws RemoteException{
		V50bClsTrazas.depura("V50bDudanetBean.fncAsignarResolutor() ");
		try{  
			return V50bControladorFactory.getFachada().fncAsignarResolutor(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncReenviarConsulta</p>
	 * <p>Descripcin: Reenva una consulta a otro resolutor</p>
	 * <p>Copyright: Copyright (c) 07/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos para el reenvo
	 * @return Lista con los datos de comunicacin al suscriptor y un entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncReenviarConsulta(V50bConsultaBean form) throws RemoteException{
		V50bClsTrazas.depura("V50bDudanetBean.fncReenviarConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncReenviarConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarVisibleInternet</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para que sea visible o no en internet</p>
	 * <p>Copyright: Copyright (c) 09/12/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param consulta : Formulario con los datos de la consulta
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public int fncModificarVisibleInternet(V50bConsultaBean consulta) throws Exception {
		V50bClsTrazas.depura("V50bDudanetBean.fncModificarVisibleInternet() ");
		try{  
			return V50bControladorFactory.getFachada().fncModificarVisibleInternet(consulta);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncVisibleInternetHistConsultas</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para que sea visible en internet</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public int fncVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		V50bClsTrazas.depura("V50bDudanetBean.fncVisibleInternetHistConsultas() ");
		try{  
			return V50bControladorFactory.getFachada().fncVisibleInternetHistConsultas(consultas, seleccionadas);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNoVisibleInternetHistConsultas</p>
	 * <p>Descripcin: Modifica una consulta de la T01 para que no sea visible en internet</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param consultas : todas las consultas de la busqueda
	 * @param seleccionadas : consultas seleccionadas en la lista de resultados
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin 
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public int fncNoVisibleInternetHistConsultas(ArrayList consultas, ArrayList seleccionadas) throws Exception {
		V50bClsTrazas.depura("V50bDudanetBean.fncNoVisibleInternetHistConsultas() ");
		try{  
			return V50bControladorFactory.getFachada().fncNoVisibleInternetHistConsultas(consultas, seleccionadas);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDenegarConsulta</p>
	 * <p>Descripcin: Deniega una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncDenegarConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncDenegarConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncDenegarConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncResponderConsulta</p>
	 * <p>Descripcin: Responde a una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la respuesta
	 * @return List Resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncResponderConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncResponderConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncResponderConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncRechazarConsulta</p>
	 * <p>Descripcin: Rechaza una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 5, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la denegacin
	 * @return Integer Resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncRechazarConsulta(V50bConsultaBean form) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncRechazarConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncRechazarConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncCatalogarConsulta</p>
	 * <p>Descripcin: Catalogar una consulta</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a cataloogar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncCatalogarConsulta(V50bConsultaBean form) throws Exception{
		V50bClsTrazas.depura("V50bDudanetBean.fncCatalogarConsulta() ");
		try{  
			return V50bControladorFactory.getFachada().fncCatalogarConsulta(form);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	
	/**
	 * <p>Ttulo: fncObtenerPeriodoServInactivo</p>
	 * <p>Descripcin: obtiene fechas de periodo inactivo</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param bean bean
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncObtenerPeriodoServInactivo(V50bCalendarioBean bean) throws Exception{
		V50bClsTrazas.depura("V50bDudanetBean.fncObtenerPeriodoServInactivo() ");
		try{  
			return V50bControladorFactory.getFachada().fncObtenerPeriodoServInactivo(bean);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncSolicitarInformacion</p>
	 * <p>Descripcin: solicitar informacin adicional a un tcnico o a un suscriptor</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con la info adicional
	 * @param tipoDest String con el tipo de destinatario (T)Tecnico/(S)Suscriptor
	 * @return List lista con los datos de comunicacin y un entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota 
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncSolicitarInformacion(V50bConsultaBean form, String tipoDest) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncSolicitarInformacion() ");
		try{  
			return V50bControladorFactory.getFachada().fncSolicitarInformacion(form, tipoDest);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	/**
	 * 
	 * <p>Ttulo:fncObtenerDatosGraficos </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
 	 * @author mmonge
 	 * @version 1.0
 	 * @param criteriosGrafico parametro de entrada
 	 * @return List parametro de retorno
 	 * @throws RemoteException excepcion remota
 	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncObtenerDatosGraficos(V50bCriteriosConsultaBean criteriosGrafico)throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncObtenerDatosGraficos() ");

		try{  
			return V50bControladorFactory.getFachada().fncObtenerDatosGraficos(criteriosGrafico);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	
	/**
	 * 
	 * <p>Ttulo:fncObtenerDatosAmbito </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 26, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
 	 * @author mmonge
 	 * @version 1.0
 	 * @param idioma parametro de entrada
 	 * @return List parametro de retorno
 	 * @throws RemoteException excepcion remota
 	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncObtenerDatosAmbitos(String idioma)throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncObtenerDatosAmbitos() ");

		try{  
			return V50bControladorFactory.getFachada().fncObtenerDatosAmbitos(idioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscSitResolutores(String codAmbito) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscSitResolutores() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscSitResolutores(codAmbito);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncGuardarCalendario</p>
	 * <p>Descripcin: guardamos cambios del calendario</p>
	 * <p>Copyright: Copyright (c) 04/11/2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param lista Lista de datps
	 * @return Entero con el resultado de la operacin
	 * @throws RemoteException Excepcin remota 
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public Integer fncGuardarCalendario(ArrayList lista) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncGuardarCalendario() ");
		try{  
			return V50bControladorFactory.getFachada().fncGuardarCalendario(lista);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncBuscarNotificaciones</p>
	 * <p>Descripcin: Busca las notificaciones de una consulta</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param consulta La consulta
	 * @return List Lista con las notificaciones
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarNotificaciones(V50bConsultaBean consulta) throws RemoteException{
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscarNotificaciones() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscarNotificaciones(consulta);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncRespondeNotificacion</p>
	 * <p>Descripcin: Responde una notificacin</p>
	 * <p>Copyright: Copyright (c) Dec 12, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param respuesta La respuesta
	 * @return List Datos de la comunicacin y Resultado de la operacin
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncRespondeNotificacion(V50bNotificacionBean respuesta) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncRespondeNotificacion() ");
		try{  
			return V50bControladorFactory.getFachada().fncRespondeNotificacion(respuesta);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncBuscar24Horas</p>
	 * <p>Descripcin: Busca consultas 24 Horas</p>
	 * <p>Copyright: Copyright (c) Dec 22, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscar24Horas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscar24Horas() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscar24Horas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncBuscarPendientes</p>
	 * <p>Descripcin: Busca consultas Pendientes</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarPendientes(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscarPendientes() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscarPendientes(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	/**
	 * <p>Ttulo: fncBuscarRetrasadas</p>
	 * <p>Descripcin: Busca consultas Retrasadas</p>
	 * <p>Copyright: Copyright (c) Dec 26, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author brey
	 * @version 1.0
	 * @param v50bCodResolutor El resolutor
	 * @param v50bCodAmbito El mbito
	 * @param v50bStrIdioma El idioma
	 * @return List Lista con las consultas
	 * @throws RemoteException Excepcin remota
	 * 
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncBuscarRetrasadas(String v50bCodResolutor, String v50bCodAmbito, String v50bStrIdioma)throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncBuscarRetrasadas() ");
		try{  
			return V50bControladorFactory.getFachada().fncBuscarRetrasadas(v50bCodResolutor,v50bCodAmbito,v50bStrIdioma);
		} catch(Exception e) {
	    	throw new RemoteException("", e);
		}
	}
	
	  /**
	   * Realiza una consulta 
	   * @author brey
	   * @param encuestaBean V50bEncuestaBean: Objeto bean donde se contienen los datos
	   * @return List: lista resultado
	   * @throws Exception SE ELEVA LA EXCEPXION
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncBusqEncuestas(V50bEncuestaBean encuestaBean)throws Exception {
		  try{   
			  	return V50bControladorFactory.getFachada().fncBusqEncuestas(encuestaBean);
			  }
			  catch(Exception e)
			  {
			      throw new RemoteException("", e);
			  }
	  }  
	  
	  /**
	   * Recupera un fichero
	   * @author brey
	   * @param encuestas String: Sentencia SQL a lanzar
	   * @return String: el resultado de la select (un campo). "" si es vaco.
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncExcelEncuestasResultados(V50bEncuestaBean encuestas) throws Exception {
		  try{   
			  return V50bControladorFactory.getFachada().fncExcelEncuestasResultados(encuestas);
		  }
		  catch(Exception e)
		  {
			  throw new RemoteException("", e);
		  }
		  
	  }
	  
	  /**
	   * Recupera un fichero
	   * @author brey
	   * @param encuestas String: Sentencia SQL a lanzar
	   * @return String: el resultado de la select (un campo). "" si es vaco.
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public List fncCargarEncuesta(V50bEncuestaBean encuestas) throws Exception {
		  try{
			  return V50bControladorFactory.getFachada().fncCargarEncuesta(encuestas);
		  }
		  catch(Exception e)
		  {
			  throw new RemoteException("", e);
		  }
		  
	  }
	  
	  /**
		 * 
		 * <p>Ttulo: fncEliminarEncuesta</p>
		 * <p>Descripcin: Elimina una encuesta de la BD</p>
		 * <p>Copyright: Copyright (c) 08/01/2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author alata
		 * @version 1.0
		 * @param encuestas : consultas seleccionadas en la lista de resultados
		 * @return Entero con el resultado de la operacin
		 * @throws Exception Cualquier excepcin 
		 *
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Required"
		 *
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public int fncEliminarEncuesta(V50bEncuestaBean encuestas) throws Exception {
			V50bClsTrazas.depura("V50bDudanetBean.fncEliminarEncuesta() ");
			try{  
				return V50bControladorFactory.getFachada().fncEliminarEncuesta(encuestas);
			} catch(Exception e) {
		    	throw new RemoteException("", e);
			}
		}
		
		/**
		 * 
		 * <p>Ttulo: fncCopiarEncuesta</p>
		 * <p>Descripcin: Copia una encuesta de la BD</p>
		 * <p>Copyright: Copyright (c) 08/01/2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author alata
		 * @version 1.0
		 * @param encuestas : consultas seleccionadas en la lista de resultados
		 * @return Long con el resultado de la operacin
		 * @throws Exception Cualquier excepcin 
		 *
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Required"
		 *
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public long fncCopiarEncuesta(V50bEncuestaBean encuestas) throws Exception {
			V50bClsTrazas.depura("V50bDudanetBean.fncCopiarEncuesta() ");
			try{  
				return V50bControladorFactory.getFachada().fncCopiarEncuesta(encuestas);
			} catch(Exception e) {
		    	throw new RemoteException("", e);
			}
		}
		
		 /**
		   * Realiza una consulta 
		   * @author brey
		   * @param encuestaBean V50bEncuestaBean: Objeto bean donde se contienen los datos
		   * @return List: lista resultado
		   * @throws Exception SE ELEVA LA EXCEPXION
		   *
		   * @ejb.interface-method view-type="remote"
		   * @ejb.transaction type="Supports"
		   *
		   * @weblogic.ejb.idempotent-methods
		   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		   */
		  public List fncBusqPreguntas(V50bEncuestaBean encuestaBean)throws Exception {
			  try{   
				  	return V50bControladorFactory.getFachada().fncBusqPreguntas(encuestaBean);
				  }
				  catch(Exception e)
				  {
				      throw new RemoteException("", e);
				  }
		  }  
  /**
	* <p>Ttulo: fncVerFicheroNotif</p>
	* <p>Descripcin: Obtiene el lob de la notificacin</p>
	* <p>Copyright: Copyright (c) 30/10/2008</p>
	* <p>Empresa: Eurohelp</p>
	* 
	* @author llaparra
	* @version 1.0
	* @param v50bCodigoNotif Cdigo de la notificacin
	* @return Devuelve el lob
	* @throws RemoteException Excepcin remota
	* @ejb.interface-method view-type="remote"
    * @ejb.transaction type="Supports"
    *
    * @weblogic.ejb.idempotent-methods
    * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	*/
	public V50bClsFichero fncVerFicheroNotif(String v50bCodigoNotif) throws RemoteException{
		V50bClsTrazas.depura("V50bDudanetBean.fncVerFicheroNotif() ");
		try{   
		  	return V50bControladorFactory.getFachada().fncVerFicheroNotif(v50bCodigoNotif);
		  }
		  catch(Exception e)
		  {
		      throw new RemoteException("", e);
		  }
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarPreguntas</p>
	 * <p>Descripcin: Modifica una encuesta</p>
	 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param encuestaBean V50bEncuestaBean
	 * @param listaPreguntas ArrayList
	 * @return List
	 * @throws RemoteException Excepcin remota
	 *
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Required"
	 *
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public List fncModificarPreguntas(V50bEncuestaBean encuestaBean, ArrayList listaPreguntas) throws RemoteException {
		V50bClsTrazas.depura("V50bDudanetBean.fncModificarPreguntas() ");
		try {  
			return V50bControladorFactory.getFachada().fncModificarPreguntas(encuestaBean, listaPreguntas);
		} catch(Exception e) {
		    throw new RemoteException("", e);
		}
	}
	
	/**
	   * <p>Ttulo: fncBusqRespuestas</p>
	   * <p>Descripcin: busca las respuestas de las preguntas</p>
	   * <p>Copyright: Copyright (c) Jan 12, 2009</p>
	   * <p>Empresa: Eurohelp</p>
	   * Realiza una consulta 
	   * @author alata
	   * @param encuestaBean V50bEncuestaBean: Objeto bean donde se contienen los datos
	   * @return List: lista resultado
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */  
	  public List fncBusqRespuestas(V50bEncuestaBean encuestaBean)throws Exception{
		  V50bClsTrazas.depura("V50bDudanetBean.fncBusqRespuestas() ");
		  try{   
			  	return V50bControladorFactory.getFachada().fncBusqRespuestas(encuestaBean);
			  }
			  catch(Exception e)
			  {
			      throw new RemoteException("", e);
			  }	  
	  } 
	  
	  /**
	   * <p>Ttulo: fncModificarRespuestas</p>
	   * Modifica una lista de respuestas dependiendo de su modo 
	   * @author alata
	   * @param listaRespuestas List: Objeto bean que contiene los datos
	   * @return int: int resultado
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */  
	  public int fncModificarRespuestas(ArrayList listaRespuestas) throws Exception {
		  try{   
			  	return V50bControladorFactory.getFachada().fncModificarRespuestas(listaRespuestas);
		  }
		  catch(Exception e)
		  {
		      throw new RemoteException("", e);
		  }
	  }
	  
	  /**
	   * Recupera un fichero
	   * @author brey
	   * @param respuestas String: Sentencia SQL a lanzar
	   * @return String: el resultado de la select (un campo). "" si es vaco.
	   * @throws Exception Se eleva la excepcion
	   *
	   * @ejb.interface-method view-type="remote"
	   * @ejb.transaction type="Supports"
	   *
	   * @weblogic.ejb.idempotent-methods
	   * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	   */
	  public int fncGuardarEncuestaResultados(V50bRespuestasBean respuestas) throws Exception {
		  try{   
			  return V50bControladorFactory.getFachada().fncGuardarEncuestaResultados(respuestas);
		  }
		  catch(Exception e)
		  {
			  throw new RemoteException("", e);
		  }
		  
	  }
	  
	  
 
  //ESTOS METODOS DEJADLOS AL FINAL!
  /**
   * 
   * @throws CreateException Se eleva la excepcion.
   * 
   * @ejb.create-method
   */
  public void ejbCreate() throws CreateException {}
  
  /**
   * @ejb.remove-method
   */
  public void ejbRemove() {}
  
  /**
   * @ejb.activate-method
   */
  public void ejbActivate() {}
  
  /**
   * @ejb.passivate-method
   */
  public void ejbPassivate() {}
  
  
  /**
   * 
   * @param sessionContext SessionContext
   */
  public void setSessionContext(SessionContext sessionContext) {
    this.sessionContext = sessionContext;
  }

  /**
   * 
   * @return SessionContext
   */
  public SessionContext getSessionContext() {
		return this.sessionContext;
  }

}