/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientSSL;
import HTTPClient.Log;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.jwallet.JWalletCertificate;
import oracle.security.jwallet.JWalletPersona;
import oracle.security.jwallet.JWalletPvtKey;
import oracle.security.jwallet.txtwallet.TxtWalletReader;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLSocketFactory;
import oracle.security.ssl.OracleSSLSocketFactoryImpl;

class OracleSSL
implements HTTPClientSSL {
    private static boolean inOneTwo = false;
    private OracleSSLCredential m_sslCredObj;
    private boolean m_isDefaultCredential = true;
    private OracleSSLSocketFactory m_sslSocketFactory = null;
    private SSLSocket m_sslSock = null;
    private String[] m_sslEnabledCipherSuites = null;
    protected boolean m_assumeOracleSSL = true;
    private static String sm_sCachedLocation;
    private static long sm_lLastModifiedDate;
    private static TxtWalletReader sm_WalletReader;

    OracleSSLCredential getCredential() {
        if (this.m_sslCredObj == null) {
            this.m_sslCredObj = new OracleSSLCredential();
        }
        return this.m_sslCredObj;
    }

    OracleSSL(SSLSocketFactory factory) {
        this.initHttps((OracleSSLSocketFactory)factory);
    }

    void initHttps(OracleSSLSocketFactory factory) {
        this.m_sslSocketFactory = factory == null ? new OracleSSLSocketFactoryImpl() : factory;
        this.m_sslEnabledCipherSuites = this.getSSLDefaultCipherSuites(this.m_sslSocketFactory);
    }

    private String[] getSSLDefaultCipherSuites(OracleSSLSocketFactory fac) {
        String ciphers = System.getProperty("Oracle.ssl.defaultCipherSuites", "");
        if (ciphers.equals("")) {
            return this.m_sslSocketFactory.getSupportedCipherSuites();
        }
        StreamTokenizer strTok = new StreamTokenizer(new StringReader(ciphers));
        strTok.wordChars(95, 95);
        String[] supportedCiphers = this.m_sslSocketFactory.getDefaultCipherSuites();
        Vector<String> defaultCipherSuitesV = new Vector<String>();
        try {
            while (strTok.nextToken() != -1) {
                if (strTok.ttype != -3) continue;
                String suite = strTok.sval;
                for (int j = 0; j < supportedCiphers.length; ++j) {
                    if (!suite.equals(supportedCiphers[j])) continue;
                    defaultCipherSuitesV.addElement(suite);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        String[] defaultCipherSuitesA = new String[defaultCipherSuitesV.size()];
        defaultCipherSuitesV.toArray(defaultCipherSuitesA);
        return defaultCipherSuitesA;
    }

    public String[] getSSLEnabledCipherSuites() {
        return (String[])this.m_sslEnabledCipherSuites.clone();
    }

    public SSLSession getSSLSession() {
        if (this.m_sslSock != null) {
            return this.m_sslSock.getSession();
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.m_sslSocketFactory;
    }

    void initDefaultSSLCredential() {
        String loc = System.getProperty("javax.net.ssl.KeyStore", "");
        Log.write(1, "Using wallet '" + loc + "'");
        String pass = System.getProperty("javax.net.ssl.KeyStorePassword", "");
        long lLastModified = new File(loc).lastModified();
        if (loc.equals("")) {
            sm_sCachedLocation = null;
            sm_lLastModifiedDate = 0L;
            sm_WalletReader = null;
            return;
        }
        if (!loc.equals(sm_sCachedLocation) || sm_lLastModifiedDate != lLastModified) {
            sm_sCachedLocation = loc;
            sm_lLastModifiedDate = lLastModified;
            sm_WalletReader = new TxtWalletReader(loc, pass);
        }
        OracleSSLCredential cred = this.getCredential();
        JWalletPersona personaObj = sm_WalletReader.getPersonaByIndex(0);
        int tpCount = personaObj.getTrustedCertCount();
        JWalletCertificate tpcert = null;
        for (int i = 0; i < tpCount; ++i) {
            tpcert = personaObj.getTrustedCertByIndex(i);
            cred.addTrustedCert(tpcert.getCertData());
        }
        JWalletPvtKey pKeyObj = personaObj.getPrivateKey();
        if (pKeyObj != null) {
            byte[] pvkey = pKeyObj.getPvtKeyData();
            if (pvkey != null) {
                cred.setPrivateKey(pKeyObj.getPvtKeyData(), pass);
            }
            int certCount = personaObj.getCertChainCount();
            JWalletCertificate usrcert = null;
            for (int i = certCount; i > 0; --i) {
                usrcert = personaObj.getCertChainByIndex(i - 1);
                cred.addCertChain(usrcert.getCertData());
            }
        }
    }

    Socket getSSLSocket(Socket proxy) throws IOException {
        if (this.m_isDefaultCredential) {
            this.initDefaultSSLCredential();
        }
        this.m_sslSocketFactory.setSSLCredentials(this.getCredential());
        this.m_sslSock = (SSLSocket)this.m_sslSocketFactory.createSocket(proxy);
        this.m_sslSock.setEnabledCipherSuites(this.m_sslEnabledCipherSuites);
        this.m_sslSock.startHandshake();
        return this.m_sslSock;
    }

    public Socket getSSLSocket(Socket proxy, String host, int port) throws IOException {
        return this.getSSLSocket(proxy);
    }

    public void setSSLCredential(OracleSSLCredential sslCredential) {
        this.m_sslCredObj = sslCredential;
        this.m_isDefaultCredential = false;
    }

    public void setSSLEnabledCipherSuites(String[] cipherSuites) throws IllegalArgumentException {
        if (this.m_sslSocketFactory != null) {
            String[] supportedCiphers = this.m_sslSocketFactory.getSupportedCipherSuites();
            for (int i = 0; i < cipherSuites.length; ++i) {
                boolean isSupported = false;
                for (int j = 0; j < supportedCiphers.length && !isSupported; ++j) {
                    if (!cipherSuites[i].equals(supportedCiphers[j])) continue;
                    isSupported = true;
                }
                if (isSupported) continue;
                throw new IllegalArgumentException("Cipher " + cipherSuites[i] + " is not supported ");
            }
            this.m_sslEnabledCipherSuites = (String[])cipherSuites.clone();
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("SSLSocketFactoryImplClass", "oracle.security.ssl.OracleSSLSocketFactoryImpl");
                    return null;
                }
            });
            inOneTwo = true;
        }
        catch (NoClassDefFoundError e) {
            System.setProperty("SSLSocketFactoryImplClass", "oracle.security.ssl.OracleSSLSocketFactoryImpl");
            inOneTwo = false;
        }
        sm_sCachedLocation = null;
        sm_lLastModifiedDate = 0L;
        sm_WalletReader = null;
    }
}

