/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.Log;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Date;

public class Cookie
implements Serializable {
    private static final long serialVersionUID = 8599975325569296615L;
    protected String name;
    protected String value;
    protected Date expires;
    protected String domain;
    protected String path;
    protected boolean secure;

    public Cookie(String name, String value, String domain, String path, Date expires, boolean secure) {
        if (name == null) {
            throw new NullPointerException("missing name");
        }
        if (value == null) {
            throw new NullPointerException("missing value");
        }
        if (domain == null) {
            throw new NullPointerException("missing domain");
        }
        if (path == null) {
            throw new NullPointerException("missing path");
        }
        this.name = name;
        this.value = value;
        this.domain = domain.toLowerCase();
        this.path = path;
        this.expires = expires;
        this.secure = secure;
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
    }

    protected Cookie(RoRequest req) {
        this.name = null;
        this.value = null;
        this.expires = null;
        this.domain = req.getConnection().getHost();
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.path = Util.getPath(req.getRequestURI());
        int slash = this.path.lastIndexOf(47);
        if (slash >= 0) {
            this.path = this.path.substring(0, slash);
        }
        this.secure = false;
    }

    protected static Cookie[] parse(String set_cookie, RoRequest req) throws ProtocolException {
        int beg = 0;
        int end = 0;
        int start = 0;
        char[] buf = set_cookie.toCharArray();
        int len = buf.length;
        Cookie[] cookie_arr = new Cookie[]{};
        while ((beg = Util.skipSpace(buf, beg)) < len) {
            int eq;
            if (buf[beg] == ',') {
                ++beg;
                continue;
            }
            Cookie curr = new Cookie(req);
            start = beg;
            end = set_cookie.indexOf(61, beg);
            if (end == -1) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
            }
            curr.name = set_cookie.substring(beg, end).trim();
            beg = Util.skipSpace(buf, end + 1);
            int comma = set_cookie.indexOf(44, beg);
            int semic = set_cookie.indexOf(59, beg);
            end = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : (comma > semic ? semic : ((eq = set_cookie.indexOf(61, comma)) > 0 && eq < semic ? set_cookie.lastIndexOf(44, eq) : semic))));
            curr.value = set_cookie.substring(beg, end).trim();
            beg = end;
            boolean legal = true;
            while (beg < len && buf[beg] != ',') {
                String name;
                String fieldValue;
                int equalsAt = set_cookie.indexOf("=", beg + 1);
                int semiColonAt = set_cookie.indexOf(";", beg + 1);
                if (semiColonAt == -1) {
                    semiColonAt = len;
                }
                if ((fieldValue = set_cookie.substring(equalsAt + 1, semiColonAt).trim()).equals("")) {
                    beg = semiColonAt;
                    continue;
                }
                if (buf[beg] == ';') {
                    beg = Util.skipSpace(buf, beg + 1);
                    continue;
                }
                if (beg + 6 <= len && set_cookie.regionMatches(true, beg, "secure", 0, 6)) {
                    curr.secure = true;
                    beg += 6;
                    if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == '=') {
                        beg = Util.skipSpace(buf, beg + 1);
                    }
                    if (beg < len && buf[beg] == ';') {
                        beg = Util.skipSpace(buf, beg + 1);
                        continue;
                    }
                    if (beg >= len || buf[beg] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nExpected " + "';' or ',' at position " + beg);
                }
                end = set_cookie.indexOf(61, beg);
                if (end == -1) {
                    Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
                    end = Cookie.findEndPosition(set_cookie, beg, len);
                    name = set_cookie.substring(beg, end).trim();
                } else {
                    name = set_cookie.substring(beg, end).trim();
                    beg = Util.skipSpace(buf, end + 1);
                    if (name.equalsIgnoreCase("expires")) {
                        int pos;
                        if (set_cookie.charAt(beg) == '\"') {
                            beg = Util.skipSpace(buf, beg + 1);
                        }
                        for (pos = beg; pos < len && (buf[pos] >= 'a' && buf[pos] <= 'z' || buf[pos] >= 'A' && buf[pos] <= 'Z'); ++pos) {
                        }
                        if ((pos = Util.skipSpace(buf, pos)) < len && buf[pos] == ',' && pos > beg) {
                            beg = pos + 1;
                        }
                    }
                }
                end = Cookie.findEndPosition(set_cookie, beg, len);
                String value = set_cookie.substring(beg, end).trim();
                legal &= Cookie.setAttribute(curr, name, value, set_cookie);
                beg = end;
                if (beg >= len || buf[beg] != ';') continue;
                beg = Util.skipSpace(buf, beg + 1);
            }
            if (legal) {
                cookie_arr = Util.resizeArray(cookie_arr, cookie_arr.length + 1);
                cookie_arr[cookie_arr.length - 1] = curr;
                continue;
            }
            Log.write(16, "Cooki: Ignoring cookie: " + curr);
        }
        return cookie_arr;
    }

    private static int findEndPosition(String set_cookie, int beg, int len) {
        int comma = set_cookie.indexOf(44, beg);
        int semic = set_cookie.indexOf(59, beg);
        int end = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : Math.min(comma, semic)));
        return end;
    }

    private static boolean setAttribute(Cookie cookie, String name, String value, String set_cookie) throws ProtocolException {
        if (name.equalsIgnoreCase("expires")) {
            if (value.length() > 1 && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(0, value.length() - 1).trim();
            }
            try {
                cookie.expires = new Date(value);
            }
            catch (IllegalArgumentException iae) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Invalid date `" + value + "'");
            }
        } else if (name.equalsIgnoreCase("max-age")) {
            int age;
            if (cookie.expires != null) {
                return true;
            }
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1).trim();
            }
            try {
                age = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nMax-Age '" + value + "' not a number");
            }
            cookie.expires = new Date(System.currentTimeMillis() + (long)age * 1000L);
        } else if (name.equalsIgnoreCase("domain")) {
            int vl;
            int dl;
            if (value.length() == 0) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       domain is empty - ignoring domain");
                return true;
            }
            if ((value = value.toLowerCase()).length() != 0 && value.charAt(0) != '.' && !value.equals(cookie.domain)) {
                value = '.' + value;
            }
            if (!cookie.domain.endsWith(value)) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Current domain " + cookie.domain + " does not match given parsed " + value);
                return false;
            }
            if (!value.equals(".local") && value.indexOf(46, 1) == -1) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Domain attribute " + value + "isn't .local and doesn't have at " + "least 2 dots");
                return false;
            }
            String top = null;
            if (value.length() > 3) {
                top = value.substring(value.length() - 4);
            }
            if (!(top != null && (top.equalsIgnoreCase(".com") || top.equalsIgnoreCase(".edu") || top.equalsIgnoreCase(".net") || top.equalsIgnoreCase(".org") || top.equalsIgnoreCase(".gov") || top.equalsIgnoreCase(".mil") || top.equalsIgnoreCase(".int")) || (dl = cookie.domain.length()) <= (vl = value.length()) || cookie.domain.substring(0, dl - vl).indexOf(46) == -1)) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Domain attribute " + value + "is more than one level below " + "current domain " + cookie.domain);
                return false;
            }
            cookie.domain = value;
        } else if (name.equalsIgnoreCase("path")) {
            cookie.path = value;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Date expires() {
        return this.expires;
    }

    public boolean discard() {
        return this.expires == null || this.expires.before(new Date());
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean hasExpired() {
        return this.expires != null && this.expires.getTime() <= System.currentTimeMillis();
    }

    protected boolean sendWith(RoRequest req) {
        HTTPConnection con = req.getConnection();
        String eff_host = con.getHost();
        if (eff_host.indexOf(46) == -1) {
            eff_host = eff_host + ".local";
        }
        return (this.domain.charAt(0) == '.' && eff_host.endsWith(this.domain) || this.domain.charAt(0) != '.' && eff_host.equals(this.domain)) && Util.getPath(req.getRequestURI()).startsWith(this.path) && (!this.secure || con.getProtocol().equals("https") || con.getProtocol().equals("shttp"));
    }

    public int hashCode() {
        return this.name.hashCode() + this.path.hashCode() + this.domain.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            return this.name.equals(other.name) && this.path.equals(other.path) && this.domain.equals(other.domain);
        }
        return false;
    }

    protected String toExternalForm() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.name.length() + this.value.length() + 30);
        res.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            res.append("; expires=").append(this.expires);
        }
        if (this.path != null) {
            res.append("; path=").append(this.path);
        }
        if (this.domain != null) {
            res.append("; domain=").append(this.domain);
        }
        if (this.secure) {
            res.append("; secure");
        }
        return res.toString();
    }
}

