$.validator.addMethod('validarNumerodecimal', function(value, element, params) {
		var blnRetorno = true;
		if(''=== value){
			blnRetorno = true;
		}else{
		    var valorSinFormato = eliminarFormatoNumero(value)
		    if ($.isNumeric(valorSinFormato)) {
		   
			    blnRetorno = this.optional(element) || /^((\d+(\\.\d{0,2})?)|((\d*(\.\d{1,2}))))$/.test(Math.abs(valorSinFormato));
			    
			    if (blnRetorno && ((valorSinFormato.split(".")[0].length) > params[0])){
			    	blnRetorno = false;
			    }
		    }
		    else{
		    	blnRetorno = false;
		    }
		}
	    return blnRetorno;
	},jQuery.validator.format( $.rup.i18n.app.mensajes.error.numero_decimal_incorrecto));

function validarNumerodecimalPorValor(value,params) {
	var blnRetorno = true;
	if(''=== value){
		blnRetorno = true;
	}else{
	    var valorSinFormato = eliminarFormatoNumero(value)
	    if ($.isNumeric(valorSinFormato)) {
		    blnRetorno = /^((\d+(\\.\d{0,2})?)|((\d*(\.\d{1,2}))))$/.test(Math.abs(valorSinFormato));
		    
		    if (blnRetorno && ((valorSinFormato.split(".")[0].length) > params[0])){
		    	blnRetorno = false;
		    }
	    }
	    else{
	    	blnRetorno = false;
	    }
	}
    return blnRetorno;
}



function formatearNumero(objeto){
	var valor = numeroFormater(objeto.value.toString());
	$("input[name='"+ (objeto.name.substring(0, (objeto.name.length-4))) +"']").val(eliminarFormatoNumero(valor));
	$("input[name='"+ objeto.name +"']").val(valor);
}

function formatearNumeroImporteAdmitido(objeto){
	var valor = numeroFormater(objeto);
	$("input[name='importeAdmitido']").val(eliminarFormatoNumero(valor));
}

function eliminarFormatoNumero(value){
	if (null != value) {
		value = value.toString().replace(/\./g,''); 
		value = value.toString().replace(/\,/g,'.');
		if (!isNaN(value)) {
			return value;
		}
	}
	return "";
}

$.validator.addMethod('validarPorcentaje', function(value) {
    var blnRetorno = true;
    
    var valorSinFormato = eliminarFormatoNumero(value);
    
    if ((parseFloat(valorSinFormato)<0) || parseFloat(valorSinFormato)>(100.00) )
    	blnRetorno = false;
    
    return blnRetorno;
}, jQuery.validator.format($.rup.i18n.app.mensajes.error.porcentaje_incorrecto));

function validarPorcentajePorValor(value){
    var blnRetorno = true;
    
    var valorSinFormato = eliminarFormatoNumero(value);
    
    if ((parseFloat(valorSinFormato)<0) || parseFloat(valorSinFormato)>(100.00) )
    	blnRetorno = false;
    
    return blnRetorno;
}

//Bloquear inspeccion

function bloquearDenuncia() {
	
	$(".bloquearPorExpedienteCerrado").each(function() {
		var id = $(this).attr("id");
        
		/**
		 * Comprobaremos si el elemento es un rup_combo para ponerlo disable
		 * 
		 * Si no es un rup_combo comprobaremos que si es el boton (la varita magica)
		 * 
		 * Si no es ni combo ni boton de la varita es un input, por lo que lo pondremos a readonly
		 */
    	if($("#"+id).hasClass("rup_combo")){	
    		$("#"+id).rup_combo("disable");
    	}else if($("#"+id).hasClass("btn")){	
    		$("#"+id).addClass("disabled");
    	}else if($("#"+id).hasClass("changeControl")){	
    		$("#"+id).addClass("disabled");
    	}else{
    		$("#"+id).prop("readOnly", "readOnly");
    	} 	
	});
	
}

//Left Pad
function pad (str, max) {
	if(str === undefined){
		str = 0
	}else{
	    str = str.toString();
	} 
	    return str.length < max ? pad("0" + str, max) : str;
	
}

//funcion de formato de ("###,###.##") a la columna de ADMITIDO
function numeroFormater(cellvalue) {
	if((null!=cellvalue && ''!=cellvalue && ""!=cellvalue) || 0 ===cellvalue){	
		//pueden venir valores que no son strings, los casteamos
		var cellvalue = ""+ cellvalue;
		var existeComa = cellvalue.indexOf(",");
		//si no existe coma es posible que el usuario use el . como separador de decimales
		if (existeComa == -1) {
			cellvalue = cellvalue.toString().replace(/\./g,',');
		}else{
			cellvalue = cellvalue.toString().replace(/\./g,'');
		}
		cellvalue = cellvalue.toString().replace(/\,/g,'.');
		cellvalue = parseFloat(cellvalue).toFixed(2);
		var resultado = new Intl.NumberFormat('es-ES').format(cellvalue);
		// como el resultado siempre tiene que tener decimales, en caso de no tenerlos en este punto
		// ponemos ,00
		if (resultado.indexOf(",") == -1) {
			resultado += ",00";
		}
		return resultado;
	}else{
		return '';
	}
}
//Validar si es numero positivo de 4 digitos
$.validator.addMethod('isPositiveNumber', function(value) {
	return ($.isNumeric(value) && value >999) ? true:false;
},$.rup.i18n.app.mensajes.error.numero_positivo_incorrecto);


function validateDNI(dni) {
	var lockup = 'TRWAGMYFPDXBNJZSQVHLCKE';
	var valueDni = dni.substr(0, dni.length - 1);
	var letra = dni.substr(dni.length - 1, 1).toUpperCase();

	if (lockup.charAt(valueDni % 23) == letra){
		return true;
	}
	return false;
}

function validatePASAPORTE(pasaporte) {
	return /^[a-z]{3}[0-9]{6}[a-z]?$/i.test(pasaporte);
}

function validateCIF(cif) {
	cif = cif.toUpperCase();
	if (!cif || cif.length !== 9) {
		return false;
	}
	var letters = [ 'J', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I' ];
	var digits = cif.substr(1, cif.length - 2);
	var letter = cif.substr(0, 1);
	var control = cif.substr(cif.length - 1);
	var sum = 0;
	var i;
	var digit;

	if (!letter.match(/[A-Z]/)) {
		return false;
	}
	for (i = 0; i < digits.length; ++i) {
		digit = parseInt(digits[i]);

		if (isNaN(digit)) {
			return false;
		}

		if (i % 2 === 0) {
			digit *= 2;
			if (digit > 9) {
				digit = parseInt(digit / 10) + (digit % 10);
			}
			sum += digit;
		} else {
			sum += digit;
		}
	}
	sum %= 10;
	if (sum !== 0) {
		digit = 10 - sum;
	} else {
		digit = sum;
	}

	if (letter.match(/[ABEH]/)) {
		return String(digit) === control;
	}
	if (letter.match(/[NPQRSW]/)) {
		return letters[digit] === control;
	}

	return String(digit) === control || letters[digit] === control;
}

function validateNIE(nie) {
	"use strict";
	nie = nie.toUpperCase();
	 // Basic format test
	 if ( !nie.match('((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)') ) {
	  return false;
	 }
	 // Test NIE
	 //T
	 if ( /^[T]{1}/.test( nie ) ) {
	  return ( nie[ 8 ] === /^[T]{1}[A-Z0-9]{8}$/.test( nie ) );
	 }
	 //XYZ
	 if ( /^[XYZ]{1}/.test(nie)) {
	  return (
		nie[8] === "TRWAGMYFPDXBNJZSQVHLCKE".charAt(
		  nie.replace( 'X', '0' )
	     .replace( 'Y', '1' )
	     .replace( 'Z', '2' )
	     .substring( 0, 8 ) % 23
	   )
	  );
	 }
}

function validarDNICIFNIEPASAPORTE(value,tipoDocumento) {
	if (null != value && value != "") {
		value = value.toUpperCase();
		// compruebo que tipo de documento es
		switch (tipoDocumento) {
		case "1":
			return validateDNI(value);
		case "2":
			return validateCIF(value);
		case "3":
			return validateNIE(value);
		case "4":
			return validatePASAPORTE(value);
		default:
			return true; // si no ha elegido el tipo
		}
	}
	return true;
}

//Recarga el combo con la url seleccionada, si se indica se resetea el valor
function reloadUrl($combo, url, reset) {
	if ($combo.length > 0) {
			if(reset){
					$combo.rup_combo("setRupValue", "");
				}
			$combo.data("settings").source = url;
			$combo.rup_combo("reload");
	}
};

function activarControlCambios(){

	$(":input").change(function(){
		$("#controlCambios").val(1);
	});
}
function accederMenuControCambios(controller){
	if (null !== $("#controlCambios").val() && "1" === $("#controlCambios").val()) {
		// hay cambios en la pantalla, deberiamos mostrar mensaje de que hay cambios
		$.rup_messages("msgConfirm", {
			title:  $.rup.i18n.app.mensajes.titulo,
			message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
			OKFunction: function(){
				$(".container #guardar").click();
				accederMenu(controller);
			},
			CANCELFunction: function(){
				accederMenu(controller);
			}
		});
	}else{
		// si no hay cambios, accedemos directamente al controller
		accederMenu(controller);
	}
}

function resetFormulario($form){
	var $self = this;
	// Se eliminan los estilos de errores de validacion
	if ($form.data("validator") !== undefined){
		//ocultar los errores, menos en el input pq tb desaparece
		$(".error:not(:input)").hide();
		// y despues quitamos los errores que queden
		$(".error").removeClass("error");
	}
	
	
	// Se realiza el reset de los campos ordinarios
	jQuery("input[type!='button'][type!='checkbox'][type!='radio'][type!='hidden'], textarea", $form).val(""); 
	// Para los check de rup_table con seleccion multiple
	$(".cbox").not("[disabled='disabled']", $form).removeAttr("checked");
	// Se realiza el reset de los rup_combo
	jQuery.each($("select.rup_combo",$form), function(index,elem){
			jQuery(elem).rup_combo("reset");
	});
	//Vaciar los autocompletes
	$("[ruptype='autocomplete']", $form).each(function (index, element) {
		$(element).val("");
	});
	
	$form.resetForm();
	
	return $self;
}

//Funcion que pinta el texto en el feedback por defecto (ERROR)
function pintarFeedbackError(textoError, feedbackError) {
	var mensajeError = textoError && textoError !== "" ? textoError : $.rup.i18n.app.mensajes.errorGenerico;
	// Mostrar feedback
	feedbackError.rup_feedback("set", mensajeError, "error");
};

function pintarFeedback  (texto, tipo, feedback) {
	var mensaje = texto && texto !== "" ? texto : $.rup.i18n.app.mensajes.errorGenerico;
	// Mostrar feedback
	feedback.rup_feedback("set", mensaje, tipo);
};

function validarTlfEspanya(tlf) {
	return /^(\+34|0034|34)?[6789]\d{8}$/.test(tlf);
}


function createDate(dateString){
	var partDate = dateString.split("-");
	
	return $.rup.lang === "es" ? new Date(partDate[2],partDate[1]-1,partDate[0]):new Date(partDate[2],partDate[0],partDate[1]-1);	
}

$.validator.addMethod("decimalPrecision6Scale2", decimalPrecision6Scale2, $.rup.i18n.app.validaciones.numDecimal);

function decimalPrecision6Scale2(value){
	
	if(typeof value !== "undefined" && value !== "" && value !== null){
		return /^((\d\.?\d{3})|(\d{1,3}))(\,\d{1,2})?$/.test(value);
	}else{
		return true;
	}	
}

$.validator.addMethod("decimalPrecision8Scale2", decimalPrecision8Scale2, $.rup.i18n.app.validaciones.numDecimal82);

function decimalPrecision8Scale2(value){
	
	if(typeof value !== "undefined" && value !== "" && value !== null){
		return /^((\d{1,8})|(\d{1,3}\.)(\d{3})|(\d{1,2}\.)(\d{3}\.)(\d{3}))(\,\d{1,2})?$/.test(value);
	}else{
		return true;
	}	
}

$.validator.addMethod("decimalPrecision10Scale2", decimalPrecision10Scale2, $.rup.i18n.app.validaciones.numDecimal82);
function decimalPrecision10Scale2(value){
	
	if(typeof value !== "undefined" && value !== "" && value !== null){
		return /^((\d{1,10})|(\d{1,3}\.)(\d{3})|(\d{1,3}\.)(\d{3}\.)(\d{3}))(\,\d{1,2})?$/.test(value);
	}else{
		return true;
	}	
}


function hasValueCombo(combo, value){
	
	var resultado = false;
	
	if(null != combo && combo[0].nodeName == 'SELECT'){
		
		$(combo.selector + ' option').each(function() {
			
		    if($(this).val() == value){
		    	
		    	resultado = true;
		    }
		});
	}
	
	return resultado;
}

function tlfValidator(value){
	if(typeof value !== "undefined" && value !== "" && value !== null){
			return validarTlfEspanya(value);
	}else{
		return true;
	}	
}
$.validator.addMethod("tlfValidator", tlfValidator, $.rup.i18n.app.validaciones.tlfIncorrecto);