jQuery(function($) {

	$(document).ready(function(){
		
		$("#btnNuevoTipoReclamacion").click(function(){
			$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", "");
			$("#tiposReclamacionaddButton_1").click();
		});
		
		$("#btnEditarTipoReclamacion").click(function(){
			$("#tiposReclamacioneditButton_1").click();
		});
		
		$("#tiposReclamacion").rup_datatable({
			
			primaryKey: "idTipoReclamacion",
			loadOnStartUp: false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			filter:{
		  		id:"tiposReclamacion_filter_form",
		  		filterToolbar:"tiposReclamacion_filter_toolbar",
		  		collapsableLayerId:"tiposReclamacion_filter_fieldset"
		 	},
		 	
		 	formEdit:{
	        	detailForm: "#tiposReclamacion_detail_div",
				fillDataMethod: "clientSide",
				
				validate:{
	    			rules:{
	    				"idTipoReclamacion":{required:true,digits:true},
	    				"descTipoEu":{required:true},
	    				"descTipoEs":{required:true}
	    			}
	    		}
	    	},
	    	select:{
	    	    
	    	},
	    	buttons:{
	    			
	    	},
		 	initComplete:function() {
		 		$(".dt-buttons").hide();
	    	},
	    	usePlugins: [
				 "formEdit",
				 "buttons",
				 "select"
				 ]
		     	
		});
		
		$("#btnEditarTipoReclamacion").attr("disabled", true);
		
		var tblTiposReclamacion = $("#tiposReclamacion").DataTable();
		var filaSeleccionada;
		
		$('#tiposReclamacion tbody').on( 'click', 'tr', function () {
			filaSeleccionada = tblTiposReclamacion.row(this).data();
			
			if($(this).hasClass('selected') ) {
				filaSeleccionada = "";
			}
			
			if(typeof filaSeleccionada !== "undefined" && filaSeleccionada !== "" && filaSeleccionada !== null){
				$("#btnEditarTipoReclamacion").removeAttr("disabled");
			}else{
				$("#btnEditarTipoReclamacion").attr("disabled", true);
			}
		});
		
		$('#tiposReclamacion tbody').on( 'dblclick', 'tr', function () {
			setTimeout(function(){ 
				if($("#modal_codProcedureId_filter_tableHidden").val() != 0){
					$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", $("#modal_codProcedureId_filter_tableHidden").val());

				}else{
					$("#modal_codProcedureId_filter_table").rup_combo("clear");					
				}
			}, 0);
		});
		
		$("#btnBusqTiposReclamacion").click(function() {
			
			if($("#tiposReclamacion_filter_form").valid()){
				
				$("#tiposReclamacion_filter_filterButton").click();
				$("#divTblTiposReclamacion").attr("hidden", false);
			}
			
			
		});
		
		$("#btnLimpiarBusqTiposReclamacion").click(function() {

			$("#codProcedureId_filter_table").rup_combo("setRupValue", "");
			$('#codProcedureId_filter_tableHidden').attr("value", "");
			$("#tiposReclamacion_filter_cleanButton").click();
			$("#divTblTiposReclamacion").attr("hidden", true);
			$("#tiposReclamacion_filter_form").rup_validate("resetForm");
			
		});
		
		
		
		
		//Solución temporal hasta que habiliten la funcionalidad blockPKeditForm
		$('#tiposReclamacion').on("tableEditFormAddEditBeforeShowForm",function(){
			
			
			var id = $("#modalIdTipoReclamacion").val();
			
			if(typeof id !== "undefined" && id !== "" && id !== null){
				
				$("#modalIdTipoReclamacion").attr("readonly", "true");
				
			}else{
				
				$("#modalIdTipoReclamacion").removeAttr("readonly");
			}
			
		});	
		
		$('#tiposReclamacion').on("tableEditFormAddEditAfterShowForm",function(){
			$(".ui-dialog-titlebar-close").hide();
		});
		
		$('#codProcedureId_filter_table')
		.rup_combo(
				{
					blank : "",
					source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
					sourceParam : {
						label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
								: "descripcionEu"),
						value : "idProcedimiento"
					},
					width: 500,
					select : function() {
						$('#codProcedureId_filter_tableHidden').val(
								$('#codProcedureId_filter_table').val());
					}
				});
		$('#modal_codProcedureId_filter_table')
		.rup_combo(
				{
					blank : "",
					source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
					sourceParam : {
						label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
								: "descripcionEu"),
						value : "idProcedimiento"
					},
					width: 500,
					select : function() {
						$('#modal_codProcedureId_filter_tableHidden').val(
								$('#modal_codProcedureId_filter_table').val());
					}
				});
	});	
	
	$(".dt-buttons").hide();
		
});