jQuery(function($) {

	$(document).ready(function(){
		
		$("#btnNuevoTipoVentas").click(function(){
            $("#modal_codProcedureId_filter_table").rup_combo("setRupValue", "");
			$("#tiposVentasaddButton_1").click();
		});
		
		$("#btnEditarTipoVentas").click(function(){
			$("#tiposVentaseditButton_1").click();
		});
		
		$("#tiposVentas").rup_datatable({
			
			primaryKey: "idTipoVenta",
			loadOnStartUp: false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			filter:{
		  		id:"tiposVentas_filter_form",
		  		filterToolbar:"tiposVentas_filter_toolbar",
		  		collapsableLayerId:"tiposVentas_filter_fieldset"
		 	},
		 	
		 	formEdit:{
	        	detailForm: "#tiposVentas_detail_div",
				fillDataMethod: "clientSide",
				
				validate:{
	    			rules:{
	    				"idTipoVentas":{required:true,digits:true},
	    				"descTipoEu":{required:true},
	    				"descTipoEs":{required:true}
	    			}
	    		}
	    	},
	    	select:{
	    	    
	    	},
	    	buttons:{
	    			
	    	},
		 	initComplete:function() {
		 		$(".dt-buttons").hide();
	    	},
	    	usePlugins: [
				 "formEdit",
				 "buttons",
				 "select"
				 ]
		     	
		});
		
		$("#btnEditarTipoVentas").attr("disabled", true);
		
		var tblTiposVentas = $("#tiposVentas").DataTable();
		var filaSeleccionada;
		
		$('#tiposVentas tbody').on( 'click', 'tr', function () {
			filaSeleccionada = tblTiposVentas.row(this).data();
			
			if($(this).hasClass('selected') ) {
				filaSeleccionada = "";
			}
			
			if(typeof filaSeleccionada !== "undefined" && filaSeleccionada !== "" && filaSeleccionada !== null){
				
				$("#btnEditarTipoVentas").removeAttr("disabled");
			}else{
				$("#btnEditarTipoVentas").attr("disabled", true);
			}
		});
		
		$('#tiposVentas tbody').on( 'dblclick', 'tr', function () {
		    setTimeout(function(){ 
		    	if($("#modal_codProcedureId_filter_tableHidden").val() != 0){
					$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", $("#modal_codProcedureId_filter_tableHidden").val());

				}else{
					$("#modal_codProcedureId_filter_table").rup_combo("clear");					
				}
		    }, 0);
		});
		
		$("#btnBusqTiposVentas").click(function() {
			
			if($("#tiposVentas_filter_form").valid()){
				
				$("#tiposVentas_filter_filterButton").click();
				$("#divTblTiposVentas").attr("hidden", false);
			}
			
			
		});
		
		$("#btnLimpiarBusqTiposVentas").click(function() {
			
		    $("#codProcedureId_filter_table").rup_combo("setRupValue", "");
		    $('#codProcedureId_filter_tableHidden').attr("value", "");
			$("#tiposVentas_filter_cleanButton").click();
			$("#divTblTiposVentas").attr("hidden", true);
			$("#tiposVentas_filter_form").rup_validate("resetForm");
			
		});
		
		
		
		
		//Solución temporal hasta que habiliten la funcionalidad blockPKeditForm
		$('#tiposVentas').on("tableEditFormAddEditBeforeShowForm",function(){
			
			
			var id = $("#modalIdTipoVentas").val();
			
			if(typeof id !== "undefined" && id !== "" && id !== null){
				
				$("#modalIdTipoVentas").attr("readonly", "true");
				
			}else{
				
				$("#modalIdTipoVentas").removeAttr("readonly");
			}
			
		});	
		
		$('#tiposVentas').on("tableEditFormAddEditAfterShowForm",function(){
			$(".ui-dialog-titlebar-close").hide();
		});
		
		$('#codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#codProcedureId_filter_tableHidden').val(
		                        $('#codProcedureId_filter_table').val());
		            }
		});
		$('#modal_codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#modal_codProcedureId_filter_tableHidden').val(
		                        $('#modal_codProcedureId_filter_table').val());
		            }
		});
	});	
	
	$(".dt-buttons").hide();
		
});