jQuery(function($) {

	$(document).ready(function(){
		
		$("#btnNuevoProducto").click(function(){
            $("#modal_codProcedureId_filter_table").rup_combo("setRupValue", "");
			$("#productoaddButton_1").click();
		});
		
		$("#btnEditarProducto").click(function(){
			$("#productoeditButton_1").click();
		});
		
		$("#producto").rup_datatable({
			
			primaryKey: "idProducto",
			loadOnStartUp: false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			filter:{
		  		id:"producto_filter_form",
		  		filterToolbar:"producto_filter_toolbar",
		  		collapsableLayerId:"producto_filter_fieldset"
		 	},
		 	
		 	formEdit:{
	        	detailForm: "#producto_detail_div",
				fillDataMethod: "clientSide",
				
				validate:{
	    			rules:{
	    				"idProducto":{required:true,digits:true},
	    				"descTipoEu":{required:true},
	    				"descTipoEs":{required:true}
	    			}
	    		}
	    	},
	    	select:{
	    	    
	    	},
	    	buttons:{
	    			
	    	},
		 	initComplete:function() {
		 		$(".dt-buttons").hide();
	    	},
	    	usePlugins: [
				 "formEdit",
				 "buttons",
				 "select"
				 ]
		     	
		});
		
		$("#btnEditarProducto").attr("disabled", true);
		
		var tblProducto = $("#producto").DataTable();
		var filaSeleccionada;
		
		$('#producto tbody').on( 'click', 'tr', function () {
			filaSeleccionada = tblProducto.row(this).data();
			
			if($(this).hasClass('selected') ) {
				filaSeleccionada = "";
			}
			
			if(typeof filaSeleccionada !== "undefined" && filaSeleccionada !== "" && filaSeleccionada !== null){
				
				$("#btnEditarProducto").removeAttr("disabled");
			}else{
				$("#btnEditarProducto").attr("disabled", true);
			}
		});
		$('#producto tbody').on( 'dblclick', 'tr', function () {
		    setTimeout(function(){ 
		    	if($("#modal_codProcedureId_filter_tableHidden").val() != 0){
					$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", $("#modal_codProcedureId_filter_tableHidden").val());

				}else{
					$("#modal_codProcedureId_filter_table").rup_combo("clear");					
				}
		    }, 0);
		});
		
		$("#btnBusqProducto").click(function() {
			
			if($("#producto_filter_form").valid()){
				
				$("#producto_filter_filterButton").click();
				$("#divTblProducto").attr("hidden", false);
			}
			
			
		});
		
		$("#btnLimpiarBusqProducto").click(function() {
			
			$("#codProcedureId_filter_table").rup_combo("setRupValue", "");
		    $('#codProcedureId_filter_tableHidden').attr("value", "");
			$("#producto_filter_cleanButton").click();
			$("#divTblProducto").attr("hidden", true);
			$("#producto_filter_form").rup_validate("resetForm");
			
		});
		
		
		
		
		//Solución temporal hasta que habiliten la funcionalidad blockPKeditForm
		$('#producto').on("tableEditFormAddEditBeforeShowForm",function(){
			
			
			var id = $("#modalIdProducto").val();
			
			if(typeof id !== "undefined" && id !== "" && id !== null){
				
				$("#modalIdProducto").attr("readonly", "true");
				
			}else{
				
				$("#modalIdProducto").removeAttr("readonly");
			}
			
		});	
		
		$('#producto').on("tableEditFormAddEditAfterShowForm",function(){
			$(".ui-dialog-titlebar-close").hide();
		});
		$('#codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#codProcedureId_filter_tableHidden').val(
		                        $('#codProcedureId_filter_table').val());
		            }
		});
		$('#modal_codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#modal_codProcedureId_filter_tableHidden').val(
		                        $('#modal_codProcedureId_filter_table').val());
		            }
		});
	});	
	
	$(".dt-buttons").hide();
		
});