jQuery(function($) {

	$(document).ready(function(){
		
		setTextAreaAutoSize();
		$("textarea[data-autoresize!=null]").each(function(i,e){
			resizeTextarea(e);
		});
		
		$("#btnNuevoMotivo").click(function(){
            $("#modal_codProcedureId_filter_table").rup_combo("setRupValue", "");
			$("#motivoaddButton_1").click();
		});
		
		$("#btnEditarMotivo").click(function(){
			$("#motivoeditButton_1").click();
			$("textarea[data-autoresize!=null]").each(function(i,e){
				resizeTextarea(e);
			});
		});
		
		$("#motivo").rup_datatable({
			
			primaryKey: "idMotivo",
			loadOnStartUp: false,
			autoWidth : false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			filter:{
		  		id:"motivo_filter_form",
		  		filterToolbar:"motivo_filter_toolbar",
		  		collapsableLayerId:"motivo_filter_fieldset"
		 	},
		 	
		 	formEdit:{
	        	detailForm: "#motivo_detail_div",
				fillDataMethod: "clientSide",
				
				validate:{
	    			rules:{
	    				"idMotivo":{required:true,digits:true},
	    				"descTipoEu":{required:true},
	    				"descTipoEs":{required:true}
	    			}
	    		}
	    	},
	    	select:{
	    	    
	    	},
	    	buttons:{
	    			
	    	},
		 	initComplete:function() {
		 		$(".dt-buttons").hide();
	    	},
	    	usePlugins: [
				 "formEdit",
				 "buttons",
				 "select"
				 ] ,columnDefs:[
			    		{
			    			targets: [0],
			    			width: "2%"
			    		},			    		
			    		{
			    			targets: [1,2],
			    			width: "49%"
			    		}
			    	]
		     	
		});
		
		$("#btnEditarMotivo").attr("disabled", true);
		
		var tblMotivo = $("#motivo").DataTable();
		var filaSeleccionada;
		
		$('#motivo tbody').on( 'click', 'tr', function () {
			filaSeleccionada = tblMotivo.row(this).data();
			
			if($(this).hasClass('selected') ) {
				filaSeleccionada = "";
			}
			
			if(typeof filaSeleccionada !== "undefined" && filaSeleccionada !== "" && filaSeleccionada !== null){
				
				$("#btnEditarMotivo").removeAttr("disabled");
			}else{
				$("#btnEditarMotivo").attr("disabled", true);
			}
		});
		
		$('#motivo tbody').on( 'dblclick', 'tr', function () {
		    setTimeout(function(){ 
		    	if($("#modal_codProcedureId_filter_tableHidden").val() != 0){
					$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", $("#modal_codProcedureId_filter_tableHidden").val());

				}else{
					$("#modal_codProcedureId_filter_table").rup_combo("clear");					
				}
		    }, 0);
		});
		
		$("#btnBusqMotivo").click(function() {
			
			if($("#motivo_filter_form").valid()){
				
				$("#motivo_filter_filterButton").click();
				$("#divTblMotivo").attr("hidden", false);
			}
			
			
		});
		
		$("#btnLimpiarBusqMotivo").click(function() {
			
			$("#codProcedureId_filter_table").rup_combo("setRupValue", "");
		    $('#codProcedureId_filter_tableHidden').attr("value", "");
			$("#motivo_filter_cleanButton").click();
			$("#divTblMotivo").attr("hidden", true);
			$("#motivo_filter_form").rup_validate("resetForm");
			
		});
		
		
		
		
		//Solución temporal hasta que habiliten la funcionalidad blockPKeditForm
		$('#motivo').on("tableEditFormAddEditBeforeShowForm",function(){
			
			
			var id = $("#modalIdMotivo").val();
			
			if(typeof id !== "undefined" && id !== "" && id !== null){
				
				$("#modalIdMotivo").attr("readonly", "true");
				
			}else{
				
				$("#modalIdMotivo").removeAttr("readonly");
			}
			
		});	
		
		$('#motivo').on("tableEditFormAddEditAfterShowForm",function(){
			$(".ui-dialog-titlebar-close").hide();
		});
		
		$('#codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#codProcedureId_filter_tableHidden').val(
		                        $('#codProcedureId_filter_table').val());
		            }
		});
		$('#modal_codProcedureId_filter_table')
		.rup_combo(
		        {
		            blank : "",
		            source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
		            sourceParam : {
		                label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
		                        : "descripcionEu"),
		                value : "idProcedimiento"
		            },
		            width: 500,
		            select : function() {
		                $('#modal_codProcedureId_filter_tableHidden').val(
		                        $('#modal_codProcedureId_filter_table').val());
		            }
		});
	});	
	
	$(".dt-buttons").hide();
		
});