jQuery(function($) {

	$(document).ready(function(){
		
		$("#btnNuevoDecision").click(function(){
			$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", "");
			$("#decisionaddButton_1").click();
		});
		
		$("#btnEditarDecision").click(function(){
			$("#decisioneditButton_1").click();
		});
		
		$("#decision").rup_datatable({
			
			primaryKey: "idDecision",
			loadOnStartUp: false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			filter:{
		  		id:"decision_filter_form",
		  		filterToolbar:"decision_filter_toolbar",
		  		collapsableLayerId:"decision_filter_fieldset"
		 	},
		 	
		 	formEdit:{
	        	detailForm: "#decision_detail_div",
				fillDataMethod: "clientSide",
				
				validate:{
	    			rules:{
	    				"idDecision":{required:true,digits:true},
	    				"descTipoEu":{required:true},
	    				"descTipoEs":{required:true}
	    			}
	    		}
	    	},
	    	columns:[
	    		{ "data": "idDecision" },
	            { "data": "descTipoEs" },
	            { "data": "descTipoEu"},
	            { "data": "esNoFormal",
	                "render": function (data, type, row) {
	                	if(data === 1){
	                		return $.rup.i18n.app.tabla.Si
	                	}else{
	                		return $.rup.i18n.app.tabla.No
	                	} 
	                }
	              },
	    	],
	    	select:{
	    	    
	    	},
	    	buttons:{
	    			
	    	},
		 	initComplete:function() {
		 		$(".dt-buttons").hide();
	    	},
	    	usePlugins: [
				 "formEdit",
				 "buttons",
				 "select"
				 ]
		     	
		});
		
		$("#btnEditarDecision").attr("disabled", true);
		
		var tblDecision = $("#decision").DataTable();
		var filaSeleccionada;
		
		$('#decision tbody').on( 'click', 'tr', function () {
			filaSeleccionada = tblDecision.row(this).data();
			
			if($(this).hasClass('selected') ) {
				filaSeleccionada = "";
			}
			
			if(typeof filaSeleccionada !== "undefined" && filaSeleccionada !== "" && filaSeleccionada !== null){
				
				$("#btnEditarDecision").removeAttr("disabled");
			}else{
				$("#btnEditarDecision").attr("disabled", true);
			}
		});
		
		$('#decision tbody').on( 'dblclick', 'tr', function () {
			setTimeout(function(){ 
				if($("#modal_codProcedureId_filter_tableHidden").val() != 0){
					$("#modal_codProcedureId_filter_table").rup_combo("setRupValue", $("#modal_codProcedureId_filter_tableHidden").val());

				}else{
					$("#modal_codProcedureId_filter_table").rup_combo("clear");					
				}
			}, 0);
		});
		
		$("#btnBusqDecision").click(function() {
			
			if($("#decision_filter_form").valid()){
				
				$("#decision_filter_filterButton").click();
				$("#divTblDecision").attr("hidden", false);
			}
			
			
		});
		
		$("#btnLimpiarBusqDecision").click(function() {
			

			$("#codProcedureId_filter_table").rup_combo("setRupValue", "");
			$('#codProcedureId_filter_tableHidden').attr("value", "");
			$("#decision_filter_cleanButton").click();
			$("#divTblDecision").attr("hidden", true);
			$("#decision_filter_form").rup_validate("resetForm");
			
		});
		
		
		
		
		//Solución temporal hasta que habiliten la funcionalidad blockPKeditForm
		$('#decision').on("tableEditFormAddEditBeforeShowForm",function(){
			
			
			var id = $("#modalIdDecision").val();
			
			if(typeof id !== "undefined" && id !== "" && id !== null){
				
				$("#modalIdDecision").attr("readonly", "true");
				
			}else{
				
				$("#modalIdDecision").removeAttr("readonly");
			}
			
		});	
		
		$('#decision').on("tableEditFormAddEditAfterShowForm",function(){
			$(".ui-dialog-titlebar-close").hide();
		});
		

		$('#codProcedureId_filter_table')
		.rup_combo(
				{
					blank : "",
					source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
					sourceParam : {
						label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
								: "descripcionEu"),
						value : "idProcedimiento"
					},
					width: 500,
					select : function() {
						$('#codProcedureId_filter_tableHidden').val(
								$('#codProcedureId_filter_table').val());
					}
				});
		
		$('#modal_codProcedureId_filter_table')
		.rup_combo(
				{
					blank : "",
					source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro",
					sourceParam : {
						label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
								: "descripcionEu"),
						value : "idProcedimiento"
					},
					width: 500,
					select : function() {
						$('#modal_codProcedureId_filter_tableHidden').val(
								$('#modal_codProcedureId_filter_table').val());
					}
				});
	});	
	
	$(".dt-buttons").hide();
		
});