jQuery(document).ready(function(){	
	var  procedureId = $('#procedureId').val();
	var  folderId = $('#folderId').val();
	var parametroConfig = $('#parametroConfig').val();

	$('#btnGenerarDocumento').prop("disabled", true);
	$('#btnEditarDocumento').prop("disabled", true);
	$('#btnAportarDocumento').prop("disabled", true);
	$('#btnDescargarDocumento').prop("disabled", true);
	$('#btnEliminarDocumento').prop("disabled", true);
	
	var idProcedimiento=$('#idProcedimiento').val();
	var idExpediente =$('#idExpediente').val();
	var idiomaBusq = $("#comboIdiomaValue").val();
	
	var cargaIdioma = [{i18nCaption: "---", value:"-1"},
		{i18nCaption: $.rup.i18n.app.idioma.euskera, value:"0"},
		{i18nCaption: $.rup.i18n.app.idioma.castellano, value:"1"},
		{i18nCaption: $.rup.i18n.app.idioma.bilingue, value:"3"}]
	$("#comboIdioma").rup_combo({
		source: cargaIdioma,		
		onLoadSuccess: function() {
			cambiarIdioma = true;
			$("#comboIdioma").rup_combo("setRupValue", idiomaBusq);
		},
		change: function(){
			idiomaBusq = $("#comboIdioma").rup_combo("getRupValue");			
			var newUrl = "/ab78WebAppWar/plantillas/tabla/"+idProcedimiento +"/"+idExpediente + "/" + idiomaBusq;
			$("#PlantillaTabla").rup_table('setGridParam',{url:newUrl+"/filter"}).trigger("reloadGrid");
		}
	});
		
	$("#accordionPlantillas").rup_accordion({
		active: $("#cambiosAcordeon")[0] ? false : true, // Acordeon de cambios pendientes abierto
		collapsible: $("#cambiosAcordeon")[0] ? false : true, // Acordeon de cambios pendientes abierto
		autoHeight: false,
		beforeActivate: function(event, ui) {		
	    	var currHeader = null;
	        if (ui.newHeader[0]) { 
	        	// Abriendo la seccion
	        	currHeader = ui.newHeader;
	        } else { 
	        	//Cerrando la seccion
	            currHeader  = ui.oldHeader;
	        }
	        var currContent = currHeader.next('.ui-accordion-content');
	
	        var isPanelOpened = currHeader.attr('aria-selected') == 'true';
	
	         // Toggle cabecera
	        currHeader.toggleClass('ui-corner-all',isPanelOpened).toggleClass('ui-accordion-header-active ui-state-active ui-corner-top',!isPanelOpened).attr('aria-selected',((!isPanelOpened).toString()));
	
	        // Toggle icono triangulo/flechita
	        currHeader.children('.ui-icon').toggleClass('ui-icon-triangle-1-e',isPanelOpened).toggleClass('ui-icon-triangle-1-s',!isPanelOpened);
	
	         // Toggle contenido del panel
	        currContent.toggleClass('ui-accordion-content-active',!isPanelOpened)    
	        
	        // Acciones (plegar/desplegar) con animaciones
	        if (isPanelOpened) {
	        	currContent.slideUp(); 
	        }else { 
	        	currContent.slideDown(); 
	        }	        
	        // Cancelamos la funcionalidad por defecto
	        return false; 
	    }

	});
	$("#accordionPlantillas").rup_accordion("activate", 0);
	
	$("#PlantillaTabla").rup_table({
		url: "/ab78WebAppWar/plantillas/tabla/"+idProcedimiento +"/"+idExpediente + "/" + idiomaBusq,
		colNames: [
			"idPlantilla",
			$.rup.i18n.app.tablaPlantilla.descripcion,
			"",
			"tarea",
			"ruta",
			"codProcedureId"
		],
		colModel: [
			{ 	
				name: "idPlantilla", 
			 	label: "idPlantilla",
			 	hidden:true

			},
			{ 	
				name:(("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				label:(("eu"==$.rup_utils.get("language")) ? "descripcionEuskera": "descripcionCastellano"),
				align: "left",
				width: 750,
				classes: "celdaSinBorde"
			},
			{ 	
				name: "existeDoc", 
			 	label: "",
			 	align: "left", 
				width: 5,
				
			 	
			},
			{ 	
				name: "tiposPlantilla.taskId", 
			 	label: "tarea",
				hidden:true
				
			},
			{ 	
				name: "relExpPla.ruta", 
			 	label: "ruta",
				hidden:true
				
			},
			{ 	
				name: "procedimientos.codProcedureId", 
			 	label: "codProcedureId",
				hidden:true
				
			}
        ],
        rowNum:12,   
        width:800,
        model:"Plantillas",
		sortorder : "asc",
        usePlugins:[
        	"toolbar",
        	"responsive"
         	],
     	primaryKey: "idPlantilla",
        sortname: "eu"== $.rup_utils.get("language")  ? "descripcionEuskera": "descripcionCastellano",
        loadComplete : function (rowData){
        	var row_ids = jQuery("#PlantillaTabla").getDataIDs();
            jQuery.each(row_ids, function(i, row_id){
                if(0 != $("#PlantillaTabla").rup_table("getCol",row_id, "relExpPla.ruta") && 0 != parametroConfig)
                {
                	$("#PlantillaTabla").rup_table("setCell",row_id, "existeDoc",'<i class="fa fa-file-text" aria-hidden="true"></i>');

                }
            });
        },
        onSelectRow: function(id){ 
        	
    	  var dataRow = jQuery('#PlantillaTabla').jqGrid ('getRowData', id);
    	   var ruta = dataRow['relExpPla.ruta'];
    	   var tarea = dataRow['tiposPlantilla.taskId'];
    	
    	 switch(parametroConfig) {
	 		  case VALOR_DESCARGAR:
				     $('#btnGenerarDocumento').prop("disabled", true);
			         $('#btnEditarDocumento').prop("disabled", true);
			         $('#btnAportarDocumento').prop("disabled", true);
			         $('#btnDescargarDocumento').prop("disabled", false);
			         $('#btnEliminarDocumento').prop("disabled", true);
			        
	 		    break;
	 		  case VALOR_TRAMITAR_ONLINE:
			  
				  if( tarea == '' )
			      {
			         $('#btnGenerarDocumento').prop("disabled", true);
			         $('#btnEditarDocumento').prop("disabled", true);
			         $('#btnAportarDocumento').prop("disabled", true);
			         $('#btnEliminarDocumento').prop("disabled", true);
			         $('#btnDescargarDocumento').prop("disabled", false);
			      }
				  else if((tarea != '' && ruta == '')||(tarea != '' && ruta != '') ){
					  $('#btnGenerarDocumento').prop("disabled", true);
					  if (ruta != ''){
						  
						  if($("#esExpedienteCerrado").val() === "true"){
							  $('#btnAportarDocumento').prop("disabled", true);
							  $('#btnEditarDocumento').prop("disabled", true);
							  $('#btnEliminarDocumento').prop("disabled", true);	
					  	  } else {
					  		 $('#btnAportarDocumento').prop("disabled", false);
					  		 $('#btnEditarDocumento').prop("disabled", false);
							 $('#btnEliminarDocumento').prop("disabled", false);	 
					  	  }
					      $('#btnDescargarDocumento').prop("disabled", true);
	 			     }else{
	 			    	 if($("#esExpedienteCerrado").val() === "true"){
							  $('#btnGenerarDocumento').prop("disabled", true);
						  } else {
							  $('#btnGenerarDocumento').prop("disabled", false);
						  }	  
					      $('#btnEditarDocumento').prop("disabled", true);
					      $('#btnEliminarDocumento').prop("disabled", true);
					      $('#btnAportarDocumento').prop("disabled", true);
					      $('#btnDescargarDocumento').prop("disabled", true);
				  	}
				  }
				  
	 		    break;
	 		  case VALOR__DESCARGAR_Y_ONLINE:
 			  		$('#btnDescargarDocumento').prop("disabled", false);
 			  		if((tarea == '' && ruta == '')||(tarea != '' && ruta == '') ){
 			  			if($("#esExpedienteCerrado").val() === "true"){
		 					$('#btnGenerarDocumento').prop("disabled", true);
 			  			} else {
		 					$('#btnGenerarDocumento').prop("disabled", false);
 			  			}	  
 			  			$('#btnEditarDocumento').prop("disabled", true);
 			  			$('#btnAportarDocumento').prop("disabled", true);
 			  			$('#btnEliminarDocumento').prop("disabled", true);        
 			  		} else if(ruta != ''){
 			  			$('#btnGenerarDocumento').prop("disabled", true);
	 			  		 if($("#esExpedienteCerrado").val() === "true"){
		    				 $('#btnEditarDocumento').prop("disabled", true);
		    				 $('#btnEliminarDocumento').prop("disabled", true);
		 				 } else {
		 					 $('#btnEditarDocumento').prop("disabled", false);
		 					$('#btnEliminarDocumento').prop("disabled", false);
		 				 }	 
	 			  		 if (tarea != ''){
	 			  			 if($("#esExpedienteCerrado").val() === "true"){
								  $('#btnAportarDocumento').prop("disabled", true);
	 			  			 } else {
						  		 $('#btnAportarDocumento').prop("disabled", false);
	 			  			 }
	 			  		 }else{
 			  				$('#btnAportarDocumento').prop("disabled", true);
	 			  		 }
			       }
			    break;
	 		  default:
	 		    // code block
	 		}
	    	   
        }
     });	
	
	$("#btnGenerarDocumento").on("click", function () {
		
		var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
		var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
		var idPlantilla = rowData.idPlantilla;
		var idDenuncia = $("#idReclamacion").val()
		if(activeRowId !=null){
			bloquearInterfaz();
			$.ajax({
				url : "/ab78WebAppWar/plantillas/llamarWebService/generarDocumentoNegocio/"+ idDenuncia +"/" + idPlantilla +"/" + folderId,
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	desbloquearInterfaz();
		    		var data = JSON.parse(json);
			    	if(data)
			    	{			
			    		generarDocumento(data);
			    		$("#PlantillaTabla").rup_table("setCell",rowData.idPlantilla, "relExpPla.ruta",data);
			    		$("#PlantillaTabla").rup_table("setCell",rowData.idPlantilla, "existeDoc",'<i class="fa fa-file-text" aria-hidden="true"></i>');
			    		
			    	}else{
			    		$.rup_messages("msgAlert",{
			    			title:  $.rup.i18n.app.mensajes.alerta,
			    			message: $.rup.i18n.app.mensajes.avisos
			    			
			    		});
			    		
			    	}
			    	
			    },
			    error : function (respuesta){
			    	desbloquearInterfaz();
					$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#id_capaPlantilla").rup_feedback("set",respuesta.responseText, "error");
					
			    }
			});
		}
		else{
			desbloquearInterfaz();
			$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#id_capaPlantilla").rup_feedback("set", $.rup.i18n.app.msgAlert.selFila, "error");
		}

	});
	
	$("#btnEditarDocumento").on("click", function () {
	
		var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
		var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
		var idPlantilla = rowData["idPlantilla"];
		var idDenuncia = $("#idReclamacion").val()
		
		if(activeRowId !=null){
			bloquearInterfaz();
			$.ajax({	
				
				url : "/ab78WebAppWar/plantillas/llamarWebService/modificarDocumentoNegocio/"+ idPlantilla +"/" + idDenuncia +"/" + folderId,
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	desbloquearInterfaz();
			    	if(json.length>0){
			    		var data = JSON.parse(json);
				    		editarDocumento(data);
			    	}else{
			    		
			    		$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			    		$("#id_capaPlantilla").rup_feedback("set",$.rup.i18n.app.mensajes.avisoNoRuta, "error");
			    		if($("#esExpedienteCerrado").val() === "true"){
			    			$('#btnGenerarDocumento').prop("disabled", true);
			    		}else{
			    			$('#btnGenerarDocumento').prop("disabled", false);
			    		}	
			    		$('#btnEditarDocumento').prop("disabled", true);
			    		$('#btnEliminarDocumento').prop("disabled",true);
			    		$('#btnAportarDocumento').prop("disabled", true);
			    		$("#PlantillaTabla").rup_table("setCell",activeRowId, "existeDoc",'<i></i>');
			    		
			    	}
			    },
			    error: function (respuesta) {
			    	desbloquearInterfaz();
			    	$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#id_capaPlantilla").rup_feedback("set",respuesta.responseText, "error");
			    }
			});
		}
		else{
			desbloquearInterfaz();
			$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#id_capaPlantilla").rup_feedback("set", $.rup.i18n.app.msgAlert.selFila, "error");
		}
		
	});
				
	$("#btnAportarDocumento").on("click", function () {
		
		//bloquear modal hasta que carga los datos de platea y limpiar formulario			
		var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
		var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
		var idPlantilla = rowData.idPlantilla;
		
		if(activeRowId !=null){
			bloquearInterfaz();
			
			$.ajax({
					
					url : "/ab78WebAppWar/plantillas/aportarDocumentoNegocio/" + idPlantilla +"/" + procedureId +"/" + folderId ,
					contentType: "application/json",
				    type: "GET",
				    dataType: "json",
				    success: function (result){
				    	desbloquearInterfaz();
				    	$("#PlantillaTabla").rup_table("setCell",rowData.idPlantilla, "relExpPla.ruta",null);
				    	
				    	var xmlDoc = $.parseXML( result );
			    		var $xml = $( xmlDoc );
			    		var msgResult = ("eu"==$.rup_utils.get("language")) ? $xml.find( "descripcionEuskera" ).text(): $xml.find( "descripcionCastellano" ).text();
				    	$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#id_capaPlantilla").rup_feedback("set",msgResult, "ok");
						
						if($("#esExpedienteCerrado").val() === "true"){
			    			$('#btnGenerarDocumento').prop("disabled", true);
			    		}else{
			    			$('#btnGenerarDocumento').prop("disabled", false);
			    		}	
			    		$('#btnEditarDocumento').prop("disabled", true);
			    		 $('#btnEliminarDocumento').prop("disabled", true);
			    		$('#btnAportarDocumento').prop("disabled", true);
			    		$("#PlantillaTabla").rup_table("setCell",activeRowId, "existeDoc",'<i></i>');
				    },
					error : function (respuesta){
						desbloquearInterfaz();
						$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#id_capaPlantilla").rup_feedback("set",respuesta.responseText, "error");
						
					}				    
				});
		}
		else{
			desbloquearInterfaz();
			$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#id_capaPlantilla").rup_feedback("set", $.rup.i18n.app.msgAlert.selFila, "error");
		}
		
	});		
	
	
	$("#btnDescargarDocumento").on("click", function () {
		var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
		var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
		var idPlantilla = rowData.idPlantilla;
		var idDenuncia = $("#idReclamacion").val()

		if(activeRowId !=null){
	
			bloquearInterfaz();
			$.ajax({
				url : "/ab78WebAppWar/plantillas/llamarWebService/descargarDocumentoNegocio/" + idDenuncia +"/" + idPlantilla +"/" + folderId,
				contentType: "application/json",
			    type: "GET",
			    success: function (json) 
			    {
			    	desbloquearInterfaz();
		    		var data = JSON.parse(json);
			    	if(data)
			    	{			
			    		
			    		$("#rutaDocumento").val(data);
						$("#form_Documento").submit();
			    	}else{
			    		$.rup_messages("msgAlert",{
			    			title:  $.rup.i18n.app.mensajes.alerta,
			    			message: $.rup.i18n.app.mensajes.avisos
			    			
			    		});
			    		
			    	}
			    	
			    },
			    error : function (respuesta){
					desbloquearInterfaz();
					$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
					$("#id_capaPlantilla").rup_feedback("set",respuesta.responseText, "error");
					
				}		
			});
		}
		else{
			desbloquearInterfaz();
			$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#id_capaPlantilla").rup_feedback("set", $.rup.i18n.app.msgAlert.selFila, "error");
		}

	});
	
	$("#btnEliminarDocumento").on("click", function () {
		var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
	
		var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
		
		var idDenuncia = $("#idReclamacion").val()
		
		var idPlantilla = rowData.idPlantilla;
		if(activeRowId !=null){
			bloquearInterfaz();
			$.ajax({ 
				url : "/ab78WebAppWar/plantillas/llamarWebService/eliminarDocumentoNegocio/"+ idPlantilla +"/" + idDenuncia +"/" + folderId,
				contentType: "application/json",
			    type: "GET",
			    success: function (result){
				    	desbloquearInterfaz();
				    	if($("#esExpedienteCerrado").val() === "true"){
			    			$('#btnGenerarDocumento').prop("disabled", true);
			    		}else{
			    			$('#btnGenerarDocumento').prop("disabled", false);
			    		}	
			    		$('#btnEditarDocumento').prop("disabled", true);
			    		$('#btnEliminarDocumento').prop("disabled", true);
			    		$('#btnAportarDocumento').prop("disabled", true);
		
			    		$("#PlantillaTabla").rup_table("setRowData", activeRowId,{"relExpPla.ruta":""});
		    				
			    		$("#PlantillaTabla").rup_table("setCell",activeRowId, "existeDoc",'<i></i>');
			    		$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#id_capaPlantilla").rup_feedback("set",$.rup.i18n.app.mensajes.documentoEliminado, "ok");
				    },
					error : function (respuesta){
						desbloquearInterfaz();
						$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#id_capaPlantilla").rup_feedback("set",respuesta.responseText, "error");
						
					}				    
				});
		}
		else{
			desbloquearInterfaz();
			$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#id_capaPlantilla").rup_feedback("set", $.rup.i18n.app.msgAlert.selFila, "error");
		}
		
	});		
	
});

function generarDocumento(data){

	$('#btnGenerarDocumento').prop("disabled", true);
	if($("#esExpedienteCerrado").val() === "true"){
		$('#btnEditarDocumento').prop("disabled", true);	
	}else{
		$('#btnEditarDocumento').prop("disabled", false);	
	}	
	var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
	var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
	var taskId = rowData['tiposPlantilla.taskId'];
	if(taskId !=''){
		if($("#esExpedienteCerrado").val() === "true"){
			  $('#btnAportarDocumento').prop("disabled", true);
	  	  } else {
	  		 $('#btnAportarDocumento').prop("disabled", false);
	  	  }
	}else{
		$('#btnAportarDocumento').prop("disabled", true);
	}
	
	if($("#esExpedienteCerrado").val() === "true"){
		$('#btnEliminarDocumento').prop("disabled",true);	
	}else{
		$('#btnEliminarDocumento').prop("disabled",false);
	}	
	$("#id_capaPlantilla").rup_feedback({ gotoTop : true, block : false, closeLink : true });
	$("#id_capaPlantilla").rup_feedback("set",$.rup.i18n.app.mensajes.documentoGenerado, "ok");
	location.href = data;

}

function editarDocumento(data){

	$('#btnGenerarDocumento').prop("disabled", true);
	
	var activeRowId = $("#PlantillaTabla").rup_table("getGridParam", "selrow");
	var rowData = $("#PlantillaTabla").rup_table("getRowData",activeRowId);
	var taskId = rowData['tiposPlantilla.taskId'];
	if(taskId !=''){
		if($("#esExpedienteCerrado").val() === "true"){
			  $('#btnAportarDocumento').prop("disabled", true);
	  	  } else {
	  		 $('#btnAportarDocumento').prop("disabled", false);
	  	  }
	}else{
		$('#btnAportarDocumento').prop("disabled", true);
	}
	if($("#esExpedienteCerrado").val() === "true"){
		$('#btnEditarDocumento').prop("disabled", true);
		$('#btnEliminarDocumento').prop("disabled",true);
	}else{
		$('#btnEditarDocumento').prop("disabled", false);
		$('#btnEliminarDocumento').prop("disabled",false);
	}	
	location.href = data;
}

		
