jQuery(function($){
	if($("#bloquearPagina").val() === "false"){
		instanceInpecciones();
	}
});

function instanceInpecciones(){
	$("#modalInspeciones").rup_dialog({
		type: $.rup.dialog.DIV,
		title: $.rup.i18n.app.inspecciones.tituloInspecionar,
		width: 800,
		closeOnEscape: false,
		autoOpen: false,
		draggable: false,
		stack: false,
		modal:true,
		buttons:[
			{
				id: "btnSendInspecion",
				text: $.rup.i18n.app.botones.enviar,
				click: function() {
					confirmDialog(marcarInspeccion, $.rup.i18n.app.mensajes.confirmarOperacion);
				},
			}
		],
		close: function(){
			bloquearInterfaz();
			location.reload();
		}
	});
	
	$("#btnInspeccionar").click(function() {
		
		if($("#tipoDenuncia").val() == TIPO_DENUNCIA_NO_FORMAL && $("#nAfectados").val() > 0 && $("#numeroPartesInculpadas").val() != 1){
			$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.soloUnaParteInculpada, "alert");
		} else {
			if (controlCambios()) {
				// hay cambios en la pantalla, deberiamos mostrar mensaje de que hay cambios
				$.rup_messages("msgConfirm", {		
					title:  $.rup.i18n.app.mensajes.titulo,
					message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
					OKFunction: function(){
						$(".container #btnGuardar").click();
						$("#fechaLimite").rup_date("setRupValue", null);
						$("#observacionesInspecciones").val(null);
						$("#feedbackMensajesInspeciones").rup_feedback("close");
						$("#modalInspeciones").rup_dialog("open");
					},
					CANCELFunction: function(){
						$("#fechaLimite").rup_date("setRupValue", null);
						$("#observacionesInspecciones").val(null);
						$("#feedbackMensajesInspeciones").rup_feedback("close");
						$("#modalInspeciones").rup_dialog("open");
					}
				});
			}else{
				// si no hay cambios, accedemos directamente al controller
				$("#fechaLimite").rup_date("setRupValue", null);
				$("#observacionesInspecciones").val(null);
				$("#feedbackMensajesInspeciones").rup_feedback("close");
				$("#modalInspeciones").rup_dialog("open");
			}
		}		
	});
	
	$("#btnEliminarInspeccion").on("click", function() {
		if (controlCambios()) {
			$.rup_messages("msgConfirm", {		
				title:  $.rup.i18n.app.mensajes.titulo,
				message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
				OKFunction: function(){
					$(document).bind('denunciaActualizada', function(e) {
						eliminarInspeccion();
						$(document).unbind('denunciaActualizada');
					});
					$(".container #btnGuardar").click();
				},
				CANCELFunction: function(){
					$(document).unbind('denunciaActualizada');
					changesValue(false);
					eliminarInspeccion();
				}
			});
		}else{
			eliminarInspeccion();
		}
	});
	
	$("#fechaLimite").rup_date({
	});
	
	$("#feedbackMensajesInspeciones").rup_feedback({
		closeLink : true,
		block : false,
		gotoTop : false
	});
}

$("#btnActualizar").on("click", function() {
		
		location.reload();
	
});

function eliminarInspeccion(){
	$.rup_messages("msgConfirm", {
		title:  $.rup.i18n.app.mensajes.titulo,
		message: $.rup.i18n.app.mensajes.confirmacionEliminar,
		OKFunction: function () {
			bloquearInterfaz();
			$.ajax({
				url: "/ab78WebAppWar/denuncias/ficha-denuncia/inspecciones/eliminarInspeccion/" + $("#idExpediente").val(),
				type: "POST",
				success:successRequestEliminarInspeccionar,
				error: function() {
					desbloquearInterfaz();
					$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
				}
			});
		},
		CANCELFunction: function () {
		}
	});	
}

function marcarInspeccion(){
	disableButton("#btnSendInspecion");
	var fechaLimite = $("#fechaLimite").val();
	var observaciones = $("#observacionesInspecciones").val();
	
	var url ='/ab78WebAppWar/denuncias/ficha-denuncia/inspecciones/{0}/'.replace("{0}",idExpediente);
	url += '{1}?'.replace("{1}", $("#tituloDenuncia").text());
	url +='o={2}'.replace("{2}", encodeURI(observaciones));
	if(fechaLimite != null&& fechaLimite!== ""){
		url += '&fechaLimite={3}'.replace("{3}", fechaLimite);
	};
	bloquearInterfaz();
	$.ajax({
		url: url,
		method: 'POST',
		success: successRequestInspeccionar,
		error: errorSendRequestInspeccionar
	});
}


function successRequestInspeccionar(response){
	desbloquearInterfaz();
	response = JSON.parse(response);
	var msg;
	if(response.result){
		
		$("#fechaLimite").rup_date("disable");
		$("#observacionesInspecciones").attr("disabled", true);
		
		var idInspeccion = response.data["idInspeccion"];
		var identInspeccion = response.data["identInspeccion"];

		var url = "/ab79WebAppWar/fichadeinspeccion/maint/" + idInspeccion;
		$("#idInspeccionExpediente").val(idInspeccion);
		$("#labelInspeccion").val(identInspeccion);
		msg = $.rup.i18n.app.mensajes.OK[response.message];
		msg = msg.replace("{0}", "<b><a class='alert-link linkPaginacion' href='{0}' target='_blank'>{1}</a></b>".replace("{0}", url).replace("{1}", identInspeccion));
		$("#feedbackMensajesInspeciones").rup_feedback("set", msg, "ok");
		executeCallback(response);
		changesValue(false);
	}else{
		msg = $.rup.i18n.app.mensajes.error[response.message];
		$("#feedbackMensajesInspeciones").rup_feedback("set", msg, "error");
		console.warn(response.error);
		enableButton("#btnSendInspecion");
	}
}

function successRequestEliminarInspeccionar(response){
	desbloquearInterfaz();
	response = JSON.parse(response);
	var msg;
	if(response.result){
		$("#labelInspeccion").val(null);
		$("#idInspeccionExpediente").val(null);
		msg = $.rup.i18n.app.mensajes.OK[response.message];
		$("#fichaDenunciaFeedback").rup_feedback("set", msg, "ok");
		changesValue(false);
		enableButton("#btnInspeccionar");
		enableButton("#btnSendInspecion");
		disableButton("#btnEnlaceIns");
		disableButton("#btnEliminarInspeccion");
	}else{
		msg = $.rup.i18n.app.mensajes.error[response.message];
		$("#fichaDenunciaFeedback").rup_feedback("set", msg, "error");
		console.warn(response.error);
		enableButton("#btnSendInspecion");
	}
}

function errorSendRequestInspeccionar(e, xhr, msgError){
	desbloquearInterfaz();
	enableButton("#btnSendInspecion");
	var msg = $.rup.i18n.app.msg.errorGenerico;
	$("#feedbackMensajesInspeciones").rup_feedback("set", msg, "error");
	console.warn(arguments);
}

function disableButtonsInspecSuccess(){
//	$("#searchIdentificadorContainer").addClass("d-none");
//	$("#searchIdentificador").attr("readonly", "readonly").attr("type", "text");
	enableButton("#btnGuardar");
	enableButton("#btnEnlaceIns");
	enableButton("#btnEliminarInspeccion");
	disableButton("#btnInspeccionar");
	//disabledFormControls();
	
}