jQuery(function($) {
	//Feedback modal
	
	if($("#idDireccion").val() == 1){
	
	$("#motivoDenuncia_detail_feedback").rup_feedback({
		type: "ok",
		gotoTop : true,
		block:false,
		closeLink: true,
		delay: 8000,
		fadeSpeed: 500
	});
	
	//Feedback modal
	$("#fichaDenunciaFeedback").rup_feedback({
		type: "ok",
		gotoTop : true,
		block:false,
		closeLink: true,
		delay: 8000,
		fadeSpeed: 500
	});
	
	//Formulario modal
	$("#motivoDenuncia_detail_div").rup_dialog({
		autoOpen: false,
		width: 800,
		modal: true,
		position: { my: "center center" },
		type: $.rup.dialog.DIV,
		open: function(event, ui) {
			$(".rup-feedback").hide();
			$("#idReclamacionModal").val($("#idReclamacion").val());
			$("textarea[data-autoresize!=null]").each(function(i,e){
				resizeTextarea(e);
			});
		}, close:function(){
			$('#motivoDenuncia_detail_form').rup_form("resetForm");
		}
	});
	
	//Cancelar
	$("#motivoDenuncia_detail_button_cancel").click(function(){
		$("#motivoDenuncia_detail_div").rup_dialog('close');
	});
	
	//Guardar
	$("#motivoDenuncia_detail_button_save").click(function(){
		if($("#motivoDenuncia_detail_form").valid()){
			bloquearInterfaz();
			$("#motivoDenuncia_detail_form").submit();
		}
	});
	
	
$("#motivoDenuncia").rup_datatable({
		
		primaryKey: "idMotivoInterno",
		loadOnStartUp: true,
		pagingType: "full_numbers",
		dom: 'rt<"bottom"lip>',
		autoWidth : false,
		pageLength : 5,
		lengthMenu: [5, 10, 25, 50],
		order: [[ 0, 'asc' ]],
		filter:{
	  		id:"motivoDenuncia_filter_form",
	  		filterToolbar:"motivoDenuncia_filter_toolbar",
	  		collapsableLayerId:"motivoDenuncia_filter_fieldset"
	 	},
    	select:{
    	    
    	},    	
    	buttons:{
    			
    	},
	 	initComplete:function() {
	 		$(".dt-buttons").hide();
    	},
    	usePlugins: [
			 "buttons",
			 "select"
			 ],
			 columnDefs:[
		    		{
		    			targets: [0],
		    			visible:false
		    		},
		    		{
		    			targets: [1],
		    			width: "50%",
		    			render: function(data, type, row, meta){
		    				if ($.rup.lang == "es"){
		    					return row.motivo.descMotivoEs
		    				}

		    				if ($.rup.lang == "eu"){
		    					return row.motivo.descMotivoEu
		    				}
		    			    } 
		    		},
		    		{
		    			targets: [2,3],
		    			visible:false
		    		},
		    		{
		    			targets: [4],
		    			width: "50%"
		    		}
		    	]
	     	
	});

var tablaMotivo = $('#motivoDenuncia').DataTable();
var filaSeleccionadaMotivo = null;

//Fila seleccionada
$('#motivoDenuncia tbody').on( 'click', 'tr', function () {
	filaSeleccionadaMotivo = tablaMotivo.row(this).data();
	if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
        filaSeleccionadaMotivo = "";
    }
    else {
    	tablaMotivo.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    }
});

$("#btnNuevoMotivoDenuncia").click(function(){
	
	if(typeof filaSeleccionadaMotivo !== "undefined" && filaSeleccionadaMotivo !== "" && filaSeleccionadaMotivo !== null){
		
		$.rup_messages("msgConfirm", {
			title: $.rup.i18n.base.rup_table.changes,
			message: $.rup.i18n.base.rup_table.checkSelectedElems,
			OKFunction:	function() {
				tablaMotivo 
			    .rows( '.selected' )
			    .nodes()
			    .to$() 
			    .removeClass( 'selected' );
				$("#motivoDenuncia_detail_div").rup_dialog("setOption", "title", $.rup.i18n.base.rup_table.edit.addCaption);
				$("#motivoDenuncia_detail_div").rup_dialog("open");
				filaSeleccionadaMotivo = "";						
			}
		});
		
	}else{
		$("#motivoDenuncia_detail_div").rup_dialog("setOption", "title", $.rup.i18n.base.rup_table.edit.addCaption);
		$("#motivoDenuncia_detail_div").rup_dialog("open");
	}

	$("#comboIndMotivoFilter").rup_combo("reload");
	
	$("#fichaDenunciaFeedback").rup_feedback("close");
	$("#motivoDenuncia_detail_form").rup_validate("resetForm");
	$("#motivoDenuncia_detail_feedback").rup_feedback("close");
	$("#idReclamacionModal").val($("#idReclamacion").val());	
	
});

//Editar
$("#btnEditarMotivoDenuncia").click(function(){
	
	if(typeof filaSeleccionadaMotivo !== "undefined" && filaSeleccionadaMotivo !== "" && filaSeleccionadaMotivo !== null){						
		bloquearInterfaz();
		recuperarMotivoDetalle(filaSeleccionadaMotivo);
		$("#motivoDenuncia_detail_feedback").rup_feedback("close");
		
	}else{
		$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
		$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error.lineaNoSeleccionada, "alert");
	}
	
});

//Eliminar
$("#btnEliminarMotivoDenuncia").click(function(){
	
	$(".rup-feedback").hide();
	if(typeof filaSeleccionadaMotivo !== "undefined" && filaSeleccionadaMotivo !== "" && filaSeleccionadaMotivo !== null){
		
		// Mensaje de confirmación
		$.rup_messages("msgConfirm", {
			title: $.rup.i18n.base.rup_table.del.caption,
			message: $.rup.i18n.base.rup_table.del.msg,
			OKFunction:	function() {
				bloquearInterfaz();
				$.ajax({
					url: "/ab78WebAppWar/relacionMotivoDen/" + + filaSeleccionadaMotivo.idMotivoInterno,
					contentType : 'application/json; charset=utf-8',
					dataType: "json",
					data: JSON.stringify(filaSeleccionadaMotivo),
					type: "DELETE",
					success: function(){
						$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.base.rup_table.deletedOK, "ok");
						desbloquearInterfaz();
						tablaMotivo.ajax.reload();
						filaSeleccionadaMotivo = "";
						setTimeout(function(){
						}, 600);
					},
					error: function(){
						desbloquearInterfaz();
						$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
						$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
						filaSeleccionadaMotivo = "";
					}
				});
			}
		});
		
	}else{
		$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true});
		$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error.lineaNoSeleccionada, "alert");
	}
	
});

$("#motivoDenuncia_detail_form").rup_form({
	feedback: $("#apartamentosEstudiosDetalle_detail_feedback"),
	url: "/ab78WebAppWar/relacionMotivoDen/",
	type: "POST",
	contentType: "application/json",
	dataType:"json",
	validate:{ 
		liveCheckingErrors : false,
		showFieldErrorAsDefault : true,
		showErrorsInFeedback : false,
		showFieldErrorsInFeedback : true,
		rules:{
			"motivo.idMotivo":{required:true},
			"descMotivo":{required:true}			
		}
   },
   beforeSubmit: function(){
   },
   success: function(){
	   setTextAreaAutoSize();
		$("textarea[data-autoresize!=null]").each(function(i,e){
			resizeTextarea(e);
		});
	   $("#motivoDenuncia_detail_div").rup_dialog('close');
	   tablaMotivo.ajax.reload();
	   $("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
	   $("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.OK.datos_guardados_OK, "ok");
	   filaSeleccionadaMotivo = "";
	   desbloquearInterfaz();
	   setTimeout(function(){		
		 }, 600);
	  
   },
   error: function(){
	   $("#motivoDenuncia_detail_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
	   $("#motivoDenuncia_detail_feedback").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_guardados_error, "error");
	   filaSeleccionadaMotivo = "";
	   desbloquearInterfaz();
   }

});

	}
	
});


function recuperarMotivoDetalle(filaSeleccionadaMotivo){
	$.ajax({
		type: "GET",
		url: "/ab78WebAppWar/relacionMotivoDen/" + filaSeleccionadaMotivo.idMotivoInterno,
		dataType: "json",
		success: function(data){
			$("#motivoDenuncia_detail_div").rup_dialog("setOption", "title", $.rup.i18n.base.rup_table.edit.editCaption);
			$("#motivoDenuncia_detail_div").rup_dialog("open");
			desbloquearInterfaz();
			$("#motivoDenuncia_detail_form").rup_validate("resetForm");
			$("#idReclamacionModal").val(data.idReclamacion);
			$("#comboIndMotivoFilter").val(data.motivo.idMotivo);
			$("#comboIndMotivoFilterHidden").val(data.motivo.idMotivo);

			$("#idMotivoInternoModal").val(data.idMotivoInterno);
			$("#modalDescMotivo").val(data.descMotivo);
			$("#comboIndMotivoFilter").rup_combo("refresh");

			$("textarea[data-autoresize!=null]").each(function(i,e){
				resizeTextarea(e);
			});
	           
		},
		error: function(){
			$("#motivoDenuncia_detail_div").rup_dialog("close");
			desbloquearInterfaz();
			$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
			$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
		}
	});
}