jQuery(function($) {
	setTextAreaAutoSize();
	$("textarea[data-autoresize!=null]").each(function(i,e){
		resizeTextarea(e);
	});
	rellenarSignatura($('#identificadorEstablecimiento').val());	
	cargarComboOtrosPaises();
	
	$('#importeDevolucion').val(numeroFormater($('#importeDevolucion').val()));
	$('#importeIndemnizacion').val(numeroFormater($('#importeIndemnizacion').val()));
	$('#importeDevolucionHidden').val($('#importeDevolucion').val());
	$('#importeIndemnizacionHidden').val($('#importeIndemnizacion').val());
	
	$("#pageWrapperDenuncia").rup_tabs({
		tabs : [
			{i18nCaption: $.rup.i18n.app.tabs.expediente, layer:".tab-denuncia-expediente"},
			{i18nCaption: $.rup.i18n.app.tabs.denuncia, layer:".tab-denuncia-denuncia"},
			{i18nCaption: $.rup.i18n.app.tabs.resultado, layer:".tab-denuncia-resultado"}],
			create: function(){
				$("#pestanyaDenuncia").removeClass("d-none");
				$("#pestanyaResultado").removeClass("d-none");
				inicializaControlCambios("formDenuncia");
				desbloquearInterfaz();
			},
			select: function(event, tab){
				//bloquearInterfaz();
				var pestania = $("#pageWrapperDenuncia").tabs('option', 'active');		
				var nombre = document.getElementsByClassName("ui-tabs-anchor")[pestania].innerHTML;
				if (controlCambios()) {	
					$.rup_messages("msgConfirm", {
						title:  $.rup.i18n.app.mensajes.titulo,
						message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
						OKFunction: function () {
							// save and go
							$(".container #btnGuardar").click();
							inicializaControlCambios("formDenuncia");
						},
						CANCELFunction: function () {
							// reset and go
							volverAsignarMismosDatosDireccion();
							$("#controlCambios").val(0);
							changesValue(false);
							desbloquearInterfaz();
							inicializaControlCambios("formDenuncia");					
						}
					});	
				}else{
					desbloquearInterfaz();
				}
			}
	});
	
	$("#fichaDenunciaFeedback").rup_feedback({
		closeLink : true,
		block : false,
		gotoTop : false
	});
	
	$("#fichaDenunciaBusqEstFeedback").rup_feedback({
		block:false,
		delay: 3000,
		fadeSpeed: 1000
	});
	
	$("#terDirExpFeedback").rup_feedback({
		closeLink : true,
		block : false,
		gotoTop : false
	});
	
	$(".rup_accordion").rup_accordion({
		active: $("#cambiosAcordeon")[0] ? false : true, // Acordeon de cambios pendientes abierto
		collapsible: $("#cambiosAcordeon")[0] ? false : true, // Acordeon de cambios pendientes abierto
		autoHeight: false,
		beforeActivate: function(event, ui) {		
	    	var currHeader = null;
	        if (ui.newHeader[0]) { 
	        	// Abriendo la seccion
	        	currHeader = ui.newHeader;
	        } else { 
	        	//Cerrando la seccion
	            currHeader  = ui.oldHeader;
	        }
	        var currContent = currHeader.next('.ui-accordion-content');
	
	        var isPanelOpened = currHeader.attr('aria-selected') == 'true';
	
	         // Toggle cabecera
	        currHeader.toggleClass('ui-corner-all',isPanelOpened).toggleClass('ui-accordion-header-active ui-state-active ui-corner-top',!isPanelOpened).attr('aria-selected',((!isPanelOpened).toString()));
	
	        // Toggle icono triangulo/flechita
	        currHeader.children('.ui-icon').toggleClass('ui-icon-triangle-1-e',isPanelOpened).toggleClass('ui-icon-triangle-1-s',!isPanelOpened);
	
	         // Toggle contenido del panel
	        currContent.toggleClass('ui-accordion-content-active',!isPanelOpened)    
	        
	        // Acciones (plegar/desplegar) con animaciones
	        if (isPanelOpened) {
	        	currContent.slideUp(); 
	        }else { 
	        	currContent.slideDown(); 
	        }	        
	        // Cancelamos la funcionalidad por defecto
	        return false; 
	    }

	});
	//Combo tipo documento modal interesado
	$("#tipoDocumentoInteresadoModal").rup_combo({
		blank: "",
		source: "/ab78WebAppWar/tiposdocumento",
		sourceParam: {
			label: ("eu" === $.rup_utils.get("language"))? "descripcionEuskera" : "descripcionCastellano",
			value: "idTipoDocumento"
		},
		disabled: true,
		orderedByValue: true,
		width: 244,
		select: function(){
			if($("#tipoDocumentoInteresadoModal").val() == TIPO_DOCUMENTO_CIF){
				$("#apellido1InteresadoModal").parent().attr("hidden", "true");
				$("#apellido2InteresadoModal").parent().attr("hidden", "true");
				$("#sexoInteresadoModal").parent().attr("hidden", "true");
			} else{
				$("#apellido1InteresadoModal").parent().removeAttr("hidden");
				$("#apellido2InteresadoModal").parent().removeAttr("hidden");
				$("#sexoInteresadoModal").parent().removeAttr("hidden");
			}
		}
	});
	
	if(sessionStorage.getItem("guardarDenunciaOk") === "true"){
		$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.OK.datos_guardados_OK, "ok");
		sessionStorage.setItem("guardarDenunciaOk", false);
	}	
	
	if($("#esExpedienteCerrado").val() === "true"){
		setTimeout(function() {  
			bloquearDenuncia();
	    }, 1500);
	}

	//Combo sexo modal interesado
	$("#sexoInteresadoModal").rup_combo({
		blank: "",
		source: "/ab78WebAppWar/sexos/verValorCombo",
		sourceParam: {
			label: ("eu" === $.rup_utils.get("language"))? "descripcionEuskera" : "descripcionCastellano",
			value: "idSexo"
		},
		orderedByValue: true,
		disabled: true,
		width: 244
	});
	
	
	$('.ui-datepicker-trigger:disabled').addClass("d-none");
	
	if($('#indConoceEstablecimiento').val() == 1){
		$('#sinDenunciados').addClass("d-none");
		$('#hayDenunciados').removeClass("d-none");
	}

	if($("#observacionesNoCensado").val() != ""){
		$('#sinDenunciados').removeClass("d-none");
	}
	
	var url ="/ab78WebAppWar/denuncias/ficha-denuncia/guardar/"+$('#idExpediente').val();
	var isDenunciaMigrada=$('#idExpediente').val()=="" ||$('#idExpediente').val()==null||$('#idExpediente').val()=="0";
	if(isDenunciaMigrada){
		url="/ab78WebAppWar/denuncias/ficha-denuncia/guardar/mig/"+$('#idReclamacion').val();
	}
	
	$('#formDenuncia').rup_form({
		feedback: $("#fichaDenunciaFeedback"),
		url: url,
		type: "POST",
		contentType : 'application/json; charset=utf-8',
		dataType: "json",
		validate:{ 
			ignore: [],
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : true,
			showFieldErrorsInFeedback : true,
			rules:{
				"idTipoEstablecimiento":{
					required: true
				},
				"idProvinciaDenunciado":{
					required: true
				},
				"idMunicipioDenunciado":{
					required: true
				},
				"direccionDenunciado.codigoPostal":{
					digits:true
				},
				"telefonoDenunciado":{
					tlfValidator: function(){
						var valueEstPais = $("input[name='radioPais']:checked").val();
						if(1 == valueEstPais){
							return true;
						}else{
							return false;
						}
					}
				},
				"fechaHechos":{
					date:true, 
					required : true
				},
				"asuntoHechos":{
					required: true
				},
				"descHechosEs":{
					required: true
				},				
				"importeDevolucion":{
					decimalPrecision10Scale2:true
				},
				"importeIndemnizacion":{
					decimalPrecision10Scale2:true
				},
//				"documento":{
//					docIdentificativoPersonalizado:true 
//				},
				"identificadorEstablecimiento":{
					required: function(){
						if("" !== $('#indTipoReclamacionHidden').val() && $("#indTipoReclamacionHidden").val()==0){
							return true;
						}
					}
				},
				
				"fechaDecision":{date:true}
			},
			invalidHandler: function(){
				desbloquearInterfaz();
			}
	   },
	   beforeSubmit:function(data){
		   
		   if($("#indTipoReclamacionEst").is(':checked')){
		   	if($("#partLetra").val() == "" || $("#partProv").val() == "" || $("#partSequencia").val() == "" ){
			   	$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.validaciones.identificadorEstablecimientoVacio, "error");
			   	desbloquearInterfaz();
			   	return false;   
		   	}   
		   }
		   
		   var importeDevolucion;
		   var importeIndemnizacion;
		   for (var i in data) {
			   if (data[i].name === "importeDevolucion") {
				   importeDevolucion = (data[i].value).replace(".","");
				   importeDevolucion = importeDevolucion.replace(".","");
				   importeDevolucion = importeDevolucion.replace(",",".");
			   }
			   if (data[i].name === "importeIndemnizacion") {
				   importeIndemnizacion = (data[i].value).replace(".","");
				   importeIndemnizacion = importeIndemnizacion.replace(".","");
				   importeIndemnizacion = importeIndemnizacion.replace(",",".");
			   }
		   }
		   $('#importeDevolucionHidden').val(importeDevolucion);
		   $('#importeIndemnizacionHidden').val(importeIndemnizacion);
		   if($('#indTipoReclamacionOtros').is(':checked')){
		  	   $("#identificadorEstablecimiento").val(null)
		    }
		  		   
		   $(".comboSubtipo").each(function(){
				var $id = "#"+this.id;
				var $idHidden=$id+"Hidden";
				var hidden = $($idHidden);
				var value =$(hidden).data("tercero")+"-"+$(hidden).val();	
				 $($idHidden).val(value);
		   });

		   var valueEstPais = $("input[name='radioPais']:checked").val();
		   if(1 != valueEstPais){
				$("#telefonoDenunciado").val("");
		   }
	   },
	   success: function(data){
		   
		   if(data.result === 1){
			   sessionStorage.setItem("guardarDenunciaOk", true);
			   location.reload();
		   }else{
			   $("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error[data.message], "error");
		   }
	   },
	   error: function(){
		   $('#importeDevolucionHidden').val($('#importeDevolucion').val());
		   $('#importeIndemnizacionHidden').val($('#importeIndemnizacion').val());
		   desbloquearInterfaz();
	   }

	});
	
	/**
	 * Se validara si tiene Nº registro para proceder con la validacion de los datos que tenemos con los del censo
	 */
	
	$("input[name='radioTipoInfraccion']").on("change", function(){
		$('#tipoInfraccionReclamacionHidden').val(this.value);
	});
	
	
	$("input[name='radioIndTipoReclamacion']").on("change", function(){
		$('#indTipoReclamacionHidden').val(this.value);
		$('#actividadOtros').val("");
		$('#ilegales').prop("checked", false);
		
		divCensadoNoCensadoHideShow();
//		var titulo = divCensadoNoCensadoHideShow();
//		if (null != titulo && titulo == 1 && $('#procedureId').val() !== '1114101'){
//			$('#fichaDenunciaFeedback').rup_feedback("set",$.rup.i18n.app.mensajes.error.titularObligatorio,"alert");
//		}
		
		if(($("input[name='radioIndTipoReclamacion']:checked").val() == 1) &&
				($("#comboIdTipoEstablecimientoHidden").val() == 'A' || $("#comboIdTipoEstablecimientoHidden").val() == 'F'
					|| $("#comboIdTipoEstablecimientoHidden").val() == 'I')){
			$('#paisOtrosRdo').removeClass("disabled");
		} else {
			$('#paisOtrosRdo').addClass("disabled");
		}
		divUbicacionLock();
		
		if($("input[name='radioIndTipoReclamacion']:checked").val() == 1 && null != $(".selectorId[value='1']")  && $(".selectorId[value='1']").attr('data-tercero') != ""){
			var documentoTercero = $(".selectorId[value='1']").attr('data-tercero');
			$.ajax({
			    url : '/ab78WebAppWar/relDenunciaTercero/comprobarCIF?documentoTercero='+ documentoTercero ,
			    type : 'GET',
			    dataType:'json',
			    success : function(data) {              
			        if (data != 0){
			        	$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error.titularExistente, "alert");
			        }
			    },
			    error : function(request,error)
			    {
			    	
			    }
			});
		}
		
		if($("input[name='radioIndTipoReclamacion']:checked").val() == 0 && "" !== $('#identificadorEstablecimiento').val()){
			searchByIdentificador();
		}
	});
	
	$('#btnMiniBuscador').on('click', function(){
		$("#idProvinciaHidden").val($("#idProvinciaDenunciadoHidden").val());
		$("#idMunicipioHidden").val($("#idMunicipioDenunciadoHidden").val());
		$("#idLocalidadHidden").val($("#idLocalidadDenunciadoHidden").val());
		$('#miniBuscador').rup_dialog("open");
	});
	
	$('#btnMiniAlta').on('click', function(){
		searchByIdentificador();
		$("#datosTercerosInteresados").removeAttr("hidden");
	});
	
	$('#devolucion').click(function(){
		$('#importeDevolucion').attr("disabled", $('#devolucion').prop('checked')?null:"disabled");
		!$('#devolucion').prop('checked') && $('#importeDevolucion').val(null);
		!$('#devolucion').prop('checked') && $('#importeDevolucionHidden').val(null);
	});
	
	$('#indemnizacion').click(function(){
		$('#importeIndemnizacion').attr("disabled", $('#indemnizacion').prop('checked')?null:"disabled");
		!$('#indemnizacion').prop('checked') && $('#importeIndemnizacion').val(null);
		!$('#indemnizacion').prop('checked') && $('#importeIndemnizacionHidden').val(null);
	});
	
	$('#importeDevolucion').on("change", function(){
		$('#importeDevolucionHidden').val(this.value);
	});
	$('#importeIndemnizacion').on("change", function(){
		$('#importeIndemnizacionHidden').val(this.value);
	});
	
//	$(".changeControl").change(function(){
//		$("#controlCambios").val(1);
//	});
	
	$("#partLetra").on("keyup", function(){
		var key = event.keyCode;	
		var ignoreKeys = [8, 9, 16, 17, 18, 19, 37, 38, 39, 40];
		if(ignoreKeys.indexOf(key) >= 0) {
			return;
		}
		$("#partLetra").val($("#partLetra").val().toUpperCase());
		$("#partProv").focus();
	});
	$('#partLetra').change(function(){
		var tipoEst = $('#partLetra').val();
		$('#comboIdTipoEstablecimientoHidden').val(tipoEst);
		$('#comboIdTipoEstablecimiento').rup_combo("setRupValue",tipoEst);
		setIdentificador();
	});
	
	$("#partProv").on("keyup", function(){
		var key = event.keyCode;
		var ignoreKeys = [8, 9, 16, 17, 18, 19, 37, 38, 39, 40];
		if(ignoreKeys.indexOf(key) >= 0) {
			return;
		}
		$("#partProv").val($("#partProv").val().toUpperCase());
		if($("#partProv").val().length<2)
			return;
		$("#partSequencia").focus();
	});
	$("#partProv").on("change", function(){
		if($("#partProv").val() ===""){
			$("#identificadorEstablecimiento").val(null);
			return;
		}	
		setIdentificador()
	});
	
	$("#partSequencia").on("change", function(){
		if($("#partSequencia").val() ===""){
			$("#identificadorEstablecimiento").val(null);
			return;
		}	
		setIdentificador()
	});
	
	$(".iconoDerecha").rup_tooltip({
		content:{
			text:$.rup.i18n.app.tooltip.misGestiones
		},
		position:{
			my: 'bottom center',
			at: 'top center',
		}	
	});
		
	$("input[name='postalEstType']").on("change", function(){
		var paisModal = $('input[name="postalEstType"]:checked').val();
		if(paisModal == "1"){
			$("#paisEspanaModal").addClass(" d-none");
			$("#paisOtroModal").removeClass("d-none");
			$(".borrarEsp").val(null);
			$("#idProvinciaModalExp").rup_combo("reload")
		}else{
			$("#paisOtroModal").addClass(" d-none");
			$("#paisEspanaModal").removeClass("d-none");
			$(".borrarOtros").val(null);
			$("#idPaisOtrosModalExp").rup_combo("reload")
		}
	});
	
	if(null != $("#idInspeccionExpediente").val() && $("#idInspeccionExpediente").val() != "0"){
		//$("#divSignaturaAsociada").removeClass("d-none");
		$("#divSignatura").addClass("d-none");
//		$( "#indTipoReclamacionEst" ).prop( "disabled", true );
//		$( "#indTipoReclamacionOtros" ).prop( "disabled", true );
	}	
	
//	$("#partLetra").prop( "disabled", true );
//	$("#partProv").prop( "disabled", true );
//	$("#partSequencia").prop( "disabled", true );

	if($('#procedureId').val() === '1114101') {
		cargarCamposDenunciaNoFormal();
	} else {
		cargarCamposDenunciaFormal();
	}
	
	$("#idEscaleraDenunciado").on("change", function(){
		$("#idEscaleraDenunciadoExtHidden").val($("#idEscaleraDenunciado").val());
	});
	
	cargaMaestros();
	cargaFechas();
	cargaDomicilioDenunciante();
	//cargaDomicilioAfectado();
	cargarDireccionEstablecimientoDenunciado();
	buscarProvinciaTTHH();
	formTerceros();
	
	divCensadoNoCensadoHideShow();
});

function borrarDenunciado(idTercero){
	bloquearInterfaz();
	$.ajax({
		url:"/ab78WebAppWar/relDenunciaTercero/delete?idTercero="+parseInt(idTercero)+"&idExpediente="+parseInt($('#idExpediente').val())+"&migrado="+$('#migradoExpModalHidden').val(),
		method: 'DELETE',
		dataType : 'json',
		success: function(data){
			
			if(data.result == "1"){
				$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.OK[data.message], "ok");
				location.reload();
			}else{
				desbloquearInterfaz();
				$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error[data.message], "error");
			}
		},
		error: function(data){
			desbloquearInterfaz();
			$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error[data.message], "error");
		}
	});
}

function cargaDomicilioDenunciante(){
	if(null != $('#isEnableShowDireccionPostal').val() && "" !== $('#isEnableShowDireccionPostal').val() && "false" !== $('#isEnableShowDireccionPostal').val()){
		$("#idProvinciaDenunciante").rup_combo({
			source: "/ab78WebAppWar/nora/provincias",
			blank: "00",
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			width: 250,
			onLoadSuccess : function() {
				var idProvinciaDenuncianteHidden = pad($("#idProvinciaDenuncianteHidden").val(),2);
				$("#idProvinciaDenunciante").rup_combo("setRupValue", idProvinciaDenuncianteHidden);
			},
			select : function() {
				var idProvinciaDenuncianteHidden = $("#idProvinciaDenunciante").val();
				$("#idProvinciaDenuncianteHidden").val(idProvinciaDenuncianteHidden);
				$("#idMunicipioDenuncianteHidden").val("");
				$("#idMunicipioDenunciante").rup_combo("setRupValue", "00");
			},
			change: function() {
			},
			open: function(){
				$("#idProvinciaDenunciante-menu").width(
					$("#idProvinciaDenunciante-button").width()
				);
			}
		});
		$("#idProvinciaDenuncianteHidden").on("change", function(){
			var idProvinciaDenuncianteHidden =  $("#idProvinciaDenuncianteHidden").val() !== "" ? pad($("#idProvinciaDenuncianteHidden").val(),2): "";
			$("#idProvinciaDenuncianteHidden").val(idProvinciaDenuncianteHidden);
			$("#idProvinciaDenunciante").rup_combo("setRupValue", idProvinciaDenuncianteHidden);
			$("#idMunicipioDenuncianteHidden").val("");
			$("#idMunicipioDenunciante").rup_combo("setRupValue", "00");
		});
		
		$("#idMunicipioDenunciante").rup_combo({
			source: "/ab78WebAppWar/nora/municipios",
			parent: ["idProvinciaDenunciante"],
			blank: "00",
			width: 250,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				var idMunicipioDenuncianteHidden = pad($("#idMunicipioDenuncianteHidden").val(),3);
				$("#idMunicipioDenunciante").rup_combo("setRupValue", idMunicipioDenuncianteHidden);
			},
			select : function() {
				var idMunicipioDenuncianteHidden =  $("#idMunicipioDenunciante").val();
				$("#idMunicipioDenuncianteHidden").val(idMunicipioDenuncianteHidden);
				$("#idLocalidadDenunciante").rup_combo("setRupValue", "00");
				$("#idLocalidadDenuncianteHidden").val("");
			},
			change: function() {
			},
			open: function(){
				$("#idMunicipioDenunciante-menu").width(
					$("#idMunicipioDenunciante-button").width()
				);
			}
		});
		
		$("#idMunicipioDenuncianteHidden").on("change", function(){
			var idMunicipioDenuncianteHidden =  $("#idMunicipioDenuncianteHidden").val() !== "" ? pad($("#idMunicipioDenuncianteHidden").val(),3): "";
			$("#idMunicipioDenuncianteHidden").val(idMunicipioDenuncianteHidden);
			$("#idMunicipioDenunciante").rup_combo("setRupValue", idMunicipioDenuncianteHidden);
			$("#idLocalidadDenunciante").rup_combo("setRupValue", "00");
			$("#idLocalidadDenuncianteHidden").val("");
		});
		
		$("#idLocalidadDenunciante").rup_combo({
			source: "/ab78WebAppWar/nora/localidades",
			parent: ["idProvinciaDenunciante", "idMunicipioDenunciante"],
			blank: "",
			width: 300,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				var idLocalidadDenuncianteHidden = pad($("#idLocalidadDenuncianteHidden").val(),14);
				$("#idLocalidadDenunciante").rup_combo("setRupValue", idLocalidadDenuncianteHidden);
			},
			select : function() {
				var idLocalidadDenuncianteHidden = $("#idLocalidadDenunciante").val();
				$("#idLocalidadDenuncianteHidden").val(idLocalidadDenuncianteHidden);
			},
			open: function(){
				$("#idLocalidadDenunciante-menu").width(
					$("#idLocalidadDenunciante-button").width()
				);
			}
		});
	}
}

function cargaDomicilioAfectado(){
	if(null != $('#flagDireccionAfectados').val() && "" !== $('#flagDireccionAfectados').val() && "false" !== $('#flagDireccionAfectados').val()){
	if(null != $('#isEnableShowDireccionPostal').val() && "" !== $('#isEnableShowDireccionPostal').val() && "false" !== $('#isEnableShowDireccionPostal').val()){
		$("#idProvinciaAfectado").rup_combo({
			source: "/ab78WebAppWar/nora/provincias",
			blank: "00",
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			width: 250,
			onLoadSuccess : function() {
				var idProvinciaAfectadoHidden = pad($("#idProvinciaAfectadoHidden").val(),2);
				$("#idProvinciaAfectado").rup_combo("setRupValue", idProvinciaAfectadoHidden);
			},
			select : function() {
				var idProvinciaAfectadoHidden = $("#idProvinciaAfectado").val();
				$("#idProvinciaAfectadoHidden").val(idProvinciaAfectadoHidden);
				$("#idMunicipioAfectadoHidden").val("");
				$("#idMunicipioAfectado").rup_combo("setRupValue", "00");
			},
			change: function() {
			},
			open: function(){
				$("#idProvinciaAfectado-menu").width(
					$("#idProvinciaAfectado-button").width()
				);
			}
		});
		$("#idProvinciaAfectadoHidden").on("change", function(){
			var idProvinciaAfectadoHidden =  $("#idProvinciaAfectadoHidden").val() !== "" ? pad($("#idProvinciaAfectadoHidden").val(),2): "";
			$("#idProvinciaAfectadoHidden").val(idProvinciaAfectadoHidden);
			$("#idProvinciaAfectado").rup_combo("setRupValue", idProvinciaAfectadoHidden);
			$("#idMunicipioAfectadoHidden").val("");
			$("#idMunicipioAfectado").rup_combo("setRupValue", "00");
		});
		
		$("#idMunicipioAfectado").rup_combo({
			source: "/ab78WebAppWar/nora/municipios",
			parent: ["idProvinciaAfectado"],
			blank: "00",
			width: 250,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				var idMunicipioAfectadoHidden = pad($("#idMunicipioAfectadoHidden").val(),3);
				$("#idMunicipioAfectado").rup_combo("setRupValue", idMunicipioAfectadoHidden);
			},
			select : function() {
				var idMunicipioAfectadoHidden =  $("#idMunicipioAfectado").val();
				$("#idMunicipioAfectadoHidden").val(idMunicipioAfectadoHidden);
				$("#idLocalidadAfectado").rup_combo("setRupValue", "00");
				$("#idLocalidadAfectadoHidden").val("");
			},
			change: function() {
			},
			open: function(){
				$("#idMunicipioAfectado-menu").width(
					$("#idMunicipioAfectado-button").width()
				);
			}
		});
		
		$("#idMunicipioAfectadoHidden").on("change", function(){
			var idMunicipioAfectadoHidden =  $("#idMunicipioAfectadoHidden").val() !== "" ? pad($("#idMunicipioAfectadoHidden").val(),3): "";
			$("#idMunicipioAfectadoHidden").val(idMunicipioAfectadoHidden);
			$("#idMunicipioAfectado").rup_combo("setRupValue", idMunicipioAfectadoHidden);
			$("#idLocalidadAfectado").rup_combo("setRupValue", "00");
			$("#idLocalidadAfectadoHidden").val("");
		});
		
		$("#idLocalidadAfectado").rup_combo({
			source: "/ab78WebAppWar/nora/localidades",
			parent: ["idProvinciaAfectado", "idMunicipioAfectado"],
			blank: "",
			width: 300,
			sourceParam: {
				label: "dsO",
				value: "id"
			},
			onLoadSuccess : function() {
				var idLocalidadAfectadoHidden = pad($("#idLocalidadAfectadoHidden").val(),14);
				$("#idLocalidadAfectado").rup_combo("setRupValue", idLocalidadAfectadoHidden);
			},
			select : function() {
				var idLocalidadAfectadoHidden = $("#idLocalidadAfectado").val();
				$("#idLocalidadAfectadoHidden").val(idLocalidadAfectadoHidden);
			},
			open: function(){
				$("#idLocalidadAfectado-menu").width(
					$("#idLocalidadAfectado-button").width()
				);
			}
		});
	}
	}
}

function cargaMaestros(){
	
	$(".comboSubtipo").each(function(){
		var $id = "#"+this.id;
		var $idHidden=$id+"Hidden";
		var $idHiddenEstatico=$id+"HiddenEstatico";
		var $idHiddenValue=$id+"HiddenValue";
		$($id).rup_combo({
			blank:"0",
			source: "/ab78WebAppWar/tipostercero/subtipos",
			width : "auto",
			ordered:false,
			sourceParam: {
			    label: (("es"===$.rup_utils.get("language")) ? "descripcionCastellano": "descripcionEuskera"),
				value: "idTipoTercero"
			},
			onLoadSuccess : function() {
				$($id).rup_combo("setRupValue", $($idHidden).val());
//				$("#controlCambios").val(0);
				changesValue(false);
			},
			select : function() {
				$($idHidden).val($($id).val());
				$($idHiddenEstatico).val($($id).val());
				var hidden = $($idHidden);
				var value =$($idHiddenValue).data("tercero")+"#"+$(hidden).val();
				$($idHiddenValue).val(value);
			},
			open: function(){
				$($id+"-menu").width(
					$($id+"-button").width()
				);
			}
		});
	});
	
	$('#comboIndMotivoFilter')
	.rup_combo(
			{
				blank : "",
				source : "/ab78WebAppWar/maestros/motivos/motivosGetAll/" + $("#idProcedimiento").val(),
				sourceParam : {
					label : (("es" === $.rup_utils.get("language")) ? "descMotivoEs"
							: "descMotivoEu"),
					value : "idMotivo"
				},
				width : 700,
				select : function() {
					$('#comboIndMotivoFilterHidden').val(
							$('#comboIndMotivoFilter').val());
				}
			});
	
	cargaComboTipoEst();
	
}

function cargaFechas(){
	var fechaPresentacionReclamacion = $("#fechaPresentacionReclamacion").val();
	$("#fechaPresentacionReclamacion").rup_date({
		labelMaskId : "fecha-mask"
	});
	
	if(fechaPresentacionReclamacion === ""){
		$("#fechaPresentacionReclamacion").rup_date("setDate", "");
	}else{
		$("#fechaPresentacionReclamacion").rup_date("setDate", new Date(fechaPresentacionReclamacion));
	}
	
	$('#fechaPresentacionReclamacion').rup_date("disable");
	
	var fechaUltimaModificacion = $("#fechaUltimaModificacion").val();
	$("#fechaUltimaModificacion").rup_date({
		labelMaskId : "fecha-mask"
	});
	
	if(fechaUltimaModificacion === ""){
		$("#fechaUltimaModificacion").rup_date("setDate", "");
	}else{
		$("#fechaUltimaModificacion").rup_date("setDate", new Date(fechaUltimaModificacion));
	}
	
	$('#fechaUltimaModificacion').rup_date("disable");
	
	var fechaHechosReclamacion = $("#fechaHechosReclamacion").val();
	$("#fechaHechosReclamacion").rup_date({
		labelMaskId : "fecha-mask"
	});
	
	if(fechaHechosReclamacion === ""){
		$("#fechaHechosReclamacion").rup_date("setDate", "");
	}else{
		$("#fechaHechosReclamacion").rup_date("setDate", new Date(fechaHechosReclamacion));
	}
	
	/*
	var fechaRegEntrada = $("#fechaRegEntrada").val();
	$("#fechaRegEntrada").rup_date({
		labelMaskId : "fecha-mask"
	});
	
	if(fechaRegEntrada === ""){
		$("#fechaRegEntrada").rup_date("setDate", "");
	}else{
		$("#fechaRegEntrada").rup_date("setDate", new Date(fechaRegEntrada));
	}*/
	
	var fechaDecision = $("#fechaDecision").val();
	$("#fechaDecision").rup_date({
		labelMaskId : "fecha-mask"
	});
	
	if(fechaDecision === ""){
		$("#fechaDecision").rup_date("setDate", "");
	}else{
		$("#fechaDecision").rup_date("setDate", new Date(fechaDecision));
	}
}

function divCensadoNoCensadoHideShow(){

	var	idAfectado = 0;
	if(null != $(".selectorId[value='1']").attr('id')){
		idAfectado = $(".selectorId[value='1']").attr('id').substring(7,13);
	}
	
	if("" !== $('#indTipoReclamacionHidden').val()){
		
		if($('#indTipoReclamacionHidden').val() == 0){
			
			$('#divSignatura').removeClass("d-none");
			$('#divIlegales').addClass("d-none");
			$('#divActividadOtros').addClass("d-none");
			
			if($('#tipoDenuncia').val() != TIPO_DENUNCIA_NO_FORMAL){
				$('#datosTercerosInteresados').removeClass("d-none");
			}else{
				$('#datosTercerosInteresados').addClass("d-none");
			}
			
			$('#nombreComercial').attr('readonly', 'true');
			if($('#comboIdTipoEstablecimiento').rup_combo("getRupValue") != $('#partLetra').val()){
					var tipoEst = $('#partLetra').val();
					$('#comboIdTipoEstablecimientoHidden').val(tipoEst);
					$('#comboIdTipoEstablecimiento').rup_combo("setRupValue",tipoEst);
					setIdentificador();
			}
		}else{
			
			$('#datosTercerosInteresados').addClass("d-none");
			$('#nombreComercial').removeAttr('readonly');
			$('#divSignatura').addClass("d-none");
			$('#divIlegales').removeClass("d-none");
			
			if($('#comboIdTipoEstablecimientoHidden').val()==="O"){
				$('#divActividadOtros').removeClass("d-none");
			}else{
				$('#divActividadOtros').addClass("d-none");
			}
			
			//Ocultaremos el campo ilegales siempre que sea DENUNCIA NOR FORMAL
			if($("#tipoDenuncia").val() == TIPO_DENUNCIA_NO_FORMAL){
				$('#divIlegales').addClass("d-none");		
			}
//			if(null == idAfectado || idAfectado == "" || $("#subTipo"+ idAfectado + "HiddenEstatico").val() != 1){
//				$('#divIlegales').addClass("d-none");	
//				$('#divActividadOtros').addClass("d-none");
//				return 1;		
//			}
		}
	}else{
		
		$('#datosTercerosInteresados').addClass("d-none");
		$('#divSignatura').addClass("d-none");
		$('#divActividadOtros').addClass("d-none");
		$('#divIlegales').addClass("d-none");
		$('#nombreComercial').attr('readonly', 'true');
	}
}

function divUbicacionLock(){
	if("" !== $('#indTipoReclamacionHidden').val()){
		if($('#indTipoReclamacionHidden').val() == 0){
			$("#idProvinciaDenunciadoHidden").attr("readonly", "readonly");
			$("#idMunicipioDenunciadoHidden").attr("readonly", "readonly");
			$("#idCalleDenunciado").attr("readonly", "readonly");
			$("#idNumeroDenunciado").attr("readonly", "readonly");
			$("#idEscaleraDenunciado").attr("readonly", "readonly");
			$("#idPisoDenunciado").attr("readonly", "readonly");
			$("#idLetraDenunciado").attr("readonly", "readonly");
			$("#idCodigoPostalDenunciado").attr("readonly", "readonly");
			$("#telefonoDenunciado").attr("readonly", "readonly");
			$("#descProvinciaExtranjeraUbicEmpresa").attr("readonly", "readonly");
			$("#descCiudadExtranjeraUbicEmpresa").attr("readonly", "readonly");
			$("#idCalleDenunciadoExt").attr("readonly", "readonly");
			$("#idNumeroDenunciadoExt").attr("readonly", "readonly");
			$("#idPisoDenunciadoExt").attr("readonly", "readonly");
			$("#idLetraDenunciadoExt").attr("readonly", "readonly");
			$("#idCalleDenunciadoExt").attr("readonly", "readonly");
			$("#idCodigoPostalDenunciadoExt").attr("readonly", "readonly");
			$("#nombreComercial").attr("readonly", "readonly");
			$("#idProvinciaDenunciado").rup_combo('disable');
			$("#idMunicipioDenunciado").rup_combo('disable');
			$("#idLocalidadDenunciado").rup_combo('disable');
			setTimeout(function(){
				$("#idPaisSolicitante").rup_combo('disable');
			}, 1000);
			$("#comboIdTipoEstablecimiento").rup_combo('disable');
							
			document.getElementById("paisEspRdo").disabled = true;
			
			if($("#paisOtrosRdo").length > 0){
				document.getElementById("paisOtrosRdo").disabled = true;
			}
		}else{
			$("#idProvinciaDenunciadoHidden").attr("readonly", false);
			$("#idMunicipioDenunciadoHidden").attr("readonly", false);
			$("#idCalleDenunciado").attr("readonly", false);
			$("#idNumeroDenunciado").attr("readonly", false);
			$("#idEscaleraDenunciado").attr("readonly", false);
			$("#idPisoDenunciado").attr("readonly", false);
			$("#idLetraDenunciado").attr("readonly", false);
			$("#idCodigoPostalDenunciado").attr("readonly", false);
			$("#telefonoDenunciado").attr("readonly", false);
			$("#descProvinciaExtranjeraUbicEmpresa").attr("readonly", false);
			$("#descCiudadExtranjeraUbicEmpresa").attr("readonly", false);
			$("#idCalleDenunciadoExt").attr("readonly", false);
			$("#idNumeroDenunciadoExt").attr("readonly", false);
			$("#idPisoDenunciadoExt").attr("readonly", false);
			$("#idLetraDenunciadoExt").attr("readonly", false);
			$("#idCalleDenunciadoExt").attr("readonly", false);
			$("#idCodigoPostalDenunciadoExt").attr("readonly", false);
			$("#nombreComercial").attr("readonly", false);
			$("#idProvinciaDenunciado").rup_combo('enable');
			$("#idMunicipioDenunciado").rup_combo('enable');
			$("#idLocalidadDenunciado").rup_combo('enable');
			setTimeout(function(){
				$("#idPaisSolicitante").rup_combo('enable');
			}, 1000);
			$("#comboIdTipoEstablecimiento").rup_combo('enable');
				
			document.getElementById("paisEspRdo").disabled = false;
			
			if($("#paisOtrosRdo").length > 0){
				document.getElementById("paisOtrosRdo").disabled = false;
			}
		}
	}
}

function cargaComboTipoEst(){
	
	$("#comboIdTipoEstablecimiento").rup_combo({
		blank:"",
		source: "/ab78WebAppWar/maestros/tipoEstablecimiento?otros=1",
		sourceParam: {
		    label: (("es" === $.rup_utils.get("language")) ? "descripcionCastellano"
					: "descripcionEuskera"),
			value: "idTipoEstablecimiento"
		},
		width : 325,
		onLoadSuccess : function() {
			$("#comboIdTipoEstablecimiento").rup_combo("setRupValue", $("#comboIdTipoEstablecimientoHidden").val());
			changesValue(false);
			
			if($("#comboIdTipoEstablecimientoHidden").val() == 'A' || $("#comboIdTipoEstablecimientoHidden").val() == 'F' || $("#comboIdTipoEstablecimientoHidden").val() == 'I'){
				$("#idLocalidadDenunciado").rup_combo("clear");
				$("#idMunicipioDenunciado").rup_combo("clear");
				$("#idProvinciaDenunciado").rup_combo("clear");
				$("#idProvinciaDenunciado").data("settings").source = "/ab78WebAppWar/nora/provincias";
				
//				if($("#indTipoReclamacionHidden").val() == "1"){
//					$('#paisOtrosRdo').removeClass("d-none");
//					$("#lblPaisOtroRdo").removeClass("d-none");
//				} else {
//					$('#paisOtrosRdo').addClass("d-none");
//					$("#lblPaisOtroRdo").addClass("d-none");
//				}
			}else{
				$("#idLocalidadDenunciado").rup_combo("clear");
				$("#idMunicipioDenunciado").rup_combo("clear");
				$("#idProvinciaDenunciado").rup_combo("clear");
				$("#idProvinciaDenunciado").data("settings").source = "/ab78WebAppWar/nora/provinciasVascas";
//				if($("#indTipoReclamacionHidden").val() == "1"){
//					$("#paisOtrosRdo").addClass("d-none");
//					$("#lblPaisOtroRdo").addClass("d-none");
//				} else {
//					$("#paisOtrosRdo").removeClass("d-none");
//					$("#lblPaisOtroRdo").removeClass("d-none");
//				}
			}
			$("#idProvinciaDenunciado").rup_combo("reload");
		},
		select : function() {
			
			$("#comboIdTipoEstablecimientoHidden").val($("#comboIdTipoEstablecimiento").val());
			if($('#comboIdTipoEstablecimiento').val()==='O'){
				$('#divActividadOtros').removeClass("d-none");
			}else{
				$('#actividadOtros').val("");
				$('#divActividadOtros').addClass("d-none");
			}
			
			if($("#comboIdTipoEstablecimientoHidden").val() == 'A' || $("#comboIdTipoEstablecimientoHidden").val() == 'F' || $("#comboIdTipoEstablecimientoHidden").val() == 'I'){
				
				if($("#idProvinciaDenunciado option").length == 4) {
					$("#idProvinciaDenunciado").data("settings").source = "/ab78WebAppWar/nora/provincias";
					$("#idLocalidadDenunciadoHidden").val("");
					$("#idLocalidadDenunciadoExtHidden").val("");
					
					$("#idMunicipioDenunciadoHidden").val("");
					$("#idMunicipioDenunciadoExtHidden").val("");
					
					$("#idProvinciaDenunciadoHidden").val("");
					$("#idProvinciaDenunciadoExtHidden").val("");
					
					$("#idLocalidadDenunciado").rup_combo("clear");
					$("#idMunicipioDenunciado").rup_combo("clear");
					$("#idProvinciaDenunciado").rup_combo("clear");
					$("#idProvinciaDenunciado").rup_combo("reload");
				}
				
//				if($("#indTipoReclamacionHidden").val() == "1"){
//					$('#paisOtrosRdo').removeClass("d-none");
//					$("#lblPaisOtroRdo").removeClass("d-none");
//				} else {
//					$('#paisOtrosRdo').addClass("d-none");
//					$("#lblPaisOtroRdo").addClass("d-none");
//				}
			}else{

				if($("#idProvinciaDenunciado option").length > 4) {
					$("#idProvinciaDenunciado").data("settings").source = "/ab78WebAppWar/nora/provinciasVascas";
					$("#idLocalidadDenunciadoHidden").val("");
					$("#idLocalidadDenunciadoExtHidden").val("");
					
					$("#idMunicipioDenunciadoHidden").val("");
					$("#idMunicipioDenunciadoExtHidden").val("");
					
					$("#idProvinciaDenunciadoHidden").val("");
					$("#idProvinciaDenunciadoExtHidden").val("");
					
					$("#idLocalidadDenunciado").rup_combo("clear");
					$("#idMunicipioDenunciado").rup_combo("clear");
					$("#idProvinciaDenunciado").rup_combo("clear");
					$("#idProvinciaDenunciado").rup_combo("reload");
				}
				
//				if($("#indTipoReclamacionHidden").val() == "1"){
//					$("#paisOtrosRdo").addClass("d-none");
//					$("#lblPaisOtroRdo").addClass("d-none");
//				} else {
//					$("#paisOtrosRdo").removeClass("d-none");
//					$("#lblPaisOtroRdo").removeClass("d-none");
//				}
				
			}
		}
	});
}

function rellenarSignatura(identificadorEstablecimiento){
	$('#partLetra').val(identificadorEstablecimiento.substring(0,1));
	$('#partProv').val(identificadorEstablecimiento.substring(1,3));
	$('#partSequencia').val(identificadorEstablecimiento.substring(3,8));
}

function borrarCensado(){
	$('#partLetra').val("");
	$('#partProv').val("");
	$('#partSequencia').val("");
	$('#idEstablecimiento').val("");
	$('#identificadorEstablecimiento').val("");
}


function searchByIdentificador(){
	
	if(null != $("#partLetra").val() && "" !== $("#partLetra").val() && null != $("#partProv").val() && "" !== $("#partProv").val() && null != $("#partSequencia").val() && "" !== $("#partSequencia").val()){
		setIdentificador();
		//$("#identificadorEstablecimiento").val(current);
		findEstablecimiento($("#searchIdentificador").val());
	}
}

function setIdentificador() {
	
	if($("#partSequencia").val() != null && $("#partSequencia").val() != ""){		
		$("#partSequencia").val(pad($("#partSequencia").val(), 5));
	}
	var letra = $("#partLetra").val();
	var prov = $("#partProv").val();
	var sequence = $("#partSequencia").val();
	var identificador = (""+letra + prov + sequence).toUpperCase();
	$("#searchIdentificador").val(identificador);
	$("#identificadorEstablecimiento").val(identificador);
	$("#signaturaAsociada").val(identificador);
}

function findEstablecimiento(value){
	bloquearInterfaz();
	//disableButton("#btnGuardar");
	value = value.toUpperCase();
	if(value == null || value === 0 || value === "" || !/\w{3}\d{5}/.test(value)){
		$("#identificadorEstablecimiento").val("");
		$("#idEstablecimiento").val("");
		$("#fichaDenunciaBusqEstFeedback").rup_feedback("set",$.rup.i18n.app.msg.establecimientoNoEncontrado,"alert");
		desbloquearInterfaz();
	}else if (/\w{3}\d{5}/.test(value)){
		
		$.get("/ab78WebAppWar/searchEstablecimiento?q="+value, function(data) {
			desbloquearInterfaz();
			data = JSON.parse(data);
			if(data.length > 0){
				
				$('#idEstablecimiento').val(data[0].idEstablecimiento);
				$('#nombreComercial').val(data[0].descrNombre);
				$('#nombreTercero').val(data[0].datosTerceros.nombre);
				$('#apellido1InteresadoModal').val(data[0].datosTerceros.apellido1);
				$('#apellido2InteresadoModal').val(data[0].datosTerceros.apellido2);
				$('#documentoInteresadoModal').val(data[0].datosTerceros.documento);
				$("#tipoDocumentoInteresadoModal").rup_combo("setRupValue", data[0].datosTerceros.tiposDocumento.idTipoDocumento);
				$("#sexoInteresadoModal").rup_combo("setRupValue", data[0].datosTerceros.sexo.idSexo);
				$("#searchIdentificador").val(value);
				const idTercero = data[0].datosTerceros.idTercero;
				const nombreCompuesto = data[0].datosTerceros.nombreCompuesto;
				if(idTercero === null || idTercero === 0 || idTercero === ""){
					$("#fichaDenunciaBusqEstFeedback").rup_feedback("set",$.rup.i18n.app.msg.titularNoAsociado,"alert");
					
					/**
					 * Mostramos los datos asociados del establecimiento, y ademas añadimos el valor 1 
					 * al control de cambios para que muestre una alerta cuando cambien de pestaña
					 */
					establecimientoActivo(data[0]);
					$("#controlCambios").val(1);
				}else{					
					establecimientoActivo(data[0]);	
					$("#controlCambios").val(1);
					
					const idTerceroDuplicado = afectadosActivos(data[0]);
					if(idTerceroDuplicado !== null){
						insertarParteInculpada(idTerceroDuplicado);
					}else{
						if($('#tipoDenuncia').val() != TIPO_DENUNCIA_NO_FORMAL){
							validarTipo(idTercero, data[0].datosTerceros.documento, nombreCompuesto);
						}
					}
				}
				
				radioButtonPais();
			}else{
				$("#identificadorEstablecimiento").val("");
				$("#idEstablecimiento").val("");
				$("#fichaDenunciaBusqEstFeedback").rup_feedback("set",$.rup.i18n.app.msg.establecimientoNoEncontrado,"alert");
			}
		});
	}
	
}

$.validator.addMethod("docIdentificativoPersonalizado", docIdentificativoPersonalizado, $.rup.i18n.app.validaciones.docIdentificativoPersonalizado);
function docIdentificativoPersonalizado(value) {	
	return validarDNICIFNIEPASAPORTE(value, "2");
}

$.validator.addMethod("documentoModalPestanyaExp", documentoModalPestanyaExp, $.rup.i18n.app.validaciones.docIdentificativoPersonalizado);
function documentoModalPestanyaExp(value) {	
	return validarDNICIFNIEPASAPORTE(value, $('#comboTiposDocExpModalHidden').val());
}

function returnId(elemento) {
	return elemento === datosTercerosList;
}

function cargarDireccionEstablecimientoDenunciado(){
	$("#idProvinciaDenunciado").rup_combo({
		source: "/ab78WebAppWar/nora/provincias",
		width: 250,
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		blank: "00",
		onLoadSuccess : function() {
			var idProvincia = pad($("#idProvinciaDenunciadoHidden").val(),2);
			$("#idProvinciaDenunciado").rup_combo("setRupValue", idProvincia);
			$("#idProvinciaDenunciado").rup_combo("refresh");
			
			if($("#idProvinciaDenunciadoHidden").val() == "00"){
				$("#idProvinciaDenunciadoHidden").val("");
				$("#idProvinciaDenunciadoExtHidden").val("");
			}
			if($("#idMunicipioDenunciadoHidden").val() == "00"){
				$("#idMunicipioDenunciadoHidden").val("");
				$("#idMunicipioDenunciadoExtHidden").val("");
			}
			
			if($("#idLocalidadDenunciadoHidden").val() == "00"){
				$("#idLocalidadDenunciadoHidden").val("");
				$("#idLocalidadDenunciadoExtHidden").val("");
			}
		},
		select : function() {
			$("#idProvinciaDenunciadoHidden").val($("#idProvinciaDenunciado").val());
			$("#idProvinciaDenunciadoExtHidden").val($("#idProvinciaDenunciado").val());
			
			$("#idMunicipioDenunciadoHidden").val("");
			$("#idMunicipioDenunciadoExtHidden").val("");
			
			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			
			$("#idMunicipioDenunciado").rup_combo("setRupValue", "00");
		},
		open: function(){
			$("#idProvinciaDenunciado-menu").width(
				$("#idProvinciaDenunciado-button").width()
			);
		}
	});
	
	$("#idProvinciaDenunciadoHidden").on("change", function(){
		var idProvinciaHidden =  $("#idProvinciaDenunciadoHidden").val() !== "" ? pad($("#idProvinciaDenunciadoHidden").val(),2): "";
		if(hasValueCombo($("#idProvinciaDenunciado"), idProvinciaHidden)){
			$("#idProvinciaDenunciadoHidden").val(idProvinciaHidden);
			$("#idProvinciaDenunciadoExtHidden").val(idProvinciaHidden);
			$("#idProvinciaDenunciado").rup_combo("setRupValue", idProvinciaHidden);
			
			$("#idMunicipioDenunciadoHidden").val("");
			$("#idMunicipioDenunciadoExtHidden").val("");
			
			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			
			$("#idMunicipioDenunciado").rup_combo("setRupValue", "00");
		}else{
			$("#idProvinciaDenunciado").rup_combo("setRupValue", "00");
			$("#idProvinciaDenunciado").val("");
			$("#idProvinciaDenunciadoExtHidden").val("");
			
			$("#idMunicipioDenunciadoHidden").val("");
			$("#idMunicipioDenunciadoExtHidden").val("");
			
			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			
			$("#idMunicipioDenunciado").rup_combo("setRupValue", "00");
		}
	});
	
	$("#idMunicipioDenunciado").rup_combo({
		source: "/ab78WebAppWar/nora/municipios",
		parent: ["idProvinciaDenunciado"],
		blank: "00",
		width: 250,
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		onLoadSuccess : function() {
			if("" === $("#idMunicipioDenunciadoHidden").val()){
				$("#idMunicipioDenunciado").rup_combo("setRupValue", "00");
			}else{
				var idMunicipio = pad($("#idMunicipioDenunciadoHidden").val(),3);
				$("#idMunicipioDenunciado").rup_combo("setRupValue", idMunicipio);
			}
			$("#idMunicipioDenunciado").rup_combo("refresh");
		},
		select : function() {
			$("#idMunicipioDenunciadoHidden").val($("#idMunicipioDenunciado").val());
			$("#idMunicipioDenunciadoExtHidden").val($("#idMunicipioDenunciado").val());
			
			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			$("#idLocalidadDenunciado").rup_combo("setRupValue", "00");
		},
		open: function(){
			$("#idMunicipioDenunciado-menu").width(
				$("#idMunicipioDenunciado-button").width()
			);
		}
	});
	
	$("#idMunicipioDenunciadoHidden").on("change", function(){
		var idMunicipioHidden =  $("#idMunicipioDenunciadoHidden").val() !== "" ? pad($("#idMunicipioDenunciadoHidden").val(),3): "";
		if(hasValueCombo($("#idMunicipioDenunciado"), idMunicipioHidden)){
			$("#idMunicipioDenunciadoHidden").val(idMunicipioHidden);
			$("#idMunicipioDenunciadoExtHidden").val(idMunicipioHidden);
			$("#idMunicipioDenunciado").rup_combo("setRupValue", idMunicipioHidden);

			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			$("#idLocalidadDenunciado").rup_combo("setRupValue", "00");
		}else{
			$("#idMunicipioDenunciado").rup_combo("setRupValue", "00");
			$("#idMunicipioDenunciado").val("");
			$("#idMunicipioDenunciadoExtHidden").val("");
			
			$("#idLocalidadDenunciadoHidden").val("");
			$("#idLocalidadDenunciadoExtHidden").val("");
			$("#idLocalidadDenunciado").rup_combo("setRupValue", "00");
		}
	});
	
	$("#idLocalidadDenunciado").rup_combo({
		source: "/ab78WebAppWar/nora/localidades",
		parent: ["idProvinciaDenunciado", "idMunicipioDenunciado"],
		blank: "",
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		onLoadSuccess : function() {
			var idLocalidad = pad($("#idLocalidadDenunciadoHidden").val(),14);
			$("#idLocalidadDenunciado").rup_combo("setRupValue", idLocalidad);
			$("#idLocalidadDenunciado").rup_combo("refresh");
			divUbicacionLock();
		},
		select : function() {
			$("#idLocalidadDenunciadoHidden").val($("#idLocalidadDenunciado").val());
			$("#idLocalidadDenunciadoExtHidden").val($("#idLocalidadDenunciado").val());
		},
		open: function(){
			$("#idLocalidadDenunciado-menu").width(
					$("#idLocalidadDenunciado-button").width()
			);
		}
	});
	
}
function buscarProvinciaTTHH(){
	$.ajax({
		url:"/ab78WebAppWar/nora/provincias/"+pad($('#territorioHistoricoHidden').val(), 2),
		method: 'GET',
		dataType : 'json',
		success: function(data){
			if("" !== $('#territorioHistoricoHidden').val()){
				$('#labelProvincia').val(data[0].dsO);
			}
		},
		error: function(data){
		}
	});
}

function formTerceros(){
	var isFirstLoad = true;
	
	$('#modalTercerosExpediente').rup_dialog({
		autoOpen: false,
		width: 850,
		modal: true,
		position: {my: "left top", at: "left+400 top+100", of: document},
		type: $.rup.dialog.DIV,
		open: function(event, ui) {
			if(null != $('#modalTercerosExpediente').data('nuevo') && $('#modalTercerosExpediente').data('nuevo') == true){
				$(this).dialog("option", "title", $.rup.i18n.base.rup_table.edit.addCaption);
			}else{
				$(this).dialog("option", "title", $.rup.i18n.base.rup_table.edit.editCaption);
			}
			
			$('#idDenunciaExpModalHidden').val($('#idReclamacion').val());
			$('#modalTercerosExpediente').removeClass("d-none");
			
			if(null != $('#modalTercerosExpediente').data('titular') && true === $('#modalTercerosExpediente').data('titular')){
				$("#formTerDirExpModal :input").prop("readonly", true);
				$("#saveTerDirBtn").addClass("d-none");
			}else{
				$("#formTerDirExpModal :input").prop("readonly", false);
				$("#saveTerDirBtn").removeClass("d-none");
			}			
			
			if($('#idTerceroExpModalHidden').val() != ""){
				
				$.ajax({
					url:"/ab78WebAppWar/relDenunciaTercero/datostercero/" + $('#idTerceroExpModalHidden').val(),
					method: 'GET',
					dataType : 'json',
					success: function(data){
						if(data.result == 1){
							if(null != data.data.pais && data.data.pais != 0 && data.data.pais != 108){
								$("#paisOtrosActRdo").prop("checked", true)
							} else {
								$("#paisEspActRdo").prop("checked", true)
							}
														
							var paisModal = $('input[name="postalEstType"]:checked').val();
							if(paisModal == "1"){
								$("#paisEspanaModal").addClass(" d-none");
								$("#paisOtroModal").removeClass("d-none");
								$(".form-control", "#paisEspSolicitante").val(null);
							}else{
								$("#paisOtroModal").addClass(" d-none");
								$("#paisEspanaModal").removeClass("d-none");
								$(".form-control", "#paisOtroSolicitante").val(null);
							}
							
							$('#documentoModalExp').val(data.data.documento);
							$('#nombreModalExp').val(data.data.nombre);
							$('#comboTiposDocExpModalHidden').val(data.data.tipoDocumento);
							$('#idTerceroExpModalHidden').val(data.data.idTercero);
							$('#idDireccionExpModalHidden').val(data.data.idDireccion);
							$('#emailModalExp').val(data.data.email);
							$('#tlfModalExp').val(data.data.telefono == "0" ? "" : data.data.telefono);
							$('#direccionModalExp').val(data.data.direccion);
							$('#codigoPostalModalExp').val(data.data.codigoPostal);
							$("#comboTiposDocExpModal").rup_combo("reload");
							
							var paisModal = $('input[name="postalEstType"]:checked').val();
							if(paisModal == "0"){
								$('#idTipoDireccionExpModalHidden').val(data.data.idTipoDireccion);
								
								$('#idProvinciaModalExpHidden').val(data.data.provincia == "0" ? "" : pad(data.data.provincia, 2));
								$('#idMunicipioModalExpHidden').val(data.data.municipio == "0" ? "" : pad(data.data.municipio, 3));
								$('#idLocalidadModalExpHidden').val(data.data.localidad == "0" ? "" : data.data.localidad);
								$('#idProvinciaModalExp').rup_combo("reload");
							} else {
								$('#descProvinciaExtranjera').val(data.data.descProvinciaExtranjera);
								$('#descCiudadExtranjera').val(data.data.descCiudadExtranjera);
								$('#idPaisOtrosModalExpHidden').val(data.data.idPais == "0" ? "" : pad(data.data.pais, 3));								
							}
						}else{
							$('#modalTercerosExpediente').rup_dialog("close");
							$('#fichaDenunciaFeedback').rup_feedback("set",$.rup.i18n.app.msg.errorGenerico,"error");
						}	
						desbloquearInterfaz();
					},
					error: function(data){
						$('#modalTercerosExpediente').rup_dialog("close");
						$('#fichaDenunciaFeedback').rup_feedback("set",$.rup.i18n.app.msg.errorGenerico,"error");
						desbloquearInterfaz();
					}
				});
				
			}
			
			
			
			$("#idPaisOtrosModalExp").rup_combo({
				source: "/ab78WebAppWar/nora/paises",
				blank: "",
				width: 250,
				sourceParam: {
					label: "dsO",
					value: "id"
				},
				onLoadSuccess : function() {
					if(null != $('#modalTercerosExpediente').data('titular') && true === $('#modalTercerosExpediente').data('titular')){
						$("#idPaisOtrosModalExp").rup_combo("disable");
					}
					
					var idPaisOtrosModalExpHidden = pad($("#idPaisOtrosModalExpHidden").val(),3);
					$("#idPaisOtrosModalExp").rup_combo("setRupValue", idPaisOtrosModalExpHidden);
				},
				select : function() {
					$("#idPaisOtrosModalExpHidden").val($("#idPaisOtrosModalExp").val());
					
				},
				open: function(){
					$("#idPaisOtrosModalExp-menu").width(
							$("#idPaisOtrosModalExp-button").width()
					);
				}
			});
		},
		close:function() {
			$('#formTerDirExpModal').validate().resetForm();
			$('#formTerDirExpModal').rup_form("resetForm");
			$('#terDirExpFeedback').rup_feedback("close");
			$('#idProvinciaModalExpHidden').val("");
			$('#idMunicipioModalExpHidden').val("");
			$('#idLocalidadModalExpHidden').val("");
			$('#comboTiposDocExpModalHidden').val("");
			//$('#idProvinciaModalExp').rup_combo("reset");
			$('#idProvinciaModalExp').rup_combo("setRupValue", "00");
			$('#idMunicipioModalExp').rup_combo("setRupValue", "00");
			$('#idLocalidadModalExp').rup_combo("setRupValue", "00");
			$('#idProvinciaModalExp').rup_combo("reload");
			$('#idTerceroExpModalHidden').val("");
			$('#idDireccionExpModalHidden').val("");
				
		}
	});
	
	$('#comboTiposDocExpModal').rup_combo({
		source : "/ab78WebAppWar/tiposdocumento",
		sourceParam : {
			label: getLocaleOption("descripcionCastellano","descripcionEuskera"),
			value: "idTipoDocumento", 
			style: "css"
		},
		blank: "",
		onLoadSuccess : function() {
			$("#comboTiposDocExpModal").rup_combo("setRupValue", $('#comboTiposDocExpModalHidden').val());
			$("#comboTiposDocExpModal").rup_combo("refresh");
			if(null != $('#modalTercerosExpediente').data('titular') && true === $('#modalTercerosExpediente').data('titular')){
				$("#comboTiposDocExpModal").rup_combo("disable");
			}
			
		},
		select : function() {
			$('#comboTiposDocExpModalHidden').val($('#comboTiposDocExpModal').val());
		},
		width:180
	});		
	
	$("#idProvinciaModalExp").rup_combo({
		source: "/ab78WebAppWar/nora/provincias",
		blank: "",
		sourceParam: {
			label: "dsO",
			value: "id"
		},
		onLoadSuccess : function() {
			if(null != $('#modalTercerosExpediente').data('titular') && true === $('#modalTercerosExpediente').data('titular')){
				$("#idProvinciaModalExp").rup_combo("disable");
			}
			
			if($('#idProvinciaModalExpHidden').val()==""){
				$("#idProvinciaModalExp").rup_combo("setRupValue", "");
			}else{
				var idProvinciaModalExp = pad($("#idProvinciaModalExpHidden").val(),2);
				$("#idProvinciaModalExp").rup_combo("setRupValue", idProvinciaModalExp);
			}
			
			if(isFirstLoad){
				setTimeout(function(){
					$("#idMunicipioModalExp").rup_combo({
						source: "/ab78WebAppWar/nora/municipios",
						parent: ["idProvinciaModalExp"],
						blank: "",
						sourceParam: {
							label: "dsO",
							value: "id"
						},
						onLoadSuccess : function() {
							
							if($("#idMunicipioModalExpHidden").val() == ""){
								desbloquearInterfaz();
							}
							
							var idMunicipioModalExp = pad($("#idMunicipioModalExpHidden").val(),3);
							$("#idMunicipioModalExp").rup_combo("setRupValue", idMunicipioModalExp);
							if(null != $('#modalTercerosExpediente').data('titular') && true === $('#modalTercerosExpediente').data('titular')){
								$("#idMunicipioModalExp").rup_combo("disable");
							}
							
							setTimeout(function(){
								
								$("#idLocalidadModalExp").rup_combo({
									source: "/ab78WebAppWar/nora/localidades",
									parent: [ "idProvinciaModalExp", "idMunicipioModalExp"],
									blank: "",
									sourceParam: {
										label: "dsO",
										value: "id"
									},
									onLoadSuccess : function() {
										var idLocalidadModalExp = $("#idLocalidadModalExpHidden").val();
										$("#idLocalidadModalExp").rup_combo("setRupValue", idLocalidadModalExp);
										desbloquearInterfaz();
									},
									select : function() {
										$("#idLocalidadModalExpHidden").val($("#idLocalidadModalExp").val());
									},
									
									open: function(){
										$("#idLocalidadModalExp-menu").width(
												$("#idLocalidadModalExp-button").width()
										);
									}	
								});
								isFirtsLoad = false;
							}, 0);
						},
						select : function() {
							$("#idMunicipioModalExpHidden").val($("#idMunicipioModalExp").val());
							$("#idLocalidadModalExp").rup_combo("setRupValue", "");
							$("#idLocalidadModalExpHidden").val("");
							if($("#idMunicipioModalExp").val()!=""){
								var settings = $("#idLocalidadModalExp").data("settings");
								settings.ultimaLlamada="";
								$("#idLocalidadModalExp").data("settings", settings);
								$("#idLocalidadModalExp").rup_combo("reload");
							}
						},
					
						open: function(){
							$("#idMunicipioModalExp-menu").width(
								$("#idMunicipioModalExp-button").width()
							);
						}
					});
					
				}, 0);
			}
			
			desbloquearInterfaz();
		},
		select : function() {
			$("#idProvinciaModalExpHidden").val($("#idProvinciaModalExp").val());
			$("#idMunicipioModalExp").rup_combo("setRupValue", "");
			$("#idMunicipioModalExpHidden").val("");
			if($("#idProvinciaModalExp").val()!=""){
				var settings = $("#idMunicipioModalExp").data("settings");
				settings.ultimaLlamada="";
				$("#idMunicipioModalExp").data("settings", settings);
				$("#idMunicipioModalExp").rup_combo("reload");
			}
		},
		open: function(){
			$("#idProvinciaModalExp-menu").width(
				$("#idProvinciaModalExp-button").width()
			);
		}
	});

	

	$("#idProvinciaModalExpHidden").on("change", function(){
		var idProvinciaModalExpHidden =  $("#idProvinciaModalExpHidden").val() !== "" ? pad($("#idProvinciaModalExpHidden").val(), 2): "";
		$("#idProvinciaModalExpHidden").val(idProvinciaModalExpHidden);
		$("#idProvinciaModalExp").rup_combo("setRupValue", idProvinciaModalExpHidden);
		$("#idMunicipioModalExpHidden").val("");
		$("#idMunicipioModalExp").rup_combo("setRupValue", "");
	});
	
	$("#idMunicipioModalExpHidden").on("change", function(){
		var idMunicipioModalExpHidden =  $("#idMunicipioModalExpHidden").val() !== "" ? pad($("#idMunicipioModalExpHidden").val(),3): "";
		$("#idMunicipioModalExpHidden").val(idMunicipioModalExpHidden);
		$("#idMunicipioModalExp").rup_combo("setRupValue", idMunicipioModalExpHidden);
		$("#idLocalidadModalExp").rup_combo("setRupValue", "");
		$("#idLocalidadModalExpHidden").val("");
	});
	
	$('#formTerDirExpModal').rup_form({
		feedback: $("#terDirExpFeedback"),
		url: "/ab78WebAppWar/relDenunciaTercero/save"+"?migrado="+$('#migradoExpModalHidden').val(),
		type: "PUT",
		contentType: "application/json",
		dataType:"json",
		validate:{ 
			ignore: [],
			liveCheckingErrors : false,
			showFieldErrorAsDefault : true,
			showErrorsInFeedback : true,
			showFieldErrorsInFeedback : true,
			rules:{	
				"datosDirecciones.identificadorEstablecimiento":{
					required: function(){
						if("" !== $('#searchIdentificador').val() && $("#searchIdentificador").val()==0){
							return true;
						}
					}
				},
				"datosDirecciones.datosTerceros.tiposDocumento.idTipoDocumento":{required:true},
				"datosDirecciones.datosTerceros.documento":{required:true, documentoModalPestanyaExp:true},
				"datosDirecciones.datosTerceros.nombre":{required:true},
				"datosDirecciones.datosTerceros.email":{email:true},
				"datosDirecciones.idProvincia":{digits:true},
				"datosDirecciones.idMunicipio":{digits:true},
				"datosDirecciones.datosTerceros.telefono":{
					//digits:true,
					tlfValidator:true
				}
			}
	   },beforeSubmit : function(){
           if($('#paisEspActRdo').is(':checked')){
        	   $("#idPaisOtrosModalExpHidden").val(108)
           }
           return true;
        },
	   success: function(data){
		   if(data.result === 1){
			   if($('#idTerceroExpModalHidden').val() != ""){
				   $('#input' + $('#idTerceroExpModalHidden').val()).val($('#documentoModalExp').val() + " - " + $('#nombreModalExp').val());
				   $("#terDirExpFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.OK[data.message], "ok");
				   setTimeout(function(){
					   $('#modalTercerosExpediente').rup_dialog("close");
					   desbloquearInterfaz();
				   },1000);
			   }else{
				   //bloquearInterfaz();
				   $("#terDirExpFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.OK[data.message], "ok");
				   setTimeout(function(){
					   //$('#modalTercerosExpediente').rup_dialog("close");
					   bloquearInterfaz();
					   location.reload();
				   },1000);
			   }  
		   }else{
			   desbloquearInterfaz();
			   $("#terDirExpFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error[data.message], "error");
		   }
	   },
	   error: function(){
		   desbloquearInterfaz();
		   $("#terDirExpFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.error[data.message], "error");
		   
	   }

	});
	
	$(".botonCompartir").click(function() {
		bloquearInterfaz();
		$('#idTerceroExpModalHidden').val((this.id+"").replace("mod",""));
		$('#modalTercerosExpediente').data('titular', false);
		$('#modalTercerosExpediente').data('nuevo', false);
		$('#modalTercerosExpediente').rup_dialog("open");	
	});
	
	$(".btnBorrarDenunciado").click(function() {
		confirmDialog(borrarDenunciado, $.rup.i18n.app.mensajes.confirmarOperacion, (this.id+"").replace("del",""));
	});
	
	$(".btnVerTitular").click(function() {
		bloquearInterfaz();		
		$('#idTerceroExpModalHidden').val((this.id+"").replace("del",""));
		$('#modalTercerosExpediente').data('titular', true);
		$('#modalTercerosExpediente').data('nuevo', false);
		$('#modalTercerosExpediente').rup_dialog("open");
	});
	
	$('#saveTerDirBtn').on('click', function(){
		if($('#formTerDirExpModal').valid()){
			bloquearInterfaz();
			$('#formTerDirExpModal').rup_form("submit");
		}
	});
	
	
	$('#addDenunciado').on('click', function(){
		$('#modalTercerosExpediente').data('titular', false);
		$('#modalTercerosExpediente').data('nuevo', true);
		$("#paisEspActRdo").prop("checked", true);
		$("#paisOtroModal").addClass(" d-none");
		$("#paisEspanaModal").removeClass("d-none");
		$('#modalTercerosExpediente').rup_dialog("open");
	});	
}




function seleccionarEstablecimiento(fila){
	establecimientoActivo(fila)
	
	searchByIdentificador();
	$("#datosTercerosInteresados").removeAttr("hidden");
	
	$("#controlCambios").val(1);
	
	const idTerceroDuplicado = afectadosActivos(fila)
	if(idTerceroDuplicado !== null){
		insertarParteInculpada(idTerceroDuplicado)
	} else{
		if($('#tipoDenuncia').val() != TIPO_DENUNCIA_NO_FORMAL){
			validarTipo(fila.datosTerceros.idTercero, fila.datosTerceros.documento, fila.datosTerceros.nombreCompuesto);
		}
	}
	
	$('#miniBuscador').rup_dialog("close");
	setTimeout(function(){ 
		$("#idPaisSolicitante").rup_combo('disable')
	}, 1000);
}

function afectadosActivos(fila){
	const afectadosInput = $("#afectados").val();
	
	let index = 0;
	let i = 0;
	const afectadosIndexes = [];
	const idAfectados = [];
	
	while (index != -1) {
		index = afectadosInput.indexOf("idTercero:", i + 1);
		i = index;
		if(index != -1){
			afectadosIndexes.push(index + 11);
		}
	}
	if (afectadosIndexes.length !== 0){
		afectadosIndexes.forEach(function (id){
			idAfectados.push(afectadosInput.substring(id, id + 9).split(" ")[0]);
		});
	}

	index = 0;
	i = 0;
	const documentosIndexes = [];
	const documentos = [];
	
	while (index != -1) {
		index = afectadosInput.indexOf("documento:", i + 1);
		i = index;
		if(index != -1){
			documentosIndexes.push(index + 11);
		}
	}
	if (documentosIndexes.length !== 0){
		documentosIndexes.forEach(function (id){
			documentos.push(afectadosInput.substring(id, id + 9).split(" ")[0]);
		});
	}
	if (documentos.indexOf(fila.datosTerceros.documento) >= 0 && idAfectados.length !== 0){
		const duplicateIndex = documentos.indexOf(fila.datosTerceros.documento);
		idTercero = idAfectados[duplicateIndex];
		
		return idTercero;
	}
	return null;
} 

function establecimientoActivo(fila) {
	$('#idEstablecimiento').val(fila.idEstablecimiento);
	$('#identificadorEstablecimiento').val(fila.identificadorEstablecimiento);
	$('#signaturaAsociada').val(fila.identificadorEstablecimiento);
	rellenarSignatura(fila.identificadorEstablecimiento);
	$('#searchIdentificador').val(fila.identificadorEstablecimiento);
	changesValue(true);
	$('#nombreComercial').val(fila.descrNombre);
	$('#documento').val(fila.datosTerceros.documento);
	$('#razonSocial').val(fila.datosTerceros.nombreCompuesto);
	$('#comboIdTipoEstablecimientoHidden').val($('#partLetra').val());
	if(fila.datosDirecciones.idProvincia != null && fila.datosDirecciones.idProvincia != 0){		
		$('#idProvinciaDenunciadoHidden').val(fila.datosDirecciones.idProvincia);
		$('#idProvinciaDenunciadoExtHidden').val(fila.datosDirecciones.idProvincia);
	}else{
		$('#idProvinciaDenunciadoHidden').val("");
		$('#idProvinciaDenunciadoExtHidden').val("");
	}
	if(fila.datosDirecciones.idMunicipio != null && fila.datosDirecciones.idMunicipio != 0){		
		$('#idMunicipioDenunciadoHidden').val(fila.datosDirecciones.idMunicipio);
		$('#idMunicipioDenunciadoExtHidden').val(fila.datosDirecciones.idMunicipio);
	}else{
		$('#idMunicipioDenunciadoHidden').val("");
		$('#idMunicipioDenunciadoExtHidden').val("");
	}
	if(fila.datosDirecciones.idLocalidad != null && fila.datosDirecciones.idLocalidad != 0){		
		$('#idLocalidadDenunciadoHidden').val(fila.datosDirecciones.idLocalidad);
		$('#idLocalidadDenunciadoExtHidden').val(fila.datosDirecciones.idLocalidad);
	}else{
		$('#idLocalidadDenunciadoHidden').val("");
		$('#idLocalidadDenunciadoExtHidden').val("");
	}
	$('#idCalleDenunciado').val(fila.datosDirecciones.direccion);
	$('#idNumeroDenunciado').val(fila.datosDirecciones.numero);
	$('#idEscaleraDenunciado').val(fila.datosDirecciones.escalera);
	
	$('#idPisoDenunciado').val(fila.datosDirecciones.piso);
	$('#idLetraDenunciado').val(fila.datosDirecciones.letra);
	$('#idCodigoPostalDenunciado').val(fila.datosDirecciones.codigoPostal);
	$('#telefonoDenunciado').val(fila.telefono);
	
	$('#descProvinciaExtranjeraUbicEmpresa').val(fila.datosDirecciones.descProvinciaExtranjera);
	$('#descCiudadExtranjeraUbicEmpresa').val(fila.datosDirecciones.descCiudadExtranjera);
	$('#idCalleDenunciadoExt').val(fila.datosDirecciones.direccion);
	$('#idNumeroDenunciadoExt').val(fila.datosDirecciones.numeroExtranjeraAgencia);
	$('#idPisoDenunciadoExt').val(fila.datosDirecciones.pisoExtranjeraAgencia);
	$('#idLetraDenunciadoExt').val(fila.datosDirecciones.letraExtranjeraAgencia);
	$('#idCodigoPostalDenunciadoExt').val(fila.datosDirecciones.codigoPostalExtranjeraAgencia);
	$('#idPaisHiddenExt').val(fila.datosDirecciones.idPais);
	$('#idEscaleraDenunciadoExtHidden').val(fila.datosDirecciones.escalera);
	
	setTimeout(function(){ 
		$("#idProvinciaDenunciado").rup_combo("reload");
	}, 0);
	setTimeout(function(){ 
		$("#idMunicipioDenunciado").rup_combo("reload");
	}, 0);
	setTimeout(function(){ 
		$("#idLocalidadDenunciado").rup_combo("reload");
	}, 0);
	setTimeout(function(){ 
		$("#idPaisSolicitante").rup_combo("reload");
	}, 0);
	
	document.getElementById("paisEspRdo").disabled = false;
	document.getElementById("paisOtrosRdo").disabled = false;
	if(fila.datosDirecciones.idPais != null && fila.datosDirecciones.idPais != 0 && fila.datosDirecciones.idPais != 108){
		$("#paisEspRdo").prop("checked", false);
		$("#paisOtrosRdo").prop("checked", true);
		
//		$("#paisOtrosRdo").removeClass("d-none");
//		$("#lblPaisOtroRdo").removeClass("d-none");
	} else {
		$("#paisEspRdo").prop("checked", true);
		$("#paisOtrosRdo").prop("checked", false);
		
//		$('#paisOtrosRdo').addClass("d-none");
//		$("#lblPaisOtroRdo").addClass("d-none");
	}
	document.getElementById("paisEspRdo").disabled = true;
	document.getElementById("paisOtrosRdo").disabled = true;
}

function validarTipo(idTercero, documento, nombreCompuesto){
	$.rup_messages("msgConfirm", {
	     title: $.rup.i18n.app.mensajes.titulo,
	     message: $.rup.i18n.app.mensajes.confirmacionAltaAfectado.replace("{0}", documento + " - " + nombreCompuesto),
	     OKFunction: function(){

	    	bloquearInterfaz();
	    	 $.ajax({
				url: "/ab78WebAppWar/denuncias/ficha-denuncia/insertarParticipacion",
				type: "POST",
				data: {"folderId": $("#folderId").val(), "idTercero": idTercero, "idExpediente": $("#idExpediente").val()},
				success: function() {
					
					$("#btnGuardar").click();
					
					$('#miniBuscador').rup_dialog("close");
				},
				error: function() {
					$('#miniBuscador').rup_dialog("close");
					setTimeout(function(){ 
						$("#idPaisSolicitante").rup_combo('disable')
					}, 1000);
					desbloquearInterfaz();
					$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
				}
			});
	    	 	
		}
	});
}

function insertarParteInculpada(idTercero){
	$.rup_messages("msgConfirm", {
	     title: $.rup.i18n.app.mensajes.titulo,
	     message: $.rup.i18n.app.msg.setParteInculpada,
	     OKFunction: function(){
			bloquearInterfaz();
			 $.ajax({
					url: "/ab78WebAppWar/denuncias/ficha-denuncia/insertarParteInculpada",
					type: "POST",
					data: {"idTercero": idTercero, "idExpediente": $("#idExpediente").val()},
					success: function() {
						var idRecTer = $("#subTipo" + idTercero + "HiddenValue").val().split("#")[0]
						$("#subTipo" + idTercero + "HiddenValue").val(idRecTer + "#1")
						$("#subTipo" + idTercero + "Hidden").val(1)
						$("#subTipo" + idTercero).rup_combo("setRupValue", $("#subTipo" + idTercero + "Hidden").val())
						
						$("#btnGuardar").click();	
						
						$('#miniBuscador').rup_dialog("close");
						setTimeout(function(){ 
							$("#idPaisSolicitante").rup_combo('disable')
						}, 1000);
					},
					error: function() {
						$('#miniBuscador').rup_dialog("close");
						setTimeout(function(){ 
							$("#idPaisSolicitante").rup_combo('disable')
						}, 1000);
						desbloquearInterfaz();
						$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
					}
				});
	     	}
	});
}

function findEstablecimientoSetDireccion(value){
	bloquearInterfaz();
	value = value.toUpperCase();
	if(value == null || value === 0 || value === "" || !/\w{3}\d{5}/.test(value)){
		$("#identificadorEstablecimiento").val("");
		$("#idEstablecimiento").val("");
		$("#fichaDenunciaBusqEstFeedback").rup_feedback("set",$.rup.i18n.app.msg.establecimientoNoEncontrado,"alert");
		desbloquearInterfaz();
	}else if (/\w{3}\d{5}/.test(value)){
		
		$.get("/ab78WebAppWar/searchEstablecimiento?q="+value, function(data) {
			desbloquearInterfaz();
			data = JSON.parse(data);
			if(data.length > 0){
				$('#idEstablecimiento').val(data[0].idEstablecimiento);
				$('#nombreComercial').val(data[0].descrNombre);
				$('#idProvinciaDenunciadoHidden').val(data[0].datosDirecciones.idProvincia);
				$('#idProvinciaDenunciadoExtHidden').val(data[0].datosDirecciones.idProvincia);
				
				$('#idMunicipioDenunciadoHidden').val(data[0].datosDirecciones.idMunicipio);
				$('#idMunicipioDenunciadoExtHidden').val(data[0].datosDirecciones.idMunicipio);
				
				$('#idLocalidadDenunciadoHidden').val(data[0].datosDirecciones.idLocalidad);
				$('#idLocalidadDenunciadoExtHidden').val(data[0].datosDirecciones.idLocalidad);
				
				$('#idCalleDenunciado').val(data[0].datosDirecciones.direccion);
				$('#idNumeroDenunciado').val(data[0].datosDirecciones.numero);
				
				$('#idEscaleraDenunciado').val(data[0].datosDirecciones.escalera);
				$('#idEscaleraDenunciadoExtHidden').val(data[0].datosDirecciones.escalera);
				
				$('#idPisoDenunciado').val(data[0].datosDirecciones.piso);
				$('#idLetraDenunciado').val(data[0].datosDirecciones.letra);
				$('#idCodigoPostalDenunciado').val(data[0].datosDirecciones.codigoPostal);
				$('#telefonoDenunciado').val(data[0].telefono);
				setTimeout(function(){ 
					$("#idProvinciaDenunciado").rup_combo("reload");
				}, 0);
				setTimeout(function(){ 
					$("#idMunicipioDenunciado").rup_combo("reload");
				}, 0);
				setTimeout(function(){ 
					$("#idLocalidadDenunciado").rup_combo("reload");
				}, 0);
				
			}else{
				$("#identificadorEstablecimiento").val("");
				$("#idEstablecimiento").val("");
				$("#fichaDenunciaBusqEstFeedback").rup_feedback("set",$.rup.i18n.app.msg.establecimientoNoEncontrado,"alert");
				
			}
		});
	}
	
}


function cargarComboOtrosPaises(){
//Cargamos combo de otros paises
$("#idPaisSolicitante").rup_combo({
	source: "/ab78WebAppWar/nora/paisesOtros",
	blank: "",
//	width: 300,
	sourceParam: {
		label: "dsO",
		value: "id"
	},
	onLoadSuccess : function() {
		$("#idPaisSolicitante").rup_combo("setRupValue", $("#idPaisHiddenExt").val());
	},		
	select : function() {
		$("#idPaisHiddenExt").val($("#idPaisSolicitante").val());	
	},
	change: function() {
		
	},
	open: function(){
		
	}
})

}

function cargarCamposDenunciaFormal() {
	
	$("#idComboProductos").rup_combo({
		blank:"",
		source: "/ab78WebAppWar/maestros/productos/procedimientos/" + $("#idProcedimiento").val(),
		sourceParam: {
		    label: (("es"===$.rup_utils.get("language")) ? "descTipoEs": "descTipoEu"),
			value: "idProducto"
		},
		width : 400,
		onLoadSuccess : function() {
			$("#idComboProductos").rup_combo("setRupValue", $("#idComboProductosHidden").val());
//			$("#controlCambios").val(0);
			changesValue(false);
		},
		select : function() {
			$("#idComboProductosHidden").val($("#idComboProductos").val());
		}
	});
	
	$("#idComboTipoVenta").rup_combo({
		blank:"",
		source: "/ab78WebAppWar/maestros/tipoVentas/procedimientos/" + $("#idProcedimiento").val(),
		sourceParam: {
		    label: (("es"===$.rup_utils.get("language")) ? "descTipoEs": "descTipoEu"),
			value: "idTipoVenta"
		},
		width : 250,
		onLoadSuccess : function() {
			$("#idComboTipoVenta").rup_combo("setRupValue", $("#idComboTipoVentaHidden").val());
			changesValue(false);
		},
		select : function() {
			$("#idComboTipoVentaHidden").val($("#idComboTipoVenta").val());
		}
	});
	
	$("#idComboDecision").rup_combo({
		blank:"",
		source: "/ab78WebAppWar/maestros/decisiones/formales/" + $("#idProcedimiento").val(),
		sourceParam: {
			label: (("es"===$.rup_utils.get("language")) ? "descTipoEs": "descTipoEu"),
			value: "idDecision"
		},
		width : 550,
		onLoadSuccess : function() {
			$("#idComboDecision").rup_combo("setRupValue", $("#idComboDecisionHidden").val());
			changesValue(false);
		},
		select : function() {
			$("#idComboDecisionHidden").val($("#idComboDecision").val());
		}
	});
}

function cargarCamposDenunciaNoFormal() {
	//idComboDecision
	$("#idComboDecision").rup_combo({
		blank:"",
		source: "/ab78WebAppWar/maestros/decisiones/no-formales",
		sourceParam: {
		    label: (("es"===$.rup_utils.get("language")) ? "descTipoEs": "descTipoEu"),
			value: "idDecision"
		},
		width : 550,
		onLoadSuccess : function() {
			$("#idComboDecision").rup_combo("setRupValue", $("#idComboDecisionHidden").val());
			changesValue(false);
			
			if($("#idComboDecision").val() === '15'){
				$("#observacionesDecision").addClass("required");
			}
		},
		select : function() {
			$("#idComboDecisionHidden").val($("#idComboDecision").val());
		}
	});
	
	$("#idComboDecision").on("change", function(){
		if($("#idComboDecision").val() === '15'){
			$("#observacionesDecision").addClass("required");
		}
		else {
			$("#observacionesDecision").removeClass("required");
		}
	});
	
	$("#selectSexo").rup_combo({
		source: "/ab78WebAppWar/sexos/verValorCombo",
		blank: "",
		sourceParam: {
			label: getLocaleOption("descripcionCastellano", "descripcionEuskera"),
			value: "idSexo"
		},
		width: 250,
		onLoadSuccess : function() {
			var selectSexoHidden = $("#selectSexoHidden").val();
			$("#selectSexo").rup_combo("setRupValue", selectSexoHidden);
			
			$("#selectSexo").rup_combo("disable");
		},
		select : function() {
			$("#selectSexoHidden").val($("#selectSexo").val());
		},
		change: function() {
			$("#controlCambios").val(1);
		},
		open: function(){
			$("#selectSexo-menu").width(
				$("#selectSexo-button").width()
			);
		}
	});
}

function radioButtonPais(){
	var valueEstPais = $("input[name='radioPais']:checked").val();
	if(1 == valueEstPais){
		//Mostramos/Ocultamos form según radioButton
		$("#paisEsp")[0].style.display = 'block';
		$("#paisOtro")[0].style.display = 'none';
		
		//Añadimos/Quitamos sufijo "HH"
		$('.controlOtros').each(function() {
		    this.name = this.name + "HH"
		})
		$('.controlEsp').each(function() {
			if("HH" == this.name.slice(-2)){
				this.name = this.name.slice(0, -2)
			}
		})
		
		if(document.getElementById("divTelefonoDenunciado")){
			$("#divTelefonoDenunciado").show();
		}
	}else{
		//Mostramos/Ocultamos form según radioButton
		if($("#paisOtro").length > 0 || $("#paisEsp").length > 0){
		$("#paisOtro")[0].style.display = 'block';
		$("#paisEsp")[0].style.display = 'none';
		}
		//Añadimos/Quitamos sufijo "HH"
		$('.controlEsp').each(function() {
		    this.name = this.name + "HH"
		})
		$('.controlOtros').each(function() {
			if("HH" == this.name.slice(-2)){
				this.name = this.name.slice(0, -2)
			}
		})
		
		if(document.getElementById("divTelefonoDenunciado")){
			$("#divTelefonoDenunciado").hide();
		}
		
	}
}

function validarDatosDistintos(valor_1, valor_2){
	
	if( valor_1 != null && valor_1 != '' && valor_1 != 0 && (valor_2 == null || valor_2 == '' || valor_2 == 0) ){
		//Uno de los datos recibidos es nulo o vacio y el otro esta informado
		return true;
	}else if( (valor_1 == null || valor_1 == '' || valor_1 == 0) && valor_2 != null && valor_2 != '' && valor_2 != 0){
		//Uno de los datos recibidos es nulo o vacio y el otro esta informado
		return true;
	}else if( (valor_1==null || valor_1=='' || valor_1==0) && (valor_2==null || valor_2=='' || valor_2==0) ){
		//Ambos datos recibidos son nulos o vacios
		return false;
	}else if( valor_1 != null && valor_1 != '' && valor_2 != null && valor_2 != '' && valor_1 != valor_2 ){
		//Los datos estan informados con valores distintos
		return true;
	}else{
		//Else por lo que son iguales los datos
		return false;
	}
	
}

function volverAsignarMismosDatosDireccion(){
	
	$.ajax({
	    url : '/ab78WebAppWar/datosdirecciones/'+$("#idDireccionEstablecimientoDenunciado").val() ,
	    type : 'GET',
	    dataType:'json',
	    contentType: "application/json",
	    async:false,
	    success : function(fila) {              

			$('#identificadorEstablecimiento').val(fila.identificadorEstablecimiento);
			$('#signaturaAsociada').val(fila.identificadorEstablecimiento);
			rellenarSignatura(fila.identificadorEstablecimiento);
			$('#searchIdentificador').val(fila.identificadorEstablecimiento);
			$('#searchIdentificador').val(fila.identificadorEstablecimiento);
			$('#nombreComercial').val(fila.establecimiento);
			$('#comboIdTipoEstablecimientoHidden').val($('#partLetra').val());
			if(fila.idProvincia != null && fila.idProvincia != 0){		
				$('#idProvinciaDenunciadoHidden').val(fila.idProvincia);
				$('#idProvinciaDenunciadoExtHidden').val(fila.idProvincia);
			}else{
				$('#idProvinciaDenunciadoHidden').val("");
				$('#idProvinciaDenunciadoExtHidden').val("");
			}
			if(fila.idMunicipio != null && fila.idMunicipio != 0){		
				$('#idMunicipioDenunciadoHidden').val(fila.idMunicipio);
				$('#idMunicipioDenunciadoExtHidden').val(fila.idMunicipio);
			}else{
				$('#idMunicipioDenunciadoHidden').val("");
				$('#idMunicipioDenunciadoExtHidden').val("");
			}
			if(fila.idLocalidad != null && fila.idLocalidad != 0){		
				$('#idLocalidadDenunciadoHidden').val(fila.idLocalidad);
				$('#idLocalidadDenunciadoExtHidden').val(fila.idLocalidad);
			}else{
				$('#idLocalidadDenunciadoHidden').val("");
				$('#idLocalidadDenunciadoExtHidden').val("");
			}
			$('#idCalleDenunciado').val(fila.direccion);
			$('#idNumeroDenunciado').val(fila.numero);
			
			$('#idEscaleraDenunciado').val(fila.escalera);
			$('#idEscaleraDenunciadoExtHidden').val(fila.escalera);
			
			$('#idPisoDenunciado').val(fila.piso);
			$('#idLetraDenunciado').val(fila.letra);
			$('#idCodigoPostalDenunciado').val(fila.codigoPostal);
			$('#telefonoDenunciado').val(fila.telefono);
			
			$('#descProvinciaExtranjeraUbicEmpresa').val(fila.descProvinciaExtranjera);
			$('#descCiudadExtranjeraUbicEmpresa').val(fila.descCiudadExtranjera);
			$('#idCalleDenunciadoExt').val(fila.direccion);
			$('#idNumeroDenunciadoExt').val(fila.numeroExtranjeraAgencia);
			$('#idPisoDenunciadoExt').val(fila.pisoExtranjeraAgencia);
			$('#idLetraDenunciadoExt').val(fila.letraExtranjeraAgencia);
			$('#idCodigoPostalDenunciadoExt').val(fila.codigoPostalExtranjeraAgencia);
			$('#idPaisHiddenExt').val(fila.idPais);
			
			if($("#idPaisHiddenExt").val() != null && $("#idPaisHiddenExt").val() != 0 && $("#idPaisHiddenExt").val()!= 108 && $("#idPaisHiddenExt").val() != ''){				
				$("#idPaisSolicitante").rup_combo("setRupValue", $("#idPaisHiddenExt").val());
			}
			
			document.getElementById("paisEspRdo").disabled = false;
			document.getElementById("paisOtrosRdo").disabled = false;
			if(fila.idPais != null && fila.idPais != 0 && fila.idPais != 108){
				$("#paisEspRdo").prop("checked", false);
				$("#paisOtrosRdo").prop("checked", true);
			} else {
				$("#paisEspRdo").prop("checked", true);
				$("#paisOtrosRdo").prop("checked", false);
			}
			document.getElementById("paisEspRdo").disabled = true;
			document.getElementById("paisOtrosRdo").disabled = true;
			
			radioButtonPais();
	    }
	});
		
}

function validarDireccionUbicacion(){
	
	var numeroRegistro = $("#identificadorEstablecimiento").val();
	var returnThis = true;
	
	if($('#indTipoReclamacionHidden').val() == 0){
		
		if(numeroRegistro != null && numeroRegistro != ""){	
	
			$.ajax({
				type: "GET",
				url: CTX_PATH + "datosdirecciones/buscarEstablecimiento/" + $("#identificadorEstablecimiento").val(),
				contentType: "application/json",
				dataType: "json",
				async: false,
				success: function(data){
					desbloquearInterfaz();
					if(data !== null){
						var datosDistintosUbicacion = false;
	
						var establecimiento = data.establecimiento;
						if( validarDatosDistintos($("#nombreComercial").val() , establecimiento) ){
							datosDistintosUbicacion = true;
						}
						
						var codigoProvincia = (data.provincia != null && data.provincia.id != null && data.provincia.id != ''?pad(data.provincia.id, 2):null);
						if( validarDatosDistintos(pad($("#idProvinciaDenunciadoHidden").val(), 2) , codigoProvincia) ){
							datosDistintosUbicacion = true;
						}
						
						var codigoMunicipio = (data.municipio != null && data.municipio.id != null && data.municipio.id != ''?pad(data.municipio.id, 3):null);
						if( validarDatosDistintos(pad($("#idMunicipioDenunciado").val(), 3) , codigoMunicipio) ){
							datosDistintosUbicacion = true;
						}
						
						var localidad = data.localidad.id;
						if( validarDatosDistintos($("#idLocalidadDenunciadoHidden").val() , localidad) ){
							datosDistintosUbicacion = true;
						}
						
						var direccion = data.direccion;
						if( validarDatosDistintos($("#idCalleDenunciado").val() , direccion) ){
							datosDistintosUbicacion = true;
						}
						
						var numeroUbicacion = data.numero;
						if( validarDatosDistintos($("#idNumeroDenunciado").val() , numeroUbicacion) ){
							datosDistintosUbicacion = true;
						}
	
						var escalera = data.escalera;
						if( validarDatosDistintos($("#idEscaleraDenunciado").val() , escalera) ){
							datosDistintosUbicacion = true;
						}
	
						var piso = data.piso;
						if( validarDatosDistintos($("#idPisoDenunciado").val() , piso) ){
							datosDistintosUbicacion = true;
						}
						
						var letra = data.letra;
						if( validarDatosDistintos($("#idLetraDenunciado").val() , letra) ){
							datosDistintosUbicacion = true;
						}
						
						var codPostal = data.codigoPostal;
						if( validarDatosDistintos($("#idCodigoPostalDenunciado").val() , codPostal) ){
							datosDistintosUbicacion = true;
						}	
						
						if(datosDistintosUbicacion){
							$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
							$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.datosDireccionNoCoincidenConCensoTurismo, "alert");
							returnThis = false;
						}else{
							returnThis = true;
						}
					} else {
						$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
						$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.buscarEstablecimientoVacio, "alert");
						returnThis = false;
					}					
				},
				error: function(data){
					desbloquearInterfaz();
					$("#fichaDenunciaFeedback").rup_feedback({ gotoTop : false, block : false, closeLink : true });
					$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.mensajes.buscarEstablecimientoError, "error");
					returnThis = false;
				}
			});
		}

	}else{
		returnThis = true;
	}
	
	return returnThis;
	
}