//bloquearInterfaz!==undefined && bloquearInterfaz();
jQuery(function($) {		
		$("#busqEst").rup_datatable({
			primaryKey: "idEstablecimiento",
			loadOnStartUp: false,
			pagingType: "full_numbers",
			dom: 'rt<"bottom"lip>',
			pageLength : 5,
			lengthMenu: [5, 10, 25, 50],
			order: [[ 0, 'asc' ]],
			autoWidth: false,
			filter:{
		  		id:"busqEst_filter_form",
		  		filterToolbar:"busqEst_filter_toolbar",
		  		collapsableLayerId:"busqEst_filter_fieldset"
		 	},		 	
	    	columnDefs: [
		 		{
		 			targets: [0],
		 			visible: false
		 		},
		 		{
	    			targets: [1],
	    			width: "15%"
	    		},
	    		{
	    			targets: [2],
	    			width: "20%"
	    		},
	    		{
	    			targets: [3],
	    			width: "25%"
	    		},
	    		{
	    			targets: [4],
	    			width: "15%"
	    		}
			]
	    });
		
		$("#busqEstFeedback").rup_feedback({
			closeLink : true,
			block : false,
			gotoTop : false
		});
		
		$('#busqEstLimpiar').on("click", function(){
			limpiarMiniBuscador();
		});
		
		
		$('#busqEstFilterBtnAux').on("click", function(){
			if($('#busqEst_filter_form').valid()){
				$('#busqEst_filter_filterButton').click();
			}
		});
		
		
		var tbl = $('#busqEst').DataTable();
		var fila = null;

		$('#busqEst tbody').on( 'click', 'tr', function () {
			fila = tbl.row(this).data();
			if ($(this).hasClass('selected')) {
		        $(this).removeClass('selected');
		        $('#busqEstSeleccionar').addClass("disabled");
		        fila = null;
		    }else{
		    	tbl.$('tr.selected').removeClass('selected');
		        $(this).addClass('selected');
		        $('#busqEstSeleccionar').removeClass("disabled");
		    }
		});
		
		$('#busqEst tbody').on( 'dblclick', 'tr', function () {
			fila = tbl.row(this).data();
			if ($(this).hasClass('selected')) {
		        $(this).removeClass('selected');
		        $('#busqEstSeleccionar').addClass("disabled");
		        fila = null;
		    }else{
		    	tbl.$('tr.selected').removeClass('selected');
		        $(this).addClass('selected');
		        $('#busqEstSeleccionar').removeClass("disabled");
		    }
		});
		
		$('#busqEst tbody').on('dblclick', 'tr', function () {
			if(fila != null){
				seleccionarEstablecimiento(fila);
			}
		});
		
		$('#busqEstSeleccionar').on("click", function(){
			if(fila != null){
				seleccionarEstablecimiento(fila);
			}
		});
		
		
		$("#busqEst_filter_form").rup_validate({
			feedback: $('#busqEstFeedback'),
			liveCheckingErrors: false,
			showFieldErrorAsDefault: true,
			showErrorsInFeedback: true,
			showFieldErrorsInFeedback:true, 
			rules:{
				"datosDirecciones.idProvincia":{digits:true},
				"datosDirecciones.idMunicipio":{digits:true},
				"datosDirecciones.numero":{digits:true},
				"datosDirecciones.piso":{digits:true},
				"datosDirecciones.codigoPostal":{digits:true, minlength:5}
			}
		});
		
		
		tbl.on('xhr', function(event, settings, data, response) {
			desbloquearInterfaz();
			if (null != data && 200 === response.status) {
				setTimeout(function(){
					$("#divTblBusqEst .pagination").css("width", "max-content");						
				}, 0)
				$('#divTblBusqEst').removeClass("d-none");
				window.scrollTo(0, document.body.scrollHeight);
			}
		});
		
		$('#miniBuscador').rup_dialog({
			title: $.rup.i18n.app.titulos.busqEst,
			autoOpen: false,
			width: 1100,
			modal: true,
			position: {my: "left top", at: "left+400 top+100", of: document},
			type: $.rup.dialog.DIV,
			open: function(event, ui) {				
				$('#miniBuscador').removeClass("d-none");
				$("#comboIdTipoEstablecimientoBuscador").rup_combo({
					blank:"",
					source: "/ab78WebAppWar/maestros/tipoEstablecimiento",
					sourceParam: {
					    label: "descripcionDecorator",
						value: "idTipoEstablecimiento"
					},
					width : 220,
					onLoadSuccess : function() {
						$("#comboIdTipoEstablecimientoBuscador").rup_combo("setRupValue", $("#comboIdTipoEstablecimientoBuscadorHidden").val());
					},
					select : function() {
						$("#comboIdTipoEstablecimientoBuscadorHidden").val($("#comboIdTipoEstablecimientoBuscador").val());
					}
				});
				
				$("#idProvinciaSolicitante").rup_combo({
					source: "/ab78WebAppWar/nora/provincias",
					blank: "",
					sourceParam: {
						label: "dsO",
						value: "id"
					},
					onLoadSuccess : function() {						
						$("#idProvinciaHidden").removeAttr('readonly');
						var idProvincia = pad($("#idProvinciaHidden").val(),2);
						$("#idProvinciaSolicitante").rup_combo("setRupValue", idProvincia);
						
						$("#idMunicipioHidden").removeAttr('readonly');
						
						if($("#idProvinciaHidden").val() == 00){
							$("#idProvinciaHidden").val("");
						}
						
						if($("#idMunicipioHidden").val() == 000){
							$("#idMunicipioHidden").val("");
						}
						
						$("#idMunicipioSolicitante").rup_combo({
							source: "/ab78WebAppWar/nora/municipios",
							parent: ["idProvinciaSolicitante"],
							blank: "",
							sourceParam: {
								label: "dsO",
								value: "id"
							},
							onLoadSuccess : function() {
								if("" === $("#idMunicipioHidden").val()){									
									$("#idMunicipioSolicitante").rup_combo("setRupValue", "");									
								}else{									
									var idMunicipio = pad($("#idMunicipioHidden").val(),3);
									$("#idMunicipioSolicitante").rup_combo("setRupValue", idMunicipio);									
								}
							},
							select : function() {
								$("#idMunicipioHidden").val($("#idMunicipioSolicitante").val());
								$("#idLocalidadSolicitante").rup_combo("setRupValue", "");
								$("#idLocalidadHidden").val("");
							},
							change: function() {
								
							},
							open: function(){
								$("#idMunicipioSolicitante-menu").width(
									$("#idMunicipioSolicitante-button").width()
								);
							}
						});
						
						$("#idLocalidadSolicitante").rup_combo({
							source: "/ab78WebAppWar/nora/localidades",
							parent: ["idProvinciaSolicitante", "idMunicipioSolicitante"],
							blank: "",
							sourceParam: {
								label: "dsO",
								value: "id"
							},
							onLoadSuccess : function() {
								var idLocalidad = $("#idLocalidadHidden").val();
								$("#idLocalidadSolicitante").rup_combo("setRupValue", idLocalidad);
							},
							select : function() {
								$("#idLocalidadHidden").val($("#idLocalidadSolicitante").val());
							},
							change: function(){
							},
							open: function(){
								$("#idLocalidadSolicitante-menu").width(
										$("#idLocalidadSolicitante-button").width()
								);
							}								
						});	
					},
					select : function() {
						$("#idProvinciaHidden").val($("#idProvinciaSolicitante").val());
						$("#idMunicipioHidden").val("");
						$("#idMunicipioSolicitante").rup_combo("setRupValue", "");
						
						$("#idLocalidadSolicitante").rup_combo("setRupValue", "");
						$("#idLocalidadHidden").val("");
					},
					change: function() {				
					},
					open: function(){
						$("#idProvinciaSolicitante-menu").width(
							$("#idProvinciaSolicitante-button").width()
						);
					}
				});
				
				$("#idProvinciaHidden").on("change", function(){					
					var idProvinciaHidden =  $("#idProvinciaHidden").val() !== "" ? pad($("#idProvinciaHidden").val(), 2): "";
					$("#idProvinciaHidden").val(idProvinciaHidden);
					$("#idProvinciaSolicitante").rup_combo("setRupValue", idProvinciaHidden);
					$("#idMunicipioHidden").val("");
					$("#idMunicipioSolicitante").rup_combo("setRupValue", "");
					$("#idLocalidadSolicitante").rup_combo("setRupValue", "");
					$("#idLocalidadHidden").val("");
				});
				
				
				
				$("#idMunicipioHidden").on("change", function(){					
					var idMunicipioHidden =  $("#idMunicipioHidden").val() !== "" ? pad($("#idMunicipioHidden").val(),3): "";
					$("#idMunicipioHidden").val(idMunicipioHidden);
					$("#idMunicipioSolicitante").rup_combo("setRupValue", idMunicipioHidden);
					$("#idLocalidadSolicitante").rup_combo("setRupValue", "");
					$("#idLocalidadHidden").val("");
				});
				
				$('#busqEst').DataTable().clear().draw(true);	
			},
			close:function() {
				limpiarMiniBuscador();
				$('#busqEstSeleccionar').addClass("disabled");
				radioButtonPais();
			}
		});
		
		

		
		
		
//		Funcion radioButtonPais al inicializar y en onChange
		radioButtonPais();
		$("input[name='radioPais']").on("change", radioButtonPais);
		
//		Llamamos a esta funcion al cambiar entre "España" y "Otros paises" en la actividad turistica
//		Ocultamos/mostramos dependiendo del radioButton
//		Cambiamos los names de los inputs añadiendo/quitando sufijo "HH" (clases .controlEsp para form de españa y controlOtros para form Otros paises) para que al guardar no se cojan esos valores
		function radioButtonPais(){
			var valueEstPais = $("input[name='radioPais']:checked").val();
			if(1 == valueEstPais){
				//Mostramos/Ocultamos form según radioButton
				$("#paisEsp")[0].style.display = 'block';
				$("#paisOtro")[0].style.display = 'none';
				
				//Añadimos/Quitamos sufijo "HH"
				$('.controlOtros').each(function() {
				    this.name = this.name + "HH"
				})
				$('.controlEsp').each(function() {
					if("HH" == this.name.slice(-2)){
						this.name = this.name.slice(0, -2)
					}
				})
				
				if(document.getElementById("divTelefonoDenunciado")){
					$("#divTelefonoDenunciado").show();
				}
			}else{
				//Mostramos/Ocultamos form según radioButton
				if($("#paisOtro").length > 0 || $("#paisEsp").length > 0){
				$("#paisOtro")[0].style.display = 'block';
				$("#paisEsp")[0].style.display = 'none';
				}
				//Añadimos/Quitamos sufijo "HH"
				$('.controlEsp').each(function() {
				    this.name = this.name + "HH"
				})
				$('.controlOtros').each(function() {
					if("HH" == this.name.slice(-2)){
						this.name = this.name.slice(0, -2)
					}
				})
				
				if(document.getElementById("divTelefonoDenunciado")){
					$("#divTelefonoDenunciado").hide();
				}
				
			}
		}
		
		
		// Si la actividad turistica es de España se vacia el form de "Otros paisess" y viceversa
		if($("#paisOtro").length > 0 || $("#paisEsp").length > 0){
		clearNotChecked();
		}
		
		function clearNotChecked(){
			var valueEstPais = $("input[name='radioPais']:checked").val();
			if(1 == valueEstPais){
				$('.controlOtros').each(function() {
				    this.value = ""
				})
				$("#idProvinciaDenunciado").rup_combo("setRupValue", "")
				$("#idMunicipioDenunciado").rup_combo("setRupValue", "")
				$("#idLocalidadDenunciado").rup_combo("setRupValue", "")
			}else{
				$('.controlEsp').each(function() {
				    this.value = ""
				})
				$("#idPaisSolicitante").rup_combo("setRupValue", "")
				$("#idMunicipioDenunciado").rup_combo("setRupValue", "")
				$("#idLocalidadDenunciado").rup_combo("setRupValue", "")
			}
		}

	

});

function limpiarMiniBuscador(){
	$("#comboIdTipoEstablecimientoBuscadorHidden").val("");
	$("#comboIdTipoEstablecimientoBuscador").val("");
	$("#comboIdTipoEstablecimientoBuscador").rup_combo("setRupValue", "");
	$("#comboIdTipoEstablecimientoBuscador").rup_combo("reload");
	
	$("#idProvinciaHidden").val("");
	$("#idProvinciaSolicitante").val("");
	$("#idProvinciaSolicitante").rup_combo("setRupValue", "");
	$("#idProvinciaSolicitante").rup_combo("reload");
	
	$("#idMunicipioHidden").val("");
	$("#idMunicipioSolicitante").val("");
	$("#idMunicipioSolicitante").rup_combo("setRupValue", "");
	$("#idMunicipioSolicitante").rup_combo("reload");
	
	$("#idLocalidadHidden").val("");
	$("#idLocalidadSolicitante").val("");
	$("#idLocalidadSolicitante").rup_combo("setRupValue", "");
	$("#idLocalidadSolicitante").rup_combo("reload");
	$('#busqEst_filter_form').rup_form("resetForm");
	
	$("#comboIdTipoEstablecimientoBuscadorHidden").val("0");
	$('#busqEst').DataTable().clear().draw(true);
	$("#comboIdTipoEstablecimientoBuscadorHidden").val("");
}