var idExpediente = $('#idExpediente').val();
var expedienteValidado = $('#expedienteValidado').val();

jQuery(function($) {
	
	$("#btnGuardar").click(function(){
		// Si expediente de oficio debe asociar el establecimiento
		/*if(isValidForm()){			
			confirmDialog(guardarExpedienteEstablecimiento, $.rup.i18n.app.mensajes.confirmarOperacion);
		}*/
		if($('#procedureId').val() === '1114101') {
			if($("#idComboDecision").val() === '15' && $("#observacionesDecisionEs").val() === '') {
				$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.otrosMotivosDesc, "error");
				return;
			}
			var isAnyChecked = false;
			$(".check-irregularidad").each(function () {
				if($(this).is(':checked')){
					isAnyChecked = true;
					return false;
				}
			});
			if(!isAnyChecked){
				$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.irregularidadNecesaria, "error");
				return;
			}
		}
        if($('#formDenuncia').valid() && validarDireccionUbicacion()){
			if($("#indTipoReclamacionHidden").val() === '1'){
				if($('#comboIdTipoEstablecimiento').val() === '') {
					$('#comboIdTipoEstablecimientoHidden').val(null);
				} else {
					$('#comboIdTipoEstablecimientoHidden').val($('#comboIdTipoEstablecimiento').val());
				}
				borrarCensado();
				$('#signaturaAsociada').val("");
				$('#searchIdentificador').val("");
			}
			$('#importeHidden').val($('#importe').val());
			bloquearInterfaz();
			$('#formDenuncia').submit();
			inicializaControlCambios("formDenuncia");
		}
	});
	
	
	$("#btnAction").length > 0 && $("#btnAction").click(tryExecuteAction);

	
	$("#btnCenso").click(function(){
		if(controlCambios()){
//		if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
			$.rup_messages("msgConfirm", {		
				title:  $.rup.i18n.app.mensajes.titulo,
				message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
				OKFunction: function(){
					$(".container #btnGuardar").click();
					bloquearInterfaz();
					abrirEnPestania("/ab63WebAppWar/establecimientos/maint/" + $("#identificadorEstablecimiento").val());
				},
				CANCELFunction: function(){
					bloquearInterfaz();
					abrirEnPestania("/ab63WebAppWar/establecimientos/maint/" + $("#identificadorEstablecimiento").val());
				}
			});
		}
		else{
			bloquearInterfaz();
			abrirEnPestania("/ab63WebAppWar/establecimientos/maint/" + $("#identificadorEstablecimiento").val());
		}	
	});
	
	$("#btnEnlaceIns").click(function(){
		if(controlCambios()){
//		if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
			$.rup_messages("msgConfirm", {		
				title:  $.rup.i18n.app.mensajes.titulo,
				message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
				OKFunction: function(){
					$(".container #btnGuardar").click();
					bloquearInterfaz();
					irInspecciones();
				},
				CANCELFunction: function(){
					bloquearInterfaz();
					irInspecciones();
				}
			});
		}
		else{
			bloquearInterfaz();
			irInspecciones();
		}	
	});
	
	$("#btnVolverABusqueda").click(function() {
		sessionStorage.setItem("botonVolver", true);
		location.href = "/ab78WebAppWar";
	});
});

//Botón de Generar Documetos de Plantilla	
$("#btnGenerarDoc").on("click", function () {	
	if(controlCambios()){
//	if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
		// hay cambios en la pantalla, deberiamos mostrar mensaje de que hay cambios
		$.rup_messages("msgConfirm", {		
			title:  $.rup.i18n.app.mensajes.titulo,
			message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
			OKFunction: function(){
				$(".container #btnGuardar").click();
				var idExpediente=$('#idExpediente').val();
				var idProcedimiento =$('#procedureId').val();
				var isExpedienteOficio =$('#isExpedienteOficio').val();
				var url = "/ab78WebAppWar/plantillas/maint/" + idProcedimiento+"/" + idExpediente+"/" + isExpedienteOficio;
				abrirDialogoPlantillaSinBotones(url);
			},
			CANCELFunction: function(){
				var idExpediente=$('#idExpediente').val();
				var idProcedimiento =$('#procedureId').val();
				var isExpedienteOficio =$('#isExpedienteOficio').val();
				var url = "/ab78WebAppWar/plantillas/maint/" + idProcedimiento+"/" + idExpediente+"/" + isExpedienteOficio;
				abrirDialogoPlantillaSinBotones(url);
			}
		});
	}else{
		// si no hay cambios, accedemos directamente al controller
		var idExpediente=$('#idExpediente').val();
		var idProcedimiento =$('#procedureId').val();
		var isExpedienteOficio =$('#isExpedienteOficio').val();
		var url = "/ab78WebAppWar/plantillas/maint/" + idProcedimiento+"/" + idExpediente+"/" + isExpedienteOficio;
		abrirDialogoPlantillaSinBotones(url);
	}	
});

$("#btnVerDocumentos").click(function() {
	if($("#tipoDenuncia").val() === TIPO_DENUNCIA_NO_FORMAL && $("#folderId").val()){
		$("#fichaDenunciaFeedback").rup_feedback("set", $.rup.i18n.app.msg.verDocumentosDenunciaNoFormal, "alert");
	} else {
		window.open($("#urlVerDocumentosHidden").val(), '_blank');
	}
});

function tryExecuteAction(){
	if(isValidForm()){		
		confirmDialog(executeAction, $.rup.i18n.app.mensajes.confirmarOperacion);
	}
}

function executeAction(){
	bloquearInterfaz();
	disableButton("#btnAction");
	var idExpediente = $("#idExpediente").val();
	if(idExpediente){
		sendExecuteAction(idExpediente);
	}else{
		$("#fichaExpGeneralfeedBack").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
	}
}

function sendExecuteAction(idExpediente){
	var url = '/ab78WebAppWar/fichaExpediente/procesar/'+idExpediente;

	if($("#formSolicitante").length > 0) {
		url += "?"+ $("#formSolicitante").serialize();
	}
	
	$.ajax({
		url: url,
		method: 'POST',
		data: initFormToJson(),
		success: successRequestGuardarEstablecimientos,
		error: errorSendRequest
	});
}

function abrirDialogoPlantillaSinBotones(urlDestino) {
	$("#dialogs").rup_dialog({
		type: $.rup.dialog.AJAX,
		url: urlDestino ,
		autoOpen: true,
		modal: true,
		width: 800,
		resizable: true
	});	
}


function guardarExpedienteEstablecimiento(){
	bloquearInterfaz();
	disableButton("#btnGuardar");
	var idExpediente = $("#idExpediente").val();
	if(idExpediente){
		sendGuardarExpedienteEstablecimiento(idExpediente);
	}else{
		$("#fichaExpGeneralfeedBack").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
	}
}




function sendGuardarExpedienteEstablecimiento(idExpediente){
	var url = '/ab78WebAppWar/fichaExpediente/guardar/'+idExpediente;
	if($("#formSolicitante").length > 0) {
		url += "?"+ $("#formSolicitante").serialize();
	}
	
	$.ajax({
		url: url,
		method: 'POST',
		data: initFormToJson(),
		success: successRequestGuardarEstablecimientos,
		error: errorSendRequest
	});
}

function actualizarTitulo(response){
	if(response.result){
		$.each(response.data, function(key, value){
			if(key === "titleUpdated"){
				$("#tituloExpediente").text(value);
				$("#tituloExpediente").attr("title", value);
				var qTitle = $("#tituloExpediente").attr("aria-describedby");
				$("#{0}-content".replace("{0}", qTitle)).text(value);
				$("#tituloExpedienteCompleto").val(value);
			}
		});
	}
}

function successRequestGuardarEstablecimientos(response){
	desbloquearInterfaz();
//	response = JSON.parse(response);
	var msg = $.rup.i18n.app.msg[response.message]; 
	enableButton("#btnGuardar");
	if(response.result){
		$.each(response.data, function(key, value){
			if(key === "idTercero"){
				$("#idTerceroSolicitante").val(value);
				$("#idSolicitanteUbicacion").val(value);
			}
			if(key === "titleUpdated"){
				$("#tituloExpediente").val(value);
			}
			if(key === "titleComplete"){
				$("#tituloExp").text(value);
				$("#tituloExp").attr("title", value);
				var qTitle = $("#tituloExp").attr("aria-describedby");
				$("#{0}-content".replace("{0}", qTitle)).text(value);
				$("#tituloExpedienteCompleto").val(value);
			}
		});
		var operacion = $("#btnGuardar").attr("title");
		msg = msg.replace("{0}", operacion);	
		$("#fichaExpGeneralfeedBack").rup_feedback("set", msg, "ok");
		executeCallback(response);
	}else{
		if(msg === null || msg === undefined){
			msg =  $.rup.i18n.app.mensajes.error[response.message];
		}
		$("#fichaExpGeneralfeedBack").rup_feedback("set", msg, "error");
		console.warn(response.error);
	}
}

function disabledFormControls(){
	$("input[type='radio']").attr("disabled", "disabled" );
	$(".form-control").attr("readonly", "readonly" );
	$(".rup_combo").rup_combo("disable")
}

function checkUbicacionEstablecimiento(){
	if($("#idProvinciaUbicacion").length > 0){
		var idProv = $("#idProvinciaUbicacion").rup_combo("getRupValue");
		var idMun = $("#idMunicipioUbicacion").rup_combo("getRupValue");
		//var idLoc = $("#idLocalidadUbicacion").rup_combo("getRupValue");
		var direccion = $("#direccionUbicacion").val();
		return !(isNullOrEmpty(idProv) || isNullOrEmpty(idMun) /*|| isNullOrEmpty(idLoc)*/ || isNullOrEmpty(direccion));		
	}
	return true;
}

function isNullOrEmpty(value){ 
	return value == null || value ===""; 
}

function showIdentificador(datos){
	if($("#identificadorEst").length > 0){
		$("#identificadorEst").val(datos.identificadorDefinitivo);
		$("#identificadorContainer").removeClass("hide");
	}
	$("#identificadorEstablecimiento").val(datos.identificadorDefinitivo);
	var msg = $.rup.i18n.app.mensajes.OK.establecimientoCensado.replace("{0}", datos.identificadorDefinitivo);
	$.rup_messages("msgOK", {
		title: "Correcto",
		message: msg
	});
	$("#btnGuardar").unbind("click");
	$("#btnGuardar").addClass("disabled");
	$("#btnAction").unbind("click");
	$("#btnAction").addClass("disabled");
	$("#btnCenso").removeClass("disabled");
	disabledFormControls();
}

function enableInspect(){	
	enableButton($("#btnInspeccionar"));
	enableButton($("#btnGenerarDoc"));
	 $("#btnCenso").removeClass("disabled");
}


function updateButtonsCeseSuccess(){
	$("#btnGuardar").unbind("click");
	disableButton($("#btnGuardar"));
	$("#btnCenso").removeClass("disabled");
	$("#searchIdentificador").length > 0 && disableAutoIdent();
}

function disableAutoIdent(){
	$("#searchIdentificador").rup_autocomplete("off");
	$("#searchIdentificador").rup_autocomplete("disable");
	disabledFormControls();
}

function irInspecciones(){
	abrirEnPestania("/ab79WebAppWar/fichadeinspeccion/maint/" + $("#idInspeccionExpediente").val());
}

function successUpdateEst() {
	bloquearInterfaz();
	$("#initForm").submit();
}

function isValidForm(){
	var msg = "";
	if(!checkUbicacionEstablecimiento()){
		msg += $.rup.i18n.app.mensajes.error.sinUbicacionEstablecimiento;
	}
	if($("#isExpedienteOficio").val() === "true" 
		&& ( $("#identificadorEstablecimiento").val() === "" 
			 || !/\w{3}\d{5}/.test($("#identificadorEstablecimiento").val()))){
		if(msg!==""){
			msg  += "<br>";
		}
		msg += $.rup.i18n.app.mensajes.error.sinEstablecimiento;
	}
	if($("#procedureCod").val() === "0012804" && $("#dispensadoObser").val() ==  ""){
		if(msg!==""){
			msg  += "<br>";
		}
		msg += $.rup.i18n.app.mensajes.error.sinDispensa;
	}
	if($("#procedureCod").val() === "0012804" && $("#dispensadoObser").val() === "1" && !hasObservaciones()){
		if(msg!==""){
			msg  += "<br>";
		}
		msg += $.rup.i18n.app.mensajes.error.observaciones;
	}
	if(msg !== ""){
		$("#fichaExpGeneralfeedBack").rup_feedback("set", msg, "error");
		return false;
	}
	if($("#identificadorEstablecimiento").val() !== "" &&  $("#identificadorEst").length > 0){
		var identificadorEst = $("#identificadorEst").val();
		if(identificadorEst!==""){
			$("#identificadorEstablecimiento").val(identificadorEst);
		}else{
			$("#fichaExpGeneralfeedBack").rup_feedback("set",  $.rup.i18n.app.mensajes.error.sinEstablecimiento, "error");
			return false;
		}
	}
	if($("#idComboDecision").val() === '15' && $("#observacionesDecisionEs").val() === '') {
		$("#fichaExpGeneralfeedBack").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
		return false;
	}
	return true;
}

function hasObservaciones(){
	 var observaciones = $("#observaciones").val();
	 var isNotNullOrEmpty =!(observaciones === null || observaciones === "");
	 var observacionesArr = observaciones.split("###");
	 var isEmptyAnyField = (observacionesArr[0] === "" || observacionesArr[1]==="");
	return isNotNullOrEmpty  && !isEmptyAnyField;
}
