$(document).ready(function(){
	
	// Feedback
	$("#listados_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
	
	$("#comboProcedimientos").rup_combo({
		blank : "",
		source : "/ab78WebAppWar/procedimientos/combo/censo",
		sourceParam : {
			label: getLocaleOption("descripcionEsLabel", "descripcionEuLabel"),
			value : "idProcedimiento"
		},
		select: function() {
			$("#datosBusqueda").html("");
			$("#comboListado").hasClass("rup_combo")&&$("#comboListado").rup_combo("setRupValue","");
			cargarComboBusquedas();
		},
		width: 700,
		order: false,
		onLoadSuccess : function() {
			var idProcedimientoInitForm = $("#idProcedimientoInitForm").val();
			$("#comboProcedimientos").rup_combo("setRupValue", idProcedimientoInitForm);
			cargarComboBusquedas();
		},
	});
	
});

function cargarComboBusquedas(){
	var idProcedimiento = $("#comboProcedimientos").val();
	if ("" !== idProcedimiento) {
		$("#comboListado").rup_combo({
			blank : "",
			//source : "/ab78WebAppWar/listados/getAllListadoProc/"+idProcedimiento,
			source : "/ab78WebAppWar/listados/getRelLisProByProc/"+idProcedimiento,
			sourceParam : {
				label : "nombre",
				value : "idListado"
			},
			order: false,
			select: function() {
				var idListado = $("#comboListado").val();
				$("#datosBusqueda").html("");
				if ("" !== idListado) {
					$.ajax({	
				        url: "/ab78WebAppWar/busquedas/"+idListado,
				        type: "GET",
				        success: function(respuesta) {
				        	tratarRespuesta(respuesta);
				        },
				        error: function(){

				        }
				     });
				}
			},
			width: 500
		});
	}
}

function tratarRespuesta(respuesta){
	//pintar lista de busquedas y parametros de la busqueda
	var jsonResultado = JSON.parse(respuesta);
	var html = "";
	$.each(jsonResultado, function(indexBusqueda, busqueda) {
			html += "<div class=''>"
					    +"<input type='checkbox' class='busquedaschecked' value=" + busqueda.idBusqueda + " onchange='habilitarDesabilitarBoton();'> </input> "
				    + "<b>" + busqueda.nombre + "</b> </br></br>";
			$.each(busqueda.parametros, function(indexParametro, parametros) {
				if ("eu"==$.rup_utils.get("language")){
					html +="<div class='row'><div class='col-3'>" 
							+ parametros.textoMostrar 
						+"</div>"
						+"<div class='col-9'>"
							+"<input type='text' id='"+ parametros.idParametro + "' class='"+ busqueda.idBusqueda +""+(parametros.tipoParametro != null && parametros.tipoParametro == 1?' rup_date rupDateListados':'')+"'> </input>"	
						+"</div></div></br>"	
				}else{
					html +="<div class='row'><div class='col-3'>" 
							+ parametros.textoMostrar 
						+"</div>"
						+"<div class='col-9'>"
							+"<input type='text' id='"+ parametros.idParametro + "' class='"+ busqueda.idBusqueda +""+(parametros.tipoParametro != null && parametros.tipoParametro == 1?' rup_date rupDateListados':'')+"'> </input>"	
						+"</div></div></br>"	
				}
			html += "</div>";
		});
		html += "</div>";
	});
	if (null !== respuesta && "" !== respuesta) {
		html += "</br></br> <button type='button' id='btnEjecutar' class='.btn btn-primary ui-button ui-corner-all ui-widget disabled'>" + $("#botonCrearListado").val() +"</button></br></br>"
	}
	$("#datosBusqueda").html(html);
	
	$("#form_listado").rup_form({
		url : "/ab78WebAppWar/listados/llamarWebService",
		type : "POST",
		contentType : "application/json",
		dataType : 'json',
		success : function(respuesta) {
			desbloquearInterfaz();
			$("#rutaPIF").val(respuesta);
			$("#form_PIF").submit();
		}, 
		error : function (respuesta){
			desbloquearInterfaz();
				$("#listados_feedback").rup_feedback({ gotoTop : true, block : false, closeLink : true });
				$("#listados_feedback").rup_feedback("set",respuesta.responseText, "error");
			
		}
	});
	
	var fechaActual = new Date();
	
	var dd = String(fechaActual.getDate()).padStart(2, '0');
	var mm = String(fechaActual.getMonth() + 1).padStart(2, '0'); 
	var yyyy = fechaActual.getFullYear();
	
	
	var fechaEsp = dd + "/" + mm + "/" + yyyy;
	
	$(".rup_date").each(function() {
		$("#"+this.id).rup_date({
			maxDate:  fechaEsp
		});
	});
	
	$("#btnEjecutar").click(function(){
		var resultado = "";
		
		var error = false;
		
		var parametroVacio = false;
		
		$(".rup_date").each(function() {
			if(!isNaN(obtenerObjetoDate($("#"+this.id).val()))){
				if(obtenerObjetoDate($("#"+this.id).val()) > obtenerObjetoDate(fechaEsp)){
					error = true;
				}
			}
		});
		
		if(error){
			$("#listados_feedback").rup_feedback("set", $.rup.i18n.app.msg.fechaMayorActual, "error");
		}else{
			$(".busquedaschecked").each(function () {
				if($(this).is(':checked')){
					var idBusqueda = $(this).val();
					resultado += idBusqueda + "#";
					//recogemos los parametros de esa busqueda
					var parametros = $("."+idBusqueda);
					$.each(parametros, function() {
						if(!$(this).val()){
							parametroVacio = true;
						}
						resultado += $(this).attr("id") + "@" + $(this).val() +",";
					});
					resultado +="&";
				}	
			});
			if(parametroVacio){
				$("#listados_feedback").rup_feedback("set",$.rup.i18n.app.msg.parametroVacio, "error");
			}else{
				//submitimos el resultado
				$("#resultado").val(resultado);
				bloquearInterfaz();
				$("#form_listado").submit();
			}
		}
	});
	
}


function habilitarDesabilitarBoton(){
	
	var algunoSeleccionado = false;
	$(".busquedaschecked").each(function () {
		if($(this).is(':checked')){
			algunoSeleccionado = true;
		}
	});
	
	if(algunoSeleccionado){
		$("#btnEjecutar").removeClass("disabled");
	}else{
		$("#btnEjecutar").addClass("disabled");
	}
}

function obtenerObjetoDate(dateString) {
    var parts = dateString.split('/');
    return new Date(parts[2], parts[1] - 1, parts[0]);
}