var placeholder = $.rup.lang === 'es' ? "dd/mm/aaaa" : "uuuu/hh/ee";

$(document).ready(
		function() {

			$.rup_date({
				from : "fechaPresentacionDesdeFilter",
				to : "fechaPresentacionHastaFilter"
			})

			$.rup_date({
				from : "fechaHechosDesdeFilter",
				to : "fechaHechosHastaFilter"
			})

			$.rup_date({
				from : "fechaDecisionDesdeFilter",
				to : "fechaDecisionHastaFilter"
			})

			$('#busqDenunciasFeedback').rup_feedback({
				block : false
			});

			/** **FORMULARIO FILTRADO*** */
			$('#busqDenuncias_filter_form').rup_validate({
				feedback : $('#busqDenunciasFeedback'),
				liveCheckingErrors : false,
				showFieldErrorAsDefault : true,
				showErrorsInFeedback : true,
				showFieldErrorsInFeedback : true,
				rules : {
					"filter.fechaPresentacionDesde" : {
						date : true
					},
					"filter.fechaPresentacionHasta" : {
						date : true
					},
					"filter.fechaHechosDesde" : {
						date : true
					},
					"filter.fechaHechosHasta" : {
						date : true
					},
					"filter.fechaDecisionDesde" : {
						date : true
					},
					"filter.fechaDecisionHasta" : {
						date : true
					},
					"filter.datosDirecciones.idProvincia" : {
						digits : true
					},
					"filter.datosDirecciones.idMunicipio" : {
						digits : true
					},
					"filter.datosDirecciones.numero" : {
						digits : true
					},
					"filter.datosDirecciones.piso" : {
						digits : true
					},
					"filter.datosDirecciones.codigoPostal" : {
						digits : true,
						minlength : 5
					}
				}
			});
			
			/** **TABLA RESULTADOS*** */

			$('#busqDenuncias').rup_datatable({

				primaryKey : "idExpediente",
				loadOnStartUp : false,
				stateSave: true,
				stateSaveCallback: function(settings,data) {
					localStorage.setItem( 'DataTables_' + settings.sInstance, JSON.stringify(data) );
				},
				stateLoadCallback: function(settings) {
					if(sessionStorage.getItem("botonVolver") === "true"){
						return JSON.parse( localStorage.getItem( 'DataTables_' + settings.sInstance ) );
					} else {
						return '';
					}
				},
				pagingType : "full_numbers",
				dom : 'rt<"bottom"lip>',
				pageLength : 25,
				lengthMenu : [ 5, 10, 25, 50 ],
				order : [ [ 4, 'desc' ] ],
				autoWidth : false,
				filter : {
					id : "busqDenuncias_filter_form",
					filterToolbar : "busqDenuncias_filter_toolbar",
					collapsableLayerId : "busqDenuncias_filter_fieldset"
				},
				columnDefs : [ {
					targets : [ 0, 1 ],
					visible : false
				}, {
					targets : [ 2 ],
					width : "12%"
				}, {
					targets : [ 3 ],
					width : "10%"
				}, {
					targets : [ 4 ],
					width : "6%"
				}, {
					targets : [ 5 ],
					width : "12%"
				}, {
					targets : [ 6 ],
					width : "11%"
				}, {
					targets : [ 7 ],
					width : "23%"
				}, {
					targets : [ 8 ],
					render: function (data, type, row, meta) {
						if(data != null) {
							return '<a href="/ab79WebAppWar/fichadeinspeccion/maint/' + row.idInspeccion + '" target="_blank" style="color:#000000;">' + data + '</a>';
						}
					},
					width : "11%"
				}, {
					targets : [ 9 ],
					width : "15%",
					visible: (("es" === $.rup_utils.get("language")) ? true : false)
				}, {
					targets : [ 10 ],
					width : "15%",
					visible: (("eu" === $.rup_utils.get("language")) ? true : false)
				} ],
				responsive : true,
				initComplete : function() {
					if(sessionStorage.getItem("botonVolver") === "true"){
						if(sessionStorage.getItem("busqueda") == null){
							sessionStorage.removeItem("botonVolver")
						}else{
							cargarValoresPreviosEnBusq();
					        $("html, body").animate({ scrollTop: $(document).height() }, 1000);
					        setTimeout(function(){$("#btnBuscarDenuncias").click();	}, 0);		
						}
					}

				}
			});

			var table = $('#busqDenuncias').DataTable();
			var fila = null;
			
			table.on('click', 'tr', function() {
				fila = table.row(this).data();
				if (undefined !== fila && null !== fila) {
					if ($(this).hasClass('selected')) {
						$(this).removeClass('selected');
						fila = null;
						$('#btnAccederDenuncia').prop("disabled", true);
					} else {
						table.$('tr.selected').removeClass('selected');
						$(this).addClass('selected');
						$('#btnAccederDenuncia').prop("disabled", false);
					}
				}

			});
			
			table.on('dblclick', 'tr', function() {
				fila = table.row(this).data();
				if (null != fila) {
					accederFichaDenuncia(fila);
				}

			});

			table.on('xhr', function(event, settings, data, response) {
				desbloquearInterfaz();
				if (null != data && 200 === response.status) {
					setTimeout(function(){
						$("#divTblBusqDenuncias .pagination").css("width", "max-content");						
					}, 0)
					$('#divTblBusqDenuncias').removeClass("d-none");
					window.scrollTo(0, document.body.scrollHeight);
				}
			});

			table.on('error', function() {
				$('#divTblBusqDenuncias').addClass("d-none");
				$('#busqDenunciasFeedback').rup_feedback("set",
						$.rup.i18n.app.mensajes.error.busqueda, "error");
			});

			// Evita mostrar alerta con error datatable
			// [https://datatables.net/forums/discussion/8763/disable-error-reporting]
			$.fn.dataTableExt.sErrMode = 'throw';// "null"

			/** **BOTONES*** */

			$('#btnBuscarDenuncias').on(
					'click',
					function() {
						fila = null;
						$('#btnAccederDenuncia').prop("disabled", true);
						if ($('#busqDenuncias_filter_form').valid()) {
							
							if($("#tieneInspeccion").is(':checked')) {
						    	$('#tieneInspeccion').prop("value", true);
							  } else {
							    $('#tieneInspeccion').prop("value", false);
							  }
							
							
							if($("#isFormal").is(':checked')) {
						    	$('#isFormal').prop("value", true);
							  } else {
							    	$('#isFormal').prop("value", false);
							  }
							guardarFiltroForm();
							
							var partLetra = $("#partLetra").val();
							var partProv = $("#partProv").val();
							var partSequencia = $("#partSequencia").val();

							$("#searchIdentificador").val(
									partLetra + partProv + partSequencia);
							
							bloquearInterfaz();
							$('#busqDenuncias_filter_filterButton').click();
						}
					});

			$('#btnLimpiarBuscadorDenuncias').on('click', function() {
				$('#divTblBusqDenuncias').addClass("d-none");
				limpiarFormBuscador();
			});

			$('#btnAccederDenuncia').on('click', function() {
				accederFichaDenuncia(fila);
			});

			cargarCombosBuscador();
			cargarFechasBuscador();
			cargarCombosDireccion();
			buscarAvisos();

		});

function cargarCombosBuscador() {

	$('#comboIdDireccionFilter')
			.rup_combo(
					{
						blank : "",
						source : "/ab78WebAppWar/direcciones",
						sourceParam : {
							label : (("es" === $.rup_utils.get("language")) ? "descripcionCastellano"
									: "descripcionEuskera"),
							value : "idDireccion"
						},
						width : 230,
						onLoadSuccess : function() {
							
							if(typeof DIRECCION_PRECARGADA !== "undefined" && DIRECCION_PRECARGADA !== null && DIRECCION_PRECARGADA !== "") {
								$("#comboIdDireccionFilter").rup_combo("setRupValue", DIRECCION_PRECARGADA);
								$("#comboIdDireccionFilter").rup_combo("disable");
							}
							
							$("#comboIdDireccionFilterHidden").val($("#comboIdDireccionFilter").val());
							
							var idDireccionHidden = $("#comboIdDireccionFilter").val();
							
							if(idDireccionHidden == "undefined" || idDireccionHidden == null || idDireccionHidden == ""){
			
									idDireccionHidden = "0";
								
							}
							
							$('#codProcedureId_filter_table').rup_combo(
									{
										
										blank : "",
										source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro/" + idDireccionHidden,
										sourceParam : {
											label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
													: "descripcionEu"),
											value : "idProcedimiento"
										},
										width: 610,
										onLoadSuccess : function() {
											
											var idProcedimientoHidden = $("#codProcedureId_filter_tableHidden").val();
											$("#codProcedureId_filter_table").rup_combo("setRupValue", idProcedimientoHidden);		

										},
										change: function(){

											$("#codProcedureId_filter_tableHidden").val($("#codProcedureId_filter_table").val());
										},
										select : function() {
											$('#codProcedureId_filter_tableHidden').val(
													$('#codProcedureId_filter_table').val());
										}
									});

						},
						change: function(){

							$("#comboIdDireccionFilterHidden").val($("#comboIdDireccionFilter").val());
							
							var idDireccionHidden = $("#comboIdDireccionFilterHidden").val();
							
							
							if(idDireccionHidden == ""){
								
								idDireccionHidden = "0";
								
							}
					
							$('#codProcedureId_filter_table').rup_combo(
									{
										
										blank : "",
										source : "/ab78WebAppWar/procedimientos/combo/tablaMaestro/" + idDireccionHidden,
										sourceParam : {
											label : (("es" === $.rup_utils.get("language")) ? "descripcionEs"
													: "descripcionEu"),
											value : "idProcedimiento"
										},
										width: 610,
										onLoadSuccess : function() {
											var idProcedimientoHidden = $("#codProcedureId_filter_tableHidden").val();
											$("#codProcedureId_filter_table").rup_combo("setRupValue", idProcedimientoHidden);		

										},
										change: function(){

											$("#codProcedureId_filter_tableHidden").val($("#codProcedureId_filter_table").val());
										},
										select : function() {
											$('#codProcedureId_filter_tableHidden').val(
													$('#codProcedureId_filter_table').val());
										}
									});
							
						},
						select : function() {
							$('#comboIdDireccionFilterHidden').val(
									$('#comboIdDireccionFilter').val());
						}
					});

	$('#comboIdTipoEstablecimientoFilter')
			.rup_combo(
					{
						blank : "",
						source : "/ab78WebAppWar/maestros/tipoEstablecimiento",
						sourceParam : {
							label : (("es" === $.rup_utils.get("language")) ? "descripcionCastellano"
									: "descripcionEuskera"),
							value : "idTipoEstablecimiento"
						},
						onLoadSuccess : function() {
							var idTipoEstabHidden = $("#comboIdTipoEstablecimientoFilterHidden").val();
							$("#comboIdTipoEstablecimientoFilter").rup_combo("setRupValue", idTipoEstabHidden);
						},
						width : 230,
						select : function() {
							$('#comboIdTipoEstablecimientoFilterHidden').val(
									$('#comboIdTipoEstablecimientoFilter')
											.val());
						}
					});

	$('#comboIdTipoReclamacionFilter')
			.rup_combo(
					{
						blank : "",
						source : "/ab78WebAppWar/maestros/tipoReclamaciones",
						sourceParam : {
							label : (("es" === $.rup_utils.get("language")) ? "descTipoEs"
									: "descTipoEu"),
							value : "idTipoReclamacion"
						},
						onLoadSuccess : function() {
							var idReclamacionHidden = $("#comboIdTipoReclamacionFilterHidden").val();
							$("#comboIdTipoReclamacionFilter").rup_combo("setRupValue", idReclamacionHidden);
						},
						width : 230,
						select : function() {
							$('#comboIdTipoReclamacionFilterHidden').val(
									$('#comboIdTipoReclamacionFilter').val());
						}
					});

	$('#comboIdDecisionFilter')
			.rup_combo(
					{
						blank : "",
						source : "/ab78WebAppWar/maestros/decisiones/formales",
						sourceParam : {
							label : (("es" === $.rup_utils.get("language")) ? "descTipoEs"
									: "descTipoEu"),
							value : "idDecision"
						},onLoadSuccess : function() {
							var idReclamacionHidden = $("#comboIdDecisionFilterHidden").val();
							$("#comboIdDecisionFilter").rup_combo("setRupValue", idReclamacionHidden);
						},
						width : 230,
						select : function() {
							$('#comboIdDecisionFilterHidden').val(
									$('#comboIdDecisionFilter').val());
						}
					});

	$('#comboIndMotivoFilter')
			.rup_combo(
					{
						blank : "",
						ordered:false,
						source : "/ab78WebAppWar/maestros/motivos/motivosGetAll",
						sourceParam : {
							label : (("es" === $.rup_utils.get("language")) ? "descMotivoEs"
									: "descMotivoEu"),
							value : "idMotivo"
						},
						onLoadSuccess : function() {
							var idReclamacionHidden = $("#comboIndMotivoFilterHidden").val();
							$("#comboIndMotivoFilter").rup_combo("setRupValue", idReclamacionHidden);
						},
						width : 230,
						select : function() {
							$('#comboIndMotivoFilterHidden').val(
									$('#comboIndMotivoFilter').val());
						}
					});

	$('#comboIndTipoReclamacionFilter').rup_combo(
			{
				blank : "",
				source : [ {
					i18nCaption : $.rup.i18n.app.combo.censado,
					value : "0"
				}, {
					i18nCaption : $.rup.i18n.app.combo.noCensado,
					value : "1"
				} ],
				width : 230,
				onLoadSuccess : function() {
					var idReclamacionHidden = $("#comboIndTipoReclamacionFilterHidden").val();
					$("#comboIndTipoReclamacionFilter").rup_combo("setRupValue", idReclamacionHidden);
				},
				select : function() {
					$('#comboIndTipoReclamacionFilterHidden').val(
							$('#comboIndTipoReclamacionFilter').val());
				}
			});

	$('#comboTiposTerceroFilter').rup_combo(
			{
				source : "/ab78WebAppWar/tipostercero",
				sourceParam : {
					label : getLocaleOption("descripcionCastellano",
							"descripcionEuskera"),
					value : "idTipoTercero",
					style : "css"
				},
				onLoadSuccess : function() {
					var idReclamacionHidden = $("#comboTiposTerceroFilterHidden").val();
					$("#comboTiposTerceroFilter").rup_combo("setRupValue", idReclamacionHidden);
				},
				blank : "",
				select : function() {
					$('#comboTiposTerceroFilterHidden').val(
							$('#comboTiposTerceroFilter').val());
				}
			});

	$('#comboTiposDocInteresadoFilter').rup_combo(
			{
				source : "/ab78WebAppWar/tiposdocumento",
				sourceParam : {
					label : getLocaleOption("descripcionCastellano",
							"descripcionEuskera"),
					value : "idTipoDocumento",
					style : "css"
				},
				blank : "",
				onLoadSuccess : function() {
					var idReclamacionHidden = $("#comboTiposDocInteresadoFilterHidden").val();
					$("#comboTiposDocInteresadoFilter").rup_combo("setRupValue", idReclamacionHidden);
				},
				select : function() {
					$('#comboTiposDocInteresadoFilterHidden').val(
							$('#comboTiposDocInteresadoFilter').val());
				}
			});

	$("#searchIdentificador").length && setAutocompleteSearchByIdentificador({
		find : false,
		filter : []
	});

}

function cargarFechasBuscador() {

	$('#fechaPresentacionDesdeFilter').prop("placeholder", placeholder);
	$('#fechaPresentacionHastaFilter').prop("placeholder", placeholder);
	$('#fechaHechosDesdeFilter').prop("placeholder", placeholder);
	$('#fechaHechosHastaFilter').prop("placeholder", placeholder);
	$('#fechaDecisionDesdeFilter').prop("placeholder", placeholder);
	$('#fechaDecisionHastaFilter').prop("placeholder", placeholder);

	$('#fechaPresentacionDesdeFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaPresentacionDesdeFilter').val() === "" ? $(
			'#fechaPresentacionDesdeFilter').rup_date("setDate", "") : $(
			'#fechaPresentacionDesdeFilter').rup_date("setDate",
			new Date($('#fechaPresentacionDesdeFilter').val()));

	$('#fechaPresentacionHastaFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaPresentacionHastaFilter').val() === "" ? $(
			'#fechaPresentacionHastaFilter').rup_date("setDate", "") : $(
			'#fechaPresentacionHastaFilter').rup_date("setDate",
			new Date($('#fechaPresentacionHastaFilter').val()));

	$('#fechaHechosDesdeFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaHechosDesdeFilter').val() === "" ? $('#fechaHechosDesdeFilter')
			.rup_date("setDate", "") : $('#fechaHechosDesdeFilter').rup_date(
			"setDate", new Date($('#fechaHechosDesdeFilter').val()));

	$('#fechaHechosHastaFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaHechosHastaFilter').val() === "" ? $('#fechaHechosHastaFilter')
			.rup_date("setDate", "") : $('#fechaHechosHastaFilter').rup_date(
			"setDate", new Date($('#fechaHechosHastaFilter').val()));

	$('#fechaDecisionDesdeFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaDecisionDesdeFilter').val() === "" ? $('#fechaDecisionDesdeFilter')
			.rup_date("setDate", "")
			: $('#fechaDecisionDesdeFilter').rup_date("setDate",
					new Date($('#fechaDecisionDesdeFilter').val()));

	$('#fechaDecisionHastaFilter').rup_date({
		labelMaskId : "fecha-mask"
	});

	$('#fechaDecisionHastaFilter').val() === "" ? $('#fechaDecisionHastaFilter')
			.rup_date("setDate", "")
			: $('#fechaDecisionHastaFilter').rup_date("setDate",
					new Date($('#fechaDecisionHastaFilter').val()));
}

function cargarCombosDireccion() {
	$('#thPerfil').val() == ""
			&& $("#idMunicipioHidden").attr("disabled", "disabled");
	var isFirstLoad = true;

	$("#idProvinciaSolicitante")
			.rup_combo(
					{
						source : "/ab78WebAppWar/nora/provincias",
						blank : '',
						sourceParam : {
							label : "dsO",
							value : "id"
						},
						onLoadSuccess : function() {
							var idReclamacionHidden = $("#idProvinciaHidden").val();
							$("#idProvinciaSolicitante").rup_combo("setRupValue", idReclamacionHidden);
							
//							var idProvincia = pad(
//									"" !== $('#thPerfil').val() ? $('#thPerfil')
//											.val()
//											: $("#idProvinciaHidden").val(), 2);
//							if (idProvincia == "00") {
//								$("#idProvinciaSolicitante").rup_combo(
//										"setRupValue", "");
//								$("#idMunicipioHidden").attr("disabled",
//										"disabled");
//							} else {
//								$("#idProvinciaHidden").val(idProvincia)
//								var idProvinciaSolicitante = pad($(
//										"#idProvinciaHidden").val(), 2);
//								$("#idProvinciaSolicitante").rup_combo(
//										"setRupValue", idProvincia);
//	
//								$("#idMunicipioHidden").attr("disabled", null);
//							}
							var idDpto = pad(
									"" !== $('#dptoPerfil').val() ? $('#dptoPerfil')
											.val()
											: 0, 2);
							if(typeof idDpto !== 'undefined'){
								$("#comboIdDireccionFilter").rup_combo(
										"setRupValue", idDpto);
							}
							if (isFirstLoad) {
								isFirstLoad = false;
								setTimeout(
										function() {
											$("#idMunicipioSolicitante")
													.rup_combo(
															{
																source : "/ab78WebAppWar/nora/municipios",
																parent : [ "idProvinciaSolicitante" ],
																blank : "",
																sourceParam : {
																	label : "dsO",
																	value : "id"
																},
																onLoadSuccess : function() {
																	var idReclamacionHidden = $("#idMunicipioHidden").val();
																	$("#idMunicipioSolicitante").rup_combo("setRupValue", idReclamacionHidden);
																	if ($(
																			"#idMunicipioHidden")
																			.val() == "") {
																		desbloquearInterfaz();
																	}
																	var idMunicipioSolicitante = pad(
																			$(
																					"#idMunicipioHidden")
																					.val(),
																			3);
																	$(
																			"#idMunicipioSolicitante")
																			.rup_combo(
																					"setRupValue",
																					idMunicipioSolicitante);
																},
																select : function() {
																	$(
																			"#idMunicipioHidden")
																			.val(
																					$(
																							"#idMunicipioSolicitante")
																							.val());
																	$(
																			"#idLocalidadSolicitante")
																			.rup_combo(
																					"setRupValue",
																					"");
																	$(
																			"#idLocalidadHidden")
																			.val(
																					null);
																	if ($(
																			"#idMunicipioSolicitante")
																			.val() != "") {
																		var settings = $(
																				"#idLocalidadSolicitante")
																				.data(
																						"settings");
																		settings.ultimaLlamada = "";
																		$(
																				"#idLocalidadSolicitante")
																				.data(
																						"settings",
																						settings);
																		$(
																				"#idLocalidadSolicitante")
																				.rup_combo(
																						"reload");
																	}

																},
																open : function() {
																	$(
																			"#idMunicipioSolicitante-menu")
																			.width(
																					$(
																							"#idMunicipioSolicitante-button")
																							.width());
																}
															});
											setTimeout(
													function() {
														$(
																"#idLocalidadSolicitante")
																.rup_combo(
																		{
																			source : "/ab78WebAppWar/nora/localidades",
																			parent : [
																					"idProvinciaSolicitante",
																					"idMunicipioSolicitante" ],
																			blank : "",
																			sourceParam : {
																				label : "dsO",
																				value : "id"
																			},
																			onLoadSuccess : function() {
																				var idReclamacionHidden = $("#idLocalidadHidden").val();
																				$("#idLocalidadSolicitante").rup_combo("setRupValue", idReclamacionHidden);
																				var idLocalidadSolicitante = $(
																						"#idLocalidadHidden")
																						.val();
																				$(
																						"#idLocalidadSolicitante")
																						.rup_combo(
																								"setRupValue",
																								idLocalidadSolicitante);
																				desbloquearInterfaz();
																			},
																			select : function() {
																				$(
																						"#idLocalidadHidden")
																						.val(
																								$(
																										"#idLocalidadSolicitante")
																										.val());
																			},
																			open : function() {
																				$(
																						"#idLocalidadSolicitante-menu")
																						.width(
																								$(
																										"#idLocalidadSolicitante-button")
																										.width());
																			}
																		});

													}, 150);
										}, 150);
							}
							desbloquearInterfaz();
						},
						select : function() {
							$("#idProvinciaHidden").val(
									$("#idProvinciaSolicitante").val());
							$("#idMunicipioSolicitante").rup_combo(
									"setRupValue", "");
							$("#idMunicipioHidden").val(null);
							$("#idLocalidadSolicitante").rup_combo(
									"setRupValue", "");
							$("#idLocalidadHidden").val(null);
							var municipioState = "disabled";
							if ($("#idProvinciaSolicitante").val() != "") {
								municipioState = null;
								var settings = $("#idMunicipioSolicitante")
										.data("settings");
								settings.ultimaLlamada = "";
								$("#idMunicipioSolicitante").data("settings",
										settings);
								$("#idMunicipioSolicitante")
										.rup_combo("reload");
							}
							$("#idMunicipioHidden").attr("disabled",
									municipioState);
						},
						open : function() {
							$("#idProvinciaSolicitante-menu")
									.width(
											$("#idProvinciaSolicitante-button")
													.width());
						}
					});

	$("#idProvinciaHidden").on(	"change", function() {
						var idProvinciaHidden = $("#idProvinciaHidden").val() !== "" ? pad(
								$("#idProvinciaHidden").val(), 2)
								: "";
						$("#idProvinciaHidden").val(idProvinciaHidden);
						if (idProvinciaHidden == "") {
							$("#idMunicipioHidden")
									.attr("disabled", "disabled");
						} else {
							$("#idMunicipioHidden").attr("disabled", null);
						}
						$("#idProvinciaSolicitante").rup_combo("setRupValue",
								idProvinciaHidden);
						$("#idMunicipioHidden").val(null);
						$("#idMunicipioSolicitante").rup_combo("setRupValue",
								"");
						$("#idLocalidadHidden").val(null);
						$("#idLocalidadSolicitante").rup_combo("setRupValue",
								"");
						if ($("#idProvinciaSolicitante").val() != "") {
							var settings = $("#idMunicipioSolicitante").data(
									"settings");
							settings.ultimaLlamada = "";
							$("#idMunicipioSolicitante").data("settings",
									settings);
							$("#idMunicipioSolicitante").rup_combo("reload");
						}
					});

	$("#idMunicipioHidden")
			.on(
					"change",
					function() {
						var idMunicipioHidden = $("#idMunicipioHidden").val() !== "" ? pad(
								$("#idMunicipioHidden").val(), 3)
								: "";
						$("#idMunicipioHidden").val(idMunicipioHidden);
						$("#idMunicipioSolicitante").rup_combo("setRupValue",
								idMunicipioHidden);
						$("#idLocalidadSolicitante").rup_combo("setRupValue",
								"");
						$("#idLocalidadHidden").val(null);
						if ($("#idMunicipioSolicitante").val() != "") {
							var settings = $("#idLocalidadSolicitante").data(
									"settings");
							settings.ultimaLlamada = "";
							$("#idLocalidadSolicitante").data("settings",
									settings);
							$("#idLocalidadSolicitante").rup_combo("reload");
						}
					});

}
function limpiarFormBuscador() {
	var disableDirDpto = $('#comboIdDireccionFilter').rup_combo( "isDisabled")

	$('#busqDenuncias_filter_form').rup_form("resetForm");
	$('form input[type=hidden]').val("");

	$('.rup_combo').each(function() {
		$('#' + this.id + 'Hidden').val("");
		$('#' + this.id).val("");
		$('#' + this.id).rup_combo("setRupValue", "");
		$('#' + this.id + '-button .ui-selectmenu-status').html("----");
	});

	$("#idProvinciaHidden").val(null);
	$("#idMunicipioHidden").val(null);
	$("#idLocalidadHidden").val(null);
	cargarCombosDireccion();

	if ("" !== $('#dptoPerfil').val()) {
		$('#comboIdDireccionFilter').rup_combo("setRupValue",
				$('#dptoPerfil').val());
		$('#comboIdDireccionFilterHidden').val(
				$('#comboIdDireccionFilter').val());
		disableDirDpto && $('#comboIdDireccionFilter').rup_combo("disable");
	}

	if ("" !== $('#thPerfil').val()) {
		cargarCombosDireccion();
	}
	
	sessionStorage.removeItem("busqueda")
}

function accederFichaDenuncia(fila) {

	bloquearInterfaz();
	if (null != fila && (null != fila.folderId || null != fila.idReclamacion)) {
		if (null != fila.folderId) {
			window.location.href = "/ab78WebAppWar/denuncias/ficha-denuncia/"
					+ fila.folderId;
		} else {
			window.location.href = "/ab78WebAppWar/denuncias/ficha-denuncia/mig/"
					+ fila.idReclamacion;
		}
	} else {
		desbloquearInterfaz();
		$('#busqDenunciasFeedback').rup_feedback("set",
				$.rup.i18n.app.msg.errorGenerico, "error");
	}
}

function generarXLS() {
	bloquearInterfaz();
	$
			.ajaxTransport(
					"+binary",
					function(options, originalOptions, jqXHR) {
						if (window.FormData
								&& ((options.dataType && (options.dataType == 'binary')) || (options.data && ((window.ArrayBuffer && options.data instanceof ArrayBuffer) || (window.Blob && options.data instanceof Blob))))) {
							return {
								send : function(headers, callback) {
									var xhr = new XMLHttpRequest(), url = options.url, type = options.type, async = options.async || true, dataType = options.responseType
											|| "blob", data = options.data
											|| null, username = options.username
											|| null, password = options.password
											|| null;

									xhr.addEventListener('load', function() {
										var data = {};
										data[options.dataType] = xhr.response;
										callback(xhr.status, xhr.statusText,
												data,
												xhr.getAllResponseHeaders());
									});

									xhr.open(type, url, async, username,
											password);

									for ( var i in headers) {
										xhr.setRequestHeader(i, headers[i]);
									}

									xhr.responseType = dataType;
									xhr.send(data);
								},
								abort : function() {
									jqXHR.abort();
								}
							};
						}
					});
	var order = $("#busqDenuncias").DataTable().settings()[0].aoColumns[$(
			"#busqDenuncias").DataTable().order()[0][0]].sidx;
	var sort = $("#busqDenuncias").DataTable().order()[0][1];
	$.rup_ajax({
		url : '/ab78WebAppWar/expediente-denuncia/generarXLS?order=' + order
				+ '&sort=' + sort,
		method : "POST",
		data : $('#busqDenuncias_filter_form').serializeToObject(),
		dataType : 'binary',
		success : function(data, status, xhr) {
			var contentType = 'application/vnd.ms-excel';
			var filename = "";
			var disposition = xhr.getResponseHeader('Content-Disposition');
			if (disposition && disposition.indexOf('attachment') !== -1) {
				var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
				var matches = filenameRegex.exec(disposition);
				if (matches != null && matches[1])
					filename = matches[1].replace(/['"]/g, '');
			}
			console.log("FILENAME: " + filename);
			var blob = new Blob([ data ], {
				type : contentType
			});

			
			if(window.navigator.msSaveOrOpenBlob) {
			    //IE11 & Edge
			    window.navigator.msSaveOrOpenBlob(blob, fileName); 
			}else{
			var downloadUrl = URL.createObjectURL(blob);
			var a = document.createElement("a");
			a.href = downloadUrl;
			a.download = filename;
			document.body.appendChild(a);
			a.click();
			}
			desbloquearInterfaz();
		}
	});
}

function guardarFiltroForm() {
	
	var busqueda = {};
	
	$.each($("#busqDenuncias_filter_form").serializeArray(), function() {
		busqueda[this.name] = this.value;
	});
	
	sessionStorage.setItem("busqueda", JSON.stringify(busqueda));

}

function cargarValoresPreviosEnBusq(){
	
	var filtro = JSON.parse(sessionStorage.getItem("busqueda"));
	var botonVolver = sessionStorage.getItem("botonVolver");
	if(filtro !== null && botonVolver === "true"){


        sessionStorage.removeItem("botonVolver");
		var comboIdDireccionFilter = filtro["filter.direcciones.idDireccion"];			
		$("#comboIdDireccionFilterHidden").val(comboIdDireccionFilter ? comboIdDireccionFilter : "");
		$("#comboIdDireccionFilter").rup_combo("setRupValue", comboIdDireccionFilter ? comboIdDireccionFilter : "");
		
		var comboIdProcedimientoFilter = filtro["filter.idProcedimiento"];			
		$("#codProcedureId_filter_tableHidden").val(comboIdProcedimientoFilter ? comboIdProcedimientoFilter : "");
		
		$("#folderNumberFilter").val(filtro["filter.folderNumber"]);

		$("#tituloExpedienteFilter").val(filtro["filter.tituloExpediente"]);
		
		var comboInnactivosFilter = filtro["filter.filterInactivos"];			
		$("#comboInnactivosFilter").val(comboInnactivosFilter ? comboInnactivosFilter : "1");
		
		var comboIdTipoEstablecimientoFilter = filtro["filter.tipoEstablecimiento.idTipoEstablecimiento"];			
		$("#comboIdTipoEstablecimientoFilterHidden").val(comboIdTipoEstablecimientoFilter ? comboIdTipoEstablecimientoFilter : "");
		$("#comboIdTipoEstablecimientoFilter").rup_combo("setRupValue", comboIdTipoEstablecimientoFilter ? comboIdTipoEstablecimientoFilter : "");
		
		$("#nombreComercialFilter").val(filtro["filter.nombreComercial"]);

		var comboIdTipoReclamacionFilter = filtro["filter.tipoReclamacion.idTipoReclamacion"];			
		$("#comboIdTipoReclamacionFilterHidden").val(comboIdTipoReclamacionFilter ? comboIdTipoReclamacionFilter : "");
		$("#comboIdTipoReclamacionFilter").rup_combo("setRupValue", comboIdTipoReclamacionFilter ? comboIdTipoReclamacionFilter : "");
		
		$("#numReclamacionFilter").val(filtro["filter.numReclamacion"]);
		$("#numPaginaRecFilter").val(filtro["filter.numPaginaRec"]);

		$("#fechaPresentacionDesdeFilter").rup_date("setRupValue", filtro["filter.fechaPresentacionDesde"]);
		$("#fechaPresentacionHastaFilter").rup_date("setRupValue", filtro["filter.fechaPresentacionHasta"]);

		$("#fechaHechosDesdeFilter").rup_date("setRupValue", filtro["filter.fechaHechosDesde"]);
		$("#fechaHechosHastaFilter").rup_date("setRupValue", filtro["filter.fechaHechosHasta"]);

		$("#fechaDecisionDesdeFilter").rup_date("setRupValue", filtro["filter.fechaDecisionDesde"]);
		$("#fechaDecisionHastaFilter").rup_date("setRupValue", filtro["filter.fechaDecisionHasta"]);
		
		var comboIdDecisionFilter = filtro["filter.tipoDecision.idDecision"];			
		$("#comboIdDecisionFilterHidden").val(comboIdDecisionFilter ? comboIdDecisionFilter : "");
		$("#comboIdDecisionFilter").rup_combo("setRupValue", comboIdDecisionFilter ? comboIdDecisionFilter : "");
		
		var comboIndTipoReclamacionFilter = filtro["filter.indTipoReclamacion"];			
		$("#comboIndTipoReclamacionFilterHidden").val(comboIndTipoReclamacionFilter ? comboIndTipoReclamacionFilter : "");
		$("#comboIndTipoReclamacionFilter").rup_combo("setRupValue", comboIndTipoReclamacionFilter ? comboIndTipoReclamacionFilter : "");
		
		var comboIndMotivoFilter = filtro["filter.relacionMotivo.motivo.idMotivo"];			
		$("#comboIndMotivoFilterHidden").val(comboIndMotivoFilter ? comboIndMotivoFilter : "");
		$("#comboIndMotivoFilter").rup_combo("setRupValue", comboIndMotivoFilter ? comboIndMotivoFilter : "");
		
		$("#motivoEspecifico").val(filtro["filter.relacionMotivo.descMotivo"]);

		var comboTiposTerceroFilter = filtro["filter.datosTerceros.tiposTercero.idTipoTercero"];			
		$("#comboTiposTerceroFilterHidden").val(comboTiposTerceroFilter ? comboTiposTerceroFilter : "");
		$("#comboTiposTerceroFilter").rup_combo("setRupValue", comboTiposTerceroFilter ? comboTiposTerceroFilter : "");
		
		var comboTiposDocInteresadoFilter = filtro["filter.datosTerceros.tiposDocumento.idTipoDocumento"];			
		$("#comboTiposDocInteresadoFilterHidden").val(comboTiposDocInteresadoFilter ? comboTiposDocInteresadoFilter : "");
		$("#comboTiposDocInteresadoFilter").rup_combo("setRupValue", comboTiposDocInteresadoFilter ? comboTiposDocInteresadoFilter : "");
		
		$("#documentoFilter").val(filtro["filter.datosTerceros.documento"]);
		$("#nombreInteresadoFilter").val(filtro["filter.datosTerceros.nombre"]);
		$("#apellido1InteresadoFilter").val(filtro["filter.datosTerceros.apellido1"]);
		$("#apellido2InteresadoFilter").val(filtro["filter.datosTerceros.apellido2"]);
		
		var provincia = filtro["filter.datosDirecciones.idProvincia"];			
		$("#idProvinciaHidden").val(provincia ? provincia : "");
		$("#idProvinciaSolicitante").rup_combo("setRupValue", provincia ? provincia : "");
		
		if(filtro["filter.datosDirecciones.idMunicipio"]){
			var muni = filtro["filter.datosDirecciones.idMunicipio"];
			$("#idMunicipioHidden").val(muni ? muni : "");
		}			
	
		if(filtro["filter.datosDirecciones.idLocalidad"]){
			var localidad = filtro["filter.datosDirecciones.idLocalidad"];
			$("#idLocalidadHidden").val(localidad ? localidad : "");
		}
		
		$("#direccion").val(filtro["filter.datosDirecciones.direccion"]);
		$("#numero").val(filtro["filter.datosDirecciones.numero"]);
		$("#escalera").val(filtro["filter.datosDirecciones.escalera"]);
		$("#piso").val(filtro["filter.datosDirecciones.piso"]);
		$("#letra").val(filtro["filter.datosDirecciones.letra"]);
		$("#codigoPostal").val(filtro["filter.datosDirecciones.codigoPostal"]);

		$("#identificadorInspeccion").val(filtro["filter.identificadorInspeccion"]);

		if(filtro["filter.tieneInspeccion"] == 'true') {
			$('#tieneInspeccion').prop('checked', true);
		} else {
			$('#tieneInspeccion').prop('checked', false);
		}
		

		if(filtro["filter.isFormal"] == 'true') {
			$('#isFormal').prop('checked', true);
		} else {
			$('#isFormal').prop('checked', false);
		}
		
		
//		TODO Valor previo idProcedimiento
		if(filtro["filter.identificadorEstablecimiento"] !== ""){
			$("#partLetra").val(filtro["filter.parteLetra"]);
			$("#partProv").val(filtro["filter.parteProv"]);
			$("#partSequencia").val(filtro["filter.parteSequencia"]);
			$("#searchIdentificador").val($("#partLetra").val()+$("#partProv").val()+$("#partSequencia").val());
		}			
	}
	
}

function buscarAvisos(){
	$("#avisos_feedback").rup_feedback({
		closeLink : true,
		block : false,
		gotoTop : true
	});
	$.ajax({
		url:"/ab78WebAppWar/expediente-denuncia/avisoPorFecha",
		method: 'POST',
		dataType : 'json',
		success: function(data){
			if(data.result === 1){
				if(data.message !== "" && data.message !== "[]"){
					var messages = data.message.split(',');
					msgEs = messages[0].substring(1);
					msgEu = messages[messages.length -1].slice(0, -1);

			        if("es"==$.rup_utils.get("language")){
						msgEs = findUrl(msgEs)
						$("#avisos_feedback").rup_feedback("set",msgEs,"alert");
					}
					else{
						msgEu = findUrl(msgEu)
						$("#avisos_feedback").rup_feedback("set",msgEu,"alert");
					}
				}
			}else{
				console.log(data);
			}
			
		},
		error: function(data){
			console.log(data);
			
		}
	});
}

function findUrl(msg) {
	var isURLRegex = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[-;:&=\+\$,\w]+@)?[A-Za-z0-9.-]+|(?:www.|[-;:&=\+\$,\w]+@)[A-Za-z0-9.-]+)((?:\/[\+~%\/.\w-_]*)?\??(?:[-\+=&;%@.\w_]*)#?(?:[\w]*))?)/;
	var sections = msg.split(" ");
	var urlLocation = -1;
	for(var i=0; i < sections.length; i++){
		if(isURLRegex.test(sections[i])){
			urlLocation = i;
		}
	}
	if(urlLocation !== -1){
		url = sections[urlLocation]
		sections[urlLocation] = "<b><a class='alert-link linkPaginacion' href='{0}' target='_blank'>{1}</a></b>" 
		sections[urlLocation] = sections[urlLocation].replace("{0}", url).replace("{1}", url);
		msg = sections.join(" ")
	}
	return msg;
}