/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
	
	// Evitar conflictos entre Bootstrap y jQueryUI
	$.fn.bootstrapBtn = $.fn.button.noConflict();

	//Sacar --- en los combos de toda la app
	jQuery.extend(true, jQuery.rup.i18n.base.rup_combo, { blankNotDefined : "----" });
	
	//logo
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
		
	
	//idioma
	$("#ab78WebAppWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY, modo: "default"});
	
	//menu
	$("#ab78WebAppWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal'),
		
	});
	
	if ($.rup.LAYOUT === "mixto") {
		$("#ab78WebAppWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	
	
	//pie
//	$(".footer [title]").rup_tooltip();
	
	//botones y menús desplegables
//	$('.dropdown-toggle').dropdown();

	
	//tooltips
	$('[data-toggle="tooltip"]').rup_tooltip({
		trigger: "hover"
	});
//
//	//navbar fijo al hacer scroll
//	var $navbarAffix;
//	//si tengo navbar secundario, dejo fijo ese. Si no, el principal
//	if ($(".navbar-secundario").length > 0){
//		$navbarAffix = $(".navbar-secundario");
//	}else{
//		$navbarAffix = $(".navbar-principal");
//	}
//
//	//co
//	if($navbarAffix.length > 0){		
//		$navbarAffix.affix({
//			offset: {
//				top: $navbarAffix.offset().top
//			}
//		});
//		
//	}
	//idioma cambiar en el selector de idiomas
	$("[data-idioma='" + $.rup.lang + "']").addClass("active");



	var selector = '.nav li';
	
	$(selector).on('click', function(){
	    $(selector).removeClass('active');
	    $(this).addClass('active');
	});
	
	//-----------------------------------------------------------------
	// Idioma
	//-----------------------------------------------------------------
	var urlActual = $(location).attr('href'),
		blUrlParametros = (urlActual.indexOf("?") == -1) ? false : true,
		blParamIdioma = (urlActual.indexOf("locale=") == -1) ? false : true,
		blParamIdiomaPrimero = (urlActual.indexOf("?locale=") == -1) ? false : true,
		caracter = "";

	// Eliminar el parametro idioma de la url
	if (blParamIdioma) {
		if (blParamIdiomaPrimero) 	{ caracter = "?"; }
		else 						{ caracter = "&"; }
		
		urlActual = urlActual.replace(caracter + "locale=" + $.rup.lang, "");
	}
	
	// Eliminar almohadilla del final de la url
	urlActual = urlActual.replace("#","");
	
	if (blUrlParametros && !blParamIdiomaPrimero) 	{ caracter = "&"; }
	else											{ caracter = "?"; }
	$("#lenguaje_es").attr("href", urlActual + caracter + "locale=es");
	$("#lenguaje_eu").attr("href", urlActual + caracter + "locale=eu");
	
	
	if($("#fichaExpGeneralfeedBack").length > 0){
		$("#fichaExpGeneralfeedBack").rup_feedback({
			closeLink : true,
			block : false,
			gotoTop : false
		});
	}
	
	$("a.nav-link[href*=ab78]").each(function(i,el){
	    el.onclick = function(event){
	        event.preventDefault;
	        var url = this.getAttribute("href");
	        if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
	    		$.rup_messages("msgConfirm", {		
	    			title:  $.rup.i18n.app.mensajes.titulo,
	    			message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
	    			OKFunction: function(){
	    				var str = "no-formales";
						if(window.location.href.includes(str)){ 
							if(isValidForm()){		
								executeAction();
							}
						} else{
							$(".container #btnGuardar").click();
						}
	    				window.location = url;
	    			},
	    			CANCELFunction: function(){
	    				window.location = url;
	    			}
	    		});	        	
	        	return false;
	        }
	    }
	});
	
});

function accederMenuPrincipal (nombreControlador, parametros){
	if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
		// hay cambios en la pantalla, deberiamos mostrar mensaje de que hay cambios
		$.rup_messages("msgConfirm", {		
			title:  $.rup.i18n.app.mensajes.titulo,
			message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
			OKFunction: function(){
				$(".container #guardar").click();
				accederMenuPrincipalSubmit(nombreControlador,parametros);
			},
			CANCELFunction: function(){
				accederMenuPrincipalSubmit(nombreControlador,parametros);
			}
		});
	}else{
		// si no hay cambios, accedemos directamente al controller
		accederMenuPrincipalSubmit(nombreControlador,parametros);
	}	
}	


function accederMenuPrincipalSubmit(nombreControlador,parametros){
	if(parametros === null || parametros === undefined){
		parametros="";
	}
	if(document.forms["initForm"]!=undefined){
		document.forms["initForm"].action = "/ab78WebAppWar/"+nombreControlador+"/maint?"+parametros
		bloquearInterfaz();
		$("#initForm").submit();
	}else{
		document.forms["initFormEst"].action = "/ab78WebAppWar/"+nombreControlador+"/maint?"+parametros
		bloquearInterfaz();
		$("#initFormEst").submit();
	}
}

function errorSendRequest(e, xhr, msg){
	desbloquearInterfaz();
	enableButton("#btnGuardar");
	$("#fichaExpGeneralfeedBack").rup_feedback("set", $.rup.i18n.app.msg.errorGenerico, "error");
	console.warn(arguments);
}

function getLocaleOption(es, eu){
	return ($.rup.lang === "es") ? es : eu;
}

function disableButton(idButton){
	$(idButton).prop("disabled", "disabled");
	$(idButton).addClass("disabled");
}

function enableButton(idButton){
	$(idButton).removeAttr("disabled");
	$(idButton).removeClass("disabled");
}

function executeCallback(result, delay){
	if(delay === null|| delay === undefined || delay === 0){
		delay = 10;
	}
	if(!!result.callback){
		var functionName = "{0}(JSON.parse('{1}'))".replace("{0}",result.callback).replace("{1}", JSON.stringify(result.data));
		setTimeout(functionName, delay);
	}
}

function accederPestana(nombreControlador){
	if (null !== $("#controlCambios").val() && "1" === $("#controlCambios").val()) {
		// hay cambios en la pantalla, deberiamos mostrar mensaje de que hay cambios
		$.rup_messages("msgConfirm", {
			title:  $.rup.i18n.app.mensajes.titulo,
			message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
			OKFunction: function(){
				$(".container #guardar").click();
				//accederMenu(controller);
				document.forms["initForm"].action = "/ab78WebAppWar/"+nombreControlador+"/maint"
				$("#initForm").submit();

			},
			CANCELFunction: function(){
				//accederMenu(controller);
				bloquearInterfaz();
				document.forms["initForm"].action = "/ab78WebAppWar/"+nombreControlador+"/maint"
				$("#initForm").submit();
			}
		});
	}else{
		bloquearInterfaz();
		document.forms["initForm"].action = "/ab78WebAppWar/"+nombreControlador+"/maint"
		$("#initForm").submit();
	}
} 

function confirmDialog(callback, msg, data){
	$.rup_messages("msgConfirm", {
		title:  $.rup.i18n.app.mensajes.titulo,
		message: msg,
		OKFunction: function(){
			callback(data);
		}
	});
}

function initFormToJson(){
	return form2json($("#initForm")[0]);
}

function bloquearInterfaz(){
	//Estilos por defecto
	$.blockUI({
		css: { backgroundColor: 'transparent',borderColor:'transparent'} ,
		message: '<img src="' + STATICS + '/ab78/images/cargando.gif"  id="cargando"/>' 
	});

	
}
//Desbloquear pantalla
function desbloquearInterfaz(){
	try{
		$.unblockUI();
	}catch(e){
		$('.blockUI').remove();
	}
}

function cambiarIdiomaExp (idioma){
	var url = "";
	if(document.forms["initForm"]!=undefined){
		url = document.forms["initForm"].action;
		if(url.indexOf("/inicio")!=-1){
			if(url.indexOf("/initCambioIdioma")!=-1){
				var posicion = url.indexOf("/initCambioIdioma");
				url = url.substring(0,posicion);
				url = url+"/initCambioIdioma";
			}else{
				url = url+"/initCambioIdioma";
			}
		}
		url = changeUrlLocale(url,idioma);
		document.forms["initForm"].action= url;
		bloquearInterfaz();
		$("#initForm").submit();
	}else{
		url = document.forms["initFormEst"].action;
		url = changeUrlLocale(url,idioma);
		document.forms["initFormEst"].action= url;
		bloquearInterfaz();
		$("#initFormEst").submit();
	}
}

function changeUrlLocale(url,idioma){
	if(url.indexOf("?")==-1){		
		url+= "?locale=" + idioma;
	}else{
		if(url.indexOf("?locale")==-1){
			if(url.indexOf("&locale")==-1){
			url+= "&locale=" + idioma;
			}else{
				var posicion = url.indexOf("&locale");
				url = url.substring(0,posicion);
				url += "&locale=" + idioma; 
			}
		}else{
			var posicion = url.indexOf("?locale");
			url = url.substring(0,posicion);
			url += "?locale=" + idioma; 	
		}
	}
	return url;
}

function setTextAreaAutoSize(){
	jQuery.each(jQuery('textarea[data-autoresize]'), function(index, elm) {
		  var offset = this.offsetHeight - this.clientHeight;
		  $(elm).data("offset", offset+5);
		  
		  jQuery(elm).on('keyup input', function() {
			  resizeTextarea(elm); 
		  }).removeAttr('data-autoresize');
		  //resizeTextarea(this);
	});
}
function resizeTextarea(el) {
    jQuery(el).css('height', 'auto');
    var height =el.scrollHeight  + $(el).data("offset");
    if(height>35){    	
    	jQuery(el).css('height', height);
    }
    var max= jQuery(el).attr("maxlength");
    var length =  jQuery(el).val().length;
    var text =  "{0}/{1}".replace("{0}",length).replace("{1}", max);
    jQuery(el).parent().find('.mark-length').html(text);
  };
  
  function logoutFuncion() {
	  
	  if (null !== $("#controlCambios").val() && 1 == $("#controlCambios").val()) {
			$.rup_messages("msgConfirm", {		
				title:  $.rup.i18n.app.mensajes.titulo,
				message: $.rup.i18n.app.mensajes.calculo_sin_guardar,
				OKFunction: function(){
  				var str = "no-formales";
					if(window.location.href.includes(str)){ 
						if(isValidForm()){		
							executeAction();
						}
					} else{
						$(".container #btnGuardar").click();
					}
					  window.location.href="/ab78WebAppWar/logout"
				},
				CANCELFunction: function(){
					  window.location.href="/ab78WebAppWar/logout"
				}
			});
		}
		else{
			  window.location.href="/ab78WebAppWar/logout"
		}
 };
  

 function setAutocompleteSearchByIdentificador(options){

	 var findEst =  options.find;
	 var filtro = options.filter;

 	var iden = $("#searchIdentificador").val();
 	var ignoreKeys = [8, 9, 16, 17, 18, 19, 37, 38, 39, 40];
 	findEst = (findEst == undefined)? true : findEst;
 	
 	$("#partLetra").val(iden.substring(0,1));
 	$("#partProv").val(iden.substring(1,3));;
 	$("#partSequencia").val(iden.substring(3,iden.length));
 	
 	$("#partLetra").on("keyup", function(){
 		var key = event.keyCode;
 		if(ignoreKeys.indexOf(key) >= 0) {
 			return;
 		}
 		$("#partLetra").val($("#partLetra").val().toUpperCase());
 		$("#partProv").focus();
 	});
 	$("#partLetra").on("change", function(){
 		//si el filtro de letras es nulo se busca normalmente
 		 if(filtro.length == 0){
 			 
	 		if($("#partLetra").val() ===""){
	 			$("#searchIdentificador").val(null);
	 			$("#nombreEstablecimiento").val(null);
	 			$("#nombreTitular").val(null);
	 			return;
	 		}
	 		if(findEst == true){
	 			checkFindEstablecimiento(findEst);
	 		}
 		 //si el filtro de letras viene con valores entonces pasamos a comprobar 
	 	 //si los valores introducidos en el input son los valores permitidos
 		 }else{
 			 if(filtro.indexOf($("#partLetra").val())>=0){
				if($("#partLetra").val() ===""){
		 			$("#searchIdentificador").val(null);
		 			$("#nombreEstablecimiento").val(null);
		 			$("#nombreTitular").val(null);
		 			return;
		 		}
				if(findEst == true){
					checkFindEstablecimiento(findEst);
				}
			}else{
				$("#partLetra").val("");
			}
			
 			 
 		 }
 	});

 	$("#partProv").on("keyup", function(){
 		var key = event.keyCode;
 		if(ignoreKeys.indexOf(key) >= 0) {
 			return;
 		}
 		$("#partProv").val($("#partProv").val().toUpperCase());
 		if($("#partProv").val().length<2)
 			return;
 		$("#partSequencia").focus();
 	});
 	$("#partProv").on("change", function(){
 		if($("#partProv").val() ===""){
 			$("#searchIdentificador").val(null);
 			$("#nombreEstablecimiento").val(null);
 			$("#nombreTitular").val(null);
 			return;
 		}
 		checkFindEstablecimiento(findEst);
 	});
 	
 	$("#partSequencia").on("change", function(){
 		if($("#partSequencia").val() ===""){
 			$("#searchIdentificador").val(null);
 			$("#nombreEstablecimiento").val(null);
 			$("#nombreTitular").val(null);
 			return;
 		}			
 		checkFindEstablecimiento(findEst);
 	});
 }

 function checkFindEstablecimiento(findEst){
 	var current = $("#searchIdentificador").val();
	
	var letra = $("#partLetra").val();
	var prov = $("#partProv").val();
	var sequence = $("#partSequencia").val();
	
	if(letra!='' && prov!='' && sequence!=''){
		sequence =pad(sequence, 5);
		var identificador = (""+letra + prov +sequence).toUpperCase();			
		$("#partSequencia").val(sequence);
		$("#searchIdentificador").val(identificador);
		if($("#searchIdentificador").val() !== current && findEst){
			$("#identificadorEstablecimiento").val(identificador);
			findEstablecimiento($("#searchIdentificador").val());
		}
	}
}
 
 function findEstablecimiento(value){
 	bloquearInterfaz();
 	disableButton("#btnGuardar");
 	disableButton("#btnCenso");
 	value = value.toUpperCase();
 	$("#searchIdentificador").val(value)
 	if(value == null || value === 0 || value === "" || !/\w{3}\d{5}/.test(value)){
 		$("#searchIdentificador").val(null);
 		$("#nombreEstablecimiento").val(null);
		$("#nombreTitular").val(null);
		$('#nombreComercialHidden').val(null);
 		disableButton("#btnCenso");
 		enableButton("#btnGuardar");
 		desbloquearInterfaz();
 	}else if(/\w{3}\d{5}/.test(value)){
 		$.get("/ab78WebAppWar/denuncias/no-formales/searchEstablecimiento?q="+value+"&c=false", function(data) {
 			desbloquearInterfaz();
 			enableButton("#btnGuardar");
 			data = JSON.parse(data);
 			if(data.length > 0){
 				$('#nombreComercialHidden').val(data[0].nombreEstablecimiento);
 				$("#nombreEstablecimiento").val(data[0].nombreEstablecimiento);
 				$("#nombreTitular").val(data[0].titular);
 				//enableButton("#btnCenso");
 			}else {
 				$("#nombreEstablecimiento").val(null);
 				$("#nombreTitular").val(null);
 				$("#fichaExpGeneralfeedBack").rup_feedback("set", $.rup.i18n.app.mensajes.error.identificadorError, "error");
 			}
 		});
 	}
 }
 

 function abrirEnPestania(url){
 	var $a= $("<a target='_blank'></a>");
 	$a.attr("href", url);
 	bloquearInterfaz();
 	$a.get(0).click();
 	desbloquearInterfaz();
 }