package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.terceros.TiposTercero;
import com.ejie.ab78.service.terceros.TiposTerceroService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposTerceroController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tipostercero")

public class TiposTerceroController {

	private static final Logger logger = LoggerFactory.getLogger(TiposTerceroController.class);

	@Autowired
	private TiposTerceroService tiposTerceroService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoTercero
	 *            Long
	 * @return TiposTercero Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipoTercero}", method = RequestMethod.GET)
	public @ResponseBody TiposTercero get(@PathVariable Long idTipoTercero) {
		TiposTercero tiposTercero = new TiposTercero();
		tiposTercero.setIdTipoTercero(idTipoTercero);
		tiposTercero = this.tiposTerceroService.find(tiposTercero);
		TiposTerceroController.logger.info("[GET - findBy_PK] : Obtener TiposTercero por PK");
		return tiposTercero;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterTiposTercero
	 *            TiposTercero Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TiposTercero> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TiposTercero> getAll(@ModelAttribute TiposTercero filterTiposTercero) {
		TiposTerceroController.logger.info("[GET - find_ALL] : Obtener TiposTercero por filtro");
		return this.tiposTerceroService.findAll(filterTiposTercero, null);
	}

	@RequestMapping(value = "/subtipos", method = RequestMethod.GET)
	public @ResponseBody List<TiposTercero> getSubtiposAll(@ModelAttribute TiposTercero filterTiposTercero) {
		TiposTerceroController.logger.info("[GET - find_ALL] : Obtener TiposTercero por filtro");
		return this.tiposTerceroService.getSubtiposAll(filterTiposTercero);
	}

	/**
	 * Devuelve los diferentes tipos de documentos
	 * 
	 * @param tiposTercero
	 * @return
	 */
	@RequestMapping(value = "/verValorCombo", method = RequestMethod.GET)
	public @ResponseBody List<TiposTercero> init(TiposTercero tiposTercero) {
		TiposTerceroController.logger.info("[GET - getValorCombo] : Obtener valores del combo ");
		return this.tiposTerceroService.findAll(tiposTercero, null);

	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param TiposTercero
	 *            TiposTercero Bean que contiene la informacion a modificar.
	 * @return TiposTercero Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TiposTercero edit(@RequestBody TiposTercero TiposTercero) {
		TiposTercero TiposTerceroAux = this.tiposTerceroService.update(TiposTercero);
		TiposTerceroController.logger.info("[PUT] : TiposTercero actualizado correctamente");
		return TiposTerceroAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param TiposTercero
	 *            TiposTercero Bean que contiene la informacion con la que se va
	 *            a crear el nuevo registro.
	 * @return TiposTercero Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TiposTercero add(@RequestBody TiposTercero TiposTercero) {
		TiposTercero TiposTerceroAux = this.tiposTerceroService.add(TiposTercero);
		TiposTerceroController.logger.info("[POST] : TiposTercero insertado correctamente");
		return TiposTerceroAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoTercero
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TiposTercero Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoTercero}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TiposTercero remove(@PathVariable Long idTipoTercero) {
		TiposTercero tiposTercero = new TiposTercero();
		tiposTercero.setIdTipoTercero(idTipoTercero);
		this.tiposTerceroService.remove(tiposTercero);
		TiposTerceroController.logger.info("[DELETE] : TiposTercero borrado correctamente");
		return tiposTercero;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TiposTerceroController.logger.info("[GET - View] : TiposTercero");
		return "TiposTercero";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterTiposTercero
	 *            TiposTercero Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TiposTercero> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TiposTercero> filter(
			@RequestJsonBody(param = "filter") TiposTercero filterTiposTercero,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposTerceroController.logger.info("[POST - filter] : Obtener TiposTerceros");
		return this.tiposTerceroService.filter(filterTiposTercero, TableRequestDto, false);
	}


}
