package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.ab78.service.terceros.TiposDocumentoService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDocumentoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tiposdocumento")

public class TiposDocumentoController {

	private static final Logger logger = LoggerFactory.getLogger(TiposDocumentoController.class);

	@Autowired
	private TiposDocumentoService tiposDocumentoService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoDocumento
	 *            Long
	 * @return TiposDocumento Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipoDocumento}", method = RequestMethod.GET)
	public @ResponseBody TiposDocumento get(@PathVariable Long idTipoDocumento) {
		TiposDocumento tiposDocumento = new TiposDocumento();
		tiposDocumento.setIdTipoDocumento(idTipoDocumento);
		tiposDocumento = this.tiposDocumentoService.find(tiposDocumento);
		TiposDocumentoController.logger.info("[GET - findBy_PK] : Obtener TiposDocumento por PK");
		return tiposDocumento;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterTiposDocumento
	 *            TiposDocumento Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TiposDocumento> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TiposDocumento> getAll(@ModelAttribute TiposDocumento filterTiposDocumento) {
		TiposDocumentoController.logger.info("[GET - find_ALL] : Obtener TiposDocumento por filtro");
		return this.tiposDocumentoService.findAll(filterTiposDocumento, null);
	}

	/**
	 * Devuelve los diferentes tipos de documentos
	 * 
	 * @param tipodocumento
	 * @return
	 */
	@RequestMapping(value = "/verValorCombo", method = RequestMethod.GET)
	public @ResponseBody List<TiposDocumento> init(TiposDocumento tipodocumento) {
		TiposDocumentoController.logger.info("[GET - getValorCombo] : Obtener valores del combo ");
		return this.tiposDocumentoService.findAll(tipodocumento, null);

	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento Bean que contiene la informacion a modificar.
	 * @return TiposDocumento Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TiposDocumento edit(@RequestBody TiposDocumento tiposDocumento) {
		TiposDocumento tiposDocumentoAux = this.tiposDocumentoService.update(tiposDocumento);
		TiposDocumentoController.logger.info("[PUT] : TiposDocumento actualizado correctamente");
		return tiposDocumentoAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param tiposDocumento
	 *            TiposDocumento Bean que contiene la informacion con la que se
	 *            va a crear el nuevo registro.
	 * @return TiposDocumento Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TiposDocumento add(@RequestBody TiposDocumento tiposDocumento) {
		TiposDocumento tiposDocumentoAux = this.tiposDocumentoService.add(tiposDocumento);
		TiposDocumentoController.logger.info("[POST] : TiposDocumento insertado correctamente");
		return tiposDocumentoAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoDocumento
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TiposDocumento Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoDocumento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TiposDocumento remove(@PathVariable Long idTipoDocumento) {
		TiposDocumento tiposDocumento = new TiposDocumento();
		tiposDocumento.setIdTipoDocumento(idTipoDocumento);
		this.tiposDocumentoService.remove(tiposDocumento);
		TiposDocumentoController.logger.info("[DELETE] : TiposDocumento borrado correctamente");
		return tiposDocumento;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TiposDocumentoController.logger.info("[GET - View] : tiposdocumento");
		return "tiposdocumento";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TiposDocumento> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TiposDocumento> filter(
			@RequestJsonBody(param = "filter") TiposDocumento filterTiposDocumento,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDocumentoController.logger.info("[POST - filter] : Obtener TiposDocumentos");
		return this.tiposDocumentoService.filter(filterTiposDocumento, TableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<TiposDocumento> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TiposDocumento>> search(
			@RequestJsonBody(param = "filter") TiposDocumento filterTiposDocumento,
			@RequestJsonBody(param = "search") TiposDocumento searchTiposDocumento,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDocumentoController.logger.info("[POST - search] : Buscar TiposDocumentos");
		return this.tiposDocumentoService.search(filterTiposDocumento, searchTiposDocumento, TableRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") TiposDocumento filterTiposDocumento,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDocumentoController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples TiposDocumentos");
		this.tiposDocumentoService.removeMultiple(filterTiposDocumento, TableRequestDto, false);
		TiposDocumentoController.logger.info("All entities correctly deleted!");

		return TableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquia(
			@RequestJsonBody(param = "filter") TiposDocumento filterTiposDocumento,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDocumentoController.logger.info("[POST - jerarquia] : Obtener TiposDocumentos jerarquia");
		return this.tiposDocumentoService.jerarquia(filterTiposDocumento, TableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterTiposDocumento
	 *            TiposDocumento Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TiposDocumento>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TiposDocumento>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") TiposDocumento filterTiposDocumento,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDocumentoController.logger.info("[POST - jerarquia] : Obtener TiposDocumentos jerarquia - Hijos");
		return this.tiposDocumentoService.jerarquiaChildren(filterTiposDocumento, TableRequestDto);
	}

}
