package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.ab78.service.terceros.TiposDireccionService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposDireccionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/tiposdireccion")

public class TiposDireccionController {

	private static final Logger logger = LoggerFactory.getLogger(TiposDireccionController.class);

	@Autowired
	private TiposDireccionService tiposDireccionService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoDireccion
	 *            Long
	 * @return TiposDireccion Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipoDireccion}", method = RequestMethod.GET)
	public @ResponseBody TiposDireccion get(@PathVariable Long idTipoDireccion) {
		TiposDireccion tiposDireccion = new TiposDireccion();
		tiposDireccion.setIdTipoDireccion(idTipoDireccion);
		tiposDireccion = this.tiposDireccionService.find(tiposDireccion);
		TiposDireccionController.logger.info("[GET - findBy_PK] : Obtener TiposDireccion por PK");
		return tiposDireccion;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterTiposDireccion
	 *            TiposDireccion Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TiposDireccion> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TiposDireccion> getAll(@ModelAttribute TiposDireccion filterTiposDireccion) {
		TiposDireccionController.logger.info("[GET - find_ALL] : Obtener TiposDireccion por filtro");
		return this.tiposDireccionService.findAll(filterTiposDireccion, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion Bean que contiene la informacion a modificar.
	 * @return TiposDireccion Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TiposDireccion edit(@RequestBody TiposDireccion tiposDireccion) {
		TiposDireccion tiposDireccionAux = this.tiposDireccionService.update(tiposDireccion);
		TiposDireccionController.logger.info("[PUT] : TiposDireccion actualizado correctamente");
		return tiposDireccionAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param tiposDireccion
	 *            TiposDireccion Bean que contiene la informacion con la que se
	 *            va a crear el nuevo registro.
	 * @return TiposDireccion Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TiposDireccion add(@RequestBody TiposDireccion tiposDireccion) {
		TiposDireccion tiposDireccionAux = this.tiposDireccionService.add(tiposDireccion);
		TiposDireccionController.logger.info("[POST] : TiposDireccion insertado correctamente");
		return tiposDireccionAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoDireccion
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TiposDireccion Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoDireccion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TiposDireccion remove(@PathVariable Long idTipoDireccion) {
		TiposDireccion tiposDireccion = new TiposDireccion();
		tiposDireccion.setIdTipoDireccion(idTipoDireccion);
		this.tiposDireccionService.remove(tiposDireccion);
		TiposDireccionController.logger.info("[DELETE] : TiposDireccion borrado correctamente");
		return tiposDireccion;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TiposDireccionController.logger.info("[GET - View] : tiposdireccion");
		return "tiposdireccion";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TiposDireccion> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TiposDireccion> filter(
			@RequestJsonBody(param = "filter") TiposDireccion filterTiposDireccion,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDireccionController.logger.info("[POST - filter] : Obtener TiposDireccions");
		return this.tiposDireccionService.filter(filterTiposDireccion, TableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<TiposDireccion> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TiposDireccion>> search(
			@RequestJsonBody(param = "filter") TiposDireccion filterTiposDireccion,
			@RequestJsonBody(param = "search") TiposDireccion searchTiposDireccion,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDireccionController.logger.info("[POST - search] : Buscar TiposDireccions");
		return this.tiposDireccionService.search(filterTiposDireccion, searchTiposDireccion, TableRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") TiposDireccion filterTiposDireccion,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDireccionController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples TiposDireccions");
		this.tiposDireccionService.removeMultiple(filterTiposDireccion, TableRequestDto, false);
		TiposDireccionController.logger.info("All entities correctly deleted!");

		return TableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquia(
			@RequestJsonBody(param = "filter") TiposDireccion filterTiposDireccion,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDireccionController.logger.info("[POST - jerarquia] : Obtener TiposDireccions jerarquia");
		return this.tiposDireccionService.jerarquia(filterTiposDireccion, TableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterTiposDireccion
	 *            TiposDireccion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TiposDireccion>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TiposDireccion>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") TiposDireccion filterTiposDireccion,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		TiposDireccionController.logger.info("[POST - jerarquia] : Obtener TiposDireccions jerarquia - Hijos");
		return this.tiposDireccionService.jerarquiaChildren(filterTiposDireccion, TableRequestDto);
	}

}
