package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab78.model.terceros.Sexo;
import com.ejie.ab78.service.terceros.SexoService;

/**
 * SexosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/sexos")
public class SexosController {

	private static final Logger logger = LoggerFactory.getLogger(SexosController.class);

	@Autowired
	private SexoService sS;

	/**
	 * Metodo que nos trae la lista para cargar el combo
	 * 
	 * 
	 */
	@RequestMapping(value = "/verValorCombo", method = RequestMethod.GET)
	public @ResponseBody List<Sexo> init() {
		SexosController.logger.info("[GET - getValorCombo] : Obtener valores del combo ");
		return this.sS.findAll();

	}

}
