package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.RelDenunciaTercero;
import com.ejie.ab78.model.util.ErrorResultAjaxOperation;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.terceros.DatosDireccionesService;
import com.ejie.ab78.service.terceros.RelDenunciaTerceroService;

@Controller
@RequestMapping(value = "/relDenunciaTercero")

public class RelDenunciaTerceroController {

	private static final Logger logger = LoggerFactory.getLogger(RelDenunciaTerceroController.class);

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	@Autowired
	private RelDenunciaTerceroService relDenunciaTerceroService;

	@RequestMapping(value = "/datostercero/{idTercero}", method = RequestMethod.GET)
	public @ResponseBody ResultAjaxOperation getInfoContactoTercero(@PathVariable("idTercero") Integer idTercero) {
		RelDenunciaTerceroController.logger.info("getInfoContactoTercero()");

		SuccessResultAjaxOperation successResultAjaxOperation = new SuccessResultAjaxOperation("");
		List<DatosDirecciones> datosDirecciones = this.datosDireccionesService.findInfoContactoTercero(idTercero);

		if (null != datosDirecciones) {

			DatosDirecciones direccion = datosDirecciones.get(0);
			DatosTerceros tercero = direccion.getDatosTerceros();

			successResultAjaxOperation.getData().put("idTercero", tercero.getIdTercero().toString());
			successResultAjaxOperation.getData().put("tipoDocumento",
					(null != tercero.getTiposDocumento() && null != tercero.getTiposDocumento().getIdTipoDocumento())
							? tercero.getTiposDocumento().getIdTipoDocumento().toString() : null);
			successResultAjaxOperation.getData().put("documento", tercero.getDocumento());
			if (null != tercero.getNombreCompuesto()) {
				successResultAjaxOperation.getData().put("nombre", tercero.getNombreCompuesto());
			} else {
				successResultAjaxOperation.getData().put("nombre", tercero.getNombre());
			}
			successResultAjaxOperation.getData().put("telefono", tercero.getTelefono().toString());
			successResultAjaxOperation.getData().put("email", tercero.getEmail());
			successResultAjaxOperation.getData().put("idDireccion", direccion.getIdDireccion().toString());
			successResultAjaxOperation.getData().put("provincia", direccion.getIdProvincia().toString());
			successResultAjaxOperation.getData().put("pais", direccion.getIdPais().toString());
			successResultAjaxOperation.getData().put("municipio", direccion.getIdMunicipio().toString());
			successResultAjaxOperation.getData().put("localidad", direccion.getIdLocalidad().toString());
			successResultAjaxOperation.getData().put("direccion", direccion.getDireccion());
			successResultAjaxOperation.getData().put("codigoPostal", direccion.getCodigoPostal());
			successResultAjaxOperation.getData().put("descProvinciaExtranjera", direccion.getDescProvinciaExtranjera());
			successResultAjaxOperation.getData().put("descCiudadExtranjera", direccion.getDescCiudadExtranjera());
			successResultAjaxOperation.getData().put("idTipoDireccion",
					(null != direccion.getTiposDireccion() && direccion.getTiposDireccion().getIdTipoDireccion() > 0
							? direccion.getTiposDireccion().getIdTipoDireccion().toString() : null));

			return successResultAjaxOperation;
		} else {
			return new ErrorResultAjaxOperation(Constantes.ERROR_GENERICO);
		}

	}

	@RequestMapping(value = "/save", method = RequestMethod.PUT)
	public @ResponseBody ResultAjaxOperation saveInfoContactoTercero(@RequestBody RelDenunciaTercero relDenunciaTercero,
			@RequestParam(required = true) Integer migrado) {

		RelDenunciaTerceroController.logger.info("[PUT] : save");

		try {

			this.relDenunciaTerceroService.guardarInfoContactoTercero(relDenunciaTercero, migrado == 0);

		} catch (Exception e) {

			RelDenunciaTerceroController.logger.info("saveInfoContactoTercero " + e.getMessage());

			return new ErrorResultAjaxOperation(Constantes.ERROR_GENERICO_GUARDADO);

		}
		return new SuccessResultAjaxOperation(Constantes.OK_GENERICO_GUARDADO);
	}

	@RequestMapping(value = "/delete", method = RequestMethod.DELETE)
	public @ResponseBody ResultAjaxOperation deleteDenunciado(
			@RequestParam(value = "idTercero", required = true) Integer idTercero,
			@RequestParam(value = "idExpediente", required = true) Integer idExpediente,
			@RequestParam(required = true) Integer migrado) {

		RelDenunciaTerceroController.logger.info("[DELETE] : deleteDenunciado");
		try {
			this.relDenunciaTerceroService.borrarInfoContactoTercero(idTercero, idExpediente, migrado == 0);
		} catch (Exception e) {
			return new ErrorResultAjaxOperation(Constantes.ERROR_GENERICO_GUARDADO);
		}

		return new SuccessResultAjaxOperation(Constantes.OK_GENERICO_BORRADO);

	}

	@RequestMapping(value = "/comprobarCIF", method = RequestMethod.GET)
	public @ResponseBody Integer comprobarCIF(
			@RequestParam(value = "documentoTercero", required = true) String documentoTercero) {

		return this.relDenunciaTerceroService.findCIF(documentoTercero);
	}

}
