package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.service.terceros.DatosTercerosService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;

/**
 * DatosTercerosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/datosterceros")

public class DatosTercerosController {

	private static final Logger logger = LoggerFactory.getLogger(DatosTercerosController.class);

	@Autowired
	private DatosTercerosService datosTercerosService;

	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<DatosTerceros> getAll(@ModelAttribute DatosTerceros filterDatosTerceros) {
		DatosTercerosController.logger.info("[GET - find_ALL] : Obtener DatosTerceros por filtro");
		return this.datosTercerosService.findAll(filterDatosTerceros, null);
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody DatosTerceros edit(@RequestBody DatosTerceros datosTerceros) {
		DatosTerceros datosTercerosAux = this.datosTercerosService.update(datosTerceros);
		DatosTercerosController.logger.info("[PUT] : DatosTerceros actualizado correctamente");
		return datosTercerosAux;
	}

	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DatosTerceros add(@RequestBody DatosTerceros datosTerceros) {
		DatosTerceros datosTercerosAux = this.datosTercerosService.add(datosTerceros);
		DatosTercerosController.logger.info("[POST] : DatosTerceros insertado correctamente");
		return datosTercerosAux;
	}

	@RequestMapping(value = "/{idTercero}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody DatosTerceros remove(@PathVariable Integer idTercero) {
		DatosTerceros datosTerceros = new DatosTerceros();
		datosTerceros.setIdTercero(idTercero);
		this.datosTercerosService.remove(idTercero);
		DatosTercerosController.logger.info("[DELETE] : DatosTerceros borrado correctamente");
		return datosTerceros;
	}

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		DatosTercerosController.logger.info("[GET - View] : datosterceros");
		return "datosterceros";
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<DatosTerceros> filter(
			@RequestJsonBody(param = "filter") DatosTerceros filterDatosTerceros,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosTercerosController.logger.info("[POST - filter] : Obtener DatosTerceross");
		return this.datosTercerosService.filter(filterDatosTerceros, TableRequestDto, false);
	}

}
