package com.ejie.ab78.control.terceros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.service.terceros.DatosDireccionesService;
import com.ejie.ab78.service.terceros.DatosTercerosService;
import com.ejie.ab78.service.terceros.RelExpTerService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DatosDireccionesController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/datosdirecciones")

public class DatosDireccionesController {

	private static final Logger logger = LoggerFactory.getLogger(DatosDireccionesController.class);

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	@Autowired
	private DatosTercerosService datosTercerosService;

	@Autowired
	private RelExpTerService relExpTerService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idDireccion
	 *            Integer
	 * @return DatosDirecciones Objeto correspondiente al identificador
	 *         indicado.
	 */
	@RequestMapping(value = "/{idDireccion}", method = RequestMethod.GET)
	public @ResponseBody DatosDirecciones get(@PathVariable Integer idDireccion) {
		DatosDirecciones datosDirecciones = new DatosDirecciones();
		datosDirecciones.setIdDireccion(idDireccion);
		datosDirecciones = this.datosDireccionesService.find(datosDirecciones);
		DatosDireccionesController.logger.info("[GET - findBy_PK] : Obtener DatosDirecciones por PK");
		return datosDirecciones;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Objeto que contiene los parametros de
	 *            filtrado utilizados en la busqueda.
	 * @return List<DatosDirecciones> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<DatosDirecciones> getAll(@ModelAttribute DatosDirecciones filterDatosDirecciones) {
		DatosDireccionesController.logger.info("[GET - find_ALL] : Obtener DatosDirecciones por filtro");
		return this.datosDireccionesService.findAll(filterDatosDirecciones, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones Bean que contiene la informacion a modificar.
	 * @return DatosDirecciones Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody DatosDirecciones edit(@RequestBody DatosDirecciones datosDirecciones) {
		DatosDirecciones datosDireccionesAux = this.datosDireccionesService.update(datosDirecciones);
		DatosDireccionesController.logger.info("[PUT] : DatosDirecciones actualizado correctamente");
		return datosDireccionesAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param datosDirecciones
	 *            DatosDirecciones Bean que contiene la informacion con la que
	 *            se va a crear el nuevo registro.
	 * @return DatosDirecciones Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody DatosDirecciones add(@RequestBody DatosDirecciones datosDirecciones) {
		DatosDirecciones datosDireccionesAux = this.datosDireccionesService.add(datosDirecciones);
		DatosDireccionesController.logger.info("[POST] : DatosDirecciones insertado correctamente");
		return datosDireccionesAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idDireccion
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return DatosDirecciones Bean eliminado.
	 */
	@RequestMapping(value = "/{idDireccion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody DatosDirecciones remove(@PathVariable Integer idDireccion) {
		DatosDirecciones datosDirecciones = new DatosDirecciones();
		datosDirecciones.setIdDireccion(idDireccion);
		this.datosDireccionesService.remove(datosDirecciones);
		DatosDireccionesController.logger.info("[DELETE] : DatosDirecciones borrado correctamente");
		return datosDirecciones;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		DatosDireccionesController.logger.info("[GET - View] : datosdirecciones");
		return "datosdirecciones";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<DatosDirecciones> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<DatosDirecciones> filter(
			@RequestJsonBody(param = "filter") DatosDirecciones filterDatosDirecciones,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosDireccionesController.logger.info("[POST - filter] : Obtener DatosDireccioness");
		return this.datosDireccionesService.filter(filterDatosDirecciones, TableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param searchDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de busqueda
	 *            a emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<DatosDirecciones> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<DatosDirecciones>> search(
			@RequestJsonBody(param = "filter") DatosDirecciones filterDatosDirecciones,
			@RequestJsonBody(param = "search") DatosDirecciones searchDatosDirecciones,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosDireccionesController.logger.info("[POST - search] : Buscar DatosDireccioness");
		return this.datosDireccionesService.search(filterDatosDirecciones, searchDatosDirecciones, TableRequestDto,
				false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") DatosDirecciones filterDatosDirecciones,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosDireccionesController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples DatosDireccioness");
		this.datosDireccionesService.removeMultiple(filterDatosDirecciones, TableRequestDto, false);
		DatosDireccionesController.logger.info("All entities correctly deleted!");

		return TableRequestDto.getMultiselection().getSelectedIds();
	}
	
	@RequestMapping(value = "/buscarEstablecimiento/{numeroRegistro}", method = RequestMethod.GET)
	public @ResponseBody DatosDirecciones buscarEstablecimiento(@PathVariable String numeroRegistro) {
		DatosDireccionesController.logger.info("[GET] : Buscar Establecimiento AB63");

		return this.datosDireccionesService.buscarEstablecimiento(numeroRegistro);
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquia(
			@RequestJsonBody(param = "filter") DatosDirecciones filterDatosDirecciones,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosDireccionesController.logger.info("[POST - jerarquia] : Obtener DatosDireccioness jerarquia");
		return this.datosDireccionesService.jerarquia(filterDatosDirecciones, TableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterDatosDirecciones
	 *            DatosDirecciones Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param TableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<DatosDirecciones>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<DatosDirecciones>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") DatosDirecciones filterDatosDirecciones,
			@RequestJsonBody TableRequestDto TableRequestDto) {
		DatosDireccionesController.logger.info("[POST - jerarquia] : Obtener DatosDireccioness jerarquia - Hijos");
		return this.datosDireccionesService.jerarquiaChildren(filterDatosDirecciones, TableRequestDto);
	}
}
