/**
 * 
 */
package com.ejie.ab78.control.nora;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab78.model.nora.T17Calle;
import com.ejie.ab78.model.nora.T17Localidad;
import com.ejie.ab78.model.nora.T17Municipio;
import com.ejie.ab78.model.nora.T17Pais;
import com.ejie.ab78.model.nora.T17Portal;
import com.ejie.ab78.model.nora.T17Provincia;
import com.ejie.ab78.model.nora.T17TipoVia;
import com.ejie.ab78.service.nora.T17CalleService;
import com.ejie.ab78.service.nora.T17LocalidadService;
import com.ejie.ab78.service.nora.T17MunicipioService;
import com.ejie.ab78.service.nora.T17PaisService;
import com.ejie.ab78.service.nora.T17PortalService;
import com.ejie.ab78.service.nora.T17ProvinciaService;
import com.ejie.ab78.service.nora.T17TipoViaService;

/**
 *  
 * 
 */
@Controller()
@RequestMapping(value = "/nora")
public class NoraController {

	private static final Logger logger = LoggerFactory.getLogger(NoraController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private T17PaisService paisService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17LocalidadService localidadService;

	@Autowired()
	private T17CalleService calleService;

	@Autowired()
	private T17PortalService portalService;

	@Autowired()
	private T17TipoViaService tipoViaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaCalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCalle(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("busquedaCalle", "model", model);
	}

	/********************************************************************************
	 * 
	 * COMBO
	 * 
	 *******************************************************************************/

	/********************************************************************************
	 * Provincias
	 *******************************************************************************/
	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provincias", method = RequestMethod.GET)
	public @ResponseBody() List<T17Provincia> getProvincias() {

		NoraController.logger.debug("Cargar provincias");
		return this.provinciaService.findAll(null, null);
	}

	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provincias/{idProvincia}", method = RequestMethod.GET)
	public @ResponseBody() List<T17Provincia> getProvincia(@PathVariable String idProvincia) {
		NoraController.logger.debug("Cargar provincias");
		T17Provincia t17Provincia = new T17Provincia();
		t17Provincia.setId(idProvincia);
		return this.provinciaService.findAll(t17Provincia, null);
	}
	
	@RequestMapping(value = "/provinciasVascas", method = RequestMethod.GET)
	public @ResponseBody() List<T17Provincia> getProvinciasVascas() {

		NoraController.logger.debug("Cargar provincias");
		return this.provinciaService.findProvinciasVascas();
	}

	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provinciasAplPresu", method = RequestMethod.GET)
	public @ResponseBody() List<T17Provincia> getProvinciasAplPresu() {

		NoraController.logger.debug("Cargar provincias con Autonomia 16");
		T17Provincia t17Provincia = new T17Provincia();
		t17Provincia.setAutonomiaId("16");

		return this.provinciaService.findAll(t17Provincia, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getMunicipios'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/municipios", method = RequestMethod.GET)
	public @ResponseBody() List<T17Municipio> getMunicipios(HttpServletRequest request) {

		String provinciaId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvincia"))
				&& null != (String) request.getParameter("idProvincia")) {
			provinciaId = request.getParameter("idProvincia");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaSolicitante"))
				&& null != (String) request.getParameter("idProvinciaSolicitante")) {
			provinciaId = request.getParameter("idProvinciaSolicitante");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaDenunciado"))
				&& null != (String) request.getParameter("idProvinciaDenunciado")) {
			provinciaId = request.getParameter("idProvinciaDenunciado");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaUbicacion"))
				&& null != (String) request.getParameter("idProvinciaUbicacion")) {
			provinciaId = request.getParameter("idProvinciaUbicacion");
		}

		T17Municipio t17Municipio = new T17Municipio();
		t17Municipio.setProvinciaId(provinciaId);

		return this.municipioService.findAll(t17Municipio, null);
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getLocalidades'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/localidades", method = RequestMethod.GET)
	public @ResponseBody() List<T17Localidad> getLocalidades(HttpServletRequest request) {

		String provinciaId = "";
		String municipioId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvincia"))
				&& null != (String) request.getParameter("idProvincia")) {
			provinciaId = request.getParameter("idProvincia");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaSolicitante"))
				&& null != (String) request.getParameter("idProvinciaSolicitante")) {
			provinciaId = request.getParameter("idProvinciaSolicitante");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaUbicacion"))
				&& null != (String) request.getParameter("idProvinciaUbicacion")) {
			provinciaId = request.getParameter("idProvinciaUbicacion");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idProvinciaDenunciado"))
				&& null != (String) request.getParameter("idProvinciaDenunciado")) {
			provinciaId = request.getParameter("idProvinciaDenunciado");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("idMunicipio"))
				&& null != (String) request.getParameter("idMunicipio")) {
			municipioId = request.getParameter("idMunicipio");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idMunicipioSolicitante"))
				&& null != (String) request.getParameter("idMunicipioSolicitante")) {
			municipioId = request.getParameter("idMunicipioSolicitante");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idMunicipioDenunciado"))
				&& null != (String) request.getParameter("idMunicipioDenunciado")) {
			municipioId = request.getParameter("idMunicipioDenunciado");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("idMunicipioUbicacion"))
				&& null != (String) request.getParameter("idMunicipioUbicacion")) {
			municipioId = request.getParameter("idMunicipioUbicacion");
		}

		T17Localidad t17Localidad = new T17Localidad();
		t17Localidad.setProvinciaId(provinciaId);
		t17Localidad.setMunicipioId(municipioId);

		return this.localidadService.findAll(t17Localidad, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateMunicipios", method = RequestMethod.GET)
	public @ResponseBody() List<T17Municipio> getUpdateMunicipios(
			@RequestParam(value = "provinciaId", required = false) String provinciaId) {

		if (provinciaId != null && !provinciaId.equals("") && !provinciaId.equals("null")) {

			T17Municipio t17Municipio = new T17Municipio();
			t17Municipio.setProvinciaId(provinciaId);

			return this.municipioService.findAll(t17Municipio, null);
		} else {
			return (List<T17Municipio>) new ArrayList<T17Municipio>();
		}
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipioId
	 *            identificador de la municipio
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateLocalidad", method = RequestMethod.GET)
	public @ResponseBody() List<T17Localidad> getUpdateLocalidades(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId) {

		if (provinciaId != null && !provinciaId.equals("") && !provinciaId.equals("null") && municipioId != null
				&& !municipioId.equals("") && !municipioId.equals("null")) {

			T17Localidad t17Localidad = new T17Localidad();
			t17Localidad.setProvinciaId(provinciaId);
			t17Localidad.setMunicipioId(municipioId);

			return this.localidadService.findAll(t17Localidad, null);
		} else {
			return (List<T17Localidad>) new ArrayList<T17Localidad>();
		}
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getCodigoPostal'.
	 * 
	 * @param portal
	 *            identificador del portal
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/codigo_postal/{portal}", method = RequestMethod.GET)
	public @ResponseBody() T17Portal getCodigoPostal(@PathVariable() String portal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setId(new Long(portal));
		return this.portalService.findCodigoPostal(t17Portal);

	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getCalles'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador de la provincia
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/calles", method = RequestMethod.GET)
	public @ResponseBody() List<T17Calle> getCalles(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setProvinciaId(provinciaId);
		t17Calle.setMunicipioId(municipalityId);

		return this.calleService.findAll(t17Calle, null);

	}

	/********************************************************************************
	 * Portal
	 *******************************************************************************/
	/**
	 * Method 'getPortales'.
	 * 
	 * @param localidadId
	 *            identificador de la localidad
	 * @param calleId
	 *            identificador de la calle
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/portales", method = RequestMethod.GET)
	public @ResponseBody() List<T17Portal> getPortales(
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "calleId", required = false) Long calleId) {

		if (// localidadId != null && !localidadId.equals("")&&
			// !localidadId.equals("null") &&
		calleId != null && calleId != 0) {
			T17Portal t17Portal = new T17Portal();
			// t17Portal.setLocalidadId(localidadId);
			t17Portal.setCalleId(calleId);

			return this.portalService.findAll(t17Portal, null);
		} else {
			return (List<T17Portal>) new ArrayList<T17Portal>();
		}
	}

	/********************************************************************************
	 * Paises
	 *******************************************************************************/
	/**
	 * Method 'getPaises'.
	 * 
	 * @return 'lista de paises' para el COMBO
	 */
	@RequestMapping(value = "/paises", method = RequestMethod.GET)
	public @ResponseBody() List<T17Pais> getPaises() {
		NoraController.logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		// pais.setId("351");
		return this.paisService.findAll(pais, null);

	}
	
	@RequestMapping(value = "/paisesOtros", method = RequestMethod.GET)
	public @ResponseBody() List<T17Pais> getPaisesOtros() {
		NoraController.logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		// pais.setId("351");
		return this.paisService.findAllOtros(pais, null);

	}

	/********************************************************************************
	 * CP
	 *******************************************************************************/
	/**
	 * Method 'getCP'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @return Lista
	 */
	@RequestMapping(value = "/cp", method = RequestMethod.GET)
	public @ResponseBody() List<T17Portal> getCP(@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(q);
		return this.portalService.findAllLikeCodigoPostal(t17Portal, null, c);

	}

	/********************************************************************************
	 * Calle
	 *******************************************************************************/
	/**
	 * Method 'getCalle'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @param provincia
	 *            String
	 * @param municipio
	 *            String
	 * 
	 * @return list
	 */
	@RequestMapping(value = "/calle", method = RequestMethod.GET)
	public @ResponseBody() List<T17Calle> getCalle(@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "provincia", required = true) String provincia,
			@RequestParam(value = "municipio", required = true) String municipio) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setDsO(q);
		t17Calle.setMunicipioId(municipio);
		t17Calle.setProvinciaId(provincia);

		return this.calleService.findAllLikeCalle(t17Calle, null, c);

	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getProvMun'. Recupera la provincia y el municipio a partir de un
	 * cod postal
	 * 
	 * @param codigoPostal
	 *            identificador del codigo postal
	 * @return T17Portal
	 */
	@RequestMapping(value = "/codigo_postal/obtenerprovmun/{codigoPostal}", method = RequestMethod.GET)
	public @ResponseBody() T17Calle getProvMun(@PathVariable() String codigoPostal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(codigoPostal);
		return this.calleService.findProvMun(t17Portal);

	}

	/********************************************************************************
	 * Tipos via
	 *******************************************************************************/
	/**
	 * Method 'getAllTipoVia'.
	 * 
	 * @return 'lista de tipos de via' para el COMBO
	 */
	@RequestMapping(value = "/tipoVia", method = RequestMethod.GET)
	public @ResponseBody() List<T17TipoVia> getAllTipoVia() {

		return this.tipoViaService.findAll(null, null);
	}

}
