package com.ejie.ab78.control.maestros;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.service.maestros.TipoVentasService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/maestros/tipoVentas")
public class TipoVentasController {

	private static final Logger logger = LoggerFactory.getLogger(TipoVentasController.class);

	@Autowired
	private TipoVentasService tipoVentasService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoVenta
	 *            Long
	 * @return TipoVenta Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipoVenta}", method = RequestMethod.GET)
	public @ResponseBody TipoVenta get(@PathVariable Long idTipoVenta) {
		TipoVenta tipoVenta = new TipoVenta();
		tipoVenta.setIdTipoVenta(idTipoVenta);
		tipoVenta = this.tipoVentasService.find(tipoVenta);
		TipoVentasController.logger.info("[GET - findBy_PK] : Obtener TipoVenta por PK");
		return tipoVenta;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TipoVenta> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoVenta> getAll(@ModelAttribute TipoVenta filterAb7804s00) {
		TipoVentasController.logger.info("[GET - find_ALL] : Obtener TipoVenta por filtro");
		filterAb7804s00.setBaja(0);
		return this.tipoVentasService.findAll(filterAb7804s00, null);
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TipoVenta> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/procedimientos/{idProcedimiento}", method = RequestMethod.GET)
	public @ResponseBody List<TipoVenta> getAll(@ModelAttribute TipoVenta filterAb7804s00,
			@PathVariable("idProcedimiento") Long idProcedimiento) {
		TipoVentasController.logger.info("[GET - find_ALL] : Obtener TipoVenta por filtro");
		filterAb7804s00.setBaja(0);
		filterAb7804s00.setIdProcedimiento(idProcedimiento);
		return this.tipoVentasService.findAllFilterProcedimiento(filterAb7804s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tipoVenta
	 *            TipoVenta Bean que contiene la informacion a modificar.
	 * @return TipoVenta Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoVenta edit(@RequestBody TipoVenta tipoVenta) {
		TipoVenta ab7804s00Aux = this.tipoVentasService.update(tipoVenta);
		TipoVentasController.logger.info("[PUT] : TipoVenta actualizado correctamente");
		return ab7804s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param tipoVenta
	 *            TipoVenta Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return TipoVenta Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoVenta add(@RequestBody TipoVenta tipoVenta) {
		TipoVenta ab7804s00Aux = this.tipoVentasService.add(tipoVenta);
		TipoVentasController.logger.info("[POST] : TipoVenta insertado correctamente");
		return ab7804s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoVenta
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TipoVenta Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoVenta}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoVenta remove(@PathVariable Long idTipoVenta) {
		TipoVenta tipoVenta = new TipoVenta();
		tipoVenta.setIdTipoVenta(idTipoVenta);
		this.tipoVentasService.remove(tipoVenta);
		TipoVentasController.logger.info("[DELETE] : TipoVenta borrado correctamente");
		return tipoVenta;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model, HttpSession httpSession) {
		TipoVentasController.logger.info("[GET - View] : ab7804s00");

		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE) != null) {
			Object folderIdUltimoExpediente = httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE);

			model.addAttribute("ultimoExpediente", folderIdUltimoExpediente);
		}
		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO) != null) {
			Object IdDenunciaUltimoExpediente = httpSession
					.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO);

			model.addAttribute("IdDenunciaUltimoExpediente", IdDenunciaUltimoExpediente);
		}

		return "tipoVentas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb7804s00
	 *            TipoVenta Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TipoVenta> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TipoVenta> filter(
			@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - filter] : Obtener Ab7804s00s");
		return this.tipoVentasService.filter(filterAb7804s00, tableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb7804s00
	 *            TipoVenta Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAb7804s00
	 *            TipoVenta Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<TipoVenta> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TipoVenta>> search(
			@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody(param = "search") TipoVenta searchAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - search] : Buscar Ab7804s00s");
		return this.tipoVentasService.search(filterAb7804s00, searchAb7804s00, tableRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb7804s00
	 *            TipoVenta Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab7804s00s");
		this.tipoVentasService.removeMultiple(filterAb7804s00, tableRequestDto, false);
		TipoVentasController.logger.info("All entities correctly deleted!");

		return tableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb7804s00
	 *            TipoVenta Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TipoVenta>> jerarquia(
			@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - jerarquia] : Obtener Ab7804s00s jerarquia");
		return this.tipoVentasService.jerarquia(filterAb7804s00, tableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAb7804s00
	 *            TipoVenta Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TipoVenta>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TipoVenta>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - jerarquia] : Obtener Ab7804s00s jerarquia - Hijos");
		return this.tipoVentasService.jerarquiaChildren(filterAb7804s00, tableRequestDto);
	}

	/**
	 * EXPORTERS
	 */

	@RequestMapping(value = "/clipboardReport", method = RequestMethod.POST)
	protected @ResponseBody List<TipoVenta> getClipboardReport(
			@RequestJsonBody(param = "filter") TipoVenta filterAb7804s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoVentasController.logger.info("[POST - clipboardReport] : : Copiar multiples usuarios");
		return this.tipoVentasService.getMultiple(filterAb7804s00, tableRequestDto, false);
	}

}
