package com.ejie.ab78.control.maestros;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.service.maestros.TipoReclamacionesService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoReclamacionesController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/maestros/tipoReclamaciones")
public class TipoReclamacionesController {

	private static final Logger logger = LoggerFactory.getLogger(TipoReclamacionesController.class);

	@Autowired
	private TipoReclamacionesService tipoReclamacionesService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idTipoReclamacion
	 *            Long
	 * @return TipoReclamacion Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipoReclamacion}", method = RequestMethod.GET)
	public @ResponseBody TipoReclamacion get(@PathVariable Long idTipoReclamacion) {
		TipoReclamacion tipoReclamacion = new TipoReclamacion();
		tipoReclamacion.setIdTipoReclamacion(idTipoReclamacion);
		tipoReclamacion = this.tipoReclamacionesService.find(tipoReclamacion);
		TipoReclamacionesController.logger.info("[GET - findBy_PK] : Obtener TipoReclamacion por PK");
		return tipoReclamacion;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<TipoReclamacion> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoReclamacion> getAll(@ModelAttribute TipoReclamacion filterAb7805s00) {
		TipoReclamacionesController.logger.info("[GET - find_ALL] : Obtener TipoReclamacion por filtro");
		filterAb7805s00.setBaja(0);
		return this.tipoReclamacionesService.findAll(filterAb7805s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion Bean que contiene la informacion a modificar.
	 * @return TipoReclamacion Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoReclamacion edit(@RequestBody TipoReclamacion tipoReclamacion) {
		TipoReclamacion ab7805s00Aux = this.tipoReclamacionesService.update(tipoReclamacion);
		TipoReclamacionesController.logger.info("[PUT] : TipoReclamacion actualizado correctamente");
		return ab7805s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion Bean que contiene la informacion con la que se
	 *            va a crear el nuevo registro.
	 * @return TipoReclamacion Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoReclamacion add(@RequestBody TipoReclamacion tipoReclamacion) {
		TipoReclamacion ab7805s00Aux = this.tipoReclamacionesService.add(tipoReclamacion);
		TipoReclamacionesController.logger.info("[POST] : TipoReclamacion insertado correctamente");
		return ab7805s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idTipoReclamacion
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return TipoReclamacion Bean eliminado.
	 */
	@RequestMapping(value = "/{idTipoReclamacion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoReclamacion remove(@PathVariable Long idTipoReclamacion) {
		TipoReclamacion tipoReclamacion = new TipoReclamacion();
		tipoReclamacion.setIdTipoReclamacion(idTipoReclamacion);
		this.tipoReclamacionesService.remove(tipoReclamacion);
		TipoReclamacionesController.logger.info("[DELETE] : TipoReclamacion borrado correctamente");
		return tipoReclamacion;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model, HttpSession httpSession) {
		TipoReclamacionesController.logger.info("[GET - View] : ab7805s00");

		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE) != null) {
			Object folderIdUltimoExpediente = httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE);

			model.addAttribute("ultimoExpediente", folderIdUltimoExpediente);
		}
		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO) != null) {
			Object IdDenunciaUltimoExpediente = httpSession
					.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO);

			model.addAttribute("IdDenunciaUltimoExpediente", IdDenunciaUltimoExpediente);
		}

		return "tipoReclamaciones";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<TipoReclamacion> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<TipoReclamacion> filter(
			@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger.info("[POST - filter] : Obtener Ab7805s00s");
		return this.tipoReclamacionesService.filter(filterAb7805s00, tableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<TipoReclamacion> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<TipoReclamacion>> search(
			@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody(param = "search") TipoReclamacion searchAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger.info("[POST - search] : Buscar Ab7805s00s");
		return this.tipoReclamacionesService.search(filterAb7805s00, searchAb7805s00, tableRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab7805s00s");
		this.tipoReclamacionesService.removeMultiple(filterAb7805s00, tableRequestDto, false);
		TipoReclamacionesController.logger.info("All entities correctly deleted!");

		return tableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquia(
			@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger.info("[POST - jerarquia] : Obtener Ab7805s00s jerarquia");
		return this.tipoReclamacionesService.jerarquia(filterAb7805s00, tableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAb7805s00
	 *            TipoReclamacion Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<TipoReclamacion>> Dto que contiene
	 *         el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<TipoReclamacion>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger.info("[POST - jerarquia] : Obtener Ab7805s00s jerarquia - Hijos");
		return this.tipoReclamacionesService.jerarquiaChildren(filterAb7805s00, tableRequestDto);
	}

	/**
	 * EXPORTERS
	 */

	@RequestMapping(value = "/clipboardReport", method = RequestMethod.POST)
	protected @ResponseBody List<TipoReclamacion> getClipboardReport(
			@RequestJsonBody(param = "filter") TipoReclamacion filterAb7805s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		TipoReclamacionesController.logger.info("[POST - clipboardReport] : : Copiar multiples usuarios");
		return this.tipoReclamacionesService.getMultiple(filterAb7805s00, tableRequestDto, false);
	}

}
