package com.ejie.ab78.control.maestros;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.model.maestros.TipoEstablecimiento;
import com.ejie.ab78.service.maestros.TipoEstablecimientoService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;

@Controller
@RequestMapping(value = "/maestros/tipoEstablecimiento")

public class TipoEstablecimientoController {

	private static final Logger logger = LoggerFactory.getLogger(TipoEstablecimientoController.class);

	@Autowired
	private TipoEstablecimientoService tipoEstablecimientoService;

	@RequestMapping(value = "/{idTipoEstablecimiento}", method = RequestMethod.GET)
	public @ResponseBody TipoEstablecimiento get(@PathVariable String idTipoEstablecimiento) {
		TipoEstablecimiento filter = new TipoEstablecimiento();
		filter.setIdTipoEstablecimiento(idTipoEstablecimiento);
		filter = this.tipoEstablecimientoService.find(filter);
		TipoEstablecimientoController.logger.info("[GET - findBy_PK] : Obtener Ab6311s00 por PK");
		return filter;
	}

	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<TipoEstablecimiento> getAll(@ModelAttribute TipoEstablecimiento filter,
			@RequestParam(value = "otros", required = false) String otros) {
		TipoEstablecimientoController.logger.info("[GET - find_ALL] : Obtener Ab6311s00 por filtro");
		filter.setBaja(0);
		return this.tipoEstablecimientoService.findAll(filter, null, otros);
	}

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody TipoEstablecimiento edit(@RequestBody TipoEstablecimiento filter) {
		TipoEstablecimiento filterAux = this.tipoEstablecimientoService.update(filter);
		TipoEstablecimientoController.logger.info("[PUT] : Ab6311s00 actualizado correctamente");
		return filterAux;
	}

	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoEstablecimiento add(@RequestBody TipoEstablecimiento filter) {
		TipoEstablecimiento filterAux = this.tipoEstablecimientoService.add(filter);
		TipoEstablecimientoController.logger.info("[POST] : Ab6311s00 insertado correctamente");
		return filterAux;
	}

	@RequestMapping(value = "/{idTipoEstablecimiento}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody TipoEstablecimiento remove(@PathVariable String idTipoEstablecimiento) {
		TipoEstablecimiento filter = new TipoEstablecimiento();
		filter.setIdTipoEstablecimiento(idTipoEstablecimiento);
		// this.tipoEstablecimientoService.remove(filter);
		TipoEstablecimientoController.logger.info("[DELETE] : Ab6311s00 borrado correctamente");
		return filter;
	}

	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		TipoEstablecimientoController.logger.info("[GET - View] : ab6311s00");
		TipoEstablecimiento tipoEstablecimiento = new TipoEstablecimiento();
		model.addAttribute("busqTipoEstablecimiento", tipoEstablecimiento);
		// model.addAttribute("initForm", new InitForm());
		return "tiposEstablecimiento";
	}

	@RequestMapping(value = "/maint", method = RequestMethod.POST)
	public String getFormEditPOST(Model model) {
		TipoEstablecimientoController.logger.info("[GET - View] : ab6311s00");
		TipoEstablecimiento tipoEstablecimiento = new TipoEstablecimiento();
		model.addAttribute("busqTipoEstablecimiento", tipoEstablecimiento);
		// model.addAttribute("initForm", new InitForm());
		return "tiposEstablecimiento";
	}

	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody com.ejie.x38.dto.TableResponseDto<TipoEstablecimiento> filter(
			@RequestJsonBody(param = "filter") TipoEstablecimiento filterAb6311s00,
			@RequestJsonBody TableRequestDto jqGridRequestDto) {
		TipoEstablecimientoController.logger.info("[POST - filter] : Obtener Ab6311s00s");
		return this.tipoEstablecimientoService.filter(filterAb6311s00, jqGridRequestDto, false);
	}

}
