package com.ejie.ab78.control.maestros;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.Producto;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.service.maestros.ProductosService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProductosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/maestros/productos")
public class ProductosController {

	private static final Logger logger = LoggerFactory.getLogger(ProductosController.class);

	@Autowired
	private ProductosService productosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idProducto
	 *            Long
	 * @return Producto Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idProducto}", method = RequestMethod.GET)
	public @ResponseBody Producto get(@PathVariable Long idProducto) {
		Producto producto = new Producto();
		producto.setIdProducto(idProducto);
		producto = this.productosService.find(producto);
		ProductosController.logger.info("[GET - findBy_PK] : Obtener Producto por PK");
		return producto;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb7803s00
	 *            Producto Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Producto> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Producto> getAll(@ModelAttribute Producto filterAb7803s00) {
		ProductosController.logger.info("[GET - find_ALL] : Obtener Producto por filtro");
		filterAb7803s00.setBaja(0);
		return this.productosService.findAll(filterAb7803s00, null);
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterAb7803s00
	 *            Producto Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Producto> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/procedimientos/{idProcedimiento}", method = RequestMethod.GET)
	public @ResponseBody List<Producto> getAll(@ModelAttribute Producto filterAb7803s00,
			@PathVariable("idProcedimiento") Long idProcedimiento) {
		ProductosController.logger.info("[GET - find_ALL] : Obtener Producto por filtro");
		filterAb7803s00.setBaja(0);
		filterAb7803s00.setIdProcedimiento(idProcedimiento);
		return this.productosService.findAllFilterProcedimiento(filterAb7803s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param producto
	 *            Producto Bean que contiene la informacion a modificar.
	 * @return Producto Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Producto edit(@RequestBody Producto producto) {
		Producto ab7803s00Aux = this.productosService.update(producto);
		ProductosController.logger.info("[PUT] : Producto actualizado correctamente");
		return ab7803s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param producto
	 *            Producto Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Producto Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Producto add(@RequestBody Producto producto) {
		Producto ab7803s00Aux = this.productosService.add(producto);
		ProductosController.logger.info("[POST] : Producto insertado correctamente");
		return ab7803s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idProducto
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Producto Bean eliminado.
	 */
	@RequestMapping(value = "/{idProducto}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Producto remove(@PathVariable Long idProducto) {
		Producto producto = new Producto();
		producto.setIdProducto(idProducto);
		this.productosService.remove(producto);
		ProductosController.logger.info("[DELETE] : Producto borrado correctamente");
		return producto;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model, HttpSession httpSession) {
		ProductosController.logger.info("[GET - View] : ab7803s00");

		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE) != null) {
			Object folderIdUltimoExpediente = httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE);

			model.addAttribute("ultimoExpediente", folderIdUltimoExpediente);
		}
		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO) != null) {
			Object IdDenunciaUltimoExpediente = httpSession
					.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO);

			model.addAttribute("IdDenunciaUltimoExpediente", IdDenunciaUltimoExpediente);
		}

		return "productos";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb7803s00
	 *            Producto Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Producto> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Producto> filter(@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - filter] : Obtener Ab7803s00s");
		return this.productosService.filter(filterAb7803s00, tableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAb7803s00
	 *            Producto Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAb7803s00
	 *            Producto Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Producto> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Producto>> search(@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody(param = "search") Producto searchAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - search] : Buscar Ab7803s00s");
		return this.productosService.search(filterAb7803s00, searchAb7803s00, tableRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAb7803s00
	 *            Producto Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Ab7803s00s");
		this.productosService.removeMultiple(filterAb7803s00, tableRequestDto, false);
		ProductosController.logger.info("All entities correctly deleted!");

		return tableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAb7803s00
	 *            Producto Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<Producto>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<Producto>> jerarquia(
			@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - jerarquia] : Obtener Ab7803s00s jerarquia");
		return this.productosService.jerarquia(filterAb7803s00, tableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAb7803s00
	 *            Producto Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<Producto>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<Producto>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - jerarquia] : Obtener Ab7803s00s jerarquia - Hijos");
		return this.productosService.jerarquiaChildren(filterAb7803s00, tableRequestDto);
	}

	/**
	 * EXPORTERS
	 */

	@RequestMapping(value = "/clipboardReport", method = RequestMethod.POST)
	protected @ResponseBody List<Producto> getClipboardReport(
			@RequestJsonBody(param = "filter") Producto filterAb7803s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ProductosController.logger.info("[POST - clipboardReport] : : Copiar multiples usuarios");
		return this.productosService.getMultiple(filterAb7803s00, tableRequestDto, false);
	}

}
