package com.ejie.ab78.control.listados;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab78.model.listados.Parametros;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.service.listados.ParametrosService;

@Controller
@SessionAttributes("usuario")
@RequestMapping(value = "/parametros")
public class ParametrosController {

	private static final Logger logger = LoggerFactory.getLogger(ParametrosController.class);

	@Autowired
	private ParametrosService parametrosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String mostrarParametro(Model model, @ModelAttribute(value = "usuario") Usuario usuario) {
		ParametrosController.logger.info("[GET - View] : listados");
		return "parametrosExpediente";
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterParametros
	 *            Parametros Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Parametros> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/{idListado}", method = RequestMethod.GET)
	public @ResponseBody List<Parametros> getAllParametros(Model model, @ModelAttribute Parametros filterParametros,
			@PathVariable Integer idBusqueda) {
		ParametrosController.logger.info("[GET - find_ALL] : Obtener Parametros por filtro");
		filterParametros.setIdBusqueda(idBusqueda);
		return parametrosService.findAllLike(filterParametros, null, null);
	}

}
