package com.ejie.ab78.control.listados;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;

import com.ejie.ab78.model.listados.Busquedas;
import com.ejie.ab78.service.listados.BusquedasService;

/**
 * ListadosController  
 * 
 *  
 */

@Controller
@SessionAttributes("usuario")
@RequestMapping(value = "/busquedas")

public class BusquedasController {

	private static final Logger logger = LoggerFactory.getLogger(BusquedasController.class);

	@Autowired
	private BusquedasService busquedasService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 *
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 *
	 * @param idListado
	 *            Integer
	 * @return Busquedas Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idListado}/{idBusqueda}", method = RequestMethod.GET)
	public @ResponseBody Busquedas get(@PathVariable Integer idListado, @PathVariable Integer idBusqueda) {
		Busquedas busquedas = new Busquedas();
		busquedas.setIdBusqueda(idBusqueda);
		busquedas = this.busquedasService.find(busquedas);
		BusquedasController.logger.info("[GET - findBy_PK] : Obtener Busquedas porPK");
		return busquedas;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterParametros
	 *            Busquedas Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Busquedas> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(value = "/{idListado}", method = RequestMethod.GET)
	public @ResponseBody List<Busquedas> getAll(Model model, @ModelAttribute Busquedas filterBusquedas,
			@PathVariable Integer idListado) {
		BusquedasController.logger.info("[GET - find_ALL] : Obtener busquedas por filtro");
		filterBusquedas.setIdListado(idListado);
		return busquedasService.findAllLike(filterBusquedas, null, null);
	}
}
