package com.ejie.ab78.control.inicio;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * FolderErrorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/denuncias/expediente-error")

public class FolderErrorController {

	private static final Logger logger = LoggerFactory.getLogger(FolderErrorController.class);

	@RequestMapping(value = "/{folderId}", method = RequestMethod.GET)
	public String getFormNoExiste(Model model, @PathVariable("folderId") String folderID) {
		FolderErrorController.logger.info("[GET - View] : error acceso desde TGune: %s", folderID);
		model.addAttribute("folderID", folderID);
		return "folderNoExiste";
	}

	@RequestMapping(method = RequestMethod.GET)
	public String getFormError(Model model) {
		FolderErrorController.logger.info("[GET - View] : error acceso desde TGune");

		return "folderError";
	}
}
