/**
 * 
 */
package com.ejie.ab78.control.expedientes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab78.adaptadores.ab61WebServiceAdaptadorService;
import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.comun.UtilsConfig;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.denuncias.IrregularidadDenuncia;
import com.ejie.ab78.model.expedientes.ExpedienteHistorico;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.ab78.model.plantillas.ParametrosConfig;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.RelDenunciaTercero;
import com.ejie.ab78.model.terceros.RelExpTer;
import com.ejie.ab78.model.terceros.TiposTercero;
import com.ejie.ab78.model.terceros.VistaDatosExpediente;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.denuncias.DenunciasService;
import com.ejie.ab78.service.denuncias.IrregularidadesDenunciaService;
import com.ejie.ab78.service.expedientes.DetailExpedienteService;
import com.ejie.ab78.service.expedientes.ExpedientesHistoricosService;
import com.ejie.ab78.service.expedientes.ExpedientesService;
import com.ejie.ab78.service.maestros.IrregularidadesService;
import com.ejie.ab78.service.plantillas.ParametrosConfigService;
import com.ejie.ab78.service.procedimientos.ProcedimientosService;
import com.ejie.ab78.service.procedimientos.ProcedureActionFacade;
import com.ejie.ab78.service.procedimientos.ProcedureActions;
import com.ejie.ab78.service.terceros.DatosDireccionesService;
import com.ejie.ab78.service.terceros.RelDenunciaTerceroService;
import com.ejie.ab78.service.terceros.RelExpTerService;

/**
 * Clase base para la ficha de expediente
 */
public abstract class ExpedienteBaseContoller implements DetailExpedienteService {

	private static final Logger logger = LoggerFactory.getLogger(ExpedienteBaseContoller.class);

	@Autowired
	private DenunciasService denunciasService;

	@Autowired
	private RelExpTerService relExpTerService;

	@Autowired
	private ExpedientesService expedientesService;

	@Autowired
	private ExpedientesHistoricosService historicosService;

	@Autowired
	private ProcedimientosService procedimientosService;

	@Autowired
	private DatosDireccionesService datosDireccionesService;

	@Autowired
	private ParametrosConfigService parametrosConfigService;

	@Autowired
	private RelDenunciaTerceroService relDenunciaTerceroService;

	@Autowired
	private ab61WebServiceAdaptadorService ab61WebServiceService;

	@Autowired
	private IrregularidadesService irregularidadesService;

	@Autowired
	private IrregularidadesDenunciaService irregularidadesDenunciaService;

	/**
	 * 
	 */
	public ExpedienteBaseContoller() {

	}

	protected abstract void setCurrentPageModel(Model model, Expedientes initForm);

	protected abstract String getTilesPage();

	protected abstract String getCurrentPage();

	/**
	 * 
	 * @param relExpTerService
	 * @param expedientesService
	 * @param procedimientosService
	 * @param datosDireccionesService
	 * @param establecimientoService
	 * @param agenciaDataService
	 */
	public ExpedienteBaseContoller(RelExpTerService relExpTerService, ExpedientesService expedientesService,
			ProcedimientosService procedimientosService, DatosDireccionesService datosDireccionesService) {
		this.relExpTerService = relExpTerService;
		this.expedientesService = expedientesService;
		this.procedimientosService = procedimientosService;
		this.datosDireccionesService = datosDireccionesService;

	}

	protected final ModelAndView mostrar(Model model, Expedientes expediente) throws Exception {
		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		ExpedienteBaseContoller.logger.info("autotenticacion:getAuthentication" + aut);

		/** Dejamos el usuario logueado en session */
		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		if ((expediente != null && expediente.getIdExpediente() != null)
				|| expediente != null && expediente.getProcedimientos() != null
						&& Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(expediente.getProcedimientos().getTipoDenuncia())
						&& expediente.getFolderId() == null) {
			// Carga el idioma en el model
			setLanguageFromContext(model, expediente);

			if (expediente.getFolderId() != null) {
				// Informacion de PLATEA
				setInfoExpedientePlatea(model, expediente, usuario);
			}

			// Recupera el parametro para la inspeccion de expedientes cerrados
			// de AB61
			boolean paramInspeccionAb61 = getA61Inspeccionable();

			if (Constantes.PROCEDIMIENTO_INSPECCIONABLE.equals(expediente.getProcedimientos().getInspeccionable())) {
				boolean expedienteCerrado = this.expedientesService.esExpedienteCerrado(expediente);
				if (expedienteCerrado) {
					if (paramInspeccionAb61) {
						model.addAttribute("esInspeccionable", true);
					} else {
						model.addAttribute("esInspeccionable", false);
					}
				} else {
					model.addAttribute("esInspeccionable", true);
				}
			} else {
				model.addAttribute("esInspeccionable", false);
			}
			
			boolean expedienteCerrado = this.expedientesService.esExpedienteCerrado(expediente);
			if (expedienteCerrado) {
				model.addAttribute("expedienteCerrado", true);
			}else{
				model.addAttribute("expedienteCerrado", false);
			}

			// Carga la informacion del nucleo necesaria
			setNucleoDependencies(model, expediente);

			// Recupera el procedimiento del nucleo
			Procedimientos procedimientos = setProcedimientoExpediente(model, expediente);
			expediente.setProcedimientos(procedimientos);

			// Recuperar el establecimiento creado con el expediente
			ProcedureActions procedureActions = getProcedureActions(expediente);
			loadDenunciaExpediente(procedureActions, model, expediente);

			setCurrentPageModel(model, expediente);

			if (expediente != null && expediente.getProcedimientos() != null
					&& expediente.getProcedimientos().getTipoDenuncia() != null) {
				model.addAttribute("tipoDenuncia", expediente.getProcedimientos().getTipoDenuncia());
			}

			model.addAttribute("expediente", expediente);
			model.addAttribute("isEnableSaveButton", procedureActions.isEnableSaveExpediente(expediente));
			model.addAttribute("isEnableExecuteAction", procedureActions.isEnableExecuteAction(expediente));
			model.addAttribute("hasSecondButton", procedureActions.hasSecondButton(expediente));
			model.addAttribute("isEnableAccessCenso", procedureActions.isEnableAccessCenso(expediente));
			model.addAttribute("isInspectionable", procedureActions.isInspectionable(expediente));
			model.addAttribute("isEnableInspect", procedureActions.isEnableInspect(expediente));
			model.addAttribute("isEnableAccessInspecciones", procedureActions.isEnableAccessInspecciones(expediente));
			model.addAttribute("isEnableCreateDocs", procedureActions.isEnableCreateDocs(expediente));
			model.addAttribute("isEnableShowUbicacionEstablecimiento",
					procedureActions.isEnableShowUbicacionEstablecimiento(expediente));
			model.addAttribute("isCloseExpediente", procedureActions.isCloseExpediente(expediente));
			model.addAttribute("titleButtons", procedureActions.getButtonsText(expediente));
			model.addAttribute("isExpedienteOficio", expediente.isExpedienteOficio());
			model.addAttribute("paramInspeccionAb61", paramInspeccionAb61);

			return new ModelAndView(getTilesPage(), "model", model);
		} else {
			return new ModelAndView("folderError");
		}
	}

	protected final ModelAndView mostrarMigrados(Model model, Integer idDenuncia) throws Exception {
		Authentication aut = SecurityContextHolder.getContext().getAuthentication();
		ExpedienteBaseContoller.logger.info("autotenticacion:getAuthentication" + aut);

		/** Dejamos el usuario logueado en session */
		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		Denuncia denuncia = this.getDenunciasService().find(new Denuncia(idDenuncia));

		if (null != denuncia && null != denuncia.getIdReclamacion()) {

			setLanguageFromContext(model, null);
			List<RelDenunciaTercero> listaDefinitivaRelDenunciaTercero = relDenunciaTerceroService
					.getRelDenunciaTerceroByIdReclamacion(denuncia);

			cargarTercerosDenunciaVista(model, listaDefinitivaRelDenunciaTercero);

			// try load from historic
			ExpedienteHistorico historico = historicosService.findByDenuncia(denuncia);

			String procedimiento = "";
			if (historico != null && historico.getIdExpHistorico() != null) {
				String url = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
				url = url.replace("[folderID]", historico.getFolderId());

				procedimiento = historico.getNombreProcedimiento();
				model.addAttribute("urlVerDocumentos", url);
			}

			model.addAttribute("procedimiento", procedimiento);
			model.addAttribute("urlab61", UtilsConfig.getAppProperties().getProperty("URLAB61"));
			model.addAttribute("denuncia", denuncia);

			if (null != denuncia.getExpediente() && null != denuncia.getExpediente().getIdExpediente()) {

				Expedientes expediente = this.expedientesService
						.find(new Expedientes(denuncia.getExpediente().getIdExpediente()));
				model.addAttribute("expediente", expediente);
				model.addAttribute("folderNumber", expediente.getFolderNumber());
				model.addAttribute("tituloExpediente", expediente.getTitulo());
			} else {
				model.addAttribute("expediente", null);
			}
			model.addAttribute("isEnableSaveButton", true);
			model.addAttribute("isExpedienteMigrado", true);
			return new ModelAndView(getTilesPage(), "model", model);
		} else {
			return new ModelAndView("folderError");
		}

	}

	private void cargarTercerosDenunciaVista(Model model, List<RelDenunciaTercero> listaDefinitivaRelDenunciaTercero) {
		List<RelDenunciaTercero> listaDenunciantes = new ArrayList<RelDenunciaTercero>();
		List<RelDenunciaTercero> listaDenunciados = new ArrayList<RelDenunciaTercero>();
		List<RelDenunciaTercero> listaAfectados = new ArrayList<RelDenunciaTercero>();
		Integer numeroPartesInculpadas = 0;

		for (RelDenunciaTercero relDenunciaTercero : listaDefinitivaRelDenunciaTercero) {
			if (null != relDenunciaTercero.getIdTipoTercero()) {
				if (Constantes.ID_TIPO_TERCERO_SOLICITANTE == relDenunciaTercero.getIdTipoTercero()) {
					listaDenunciantes.add(relDenunciaTercero);
				} else if (Constantes.ID_TIPO_TERCERO_DENUNCIADO == relDenunciaTercero.getIdTipoTercero()) {
					listaDenunciados.add(relDenunciaTercero);
				} else if (Constantes.ID_TIPO_TERCERO_AFECTADO == relDenunciaTercero.getIdTipoTercero()) {
					listaAfectados.add(relDenunciaTercero);
					if (Constantes.ID_SUBTIPO_TERCERO_PARTES_INCULPADAS == relDenunciaTercero.getIdSubtipo()) {
						numeroPartesInculpadas++;
					}
				}
			}
		}

		model.addAttribute("numeroPartesInculpadas", numeroPartesInculpadas);
		model.addAttribute("listaAfectados", listaAfectados);
		model.addAttribute("listaDenunciantes", listaDenunciantes);
		model.addAttribute("listaDenunciados", listaDenunciados);
		model.addAttribute("nDenunciados", listaDenunciados.size());
		model.addAttribute("nAfectados", listaAfectados.size());
	}

	protected void setLanguageFromContext(Model model, Expedientes initForm) {
		String idioma = LocaleContextHolder.getLocale().getLanguage();
		// initForm.setIdioma(idioma);
		model.addAttribute("lenguaje", idioma);
	}

	protected void setInfoExpedientePlatea(Model model, Expedientes expediente, Usuario usuario) throws Exception {
		boolean resultado = ab61WebServiceService.actualizarParticipaciones(expediente.getFolderId(),
				UtilUsuario.getUserConnected());
		expediente.setExpedienteOficio(false);
		model.addAttribute("flagSearchFolder", resultado);
	}

	protected void setNucleoDependencies(Model model, Expedientes expediente) {
		Integer idTercero = 0;

		DatosDirecciones direccionEstablecimiento = this.datosDireccionesService
				.findEstablecimientoExpediente(expediente.getIdExpediente());
		DatosDirecciones postalTitular;
		if (direccionEstablecimiento == null || direccionEstablecimiento.getIdDireccion() == null) {
			// Si no hay un tercero con direccion establecimiento
			idTercero = this.relExpTerService.findFirstTerceroWhitoutEstablecimiento(expediente.getIdExpediente());
		} else {
			idTercero = direccionEstablecimiento.getDatosTerceros().getIdTercero();
		}

		postalTitular = this.datosDireccionesService.findPostalTerceroId(idTercero);
		if (postalTitular != null && postalTitular.getIdDireccion() != null) {
			model.addAttribute("listaDomicilio", postalTitular);
			model.addAttribute("isEnableShowDireccionPostal", true);
		} else {
			model.addAttribute("isEnableShowDireccionPostal", false);
		}

		List<RelExpTer> listaParticipantes = relExpTerService.findParticipaciones(expediente.getIdExpediente());
		List<RelDenunciaTercero> listaAuxRelDenunciaTercero = new ArrayList<RelDenunciaTercero>();
		for (RelExpTer relExpTer : listaParticipantes) {
			if (null != relExpTer.getDatosTercerosList() && !relExpTer.getDatosTercerosList().isEmpty()
					&& relExpTer.getDatosTercerosList().size() > 1) {
				for (int i = 0; i < relExpTer.getDatosTercerosList().size(); i++) {
					TiposTercero tipoTercero = new TiposTercero(relExpTer.getTiposTercero().getIdTipoTercero());
					DatosTerceros datosTerceros = relExpTer.getDatosTercerosList().get(i);
					datosTerceros.setTiposTercero(tipoTercero);
					datosTerceros.setParticipantId(relExpTer.getParticipantId());

					RelDenunciaTercero denunciaTercero = new RelDenunciaTercero();
					denunciaTercero.setIdRelRecTer(relExpTer.getIdRelExpTer());
					denunciaTercero.setDatosTerceros(datosTerceros);
					denunciaTercero.setIdTipoTercero(tipoTercero.getIdTipoTercero());
					denunciaTercero.setParticipantId(relExpTer.getParticipantId());
					denunciaTercero.setIdSubtipo(relExpTer.getIdSubtipo());
					listaAuxRelDenunciaTercero.add(denunciaTercero);
				}
			} else {
				DatosTerceros datosTerceros = relExpTer.getDatosTercerosList().get(0);
				TiposTercero tipoTercero = new TiposTercero(relExpTer.getTiposTercero().getIdTipoTercero());
				datosTerceros.setTiposTercero(tipoTercero);
				datosTerceros.setParticipantId(relExpTer.getParticipantId());

				RelDenunciaTercero denunciaTercero = new RelDenunciaTercero();
				denunciaTercero.setIdRelRecTer(relExpTer.getIdRelExpTer());
				denunciaTercero.setDatosTerceros(datosTerceros);
				denunciaTercero.setIdTipoTercero(tipoTercero.getIdTipoTercero());
				denunciaTercero.setParticipantId(relExpTer.getParticipantId());
				denunciaTercero.setIdSubtipo(relExpTer.getIdSubtipo());
				listaAuxRelDenunciaTercero.add(denunciaTercero);
			}
		}

		// Consulta a AB7808T00 tras sincronizacin
		cargarTercerosDenunciaVista(model, listaAuxRelDenunciaTercero);

		// Migrados que no tengan folderID
		if (expediente.getFolderId() != null) {
			String url = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
			String urlOrigen = UtilsConfig.getAppProperties().getProperty("urlVerDocumento");
			url = url.replace("[folderID]", expediente.getFolderId());
			expediente.setTituloExpediente(expediente.getFolderNumber() + " - " + expediente.getTitulo());
			// initForm.setIdTerceroTitular(idTercero);
			Expedientes expedientes = this.expedientesService.find(new Expedientes(expediente.getIdExpediente()));
			if (expedientes.getTitulo() != null) {
				expediente.setTitulo(expedientes.getTitulo());
			}
			if (expedientes.getIdExpedienteOrigen() != null && expedientes.getIdExpedienteOrigen() > 0) {
				Expedientes expedientesOrigen = this.expedientesService
						.find(new Expedientes(expedientes.getIdExpedienteOrigen()));
				expediente.setIdExpedienteOrigen(expedientes.getIdExpedienteOrigen());
				model.addAttribute("urlVerDocumentosOrigen",
						urlOrigen.replace("[folderID]", expedientesOrigen.getFolderId()));
			} else {
				model.addAttribute("urlVerDocumentosOrigen", urlOrigen);
			}

			model.addAttribute("urlVerDocumentos", url);
			model.addAttribute("ab61_folderID", expediente.getFolderId());
		}

		model.addAttribute("urlab61", UtilsConfig.getAppProperties().getProperty("URLAB61"));
		model.addAttribute("idTercero", idTercero);
		model.addAttribute("folderNumber", expediente.getFolderNumber());
		model.addAttribute("tituloExpediente", expediente.getTitulo());
		model.addAttribute("hasExpedienteOrigen",
				expediente.getIdExpedienteOrigen() != null && expediente.getIdExpedienteOrigen() > 0);
	}

	protected Procedimientos setProcedimientoExpediente(Model model, Expedientes expediente) {
		Expedientes expedienteProcemiento = expedientesService
				.findProcedureIdPorExpediente(new Expedientes(expediente.getIdExpediente()));
		Procedimientos proced = procedimientosService.find(expedienteProcemiento.getProcedimientos());
		if (proced != null) {
			expediente.setProcedimientos(proced);
			model.addAttribute("procedimiento", Constantes.EUSKERA.equals(LocaleContextHolder.getLocale().getLanguage())
					? proced.getTituloProcedimientoCompletoEu() : proced.getTituloProcedimientoCompletoEs());
		}

		return proced;
	}

	private void loadDenunciaExpediente(ProcedureActions procedureActions, Model model, Expedientes expediente) {
		ExpedienteBaseContoller.logger.info("[GET - findBy_PK] : Obtener Denuncia por Expediente");
		Denuncia denuncia = new Denuncia();
		denuncia.setExpediente(expediente);
		denuncia = this.getDenunciasService().findByIdExpediente(denuncia);

		if (expediente != null && expediente.getProcedimientos() != null
				&& expediente.getProcedimientos().getTipoDenuncia() != null
				&& Constantes.TIPO_DENUNCIA_NO_FORMAL.equals(expediente.getProcedimientos().getTipoDenuncia())) {
			IrregularidadDenuncia irregularidadDenuncia = new IrregularidadDenuncia();
			if (denuncia != null && denuncia.getIdReclamacion() != null) {
				irregularidadDenuncia.setDenuncia(new Denuncia(denuncia.getIdReclamacion()));
				List<IrregularidadDenuncia> irregularidadDenuncias = this.irregularidadesDenunciaService
						.findAll(irregularidadDenuncia, null);
				denuncia.setIrregularidadDenuncias(irregularidadDenuncias);

				Irregularidad filterIrregularidad = new Irregularidad();
				filterIrregularidad.setBaja(0);
				List<Irregularidad> listIrregularidades = this.irregularidadesService.findAll(filterIrregularidad,
						null);

				model.addAttribute("irregularidades", listIrregularidades);
			}
		}

		model.addAttribute("denuncia", denuncia);
	}

	protected void setListParticipantes(Model model, Expedientes initForm) {
		Long tipoParticipantePrincipal = (long) Constantes.PARTICIPACION_SOLICITANTE;
		if (initForm.isExpedienteOficio() != null && initForm.isExpedienteOficio()) {
			tipoParticipantePrincipal = (long) Constantes.PARTICIPACION_AFECTADO;
		}
		List<VistaDatosExpediente> listaParticipantesParticipacion = relExpTerService
				.findParticipaciones2(initForm.getIdExpediente(), tipoParticipantePrincipal);
		model.addAttribute("listaSearch", listaParticipantesParticipacion.get(0).getVistaTercerosList());
		ExpedienteBaseContoller.logger.info("[INICIO] Participantes " + listaParticipantesParticipacion.size()
				+ " para el expediente : " + initForm.getIdExpediente());
	}

	// Button Guardar
	public ResultAjaxOperation saveExpediente(Denuncia denuncia, HttpServletRequest request) {
		ProcedureActions procedureActions = getProcedureActions(denuncia.getExpediente());

		// if can execute but hasn't another button,
		// -> execute action
		// else only update expediente
		Boolean execute = !procedureActions.hasSecondButton(denuncia.getExpediente())
				&& procedureActions.isEnableExecuteAction(denuncia.getExpediente());

		return save(denuncia, request, execute);
	}

	public ResultAjaxOperation saveDenuncia(Denuncia denuncia) {
		return getDenunciasService().saveDenuncia(denuncia);
	}

	public ResultAjaxOperation save(Denuncia denuncia, HttpServletRequest request, Boolean executeProcess) {
		ProcedureActions procedureActions = getProcedureActions(denuncia.getExpediente());
		ResultAjaxOperation result = expedientesService.save(denuncia, procedureActions, request, executeProcess);
		if (result.getResult() == Constantes.AJAX_OK) {
			expedientesService.updateExpedienteTitle(denuncia, ((SuccessResultAjaxOperation) result).getData(),
					procedureActions);
		}
		return result;
	}

	protected final void setTabsConfig(Model model, Procedimientos procedimientos, String currentPage) {
		model.addAttribute("currentPage", currentPage);
		ProcedureActions action = getProcedureActions(procedimientos.getCodProcedureId());
		if (action != null) {
			List<String> configs = action.getPestanaConfig();
			for (Iterator<String> iterator = configs.iterator(); iterator.hasNext();) {
				String configOption = iterator.next();
				model.addAttribute(configOption, configOption);
			}
		}
	}

	protected ProcedureActions getProcedureActions(String procedureCod) {
		ProcedureActions action = ProcedureActionFacade.getInstance().getProcedureAction(procedureCod, this);
		if (action == null) {
			action = ProcedureActionFacade.getInstance().getDefault();
		}
		return action;
	}

	protected ProcedureActions getProcedureActions(Expedientes initForm) {
		ProcedureActions action = ProcedureActionFacade.getInstance()
				.getProcedureAction(initForm.getProcedimientos().getCodProcedureId(), this);
		if (action == null) {
			action = ProcedureActionFacade.getInstance().getDefault();
		}
		return action;
	}

	protected boolean getA61Inspeccionable() {
		ParametrosConfig parametrosConfig = new ParametrosConfig();
		parametrosConfig.setDescripcion(Constantes.PARAMETRO_CONFIG_INSPECCIONABLE_AB61);
		parametrosConfig = parametrosConfigService.find(parametrosConfig);
		if (null != parametrosConfig && parametrosConfig.getValor() == 1) {
			return true;
		}
		return false;

	}

	/*
	 * GETTER/SETTER
	 */

	@Override
	public RelExpTerService getRelExpTerService() {
		return relExpTerService;
	}

	public void setRelExpTerService(RelExpTerService relExpTerService) {
		this.relExpTerService = relExpTerService;
	}

	@Override
	public ExpedientesService getExpedientesService() {
		return expedientesService;
	}

	public void setExpedientesService(ExpedientesService expedientesService) {
		this.expedientesService = expedientesService;
	}

	@Override
	public ProcedimientosService getProcedimientosService() {
		return procedimientosService;
	}

	public void setProcedimientosService(ProcedimientosService procedimientosService) {
		this.procedimientosService = procedimientosService;
	}

	@Override
	public DatosDireccionesService getDatosDireccionesService() {
		return datosDireccionesService;
	}

	public void setDatosDireccionesService(DatosDireccionesService datosDireccionesService) {
		this.datosDireccionesService = datosDireccionesService;
	}

	@Override
	public ParametrosConfigService getParametrosConfigService() {
		return parametrosConfigService;
	}

	public void setParametrosConfigService(ParametrosConfigService parametrosConfigService) {
		this.parametrosConfigService = parametrosConfigService;
	}

	@Override
	public DenunciasService getDenunciasService() {
		return denunciasService;
	}

	public void setDenunciasService(DenunciasService denunciasService) {
		this.denunciasService = denunciasService;
	}
}
