package com.ejie.ab78.control.direcciones;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import com.ejie.ab78.model.procedimientos.Direcciones;
import com.ejie.ab78.service.direcciones.DireccionesService;

@Controller
@RequestMapping(value = "/direcciones")

public class DireccionesController {

	private static final Logger logger = LoggerFactory.getLogger(DireccionesController.class);

	@Autowired
	private DireccionesService direccionesService;

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterDirecciones
	 *            Direcciones Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Direcciones> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Direcciones> getAll(@ModelAttribute Direcciones filterDirecciones) {
		DireccionesController.logger.info("[GET - find_ALL] : Obtener Direcciones por filtro");
		return this.direccionesService.findAll(filterDirecciones, null);
	}
}
