
package com.ejie.ab78.control.denuncias;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilDate;
import com.ejie.ab78.model.Aviso;
import com.ejie.ab78.model.denuncias.DenunciaNoFormal;
import com.ejie.ab78.model.denuncias.ExpedienteDenuncia;
import com.ejie.ab78.model.util.ErrorResultAjaxOperation;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.denuncias.ExpedienteDenunciaService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.reports.ReportData;

@Controller
@RequestMapping(value = "/expediente-denuncia")

public class ExpedienteDenunciaController {

	private static final Logger logger = LoggerFactory.getLogger(ExpedienteDenunciaController.class);

	@Autowired
	private ExpedienteDenunciaService expedienteDenunciaService;

	@Autowired
	@Qualifier(value = "messageSource")
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb7801s00
	 *            Denuncia Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Denuncia> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<ExpedienteDenuncia> filter(
			@RequestJsonBody(param = "filter") ExpedienteDenuncia expedienteDenuncia,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		ExpedienteDenunciaController.logger.info("[POST - filter] : Obtener Ab7801s00s");
		return this.expedienteDenunciaService.filter(expedienteDenuncia, tableRequestDto, false);
	}

	@RequestMapping(value = "/generarXLS", method = RequestMethod.POST)
	protected ModelAndView getExcelBusqEstablecimientos(@ModelAttribute ExpedienteDenuncia expedienteDenuncia,
			ModelMap modelMap, @RequestParam(value = "columns", required = false) String columns,
			@RequestParam(value = "order", required = false) String order,
			@RequestParam(value = "sort", required = false) String sort) {

		ExpedienteDenunciaController.logger.info("[POST - getExcelDenunciasFormales] :");
		TableRequestDto filter = new TableRequestDto();
		filter.setSidx(order);
		filter.setSord(sort);
		List<ExpedienteDenuncia> listExpedienteDenuncia = this.expedienteDenunciaService.findAllLike(expedienteDenuncia,
				filter, false);

		modelMap.put("fileName", "DenunciasFormales");

		List<Object> reportData = new ArrayList<Object>();
		// Hoja 1
		ReportData<DenunciaNoFormal> usuarioExcelDataAll = new ReportData<DenunciaNoFormal>();
		// nombre hoja
		usuarioExcelDataAll.setSheetName("DenunciasFormales");
		// cabeceras hoja
		Locale locale = LocaleContextHolder.getLocale();
		String tipoFinalizacion;
		if (locale.getLanguage() == "eu") {
			tipoFinalizacion = "descDecisionEU";
		} else {
			tipoFinalizacion = "descDecisionES";
		}

		columns = "[['numDenunciaFormateado','" + appMessageSource.getMessage("excel.numDenuncia", null, locale) + "']"
				+ ",['folderNumber','" + appMessageSource.getMessage("excel.numExpediente", null, locale) + "']"
				+ ",['fechaPresentacionFormateada','"
				+ appMessageSource.getMessage("excel.fechaPresentacion", null, locale) + "']" + ",['nombreAfectados','"
				+ appMessageSource.getMessage("excel.afectados", null, locale) + "']" + ",['denunciante','"
				+ appMessageSource.getMessage("excel.denunciante", null, locale) + "']" + ",['denunciadoFormateado','"
				+ appMessageSource.getMessage("excel.denunciado", null, locale) + "']" + ",['direccionDenunciado','"
				+ appMessageSource.getMessage("excel.direccionDenunciado", null, locale) + "']" + ",['"
				+ tipoFinalizacion + "','" + appMessageSource.getMessage("excel.tipoFinalizacion", null, locale)
				+ "']]";
		usuarioExcelDataAll.setHeaderNames(ReportData.parseColumns(columns));
		// datos hoja
		if (null != listExpedienteDenuncia && !listExpedienteDenuncia.isEmpty()) {
			usuarioExcelDataAll.setModelData(listExpedienteDenuncia);
		}

		reportData.add(usuarioExcelDataAll);

		modelMap.put("reportData", reportData);

		return new ModelAndView("xlsxReport", modelMap);
	}

	@RequestMapping(value = "/avisoPorFecha", method = RequestMethod.POST)
	public @ResponseBody ResultAjaxOperation avisoPorFecha() {
		Date hoy = UtilDate.fechaHoy();
		ArrayList response = new ArrayList();
		try {
			List<Aviso> avisos = this.expedienteDenunciaService.avisoPorFecha(Constantes.AB78_ID_APLICACION);
			for (Iterator<Aviso> iterator = avisos.iterator(); iterator.hasNext();) {
				Aviso aviso = (Aviso) iterator.next();
				if (aviso.getFechaInicio().before(hoy) && aviso.getFechaFin().after(hoy)) {
					response.add(aviso.getDescEs().toString());
					response.add(aviso.getDescEu().toString());
				}
			}
		} catch (Exception e) {
			ExpedienteDenunciaController.logger.info("avisoPorFecha " + e.getMessage());
			return new ErrorResultAjaxOperation("error");
		}
		return new SuccessResultAjaxOperation(response.toString());
	}
}
