package com.ejie.ab78.control.denuncias;

import java.util.List;
import java.util.Vector;

import javax.annotation.Resource;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.establecimientos.Establecimiento;
import com.ejie.ab78.model.usuario.Usuario;
import com.ejie.ab78.model.util.ErrorResultAjaxOperation;
import com.ejie.ab78.model.util.ResultAjaxOperation;
import com.ejie.ab78.model.util.SuccessResultAjaxOperation;
import com.ejie.ab78.service.denuncias.DenunciasService;
import com.ejie.ab78.service.establecimientos.EstablecimientoService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.security.UserCredentials;

/**
 * DenunciasController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/")

public class DenunciasController {

	private static final Logger logger = LoggerFactory.getLogger(DenunciasController.class);

	@Autowired
	private DenunciasService denunciasService;

	@Autowired
	private EstablecimientoService establecimientoService;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idReclamacion
	 *            Integer
	 * @return Denuncia Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idReclamacion}", method = RequestMethod.GET)
	public ModelAndView get(@PathVariable String idReclamacion, Model model) {
		if (Constantes.ACCESS_DENIED.equals(idReclamacion)) {
			return new ModelAndView("accessDenied", "model", model);
		} else if (Constantes.ACCESS_ERROR.equals(idReclamacion)) {
			return new ModelAndView("error", "model", model);
		}
		Integer idReclamacionInt = Integer.parseInt(idReclamacion);
		Denuncia denuncia = new Denuncia();
		denuncia.setIdReclamacion(idReclamacionInt);
		denuncia = this.denunciasService.find(denuncia);
		DenunciasController.logger.info("[GET - findBy_PK] : Obtener Denuncia por PK");
		model.addAttribute("denuncia", denuncia);
		model.addAttribute("isEnableSaveButton", true);
		return new ModelAndView("fichaDenunciaFormal", "model", model);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param Denuncia
	 *            Denuncia Bean que contiene la informacion a modificar.
	 * @return Denuncia Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ResultAjaxOperation edit(@RequestBody Denuncia denuncia) {
		try {
			this.denunciasService.update(denuncia);
			DenunciasController.logger.info("[PUT] : Denuncia actualizada correctamente");
		} catch (Exception e) {
			DenunciasController.logger.info(e.getMessage());
			return new ErrorResultAjaxOperation(Constantes.ERROR_GENERICO_GUARDADO);
		}

		return new SuccessResultAjaxOperation(Constantes.OK_GENERICO_GUARDADO);
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param denuncia
	 *            Denuncia Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Denuncia Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Denuncia add(@RequestBody Denuncia denuncia) {
		Denuncia denunciaAux = this.denunciasService.add(denuncia);
		DenunciasController.logger.info("[POST] : Denuncia insertado correctamente");
		return denunciaAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idReclamacion
	 *            Integer Identificador del objeto que se desea eliminar.
	 * @return Denuncia Bean eliminado.
	 */
	@RequestMapping(value = "/{idReclamacion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Denuncia remove(@PathVariable Integer idReclamacion) {
		Denuncia denuncia = new Denuncia();
		denuncia.setIdReclamacion(idReclamacion);
		this.denunciasService.remove(denuncia);
		DenunciasController.logger.info("[DELETE] : Denuncia borrado correctamente");
		return denuncia;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getFormEdit(Model model, HttpSession httpSession) {

		DenunciasController.logger.info("[GET - View] : ab7801s00");

		String username = UtilUsuario.getUserConnected();
		Usuario usuario = new Usuario();
		usuario.setNombreUsuario(username);
		model.addAttribute("usuario", usuario);

		UserCredentials userCredentials = (UserCredentials) SecurityContextHolder.getContext().getAuthentication()
				.getCredentials();
		Vector<String> listPerfiles = userCredentials.getUserProfiles();
		String provincia = "";
		String dpto = "";
		for (String perfil : listPerfiles) {
			if (Constantes.getMapaPerfilProvincia().containsKey(perfil)) {
				provincia = Constantes.getMapaPerfilProvincia().get(perfil);
			}
			if (Constantes.getMapaInstanciaProvincia().containsKey(perfil)) {
				provincia = Constantes.getMapaInstanciaProvincia().get(perfil);
			}
			if (Constantes.getmapaPerfilDpto().containsKey(perfil)) {
				dpto = Constantes.getmapaPerfilDpto().get(perfil);
			}
			if (Constantes.getMapaInstanciaDpto().containsKey(perfil)) {
				dpto = Constantes.getMapaInstanciaDpto().get(perfil);
			}
		}

		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE) != null) {
			Object folderIdUltimoExpediente = httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE);

			model.addAttribute("ultimoExpediente", folderIdUltimoExpediente);
		}
		if (httpSession.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO) != null) {
			Object IdDenunciaUltimoExpediente = httpSession
					.getAttribute(Constantes.SESSIONKEY_ULTIMO_EXPEDIENTE_MIGRADO);

			model.addAttribute("IdDenunciaUltimoExpediente", IdDenunciaUltimoExpediente);
		}

		if (StringUtils.isNotBlank(provincia)) {
			model.addAttribute("thPerfil", provincia);
		}
		if (StringUtils.isNotBlank(dpto)) {
			model.addAttribute("dptoPerfil", dpto);
		}

		return "busqDenuncias";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAb7801s00
	 *            Denuncia Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<Denuncia> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Denuncia> filter(@RequestJsonBody(param = "filter") Denuncia filterAb7801s00,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		DenunciasController.logger.info("[POST - filter] : Obtener Ab7801s00s");
		// return this.denunciasService.filter(filterAb7801s00, tableRequestDto,
		// false);
		return null;
	}
	
	@RequestMapping(value = "/establecimientos/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<Establecimiento> filter(
			@RequestJsonBody(param = "filter") Establecimiento filter,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		DenunciasController.logger.info("");
		return this.establecimientoService.filter(filter, tableRequestDto, false);
	}

	@RequestMapping(value = "/searchEstablecimiento", method = RequestMethod.GET)
	public @ResponseBody List<Establecimiento> searchEstablecimientoVarita(
			@RequestParam(value = "q", required = true) String q) {
		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setIdentificadorEstablecimiento(q);
		establecimiento.setTipoRegistro(Constantes.TIPO_REGISTRO_DEFINITIVO);
		return this.establecimientoService.findAllLike(establecimiento, null, false);
	}
}
