package com.ejie.ab78.control;

import com.ejie.ab78.model.denuncias.RelacionMotivoDen;
import com.ejie.ab78.service.RelacionMotivoDenService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableResponseDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * RelacionMotivoDenController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/relacionMotivoDen")

public class RelacionMotivoDenController {

	private static final Logger logger = LoggerFactory.getLogger(RelacionMotivoDenController.class);

	@Autowired
	private RelacionMotivoDenService relacionMotivoDenService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 * 
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param idMotivoInterno
	 *            Long
	 * @return RelacionMotivoDen Objeto correspondiente al identificador
	 *         indicado.
	 */
	@RequestMapping(value = "/{idMotivoInterno}", method = RequestMethod.GET)
	public @ResponseBody RelacionMotivoDen get(@PathVariable Long idMotivoInterno) {
		RelacionMotivoDen relacionMotivoDen = new RelacionMotivoDen();
		relacionMotivoDen.setIdMotivoInterno(idMotivoInterno);
		relacionMotivoDen = this.relacionMotivoDenService.find(relacionMotivoDen);
		RelacionMotivoDenController.logger.info("[GET - findBy_PK] : Obtener RelacionMotivoDen por PK");
		return relacionMotivoDen;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Objeto que contiene los parametros de
	 *            filtrado utilizados en la busqueda.
	 * @return List<RelacionMotivoDen> Lista de objetos correspondientes a la
	 *         busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<RelacionMotivoDen> getAll(@ModelAttribute RelacionMotivoDen filterRelacionMotivoDen) {
		RelacionMotivoDenController.logger.info("[GET - find_ALL] : Obtener RelacionMotivoDen por filtro");
		return this.relacionMotivoDenService.findAll(filterRelacionMotivoDen, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene la informacion a
	 *            modificar.
	 * @return RelacionMotivoDen Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody RelacionMotivoDen edit(@RequestBody RelacionMotivoDen relacionMotivoDen) {
		RelacionMotivoDen relacionMotivoDenAux = this.relacionMotivoDenService.update(relacionMotivoDen);
		RelacionMotivoDenController.logger.info("[PUT] : RelacionMotivoDen actualizado correctamente");
		return relacionMotivoDenAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene la informacion con la que
	 *            se va a crear el nuevo registro.
	 * @return RelacionMotivoDen Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody RelacionMotivoDen save(@RequestBody RelacionMotivoDen filter) {
		RelacionMotivoDen motivo = new RelacionMotivoDen();

		for (RelacionMotivoDen relacionAux : this.relacionMotivoDenService.findAll(motivo, null)) {
			if (filter.getIdMotivoInterno() == relacionAux.getIdMotivoInterno()) {
				return this.relacionMotivoDenService.update(filter);
			}

		}
		return this.relacionMotivoDenService.add(filter);
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 *
	 * @param idMotivoInterno
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return RelacionMotivoDen Bean eliminado.
	 */
	@RequestMapping(value = "/{idMotivoInterno}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody RelacionMotivoDen remove(@PathVariable Long idMotivoInterno) {
		RelacionMotivoDen relacionMotivoDen = new RelacionMotivoDen();
		relacionMotivoDen.setIdMotivoInterno(idMotivoInterno);
		this.relacionMotivoDenService.remove(relacionMotivoDen);
		RelacionMotivoDenController.logger.info("[DELETE] : RelacionMotivoDen borrado correctamente");
		return relacionMotivoDen;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 * 
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		RelacionMotivoDenController.logger.info("[GET - View] : relacionMotivoDen");
		return "relacionMotivoDen";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<RelacionMotivoDen> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<RelacionMotivoDen> filter(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger.info("[POST - filter] : Obtener RelacionMotivoDens");
		return this.relacionMotivoDenService.filter(filterRelacionMotivoDen, tableRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param searchRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de busqueda
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<RelacionMotivoDen> Dto que contiene el resultado de
	 *         la busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<RelacionMotivoDen>> search(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody(param = "search") RelacionMotivoDen searchRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger.info("[POST - search] : Buscar RelacionMotivoDens");
		return this.relacionMotivoDenService.search(filterRelacionMotivoDen, searchRelacionMotivoDen, tableRequestDto,
				false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples RelacionMotivoDens");
		this.relacionMotivoDenService.removeMultiple(filterRelacionMotivoDen, tableRequestDto, false);
		RelacionMotivoDenController.logger.info("All entities correctly deleted!");

		return tableRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>> Dto que
	 *         contiene el resultado del filtrado realizado por el componente
	 *         RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquia(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger.info("[POST - jerarquia] : Obtener RelacionMotivoDens jerarquia");
		return this.relacionMotivoDenService.jerarquia(filterRelacionMotivoDen, tableRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen Bean que contiene los parametros de filtrado
	 *            a emplear.
	 * @param tableRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return TableResponseDto<JerarquiaDto<RelacionMotivoDen>> Dto que
	 *         contiene el resultado del filtrado realizado por el componente
	 *         RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody TableResponseDto<JerarquiaDto<RelacionMotivoDen>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger.info("[POST - jerarquia] : Obtener RelacionMotivoDens jerarquia - Hijos");
		return this.relacionMotivoDenService.jerarquiaChildren(filterRelacionMotivoDen, tableRequestDto);
	}

	/**
	 * EXPORTERS
	 */

	@RequestMapping(value = "/clipboardReport", method = RequestMethod.POST)
	protected @ResponseBody List<RelacionMotivoDen> getClipboardReport(
			@RequestJsonBody(param = "filter") RelacionMotivoDen filterRelacionMotivoDen,
			@RequestJsonBody TableRequestDto tableRequestDto) {
		RelacionMotivoDenController.logger.info("[POST - clipboardReport] : : Copiar multiples usuarios");
		return this.relacionMotivoDenService.getMultiple(filterRelacionMotivoDen, tableRequestDto, false);
	}

}
