<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/WEB-INF/includeTemplate.inc"%>
<%@taglib prefix="form" uri="/WEB-INF/tld/spring-form.tld"%>
<%@taglib prefix="tiles" uri="/WEB-INF/tld/tiles-jsp.tld"%>
<%@page import="java.util.List,org.springframework.validation.ObjectError"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@page import="com.ejie.ab78.comun.Constantes"%>
<input id="thPerfil" type="hidden" value="${thPerfil}"/>
<input id="dptoPerfil" type="hidden" value="${dptoPerfil}"/>

<section>
	<div id="divNavBarSecundario">
		<nav class="navbar navbar-default navbar-secundario">
			<div class="container">
				<div class="pull-left mov10top">
					<h2><spring:message code="busquedaDenuncias.titulo"/></h2>
				</div>
				<div class="pull-right">
					<button type="button" id="btnBuscarDenuncias" class="btn btn-primary btn-circle btn-lg" data-toggle="tooltip" data-placement="bottom" title="<spring:message code="boton.buscar"/>" >
						<i class="fa fa-search" aria-hidden="true"></i>
					</button>
					<div class="btn-group margin-left-10">
						<button type="button" class="btn btn-default btn-circle btn-lg" aria-haspopup="true" aria-expanded="false" data-toggle="dropdown" id="btnLimpiarBuscadorDenuncias">
							<i class="fa fa-eraser" aria-hidden="true" data-toggle="tooltip" data-placement="bottom" title="<spring:message code="clear"/>"></i>
						</button>
					</div>
				</div>
			</div>
		</nav>
	</div>
</section>

<section>
	<div class="container">
		<form id="busqDenuncias_filter_form" class="card-body p-0">
			<div id="busqDenuncias_filter_toolbar" class="formulario_legend d-none" ></div>
			<div id="busqDenunciasFeedback"></div>
			<div id="avisos_feedback"></div>
			<fieldset id="busqDenuncias_filter_fieldset" class="rup-table-filter-fieldset form-horizontal">
				<div class="card m-0 mb-2">	
					<div class="card-header"><spring:message code="busquedaDenuncias.criteriosBusqueda"/></div>
					<div class="card-body">
						<div class="row">
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.direcciones.idDireccion" id="comboIdDireccionFilterHidden"/>
								<label for="comboIdDireccionFilterHidden"><spring:message code="busquedaDenuncias.direccion"/></label>
								<select id="comboIdDireccionFilter" class="form-control"></select>
							</div>
							<div class="col-xs-7 form-group">
								<input type="hidden" name="filter.idProcedimiento" id="codProcedureId_filter_tableHidden"/>
								<label for="codProcedureId_filter_tableHidden"><spring:message code="tablasmaestras.categoria.procedimiento"/></label>
								<select id="codProcedureId_filter_table" class="form-control form-control"></select>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-3 form-group">
								<label for="folderNumberFilter"><spring:message code="fexpediente.datos.codigoExpediente"/></label>
								<input id="folderNumberFilter" type="text" name="filter.folderNumber" class="form-control"/>
							</div>
							
							<div class="col-xs-3 form-group">
								<label for="tituloExpedienteFilter"><spring:message code="fexpediente.tituloExpediente"/></label>
								<c:choose>
								    <c:when test="${empty thPerfil}">
										<input id="tituloExpedienteFilter" type="text" value="" name="filter.tituloExpediente" class="form-control"/>
								    </c:when>    
								    <c:otherwise>
										<input id="tituloExpedienteFilter" type="text" value="(${thPerfil})" name="filter.tituloExpediente" class="form-control"/>
								    </c:otherwise>
								</c:choose>
							</div>
							<div class="col-xs-3 form-group">
																
								<label for="comboInnactivosFilterHidden"><spring:message code="establecimiento.estadoExpediente"/></label>
								<select id="comboInnactivosFilter" name="filter.filterInactivos" class="form-control">
									<option value="1"><spring:message code="establecimiento.soloActivos"/></option>
 									<option value="2"><spring:message code="establecimiento.cerrado"/></option>
 									<option value="3"><spring:message code="establecimiento.ambos"/></option>	
								</select>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.tipoEstablecimiento.idTipoEstablecimiento" id="comboIdTipoEstablecimientoFilterHidden"/>
								<label for="comboIdTipoEstablecimientoFilterHidden"><spring:message code="ficha.denuncia.reclamacion.tipoActividad"/></label>
								<select id="comboIdTipoEstablecimientoFilter" class="form-control"></select>
							</div>
							<!--<div class="col-xs-3 form-group">
								<label for="identificadorEstablecimientoFilter"><spring:message code="establecimiento.signatura"/></label>
								<input id="identificadorEstablecimientoFilter" type="text" name="filter.identificadorEstablecimiento" class="form-control"/>
							</div>-->
							<div class="col-3 form-group">
								<label><spring:message code="fexpediente.datos.ubicacionInversion.numeroRegistro"/></label>
								<div id="searchIdentificadorContainer" class="form-group">
									<input type="text" class="" size="1" id='partLetra' name="filter.parteLetra" autocomplete="off" maxlength="1"/>
									<span class="input-group-addon">&nbsp;&nbsp;</span>
									<input type="text" class="" size="2" id='partProv'  name='filter.parteProv' autocomplete="off"  maxlength="2"/>
									<span class="input-group-addon">&nbsp;&nbsp;</span>
									<input type="text" class="" size="5" id='partSequencia' name='filter.parteSequencia' autocomplete="off" maxlength="5"/>
								</div>
								<input type="hidden" class="form-control" id='searchIdentificador' autocomplete="off" name="filter.identificadorEstablecimiento"  />
							</div>
							<div class="col-xs-3 form-group">
								<label for="nombreComercialFilter"><spring:message code="establecimiento.nombreComercial"/></label>
								<input id="nombreComercialFilter" type="text" name="filter.nombreComercial" class="form-control"/>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.tipoReclamacion.idTipoReclamacion" id="comboIdTipoReclamacionFilterHidden"/>
								<label for="comboIdTipoReclamacionFilterHidden"><spring:message code="ficha.denuncia.reclamacion.tipoDenuncia"/></label>
								<select id="comboIdTipoReclamacionFilter" class="form-control"></select>
							</div>
							<div class="col-xs-3 form-group">
								<label for="numReclamacionFilter"><spring:message code="ficha.denuncia.resultado.numDenuncia"/></label>
								<input id="numReclamacionFilter" type="text" name="filter.numReclamacion" class="form-control"/>
							</div>
							<div class="col-xs-3 form-group">
								<label for="numPaginaRecFilter"><spring:message code="ficha.denuncia.reclamacion.numPaginaRec"/></label>
								<input id="numPaginaRecFilter" type="text" name="filter.numPaginaRec" class="form-control"/>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-3 form-group">
								<label for="fechaPresentacionDesdeFilter"><spring:message code="ficha.denuncia.reclamacion.fechaPresentacion"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaPresentacionDesdeFilter" maxlength="10" name="filter.fechaPresentacionDesde" >		
								</div> 
								<label for="fechaPresentacionHastaFilter"><spring:message code="establecimiento.fechaHasta"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaPresentacionHastaFilter"  maxlength="10" name="filter.fechaPresentacionHasta" >
								</div>
							</div>
							
							
							<div class="col-xs-3 form-group">
								<label for="fechaHechosDesdeFilter"><spring:message code="ficha.denuncia.reclamacion.fechaHechos"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaHechosDesdeFilter" maxlength="10" name="filter.fechaHechosDesde" >			
								</div> 
								<label for="fechaHechosHastaFilter"><spring:message code="establecimiento.fechaHasta"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaHechosHastaFilter" maxlength="10" name="filter.fechaHechosHasta" >								
								</div>
							</div>
							<div class="col-xs-3 form-group">
								<label for="fechaDecisionDesdeFilter"><spring:message code="ficha.denuncia.resultado.fechaDecision"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaDecisionDesdeFilter" maxlength="10" name="filter.fechaDecisionDesde" >
								</div> 
								<label for="fechaDecisionHastaFilter"><spring:message code="establecimiento.fechaHasta"/></label><br/>
								<div class="rup-date-input-group">
									<input type="text" class="form-control" id="fechaDecisionHastaFilter" maxlength="10" name="filter.fechaDecisionHasta" >
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.tipoDecision.idDecision" id="comboIdDecisionFilterHidden"/>
								<label for="comboIdDecisionFilterHidden"><spring:message code="ficha.denuncia.resultado.decision"/></label>
								<select id="comboIdDecisionFilter" class="form-control"></select>
							</div>
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.indTipoReclamacion" id="comboIndTipoReclamacionFilterHidden"/>
								<label for="comboIndTipoReclamacionFilterHidden"><spring:message code="formDatosEspecificos.tipo"/></label>
								<select id="comboIndTipoReclamacionFilter" class="form-control"></select>
							</div>
							<div class="col-xs-3 form-group"></div>							
						</div>
						
						<div class="row">
						<div class="col-xs-3 form-group">
							<input type="hidden" name="filter.relacionMotivo.motivo.idMotivo" id="comboIndMotivoFilterHidden"/>
							<label for="comboIndMotivoFilterHidden"><spring:message code="formDatosEspecificos.motivo"/></label>
							<select id="comboIndMotivoFilter" class="form-control"></select>
						</div>
						<div class="col-xs-3 form-group">
							<label for="motivoEspecifico"><spring:message code="formDatosEspecificos.motivoEspecifico"/></label>
							<input id="motivoEspecifico" class="form-control" type="text" name="filter.relacionMotivo.descMotivo" maxlength="150">
						</div>
						<div class="col-xs-3 form-group"></div>	
						</div>

						<div class="row">
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.datosTerceros.tiposTercero.idTipoTercero" id="comboTiposTerceroFilterHidden"/>
								<label for="comboTiposTerceroFilterHidden"><spring:message code="formInteresados.tipoInteresado"/></label>
								<select id="comboTiposTerceroFilter" class="form-control"></select>
							</div>
							<div class="col-xs-3 form-group">
								<input type="hidden" name="filter.datosTerceros.tiposDocumento.idTipoDocumento" id="comboTiposDocInteresadoFilterHidden"/>
								<label for="comboTiposDocInteresadoFilterHidden"><spring:message code="formInteresados.tipoDocumento"/></label>
								<select id="comboTiposDocInteresadoFilter" class="form-control"></select>
							</div>
							<div class="col-xs-3 form-group">
								<label for="documentoFilter"><spring:message code="formInteresados.documento"/></label>
								<input id="documentoFilter" class="form-control" type="text" name="filter.datosTerceros.documento" maxlength="20">
							</div>
						</div>
						
						<div class="row">
							<div class="col-xs-3 form-group">
								<label for="nombreInteresadoFilter"><spring:message code="formInteresados.nombre"/></label>
								<input id="nombreInteresadoFilter" class="form-control" type="text" name="filter.datosTerceros.nombre" maxlength="">
							</div>
							<div class="col-xs-3 form-group">
								<label for="apellido1InteresadoFilter"><spring:message code="formInteresados.apellido1"/></label>
								<input id="apellido1InteresadoFilter" class="form-control" type="text" name="filter.datosTerceros.apellido1" maxlength="">
							</div>
							<div class="col-xs-3 form-group">
								<label for="apellido2InteresadoFilter"><spring:message code="formInteresados.apellido2"/></label>
								<input id="apellido2InteresadoFilter" class="form-control" type="text" name="filter.datosTerceros.apellido2" maxlength="">
							</div>
						</div>
						
						<div class="card m-0 mt-2">
							<div class="card-header"><spring:message code="formDatosEspecificos.ubicacion"/></div>
								<div class="card-body">
						
									<div class="row">
										<div class="col-xs-4 form-group">
										<label for="idProvinciaHidden"><spring:message code="establecimiento.provincia"></spring:message></label>
									
											<div class="input-group">
												<input id="idProvinciaHidden" type="text" class="form-control" name="filter.datosDirecciones.idProvincia" maxlength="2"/>
												<span class="input-group-addon">&nbsp;&nbsp;</span>
												<select id="idProvinciaSolicitante" name="idProvinciaSolicitante" class="form-control"></select>
											</div>	
										</div>
										<div class="col-xs-4 form-group">
											<label for="idMunicipioHidden"><spring:message code="establecimiento.municipio"></spring:message></label>
											
											<div class="input-group">
												<input type="text" maxlength="3" class="form-control" id="idMunicipioHidden" name="filter.datosDirecciones.idMunicipio"/>
												<span class="input-group-addon">&nbsp;&nbsp;</span>
												<select name="idMunicipioSolicitante" id="idMunicipioSolicitante" class="form-control"></select>
											</div>
											
										</div>
										<div class="col-xs-4 form-group">
											<label for="idLocalidadSolicitante"><spring:message code="establecimiento.localidad"></spring:message></label>
											<select name="idLocalidadSolicitante" id="idLocalidadSolicitante" class="form-control"></select>
											<span class="input-group-addon">&nbsp;&nbsp;</span>
											<input type="hidden" id="idLocalidadHidden" name="filter.datosDirecciones.idLocalidad"/>
										</div>
									</div>
		
									<div class="row">
										
										<div class="col-6 form-group">
											<label for="direccion"><spring:message code="establecimiento.calle"/></label>
											<input id="direccion" class="form-control" type="text" name="filter.datosDirecciones.direccion" maxlength="100">
										</div>
										<div class="col-1 form-group">
											<label for="numero"><spring:message code="establecimiento.N"/></label>
											<input id="numero" class="form-control" type="text" name="filter.datosDirecciones.numero" maxlength="10">
										</div>
										<div class="col-1 form-group">
											<label for="escalera"><spring:message code="establecimiento.escalera"/></label>
											<input id="escalera" class="form-control" type="text" name="filter.datosDirecciones.escalera" maxlength="4">
										</div>
										<div class="col-1 form-group">
											<label for="piso"><spring:message code="establecimiento.piso"/></label>
											<input id="piso" class="form-control" type="text" name="filter.datosDirecciones.piso" maxlength="4">
										</div>
										<div class="col-1 form-group">
											<label for="letra"><spring:message code="establecimiento.letra"/></label>
											<input id="letra" class="form-control" type="text" name="filter.datosDirecciones.letra" maxlength="4">
										</div>
										<div class="col-2 form-group">
											<label for="codigoPostal"><spring:message code="establecimiento.codigoPostal"/></label>
											<input id="codigoPostal" class="form-control" type="text" name="filter.datosDirecciones.codigoPostal" maxlength="5">
										</div>
										
									</div>
								</div>
						</div>
						<br>
						<div class="row">
							<div class="col-xs-3 form-group">
								<label for="identificadorInspeccion"><spring:message code="formInspeccion.id"/></label>
								<input id="identificadorInspeccion" class="form-control" type="text" name="filter.identificadorInspeccion">
							</div>
							<div class="col-xs-4 form-group checkbox">
								<div class="movcheckbox">
									<input class="form-control" type="checkbox" value="" id="tieneInspeccion" name="filter.tieneInspeccion">
									<label for="tieneInspeccion"><spring:message code="formInspeccion.mostrarDenuncias"/></label>	
								</div>
							</div>	
							<div class="col-xs-2 form-group">
							</div>								
						</div>
						
					</div>
				</div>
				<div id="busqDenuncias_filter_buttonSet" class="right_buttons d-none">	
					<button id="busqDenunciasLimpiar" type="button" class="btn btn-primary">
						<i class="fa fa-eraser"></i>
						<span><spring:message code="clear" /></span>
					</button>
					
					<button id="busqDenuncias_filter_filterButton" type="button" class="btn btn-primary rup-filtrar rup-filter-dropdown" >
						<i class="fa fa-filter"></i>
						<span><spring:message code="filter" /></span>
					</button>
				</div>
			</fieldset>
		</form>
		
		<div id="divTblBusqDenuncias" class="d-none">
			<div class="botoneraTabla">
				<button class="btn btn-default btn-circle" id="btnAccederDenuncia" type="button" data-toggle="tooltip" data-placement="top" title='<spring:message code="boton.ir"/>' disabled="disabled">
					<i class="fa fa-pencil-square-o"></i>
				</button>
				<button class="btn btn-default btn-circle" onClick="generarXLS()" id="btnExcel" type="button" data-toggle="tooltip" data-placement="top" title='<spring:message code="boton.excel"/>'>
					<i class="fa fa-file-excel-o"></i>
				</button>
			</div>
			<table id="busqDenuncias" class="table table-striped table-bordered"
					data-url-base="/ab78WebAppWar/expediente-denuncia"
					data-filter-form="#busqDenuncias_filter_form"
					style="width: 100%;">
					<thead>
						<tr>
							<th data-col-prop="idExpediente" data-col-sidx="ID_EXPEDIENTE"></th>
							<th data-col-prop="folderId" data-col-sidx="FOLDER_ID"></th>
							<th data-col-prop="numDenunciaFormateado" data-col-sidx="NUM_ANYO,NUM_RECLAMACION"><spring:message code="ficha.denuncia.tablaBuscador.numDenuncia"/></th>
							<th data-col-prop="folderNumber" data-col-sidx="FOLDER_NUMBER"><spring:message code="fexpediente.menu.datos"/></th>
							<th data-col-prop="fechaPresentacion" data-col-sidx="FECHA_PRESENTACION"><spring:message code="ficha.denuncia.reclamacion.fechaPresentacion"/></th>
							<th data-col-prop="denunciante" data-col-sidx="NOMBRE_DENUNCIANTE"><spring:message code="ficha.denuncia.denunciante"/></th>
							<th data-col-prop="nombreDenunciado" data-col-sidx="NOMBRE_DENUNCIADO"><spring:message code="ficha.denuncia.denunciado"/></th>
							<th data-col-prop="direccionDenunciado" data-col-sidx="DIRECCION_DENUNCIADO"><spring:message code="ficha.denuncia.denunciado.direccionDenunciado"/></th>
							<th data-col-prop="identificadorInspeccion" data-col-sidx="IDENTIFICADOR_INSPECCION"><spring:message code="ficha.denuncia.resultado.codInspeccion"/></th>
					    	<th data-col-prop="descDecisionES" data-col-sidx="DESC_TIPO_ES"><spring:message code="ficha.denuncia.resultado.decision"/></th>
							<th data-col-prop="descDecisionEU" data-col-sidx="DESC_TIPO_EU"><spring:message code="ficha.denuncia.resultado.decision"/></th>
				       </tr>
				    </thead>
			</table>
		</div>
	</div>
</section>