package com.ejie.ab78.util.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * Excepción de negocio
 *
 *  
 */
@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR, reason = "Se ha producido una excepción de negocio")
public class NegocioException extends MonitorException {

	private static final long serialVersionUID = 5842719135923596990L;

	/**
	 * Construye una nueva excepción de negocio con el mensaje de detalle
	 * especificado.
	 *
	 * @param message
	 *            Detalle de la excepción.
	 *
	 */
	public NegocioException(String message) {
		super(false, message);
	}

}
