package com.ejie.ab78.util.exception;

import java.io.Serializable;

/**
 *
 * Excepcion de monitorización.
 *
 * Permite monitorizar excepciones de este tipo.
 *
 *  
 *
 */
public class MonitorException extends RuntimeException implements Serializable {

	private static final long serialVersionUID = 1L;
	private Throwable exception;

	private boolean sent = false;
	private boolean monitorizable = false;

	/**
	 * MonitorException
	 */
	@SuppressWarnings("unused")
	private MonitorException() {
	}

	/**
	 * Aa61tMonitorException
	 *
	 * @param monitorizable
	 *            boolean
	 * @param exception
	 *            Throwable
	 */
	public MonitorException(boolean monitorizable, String mensaje) {
		super(mensaje);
		this.monitorizable = monitorizable;
		this.exception = new Exception(mensaje);
	}

	/**
	 * @return the sent
	 */
	public boolean isSent() {
		return sent;
	}

	/**
	 * @return the monitorizable
	 */
	public boolean isMonitorizable() {
		return monitorizable;
	}

}
