/**
 * 
 */
package com.ejie.ab78.util;

import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 *  
 *
 */
public class UtilDao {

	private static final Integer STRING_BUFFER_CAPACITY = new Integer("500");

	/**
	 * Recupera el siguiente valor de la secuencia que le pasemos por parametro
	 * 
	 * @param jdbcTemplate
	 *            JdbcTemplate
	 * @param secuencia
	 *            String
	 * @return Long
	 */
	public static Long getNextId(JdbcTemplate jdbcTemplate, String secuencia) {
		StringBuffer query = new StringBuffer(UtilDao.STRING_BUFFER_CAPACITY);
		query.append("SELECT ");
		query.append(secuencia);
		query.append(".NEXTVAL FROM DUAL ");
		List<Object> params = new ArrayList<Object>();
		return jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

}
